/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.chain.commands.generic;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.chain.commands.util.ClassUtils;

public class WrappingLookupCommand
implements Filter {
    private static final Log LOG = LogFactory.getLog(WrappingLookupCommand.class);
    private String catalogName = null;
    private String name = null;
    private String nameKey = null;
    private String wrapperClassName = null;
    private boolean optional = false;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getWrapperClassName() {
        return this.wrapperClassName;
    }

    public void setWrapperClassName(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
    }

    @Override
    public boolean execute(Context context) throws Exception {
        Command command;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("execute [" + String.valueOf(this) + "]"));
        }
        if ((command = this.getCommand(context)) != null) {
            return command.execute(this.getContext(context));
        }
        return false;
    }

    @Override
    public boolean postprocess(Context context, Exception exception) {
        Command command = this.getCommand(context);
        if (command != null && command instanceof Filter) {
            try {
                return ((Filter)command).postprocess(this.getContext(context), exception);
            }
            catch (NoSuchMethodException ex) {
                LOG.error((Object)"Error wrapping context in postprocess", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                LOG.error((Object)"Error wrapping context in postprocess", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                LOG.error((Object)"Error wrapping context in postprocess", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                LOG.error((Object)"Error wrapping context in postprocess", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)"Error wrapping context in postprocess", (Throwable)ex);
            }
        }
        return false;
    }

    protected Command getCommand(Context context) {
        Catalog catalog;
        CatalogFactory catalogFactory = CatalogFactory.getInstance();
        String catalogName = this.getCatalogName();
        if (catalogName == null) {
            catalog = catalogFactory.getCatalog();
            catalogName = "{default}";
        } else {
            catalog = catalogFactory.getCatalog(catalogName);
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Cannot find catalog '" + catalogName + "'");
        }
        String name = this.getName();
        if (name == null) {
            name = (String)context.get(this.getNameKey());
        }
        if (name != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Lookup command " + name + " in catalog " + catalogName));
            }
            Command command = catalog.getCommand(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found command " + String.valueOf(command) + "; optional: " + this.isOptional()));
            }
            if (command == null && !this.isOptional()) {
                throw new IllegalArgumentException("Cannot find command '" + name + "' in catalog '" + catalogName + "'");
            }
            return command;
        }
        throw new IllegalArgumentException("No command name");
    }

    protected Context getContext(Context context) throws ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (this.wrapperClassName == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No defined wrapper class; returning original context.");
            }
            return context;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for wrapper class: " + this.wrapperClassName));
        }
        Class wrapperClass = ClassUtils.getApplicationClass(this.wrapperClassName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Instantiating wrapper class");
        }
        return (Context)ConstructorUtils.invokeConstructor((Class)wrapperClass, (Object[])new Object[]{context});
    }
}

