/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.chain.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.chain.commands.ActionCommandBase;
import org.govway.struts.chain.contexts.ActionContext;
import org.govway.struts.config.ActionConfig;
import org.govway.struts.config.ExceptionConfig;
import org.govway.struts.config.ForwardConfig;
import org.govway.struts.config.ModuleConfig;

public abstract class AbstractExceptionHandler
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog(AbstractExceptionHandler.class);

    @Override
    public boolean execute(ActionContext actionCtx) throws Exception {
        Exception exception = actionCtx.getException();
        if (exception == null) {
            LOG.warn((Object)"No Exception found in ActionContext");
            return true;
        }
        ExceptionConfig exceptionConfig = null;
        ActionConfig actionConfig = actionCtx.getActionConfig();
        ModuleConfig moduleConfig = actionCtx.getModuleConfig();
        if (actionConfig != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("See if actionConfig " + String.valueOf(actionConfig) + " has an exceptionConfig for " + exception.getClass().getName()));
            }
            exceptionConfig = actionConfig.findException(exception.getClass());
        } else if (moduleConfig != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No action yet, see if moduleConfig " + String.valueOf(moduleConfig) + " has an exceptionConfig " + exception.getClass().getName()));
            }
            exceptionConfig = moduleConfig.findException(exception.getClass());
        }
        if (exceptionConfig == null) {
            LOG.warn((Object)"Unhandled exception", (Throwable)exception);
            throw exception;
        }
        ForwardConfig forwardConfig = this.handle(actionCtx, exception, exceptionConfig, actionConfig, moduleConfig);
        if (forwardConfig != null) {
            actionCtx.setForwardConfig(forwardConfig);
            return false;
        }
        return true;
    }

    protected abstract ForwardConfig handle(ActionContext var1, Exception var2, ExceptionConfig var3, ActionConfig var4, ModuleConfig var5) throws Exception;
}

