/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.chain.web.MapEntry;

final class ServletSessionScopeMap
implements Map {
    private HttpSession session = null;
    private HttpServletRequest request = null;

    public ServletSessionScopeMap(HttpServletRequest request) {
        this.request = request;
        this.sessionExists();
    }

    @Override
    public void clear() {
        if (this.sessionExists()) {
            Iterator keys = this.keySet().iterator();
            while (keys.hasNext()) {
                this.session.removeAttribute((String)keys.next());
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.sessionExists()) {
            return this.session.getAttribute(this.key(key)) != null;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null || !this.sessionExists()) {
            return false;
        }
        Enumeration keys = this.session.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object next = this.session.getAttribute((String)keys.nextElement());
            if (!value.equals(next)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<MapEntry> set = new HashSet<MapEntry>();
        if (this.sessionExists()) {
            Enumeration keys = this.session.getAttributeNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                set.add(new MapEntry(key, this.session.getAttribute(key), true));
            }
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        if (this.sessionExists()) {
            return this.session.equals(o);
        }
        return false;
    }

    public Object get(Object key) {
        if (this.sessionExists()) {
            return this.session.getAttribute(this.key(key));
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (this.sessionExists()) {
            return this.session.hashCode();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return !this.sessionExists() || !this.session.getAttributeNames().hasMoreElements();
    }

    public Set keySet() {
        HashSet set = new HashSet();
        if (this.sessionExists()) {
            Enumeration keys = this.session.getAttributeNames();
            while (keys.hasMoreElements()) {
                set.add(keys.nextElement());
            }
        }
        return set;
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        if (this.session == null) {
            this.session = this.request.getSession();
            this.request = null;
        }
        String skey = this.key(key);
        Object previous = this.session.getAttribute(skey);
        this.session.setAttribute(skey, value);
        return previous;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        if (this.sessionExists()) {
            String skey = this.key(key);
            Object previous = this.session.getAttribute(skey);
            this.session.removeAttribute(skey);
            return previous;
        }
        return null;
    }

    @Override
    public int size() {
        int n = 0;
        if (this.sessionExists()) {
            Enumeration keys = this.session.getAttributeNames();
            while (keys.hasMoreElements()) {
                keys.nextElement();
                ++n;
            }
        }
        return n;
    }

    public Collection values() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.sessionExists()) {
            Enumeration keys = this.session.getAttributeNames();
            while (keys.hasMoreElements()) {
                list.add(this.session.getAttribute((String)keys.nextElement()));
            }
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }

    private boolean sessionExists() {
        if (this.session == null) {
            this.session = this.request.getSession(false);
            if (this.session != null) {
                this.request = null;
            }
        }
        return this.session != null;
    }
}

