/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.monitor.rs.server.config.Startup;
import org.openspcoop2.utils.Costanti;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.logger.LoggerFactory;
import org.openspcoop2.utils.logger.config.DiagnosticConfig;
import org.openspcoop2.utils.logger.config.Log4jConfig;
import org.openspcoop2.utils.logger.config.MultiLoggerConfig;
import org.openspcoop2.utils.logger.log4j.Log4jLoggerWithApplicationContext;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.slf4j.Logger;

public class LoggerProperties {
    private LoggerProperties() {
    }

    public static void initialize(Logger logConsole, String rootDirectory, Properties objectProperties) throws IOException, UtilsException {
        String value;
        String key;
        Enumeration<Object> ridefinito;
        Properties loggerProperties = new Properties();
        File loggerFile = null;
        loggerFile = rootDirectory != null ? new File(rootDirectory + "rs-api-monitor.log4j2.properties") : new File("rs-api-monitor.log4j2.properties");
        if (!loggerFile.exists()) {
            loggerProperties.load(LoggerProperties.class.getResourceAsStream("/rs-api-monitor.log4j2.properties"));
        } else {
            try (FileInputStream fin = new FileInputStream(loggerFile);){
                loggerProperties.load(fin);
            }
        }
        CollectionProperties loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)logConsole, (String)"OPENSPCOOP2_RSMONITOR_LOG_PROPERTIES", (String)"rs-api-monitor_local.log4j2.properties", (String)rootDirectory);
        if (loggerPropertiesRidefinito != null && loggerPropertiesRidefinito.size() > 0) {
            ridefinito = loggerPropertiesRidefinito.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = loggerPropertiesRidefinito.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
        if (objectProperties != null && objectProperties.size() > 0) {
            ridefinito = objectProperties.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = (String)objectProperties.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
        LoggerWrapperFactory.patchLoggers((Properties)loggerProperties, (Map)Costanti.ENV_LOG_API_MONITOR, Map.of("appName", "govwayAPIMonitor"));
        DiagnosticConfig diagnosticConfig = DiagnosticConfig.newEmptyDiagnosticConfig();
        diagnosticConfig.setThrowExceptionPlaceholderFailedResolution(Boolean.valueOf(true));
        Log4jConfig log4jConfig = new Log4jConfig();
        log4jConfig.setLog4jConfigProperties(loggerProperties);
        MultiLoggerConfig mConfig = new MultiLoggerConfig();
        mConfig.setDiagnosticConfig(diagnosticConfig);
        mConfig.setLog4jLoggerEnabled(true);
        mConfig.setLog4jConfig(log4jConfig);
        mConfig.setDbLoggerEnabled(false);
        try {
            LoggerFactory.initialize((String)Log4jLoggerWithApplicationContext.class.getName(), (Object[])new Object[]{mConfig});
            LoggerFactory.newLogger();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public static Logger getLoggerCore() {
        if (!Startup.isInitializedLog()) {
            Startup.initLog();
        }
        return LoggerWrapperFactory.getLogger((String)"monitor.core");
    }

    public static Logger getLoggerDAO() {
        return LoggerWrapperFactory.getLogger((String)"monitor.dao");
    }
}

