/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.monitor.rs.server.config.DatasourceInstanceProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class DatasourceProperties {
    private Logger log = null;
    private DatasourceInstanceProperties reader;
    private static DatasourceProperties datasourceProperties = null;

    private DatasourceProperties(String confDir, Logger log) throws Exception {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(DatasourceProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = DatasourceProperties.class.getResourceAsStream("/rs-api-monitor.datasource.properties");
            if (properties == null) {
                throw new Exception("File '/rs-api-monitor.datasource.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'rs-api-monitor.datasource.properties': \n\n" + e.getMessage());
            throw new Exception("RS Api MonitorProperties initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new DatasourceInstanceProperties(propertiesReader, this.log, confDir);
    }

    public static boolean initialize(String confDir, Logger log) {
        try {
            datasourceProperties = new DatasourceProperties(confDir, log);
            return true;
        }
        catch (Exception e) {
            log.error("Errore durante l'inizializzazione del BackendProperties: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static DatasourceProperties getInstance() throws UtilsException {
        if (datasourceProperties == null) {
            Class<DatasourceProperties> clazz = DatasourceProperties.class;
            synchronized (DatasourceProperties.class) {
                throw new UtilsException("DatasourceProperties non inizializzato");
            }
        }
        return datasourceProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        DatasourceProperties.datasourceProperties.reader.setLocalObjectImplementation(prop);
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    public boolean isShowSql() throws UtilsException {
        return Boolean.parseBoolean(this.readProperty(true, "db.showSql"));
    }

    public String getConfigDataSource() throws UtilsException {
        return this.readProperty(true, "db.config.dataSource");
    }

    public Properties getConfigDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("db.config.dataSource.property.");
    }

    public String getConfigTipoDatabase() throws UtilsException {
        return this.readProperty(true, "db.config.tipoDatabase");
    }

    public String getTracceDataSource() throws UtilsException {
        return this.readProperty(true, "db.tracce.dataSource");
    }

    public Properties getTracceDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("db.tracce.dataSource.property.");
    }

    public String getTracceTipoDatabase() throws UtilsException {
        return this.readProperty(true, "db.tracce.tipoDatabase");
    }

    public String getStatisticheDataSource() throws UtilsException {
        return this.readProperty(true, "db.statistiche.dataSource");
    }

    public Properties getStatisticheDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("db.statistiche.dataSource.property.");
    }

    public String getStatisticheTipoDatabase() throws UtilsException {
        return this.readProperty(true, "db.statistiche.tipoDatabase");
    }
}

