/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import java.sql.Connection;
import java.util.ArrayList;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.web.lib.mvc.login.LoginException;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.dao.DBLoginDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class AuthenticationProvider
implements org.springframework.security.authentication.AuthenticationProvider {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String operatorRoleName = "operatore";
    private String diagnosticRoleName = "diagnostica";
    private String reportRoleName = "reportistica";

    private static String getS(String v) {
        return "sec" + v + "ret";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        Object passwordObject = authentication.getCredentials();
        String password = (String)passwordObject;
        if (username == null || password == null) {
            throw new AuthenticationCredentialsNotFoundException("Credentials not found");
        }
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        try {
            connection = dbManager.getConnectionConfig();
            ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesConfig();
            DBLoginDAO loginService = new DBLoginDAO(connection, true, smp, LoggerProperties.getLoggerDAO());
            UserDetailsBean u = null;
            try {
                u = loginService.loadUserByUsername(username, false);
            }
            catch (NotFoundException e) {
                throw new BadCredentialsException("Bad credentials");
            }
            catch (Exception e) {
                this.logAndThrowAuthenticationServiceException("AuthenticationProvider,ricerca utente fallita", e);
            }
            boolean correct = false;
            try {
                loginService.setPasswordManager(ServerProperties.getInstance().getUtenzeCryptConfig());
                correct = loginService.login(username, password);
            }
            catch (LoginException e) {
                if ("Utenza bloccata, superato il numero di tentativi di accesso massimo!".equals(e.getMessage())) {
                    throw new BadCredentialsException("Bad credentials");
                }
                this.logAndThrowAuthenticationServiceException("Inizializzazione AuthenticationProvider fallita", (Exception)((Object)e));
            }
            catch (Exception e) {
                this.logAndThrowAuthenticationServiceException("Inizializzazione AuthenticationProvider fallita", e);
            }
            if (!correct) {
                throw new BadCredentialsException("Bad credentials");
            }
            ArrayList<SimpleGrantedAuthority> roles = new ArrayList<SimpleGrantedAuthority>();
            if (u.getUtente() != null && u.getUtente().getPermessi() != null) {
                SimpleGrantedAuthority grant;
                if (u.getUtente().getPermessi().isDiagnostica()) {
                    grant = new SimpleGrantedAuthority(this.diagnosticRoleName);
                    roles.add(grant);
                }
                if (u.getUtente().getPermessi().isReportistica()) {
                    grant = new SimpleGrantedAuthority(this.reportRoleName);
                    roles.add(grant);
                }
                if (roles.size() == 2) {
                    grant = new SimpleGrantedAuthority(this.operatorRoleName);
                    roles.add(grant);
                }
            }
            User user = new User(username, AuthenticationProvider.getS(""), true, true, true, true, roles);
            UsernamePasswordAuthenticationToken userAuth = new UsernamePasswordAuthenticationToken((Object)user, (Object)AuthenticationProvider.getS(""), user.getAuthorities());
            userAuth.setDetails(authentication.getDetails());
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = userAuth;
            return usernamePasswordAuthenticationToken;
        }
        finally {
            dbManager.releaseConnectionConfig(connection);
        }
    }

    private void logAndThrowAuthenticationServiceException(String msg, Exception e) throws AuthenticationServiceException {
        LoggerProperties.getLoggerCore().error(e.getMessage(), (Throwable)e);
        throw new AuthenticationServiceException(msg + ": " + e.getMessage(), (Throwable)e);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public String getOperatorRoleName() {
        return this.operatorRoleName;
    }

    public void setOperatorRoleName(String operatorRoleName) {
        this.operatorRoleName = operatorRoleName;
    }

    public String getDiagnosticRoleName() {
        return this.diagnosticRoleName;
    }

    public void setDiagnosticRoleName(String diagnosticRoleName) {
        this.diagnosticRoleName = diagnosticRoleName;
    }

    public String getReportRoleName() {
        return this.reportRoleName;
    }

    public void setReportRoleName(String reportRoleName) {
        this.reportRoleName = reportRoleName;
    }
}

