/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api.impl.utils;

import org.joda.time.DateTime;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.Converter;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.HttpRequestWrapper;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.TipoReport;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.monitor.rs.server.config.SoggettiConfig;
import org.openspcoop2.core.monitor.rs.server.model.FiltroRicercaRuoloTransazioneEnum;
import org.openspcoop2.core.monitor.rs.server.model.FormatoReportEnum;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.TransazioneRuoloEnum;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.constants.ModalitaRicercaTransazioni;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.eventi.bean.EventiSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioniGeneraliSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingSearchForm;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;

public class SearchFormUtilities {
    private ServerProperties serverProperties = ServerProperties.getInstance();
    private ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();

    public User getUtente(IContext context) {
        User user = new User();
        user.setInterfaceType(InterfaceType.STANDARD);
        user.setLogin(context.getAuthentication().getName());
        PermessiUtente permessi = new PermessiUtente();
        permessi.setDiagnostica(true);
        permessi.setReportistica(true);
        user.setPermessi(permessi);
        user.setPermitAllServizi(true);
        user.setPermitAllSoggetti(true);
        return user;
    }

    private void initBaseInfo(BaseSearchForm searchForm, IContext context, ProfiloEnum profilo, String soggetto, FiltroRicercaRuoloTransazioneEnum ruolo) throws Exception {
        this.initBaseInfo(searchForm, context, profilo, soggetto);
        if (ruolo != null) {
            switch (ruolo) {
                case FRUIZIONE: {
                    searchForm.setTipologiaRicerca(TipologiaRicerca.uscita);
                    break;
                }
                case EROGAZIONE: {
                    searchForm.setTipologiaRicerca(TipologiaRicerca.ingresso);
                    break;
                }
                case QUALSIASI: {
                    searchForm.setTipologiaRicerca(TipologiaRicerca.all);
                }
            }
        }
    }

    private void initBaseInfo(BaseSearchForm searchForm, IContext context, ProfiloEnum profilo, String soggetto) throws Exception {
        searchForm.setUser(this.getUtente(context));
        String protocollo = Converter.toProtocollo(profilo);
        searchForm.setProtocollo(protocollo);
        String tipoSoggettoLocale = (String)this.protocolFactoryManager.getDefaultOrganizationTypes().get((Object)protocollo);
        String nomeSoggettoLocale = soggetto;
        if (nomeSoggettoLocale == null && this.serverProperties.useSoggettoDefault()) {
            nomeSoggettoLocale = this.serverProperties.getSoggettoDefaultIfEnabled(protocollo);
        }
        if (nomeSoggettoLocale != null) {
            if (!SoggettiConfig.existsIdentificativoPorta(tipoSoggettoLocale, nomeSoggettoLocale)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il soggetto '" + nomeSoggettoLocale + "' indicato non esiste");
            }
            searchForm.setTipoNomeSoggettoLocale(tipoSoggettoLocale + "/" + nomeSoggettoLocale);
            searchForm.setSoggettoPddMonitor(tipoSoggettoLocale + "/" + nomeSoggettoLocale);
        } else {
            searchForm.setCheckSoggettoPddMonitor(false);
        }
        searchForm.saveProtocollo();
    }

    public HttpRequestWrapper getHttpRequestWrapper(IContext context, ProfiloEnum profilo, String soggetto, FiltroRicercaRuoloTransazioneEnum ruolo, FormatoReportEnum formato, boolean formatoStat, TipoReport tipo) throws Exception {
        HttpRequestWrapper request = new HttpRequestWrapper(context.getServletRequest());
        request.overrideParameter("distribuzione", tipo.getValue());
        String protocollo = Converter.toProtocollo(profilo);
        request.overrideParameter("protocollo", protocollo);
        String tipoSoggettoLocale = (String)this.protocolFactoryManager.getDefaultOrganizationTypes().get((Object)protocollo);
        String nomeSoggettoLocale = soggetto;
        if (nomeSoggettoLocale == null && this.serverProperties.useSoggettoDefault()) {
            nomeSoggettoLocale = this.serverProperties.getSoggettoDefaultIfEnabled(protocollo);
        }
        if (nomeSoggettoLocale != null) {
            if (!SoggettiConfig.existsIdentificativoPorta(tipoSoggettoLocale, nomeSoggettoLocale)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il soggetto '" + nomeSoggettoLocale + "' indicato non esiste");
            }
            request.overrideParameter("soggettoLocale", tipoSoggettoLocale + "/" + nomeSoggettoLocale);
        }
        if (ruolo != null) {
            switch (ruolo) {
                case FRUIZIONE: {
                    request.overrideParameter("tipologia", "Fruizione");
                    break;
                }
                case EROGAZIONE: {
                    request.overrideParameter("tipologia", "Erogazione");
                    break;
                }
                case QUALSIASI: {
                    request.overrideParameter("tipologia", "Erogazione/Fruizione");
                }
            }
        }
        String nomeParametroTipoFormato = null;
        nomeParametroTipoFormato = formatoStat ? "formato" : "formatoConfigurazione";
        switch (formato) {
            case CSV: {
                request.overrideParameter(nomeParametroTipoFormato, "csv");
                break;
            }
            case PDF: {
                request.overrideParameter(nomeParametroTipoFormato, "pdf");
                break;
            }
            case XLS: {
                request.overrideParameter(nomeParametroTipoFormato, "xls");
                break;
            }
            case XML: {
                request.overrideParameter(nomeParametroTipoFormato, "xml");
                break;
            }
            case JSON: {
                request.overrideParameter(nomeParametroTipoFormato, "json");
                break;
            }
        }
        return request;
    }

    public HttpRequestWrapper getHttpRequestWrapper(IContext context, ProfiloEnum profilo, String soggetto, TransazioneRuoloEnum ruolo, FormatoReportEnum formato, boolean formatoStat, TipoReport tipo) throws Exception {
        FiltroRicercaRuoloTransazioneEnum ruoloNull = null;
        HttpRequestWrapper wrapper = this.getHttpRequestWrapper(context, profilo, soggetto, ruoloNull, formato, formatoStat, tipo);
        if (ruolo != null) {
            switch (ruolo) {
                case FRUIZIONE: {
                    wrapper.overrideParameter("tipologia", "Fruizione");
                    break;
                }
                case EROGAZIONE: {
                    wrapper.overrideParameter("tipologia", "Erogazione");
                }
            }
        }
        return wrapper;
    }

    public TransazioniSearchForm getAndamentoTemporaleSearchForm(IContext context, ProfiloEnum profilo, String soggetto, FiltroRicercaRuoloTransazioneEnum ruolo, DateTime dataInizio, DateTime dataFine) throws Exception {
        TransazioniSearchForm searchForm = new TransazioniSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, profilo, soggetto, ruolo);
        searchForm.setModalitaRicercaStorico(ModalitaRicercaTransazioni.ANDAMENTO_TEMPORALE.getValue());
        if (dataInizio != null && dataFine != null) {
            searchForm.setDataInizio(dataInizio.toDate());
            searchForm.setDataFine(dataFine.toDate());
        }
        return searchForm;
    }

    public TransazioniSearchForm getIdMessaggioSearchForm(IContext context, ProfiloEnum profilo, String soggetto) throws Exception {
        TransazioniSearchForm searchForm = new TransazioniSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, profilo, soggetto, null);
        searchForm.setModalitaRicercaStorico(ModalitaRicercaTransazioni.ID_MESSAGGIO.getValue());
        return searchForm;
    }

    public TransazioniSearchForm getIdTokenSearchForm(IContext context, ProfiloEnum profilo, String soggetto) throws Exception {
        TransazioniSearchForm searchForm = new TransazioniSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, profilo, soggetto, null);
        searchForm.setModalitaRicercaStorico(ModalitaRicercaTransazioni.ID_TOKEN.getValue());
        return searchForm;
    }

    public TransazioniSearchForm getPurposeIdSearchForm(IContext context, String soggetto) throws Exception {
        TransazioniSearchForm searchForm = new TransazioniSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, ProfiloEnum.MODIPA, soggetto, null);
        searchForm.setModalitaRicercaStorico(ModalitaRicercaTransazioni.PURPOSE_ID.getValue());
        return searchForm;
    }

    public TransazioniSearchForm getIdApplicativoBaseSearchForm(IContext context, ProfiloEnum profilo, String soggetto) throws Exception {
        TransazioniSearchForm searchForm = new TransazioniSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, profilo, soggetto, null);
        searchForm.setModalitaRicercaStorico(ModalitaRicercaTransazioni.ID_APPLICATIVO_BASE.getValue());
        return searchForm;
    }

    public EventiSearchForm getEventiSearchForm(IContext context, DateTime dataInizio, DateTime dataFine) throws Exception {
        EventiSearchForm searchForm = new EventiSearchForm();
        searchForm.setDataInizio(dataInizio.toDate());
        searchForm.setDataFine(dataFine.toDate());
        return searchForm;
    }

    public TransazioniSearchForm getIdApplicativoSearchForm(IContext context, ProfiloEnum profilo, String soggetto, FiltroRicercaRuoloTransazioneEnum ruolo, DateTime dataInizio, DateTime dataFine) throws Exception {
        TransazioniSearchForm searchForm = new TransazioniSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, profilo, soggetto, ruolo);
        searchForm.setModalitaRicercaStorico(ModalitaRicercaTransazioni.ID_APPLICATIVO_AVANZATA.getValue());
        if (dataInizio != null && dataFine != null) {
            searchForm.setDataInizio(dataInizio.toDate());
            searchForm.setDataFine(dataFine.toDate());
        }
        return searchForm;
    }

    public ConfigurazioniGeneraliSearchForm getConfigurazioniGeneraliSearchForm(IContext context, ProfiloEnum profilo, String soggetto, TransazioneRuoloEnum ruolo) throws Exception {
        ConfigurazioniGeneraliSearchForm searchForm = new ConfigurazioniGeneraliSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, profilo, soggetto);
        if (ruolo != null) {
            switch (ruolo) {
                case FRUIZIONE: {
                    searchForm.setTipologiaTransazioni(PddRuolo.DELEGATA);
                    break;
                }
                case EROGAZIONE: {
                    searchForm.setTipologiaTransazioni(PddRuolo.APPLICATIVA);
                }
            }
        }
        return searchForm;
    }

    public StatistichePdndTracingSearchForm getStatistichePdndTracingSearchForm(IContext context, String soggetto) throws Exception {
        StatistichePdndTracingSearchForm searchForm = new StatistichePdndTracingSearchForm();
        this.initBaseInfo((BaseSearchForm)searchForm, context, ProfiloEnum.MODI, soggetto);
        return searchForm;
    }
}

