/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.richfaces.event.DropListener;
import org.richfaces.event.DropSource;

public class DropListenerHandler
extends TagHandler {
    private Class listenerType;
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");

    public DropListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getAttribute("type");
        if (this.type != null) {
            if (!this.type.isLiteral()) {
                throw new TagAttributeException(this.tag, this.type, "Must be literal");
            }
            try {
                this.listenerType = Class.forName(this.type.getValue());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.tag, this.type, (Throwable)e);
            }
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent instanceof DropSource) {
            if (parent.getParent() == null) {
                DropSource src = (DropSource)parent;
                DropListener listener = null;
                ValueExpression ve = null;
                if (this.binding != null) {
                    ve = this.binding.getValueExpression(ctx, DropListener.class);
                    listener = (DropListener)ve.getValue((ELContext)ctx);
                }
                if (listener == null) {
                    try {
                        listener = (DropListener)this.listenerType.newInstance();
                    }
                    catch (Exception e) {
                        throw new TagAttributeException(this.tag, this.type, e.getCause());
                    }
                    if (ve != null) {
                        ve.setValue((ELContext)ctx, (Object)ve);
                    }
                }
                src.addDropListener(listener);
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type org.richfaces.event.DropSource, type is: " + parent);
        }
    }
}

