/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.JspTagException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.richfaces.el.ELBuilder;
import org.richfaces.iterator.ForEachIterator;
import org.richfaces.iterator.SimpleForEachIterator;
import org.richfaces.taglib.IndexedValueExpression;
import org.richfaces.taglib.IteratedExpression;
import org.richfaces.taglib.IteratedValueExpression;

class ColumnsHandlerIterationContext {
    private ForEachIterator items;
    private String indexId;
    private Integer begin;
    private Integer end;
    private Integer columnsCount;
    private String itemId = null;
    private Integer index = 0;
    private IteratedExpression iteratedExpression;
    private String valueExpr;

    ColumnsHandlerIterationContext() {
    }

    public String getVarReplacement(TagAttribute index) {
        if (this.valueExpr == null) {
            return String.valueOf(index);
        }
        if (this.items != null && this.items.getVarReplacement() != null) {
            return this.items.getVarReplacement();
        }
        return this.valueExpr + "[" + this.index + "]";
    }

    public String getIndexReplacement() {
        return String.valueOf(this.index);
    }

    boolean hasNext() {
        try {
            return (this.end == 0 || this.index < this.end) && this.items.hasNext();
        }
        catch (Exception e) {
            return false;
        }
    }

    void correctFirst() {
        if (this.items != null && this.begin > 0 && this.index < this.begin) {
            while (this.index < this.begin && this.hasNext()) {
                this.next();
            }
            if (!this.hasNext()) {
                this.index = 0;
            }
        }
    }

    Object next() {
        try {
            Object o = this.items.next();
            Integer n = this.index;
            this.index = this.index + 1;
            return o;
        }
        catch (Exception e) {
            return null;
        }
    }

    void setColumnsCount(FaceletContext ctx, TagAttribute columns) {
        if (columns != null) {
            try {
                this.columnsCount = Integer.parseInt((String)columns.getObject(ctx));
                if (this.columnsCount < 0) {
                    this.columnsCount = 0;
                }
            }
            catch (Exception e) {
                this.columnsCount = 0;
            }
        } else {
            this.columnsCount = 0;
        }
    }

    void setBegin(FaceletContext ctx, TagAttribute begin) {
        if (begin != null) {
            try {
                Object o = begin.getObject(ctx);
                if (o instanceof Number) {
                    this.begin = ((Number)o).intValue();
                } else if (o instanceof String) {
                    this.begin = Integer.parseInt((String)o);
                }
                Integer n = this.begin;
                this.begin = this.begin - 1;
                if (this.begin < 0) {
                    this.begin = 0;
                }
            }
            catch (Exception e) {
                this.begin = 0;
            }
        } else {
            this.begin = 0;
        }
    }

    void setEnd(FaceletContext ctx, TagAttribute end) {
        if (end != null) {
            try {
                Object o = end.getObject(ctx);
                if (o instanceof Number) {
                    this.end = ((Number)o).intValue();
                } else if (o instanceof String) {
                    this.end = Integer.parseInt((String)o);
                }
                if (this.end < 0) {
                    this.end = 0;
                }
            }
            catch (Exception e) {
                this.end = 0;
            }
        } else {
            this.end = 0;
        }
    }

    void setIndex(FaceletContext ctx, TagAttribute index) {
        if (index != null) {
            try {
                this.indexId = (String)index.getObject(ctx);
            }
            catch (ClassCastException e) {
                this.indexId = null;
            }
        }
    }

    void setVar(FaceletContext ctx, TagAttribute var) {
        if (var != null) {
            try {
                this.itemId = (String)var.getObject(ctx);
            }
            catch (ClassCastException e) {
                this.itemId = null;
            }
        }
    }

    void setValue(FaceletContext ctx, TagAttribute value) throws JspTagException {
        if (value != null) {
            this.valueExpr = ELBuilder.getVarReplacement(value.getValue());
            this.items = SimpleForEachIterator.supportedTypeForEachIterator(value.getObject(ctx));
        } else {
            this.items = SimpleForEachIterator.beginEndForEachIterator(this.columnsCount - 1);
        }
    }

    ValueExpression getVarExpression(FaceletContext ctx, ValueExpression expr) {
        Object o = expr.getValue(ctx.getFacesContext().getELContext());
        int k = this.index;
        if (o.getClass().isArray() || o instanceof List) {
            return new IndexedValueExpression(expr, k);
        }
        if (o instanceof Collection || o instanceof Iterator || o instanceof Enumeration || o instanceof Map || o instanceof String) {
            if (this.iteratedExpression == null) {
                this.iteratedExpression = new IteratedExpression(expr, ",");
            }
            return new IteratedValueExpression(this.iteratedExpression, k);
        }
        throw new ELException("FOREACH_BAD_ITEMS");
    }

    void release() {
        this.items = null;
        this.index = 0;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Integer getBegin() {
        return this.begin;
    }

    public Integer getIndex() {
        return this.index;
    }
}

