/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.el.ELBuilder;
import org.richfaces.taglib.ColumnHandlerComponentConfig;
import org.richfaces.taglib.ColumnTagHandler;
import org.richfaces.taglib.ColumnsAttributes;
import org.richfaces.taglib.ColumnsHandlerIterationContext;
import org.richfaces.taglib.IteratedIndexExpression;
import org.richfaces.taglib.RequestUniqueIdGenerator;

public class ColumnsHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(ColumnsHandler.class);
    private ComponentHandler handler;
    static final String ITERATION_INDEX_VARIABLE = "__richfaces_iteration_index_variable";
    private static final String F_GENERATION_SERIES_ATTRIBUTE = "org.richfaces.F_COLUMNS_GENERATION_SERIES";
    private TagAttribute value;
    private TagAttribute index;
    private ThreadLocal<ColumnsHandlerIterationContext> iterationContextLocal = new ThreadLocal();

    private ColumnsHandlerIterationContext getIterationContext() {
        return this.iterationContextLocal.get();
    }

    public ColumnsHandler(ComponentConfig config) {
        super((TagConfig)config);
        TagAttribute idAttribute = config.getTag().getAttributes().get("id");
        ComponentConfig columnConfig = idAttribute != null && idAttribute.isLiteral() ? new ColumnHandlerComponentConfig(config) : config;
        this.handler = new ColumnTagHandler(columnConfig){

            @Override
            protected MetaRuleset createMetaRuleset(Class type) {
                MetaRuleset ruleset = super.createMetaRuleset(type);
                ruleset.addRule(new MetaRule(){

                    public Metadata applyRule(final String name, final TagAttribute attribute, MetadataTarget meta) {
                        if (ColumnsAttributes.FILTER_ATTRIBUTES.indexOf(name) != -1 || ColumnsAttributes.SORT_ATTRIBUTES.indexOf(name) != -1) {
                            return new Metadata(){

                                public void applyMetadata(FaceletContext ctx, Object instance) {
                                    if (!attribute.isLiteral()) {
                                        String expr = attribute.getValue();
                                        ColumnsHandlerIterationContext itContext = (ColumnsHandlerIterationContext)ColumnsHandler.this.iterationContextLocal.get();
                                        ValueExpression ve = ELBuilder.createValueExpression(expr, Object.class, ctx.getExpressionFactory(), (ELContext)ctx, itContext.getItemId(), itContext.getIndexId(), itContext.getVarReplacement(ColumnsHandler.this.index), itContext.getIndexReplacement());
                                        ((UIComponent)instance).setValueExpression(name, ve);
                                    } else {
                                        ((UIComponent)instance).getAttributes().put(name, attribute.getValue());
                                    }
                                }
                            };
                        }
                        return null;
                    }
                });
                return ruleset;
            }

            protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
                c.getAttributes().put(ColumnsHandler.F_GENERATION_SERIES_ATTRIBUTE, RequestUniqueIdGenerator.generateId(ctx.getFacesContext()));
                super.applyNextHandler(ctx, c);
            }
        };
    }

    private void prepare(FaceletContext ctx) {
        ColumnsHandlerIterationContext itContext = this.getIterationContext();
        try {
            this.index = this.getAttribute("index");
            itContext.setIndex(ctx, this.index);
            itContext.setColumnsCount(ctx, this.getAttribute("columns"));
            itContext.setVar(ctx, this.getAttribute("var"));
            itContext.setBegin(ctx, this.getAttribute("begin"));
            itContext.setEnd(ctx, this.getAttribute("end"));
            this.value = this.getAttribute("value");
            itContext.setValue(ctx, this.value);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        itContext.correctFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        ColumnsHandler.clearOldColumns(ctx.getFacesContext(), parent);
        ColumnsHandlerIterationContext iterationContext = new ColumnsHandlerIterationContext();
        this.iterationContextLocal.set(iterationContext);
        this.prepare(ctx);
        try {
            while (iterationContext.hasNext()) {
                this.exposeVariables(ctx);
                this.handler.apply(ctx, parent);
                iterationContext.next();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            iterationContext.release();
            this.unExposeVariables(ctx);
            this.iterationContextLocal.remove();
        }
    }

    private static void clearOldColumns(FacesContext context, UIComponent parent) {
        if (parent.getChildCount() > 0) {
            Integer generatedId = RequestUniqueIdGenerator.generateId(context);
            Iterator childrenIt = parent.getChildren().iterator();
            while (childrenIt.hasNext()) {
                UIComponent c = (UIComponent)childrenIt.next();
                Object generationSeries = c.getAttributes().get(F_GENERATION_SERIES_ATTRIBUTE);
                if (generationSeries == null || generationSeries.equals(generatedId)) continue;
                childrenIt.remove();
            }
        }
    }

    private void exposeVariables(FaceletContext ctx) {
        int componentsCount;
        ValueExpression ve;
        VariableMapper vm = ctx.getVariableMapper();
        if (vm == null) {
            return;
        }
        ColumnsHandlerIterationContext itContext = this.getIterationContext();
        if (itContext.getItemId() != null && this.value != null) {
            ValueExpression srcVE = this.value.getValueExpression(ctx, Object.class);
            ve = itContext.getVarExpression(ctx, srcVE);
            vm.setVariable(itContext.getItemId(), ve);
        }
        if (itContext.getIndexId() != null) {
            IteratedIndexExpression ve2 = new IteratedIndexExpression(itContext.getIndex());
            vm.setVariable(itContext.getIndexId(), (ValueExpression)ve2);
        }
        if ((componentsCount = itContext.getIndex() - itContext.getBegin()) != 0) {
            ve = ctx.getExpressionFactory().createValueExpression((Object)("j_id" + componentsCount), String.class);
            vm.setVariable(ITERATION_INDEX_VARIABLE, ve);
        }
    }

    private void unExposeVariables(FaceletContext ctx) {
        VariableMapper vm = ctx.getVariableMapper();
        if (vm == null) {
            return;
        }
        ColumnsHandlerIterationContext itContext = this.getIterationContext();
        if (itContext.getItemId() != null) {
            vm.setVariable(itContext.getItemId(), null);
        }
        if (itContext.getIndexId() != null) {
            vm.setVariable(itContext.getIndexId(), null);
        }
        vm.setVariable(ITERATION_INDEX_VARIABLE, null);
    }
}

