/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.renderkit.AbstractRowsRenderer;

public class CellRenderer
extends RendererBase {
    public String styleClass(FacesContext context, UIComponent component) {
        Object custom;
        StringBuffer styleClass = new StringBuffer();
        Map requestMap = context.getExternalContext().getRequestMap();
        Object parentPredefined = requestMap.get(AbstractRowsRenderer.SKIN_CELL_CLASS_KEY);
        if (null != parentPredefined) {
            styleClass.append(parentPredefined).append(" ");
        } else {
            styleClass.append("rich-table-cell ");
        }
        Object parent = requestMap.get(AbstractRowsRenderer.CELL_CLASS_KEY);
        if (null != parent) {
            styleClass.append(parent).append(" ");
        }
        if (null != (custom = component.getAttributes().get("styleClass"))) {
            styleClass.append(custom);
        }
        return styleClass.toString();
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        String clientId = component.getClientId(context);
        String style = (String)component.getAttributes().get("style");
        String styleClass = this.styleClass(context, component);
        boolean isHeader = styleClass.contains("header");
        String tag = isHeader ? "th" : "td";
        if (style != null) {
            String cssClassName = RendererUtils.getCssId((FacesContext)context, (UIComponent)component);
            this.getUtils().writeStyle(writer, context, component, cssClassName, style);
            styleClass = this.getUtils().concatStyleClasses(styleClass, cssClassName);
        }
        String scriptContentForEventHandler = this.getUtils().getScriptContentForEventHandler(writer, context, component, tag);
        this.getUtils().writeScript(writer, context, component, (Object)scriptContentForEventHandler);
        writer.startElement(tag, component);
        this.getUtils().writeAttribute(writer, "class", (Object)styleClass);
        this.getUtils().writeAttribute(writer, "id", (Object)clientId);
        this.getUtils().encodeAttributesFromArray(context, component, new String[]{"abbr", "align", "axis", "bgcolor", "char", "charoff", "colspan", "dir", "headers", "height", "lang", "nowrap", "rowspan", "scope", "title", "valign", "width", "xml:lang"});
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeEnd(writer, context, component);
        boolean isHeader = this.styleClass(context, component).contains("header");
        if (isHeader) {
            writer.endElement("th");
        } else {
            writer.endElement("td");
        }
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIColumn.class;
    }
}

