/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.Column;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTable;
import org.richfaces.component.util.FormUtil;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.context.RequestContext;
import org.richfaces.model.Ordering;
import org.richfaces.renderkit.AbstractRowsRenderer;
import org.richfaces.renderkit.HeaderEncodeStrategy;
import org.richfaces.renderkit.TableHolder;
import org.richfaces.renderkit.html.iconimages.DataTableIconSortAsc;
import org.richfaces.renderkit.html.iconimages.DataTableIconSortDesc;
import org.richfaces.renderkit.html.iconimages.DataTableIconSortNone;

public abstract class AbstractTableRenderer
extends AbstractRowsRenderer {
    private static final String SORT_DIV = ":sortDiv";
    private static final String SORT_FILTER_PARAMETER = "fsp";
    private static final String FILTER_INPUT_FACET_NAME = "filterValueInput";
    private static final String REQUIRES_SCRIPTS_PARAMETER = AbstractTableRenderer.class.getName() + ":REQUIRES_SCRIPTS";
    private final InternetResource[] REQUIRED_SCRIPTS = new InternetResource[]{this.getResource(PrototypeScript.class.getName()), this.getResource(AjaxScript.class.getName())};

    public void encodeTBody(FacesContext context, UIDataTable table) throws IOException {
        String clientId = table.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tbody", (UIComponent)table);
        writer.writeAttribute("id", (Object)(clientId + ":tb"), null);
        this.encodeRows(context, (UIComponent)table);
        writer.endElement("tbody");
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.encodeTBody(context, (UIDataTable)component);
    }

    public void encodeTBodyAjax(FacesContext context, UIDataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)table);
        this.encodeTBody(context, table);
        writer.endElement("table");
    }

    public boolean renderBodyOnly(FacesContext context, UIDataTable table) {
        Map map = context.getExternalContext().getRequestParameterMap();
        return table.isRendered() && SORT_FILTER_PARAMETER.equals(map.get(table.getClientId(context)));
    }

    public void encodeTableStructure(FacesContext context, UIDataTable table) throws IOException {
        Object key = table.getRowKey();
        table.captureOrigValue(context);
        table.setRowKey(context, null);
        this.encodeCaption(context, table);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("colgroup", (UIComponent)table);
        int columns = this.getColumnsCount(table);
        writer.writeAttribute("span", (Object)String.valueOf(columns), null);
        String columnsWidth = (String)table.getAttributes().get("columnsWidth");
        if (null != columnsWidth) {
            String[] widths = columnsWidth.split(",");
            for (int i = 0; i < widths.length; ++i) {
                writer.startElement("col", (UIComponent)table);
                writer.writeAttribute("width", (Object)widths[i], null);
                writer.endElement("col");
            }
        }
        writer.endElement("colgroup");
        this.encodeHeader(context, table, columns);
        this.encodeFooter(context, table, columns);
        table.setRowKey(context, key);
        table.restoreOrigValue(context);
    }

    public void encodeHeader(FacesContext context, UIDataTable table, int numberOfColumns) throws IOException {
        boolean isEncodeHeaders;
        UIComponent header = table.getHeader();
        boolean bl = isEncodeHeaders = this.isColumnFacetPresent(table, "header") || this.isHeaderFactoryColumnAttributePresent(table, "filterBy");
        if (header != null || isEncodeHeaders) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("thead", (UIComponent)table);
            writer.writeAttribute("class", (Object)"rich-table-thead", null);
            String headerClass = (String)table.getAttributes().get("headerClass");
            if (header != null) {
                this.encodeTableHeaderFacet(context, numberOfColumns, writer, header, "rich-table-header", "rich-table-header-continue", "rich-table-headercell", headerClass, "th");
            }
            if (isEncodeHeaders) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "rich-table-subheader", null, headerClass);
                this.encodeHeaderFacets(context, writer, table.columns(), "rich-table-subheadercell", headerClass, "header", "th", numberOfColumns);
                writer.endElement("tr");
            }
            writer.endElement("thead");
        }
    }

    public boolean isColumnFacetPresent(UIDataTable table, String facetName) {
        Iterator<UIComponent> columns = table.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent component = columns.next();
            if (!this.isColumnRendered(component) || null == component.getFacet(facetName)) continue;
            result = true;
        }
        return result;
    }

    public boolean isHeaderFactoryColumnAttributePresent(UIDataTable table, String attributeName) {
        Iterator<UIComponent> columns = table.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent column = columns.next();
            if (!this.isColumnRendered(column) || null == column.getValueExpression(attributeName)) continue;
            result = true;
        }
        return result;
    }

    protected boolean isColumnRendered(UIComponent component) {
        try {
            return component.isRendered();
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected void encodeHeaderFacets(FacesContext context, ResponseWriter writer, Iterator<UIComponent> headers, String skinCellClass, String headerClass, String facetName, String element, int colCount) throws IOException {
        int t_colCount = 0;
        RichHeaderEncodeStrategy richEncodeStrategy = new RichHeaderEncodeStrategy();
        SimpleHeaderEncodeStrategy simpleEncodeStrategy = new SimpleHeaderEncodeStrategy();
        while (headers.hasNext()) {
            UIComponent column = headers.next();
            if (!this.isColumnRendered(column)) continue;
            Integer colspan = (Integer)column.getAttributes().get("colspan");
            t_colCount = colspan != null && colspan > 0 ? (t_colCount += colspan.intValue()) : ++t_colCount;
            if (t_colCount > colCount) break;
            String classAttribute = facetName + "Class";
            String columnHeaderClass = (String)column.getAttributes().get(classAttribute);
            writer.startElement(element, column);
            this.encodeStyleClass(writer, null, skinCellClass, headerClass, columnHeaderClass);
            writer.writeAttribute("scope", (Object)"col", null);
            this.getUtils().encodeAttribute(context, column, "colspan");
            boolean sortableColumn = column.getValueExpression("comparator") != null || column.getValueExpression("sortBy") != null;
            SimpleHeaderEncodeStrategy strategy = column instanceof org.richfaces.component.UIColumn && "header".equals(facetName) ? richEncodeStrategy : simpleEncodeStrategy;
            strategy.encodeBegin(context, writer, column, facetName, sortableColumn);
            UIComponent facet = column.getFacet(facetName);
            if (facet != null && this.isColumnRendered(facet)) {
                this.renderChild(context, facet);
            }
            strategy.encodeEnd(context, writer, column, facetName, sortableColumn);
            writer.endElement(element);
        }
    }

    public void encodeFooter(FacesContext context, UIDataTable table, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = table.getFooter();
        boolean columnFacetPresent = this.isColumnFacetPresent(table, "footer");
        Iterator<UIComponent> tableColumns = table.columns();
        if (footer != null || columnFacetPresent) {
            writer.startElement("tfoot", (UIComponent)table);
            String footerClass = (String)table.getAttributes().get("footerClass");
            if (columnFacetPresent) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "rich-table-subfooter", null, footerClass);
                this.encodeHeaderFacets(context, writer, tableColumns, "rich-table-subfootercell", footerClass, "footer", "td", columns);
                writer.endElement("tr");
            }
            if (footer != null) {
                this.encodeTableHeaderFacet(context, columns, writer, footer, "rich-table-footer", "rich-table-footer-continue", "rich-table-footercell", footerClass, "td");
            }
            writer.endElement("tfoot");
        }
    }

    @Override
    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
        UIDataTable table = (UIDataTable)holder.getTable();
        ResponseWriter writer = context.getResponseWriter();
        Iterator<UIComponent> iter = table.columns();
        boolean firstColumn = true;
        boolean firstRow = holder.getRowCounter() == 0;
        int currentColumn = 0;
        UIComponent column = null;
        while (iter.hasNext()) {
            column = iter.next();
            if (firstColumn && !(column instanceof Row)) {
                String firstRowSkinClass;
                String rowSkinClass = this.getRowSkinClass();
                if (firstRow && (firstRowSkinClass = this.getFirstRowSkinClass()) != null && firstRowSkinClass.length() != 0) {
                    rowSkinClass = rowSkinClass != null && rowSkinClass.length() != 0 ? rowSkinClass + " " + firstRowSkinClass : firstRowSkinClass;
                }
                this.encodeRowStart(context, rowSkinClass, holder.getRowClass(), table, writer, holder.getRowCounter());
            }
            if (column instanceof Column) {
                boolean breakBefore;
                boolean bl = breakBefore = ((Column)column).isBreakBefore() || column instanceof Row;
                if (breakBefore && !firstColumn) {
                    writer.endElement("tr");
                    currentColumn = 0;
                    if (!(column instanceof Row)) {
                        holder.nextRow();
                        this.encodeRowStart(context, holder.getRowClass(), table, writer, holder.getRowCounter());
                    }
                }
                this.encodeCellChildren(context, column, firstRow ? this.getFirstRowSkinClass() : null, this.getRowSkinClass(), holder.getRowClass(), this.getCellSkinClass(), holder.getColumnClass(currentColumn));
                if (column instanceof Row && iter.hasNext()) {
                    holder.nextRow();
                    this.encodeRowStart(context, holder.getRowClass(), table, writer, holder.getRowCounter());
                    currentColumn = -1;
                }
            } else if (column.isRendered()) {
                writer.startElement("td", (UIComponent)table);
                this.getUtils().encodeId(context, column);
                String columnClass = holder.getColumnClass(currentColumn);
                this.encodeStyleClass(writer, null, this.getCellSkinClass(), null, columnClass);
                this.renderChildren(context, column);
                writer.endElement("td");
            }
            ++currentColumn;
            firstColumn = false;
        }
        if (!firstColumn && !(column instanceof Row)) {
            writer.endElement("tr");
        }
    }

    protected void encodeRowStart(FacesContext context, String rowClass, UIDataTable table, ResponseWriter writer, int row) throws IOException {
        this.encodeRowStart(context, this.getRowSkinClass(), rowClass, table, writer, row);
    }

    protected String getRowSkinClass() {
        return "rich-table-row";
    }

    protected String getFirstRowSkinClass() {
        return "rich-table-firstrow";
    }

    protected String getCellSkinClass() {
        return "rich-table-cell";
    }

    protected void encodeRowStart(FacesContext context, String skinClass, String rowClass, UIDataTable table, ResponseWriter writer, int row) throws IOException {
        String clientId = table.getClientId(context) + ":tr-" + row;
        writer.startElement("tr", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, null);
        this.encodeStyleClass(writer, null, skinClass, null, rowClass);
        String script = this.getScriptRowEvents(context, (UIDataAdaptor)table, clientId, "tr");
        table.getRowEventHandlers().add(script);
    }

    protected int getColumnsCount(UIDataTable table) {
        int count = 0;
        Integer span = (Integer)table.getAttributes().get("columns");
        if (null != span && span != Integer.MIN_VALUE) {
            count = span;
        } else {
            Iterator<UIComponent> col = table.columns();
            count = this.calculateRowColumns(col);
        }
        return count;
    }

    protected int calculateRowColumns(Iterator<UIComponent> col) {
        int count = 0;
        int currentLength = 0;
        while (col.hasNext()) {
            UIComponent column = col.next();
            if (!column.isRendered()) continue;
            if (column instanceof Row) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.calculateRowColumns(((Row)column).columns())) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (column instanceof Column) {
                Integer colspan;
                Column tableColumn = (Column)column;
                if (tableColumn.isBreakBefore()) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                if (null != (colspan = (Integer)column.getAttributes().get("colspan")) && colspan != Integer.MIN_VALUE) {
                    currentLength += colspan.intValue();
                    continue;
                }
                ++currentLength;
                continue;
            }
            if (!(column instanceof UIColumn)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        Map map = context.getExternalContext().getRequestParameterMap();
        if (SORT_FILTER_PARAMETER.equals(map.get(clientId = component.getClientId(context)))) {
            String sortColumnId = (String)map.get(SORT_FILTER_PARAMETER);
            List list = component.getChildren();
            UIDataTable table = (UIDataTable)component;
            boolean isSingleSortMode = !"multi".equals(table.getSortMode());
            for (UIComponent child : list) {
                UIInput filterValueInput;
                org.richfaces.component.UIColumn column;
                if (!(child instanceof org.richfaces.component.UIColumn) || !(column = (org.richfaces.component.UIColumn)child).isRendered()) continue;
                child.setId(child.getId());
                if (sortColumnId != null) {
                    String columnClientId = child.getClientId(context);
                    if (sortColumnId.equals(columnClientId)) {
                        String id = child.getId();
                        Collection<Object> sortPriority = table.getSortPriority();
                        if (isSingleSortMode) {
                            sortPriority.clear();
                        }
                        if (!sortPriority.contains(id)) {
                            sortPriority.add(id);
                        }
                        column.toggleSortOrder();
                    } else if (isSingleSortMode) {
                        column.setSortOrder(Ordering.UNSORTED);
                    }
                    RequestContext requestContext = RequestContext.getInstance((FacesContext)context);
                    requestContext.setAttribute(columnClientId + SORT_DIV, (Object)Boolean.TRUE);
                }
                if (null == (filterValueInput = (UIInput)child.getFacet(FILTER_INPUT_FACET_NAME))) continue;
                filterValueInput.setId(filterValueInput.getId());
                filterValueInput.decode(context);
                Object submittedValue = filterValueInput.getSubmittedValue();
                if (null == submittedValue) continue;
                column.setFilterValue(filterValueInput.getSubmittedValue().toString());
            }
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
            ajaxContext.addRegionsFromComponent(component);
            ajaxContext.addComponentToAjaxRender(component);
            ajaxContext.addRegionsFromComponent(component);
            ajaxContext.addRenderedArea(clientId + ":tb");
            Set ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
            Set areasToRender = ajaxContext.getAjaxAreasToRender();
            for (String area : areasToRender) {
                if (!area.startsWith(':' + clientId) || (area = area.substring(1)).equals(clientId) || ajaxRenderedAreas.contains(area)) continue;
                ajaxContext.addRenderedArea(area);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String clientId;
        AjaxContext ajaxContext;
        Set ajaxRenderedAreas;
        super.encodeEnd(context, component);
        if (component instanceof UIDataTable && (ajaxRenderedAreas = (ajaxContext = AjaxContext.getCurrentInstance()).getAjaxRenderedAreas()).contains((clientId = ((UIDataTable)component).getBaseClientId(context)) + ":tb")) {
            ajaxRenderedAreas.remove(clientId);
        }
    }

    protected void addInplaceInput(FacesContext context, UIComponent column, String buffer) throws IOException {
        String filterEvent;
        UIInput filterValueInput = (UIInput)column.getFacet(FILTER_INPUT_FACET_NAME);
        if (null == filterValueInput) {
            filterValueInput = (UIInput)context.getApplication().createComponent("javax.faces.Input");
            filterValueInput.setId(column.getId() + SORT_FILTER_PARAMETER);
            filterValueInput.setImmediate(true);
            column.getFacets().put(FILTER_INPUT_FACET_NAME, filterValueInput);
            this.setRequiresScripts(context);
            filterValueInput.getAttributes().put("onclick", "Event.stop(event);");
            filterValueInput.getAttributes().put("styleClass", "rich-filter-input");
        }
        if (null == (filterEvent = (String)column.getAttributes().get("filterEvent")) || "".equals(filterEvent)) {
            filterEvent = "onchange";
        }
        filterValueInput.getAttributes().put(filterEvent, buffer);
        filterValueInput.setValue(column.getAttributes().get("filterValue"));
        this.getUtils().encodeBeginFormIfNessesary(context, column);
        this.renderChild(context, (UIComponent)filterValueInput);
        this.getUtils().encodeEndFormIfNessesary(context, column);
    }

    protected String buildAjaxFunction(FacesContext context, UIComponent column, boolean sortable) {
        UIComponent table = column.getParent();
        String id = table.getClientId(context);
        this.setRequiresScripts(context);
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table, (boolean)true);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(id, SORT_FILTER_PARAMETER);
        if (sortable) {
            parameters.put(SORT_FILTER_PARAMETER, column.getClientId(context));
        }
        ajaxFunction.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        ajaxFunction.appendScript(buffer);
        return buffer.toString();
    }

    protected void setRequiresScripts(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (requestMap.get(REQUIRES_SCRIPTS_PARAMETER) == null) {
            requestMap.put(REQUIRES_SCRIPTS_PARAMETER, Boolean.TRUE);
        }
    }

    protected boolean isRequiresScripts(FacesContext context) {
        if (context == null) {
            return false;
        }
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        return Boolean.TRUE.equals(requestMap.get(REQUIRES_SCRIPTS_PARAMETER));
    }

    protected InternetResource[] getScripts() {
        InternetResource[] resources = null;
        if (this.isRequiresScripts(FacesContext.getCurrentInstance())) {
            resources = this.REQUIRED_SCRIPTS;
        }
        return resources;
    }

    @Override
    protected String getScriptRowEvents(FacesContext context, UIDataAdaptor table, String clientId, String tag) throws IOException {
        String superEvents = super.getScriptRowEvents(context, table, clientId, tag);
        StringBuffer sb = new StringBuffer();
        Object event = table.getAttributes().get("onRowContextMenu");
        if (superEvents != null && superEvents.length() > 0) {
            sb.append(superEvents);
        }
        if (null != event) {
            String jQueryEvent = "oncontextmenu".substring("oncontextmenu".indexOf("on") + "on".length());
            sb.append("jQuery(\"" + tag + "[id$='" + clientId + "']\")." + jQueryEvent + "(function() {").append(event).append("});");
        }
        return sb.toString();
    }

    protected class RichHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected RichHeaderEncodeStrategy() {
        }

        @Override
        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            org.richfaces.component.UIColumn col = (org.richfaces.component.UIColumn)column;
            String columnClientId = col.getClientId(context);
            String clientId = columnClientId + facetName;
            writer.writeAttribute("id", (Object)clientId, null);
            if (sortableColumn && col.isSelfSorted()) {
                FormUtil.throwEnclFormReqExceptionIfNeed((FacesContext)context, (UIComponent)column.getParent());
                writer.writeAttribute("onclick", (Object)AbstractTableRenderer.this.buildAjaxFunction(context, column, true).toString(), null);
                writer.writeAttribute("class", (Object)"rich-table-cursor-pointer", null);
            }
            writer.startElement("div", column);
            writer.writeAttribute("id", (Object)(clientId + AbstractTableRenderer.SORT_DIV), null);
            RequestContext requestContext = RequestContext.getInstance((FacesContext)context);
            if (Boolean.TRUE.equals(requestContext.getAttribute(columnClientId + AbstractTableRenderer.SORT_DIV))) {
                AjaxContext.getCurrentInstance().addRenderedArea(clientId + AbstractTableRenderer.SORT_DIV);
            }
            if (sortableColumn) {
                writer.startElement("span", column);
                writer.writeAttribute("class", (Object)"rich-table-sortable-header", null);
            }
        }

        @Override
        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            org.richfaces.component.UIColumn col = (org.richfaces.component.UIColumn)column;
            if (sortableColumn) {
                String imageUrl = null;
                if (Ordering.ASCENDING.equals((Object)col.getSortOrder())) {
                    imageUrl = null != col.getSortIconAscending() ? ViewUtil.getResourceURL((String)col.getSortIconAscending(), (FacesContext)context) : AbstractTableRenderer.this.getResource(DataTableIconSortAsc.class.getName()).getUri(context, null);
                } else if (Ordering.DESCENDING.equals((Object)col.getSortOrder())) {
                    imageUrl = null != col.getSortIconDescending() ? ViewUtil.getResourceURL((String)col.getSortIconDescending(), (FacesContext)context) : AbstractTableRenderer.this.getResource(DataTableIconSortDesc.class.getName()).getUri(context, null);
                } else if (col.isSelfSorted()) {
                    imageUrl = null != col.getSortIcon() ? ViewUtil.getResourceURL((String)col.getSortIcon(), (FacesContext)context) : AbstractTableRenderer.this.getResource(DataTableIconSortNone.class.getName()).getUri(context, null);
                }
                if (imageUrl != null) {
                    writer.startElement("img", column);
                    writer.writeAttribute("src", (Object)imageUrl, null);
                    writer.writeAttribute("alt", (Object)"", null);
                    writer.writeAttribute("width", (Object)"15", null);
                    writer.writeAttribute("height", (Object)"15", null);
                    writer.writeAttribute("class", (Object)"rich-sort-icon", null);
                    writer.endElement("img");
                }
                writer.endElement("span");
            }
            writer.endElement("div");
            if (col.getFilterMethod() == null && col.getValueExpression("filterExpression") == null && col.getValueExpression("filterBy") != null) {
                writer.startElement("div", column);
                AbstractTableRenderer.this.addInplaceInput(context, column, AbstractTableRenderer.this.buildAjaxFunction(context, column, false));
                writer.endElement("div");
            }
        }
    }

    protected class SimpleHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected SimpleHeaderEncodeStrategy() {
        }

        @Override
        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
        }

        @Override
        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
        }
    }
}

