/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import jakarta.el.ValueExpression;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.model.ExtendedDataModel;
import org.apache.commons.collections.iterators.IteratorChain;
import org.richfaces.component.Column;
import org.richfaces.component.ExtendedDataTableState;
import org.richfaces.component.ExtendedTableColumnsIterator;
import org.richfaces.component.Filterable;
import org.richfaces.component.Selectable;
import org.richfaces.component.Sortable2;
import org.richfaces.component.SortedColumnsIterator;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIDataTable;
import org.richfaces.event.extdt.ChangeColumnVisibilityEvent;
import org.richfaces.event.extdt.ColumnResizeEvent;
import org.richfaces.event.extdt.DragDropEvent;
import org.richfaces.event.extdt.ExtTableFilterEvent;
import org.richfaces.event.extdt.ExtTableSortEvent;
import org.richfaces.model.ExtendedTableDataModel;
import org.richfaces.model.ExtendedTableDataModifiableModel;
import org.richfaces.model.FilterField;
import org.richfaces.model.LocaleAware;
import org.richfaces.model.Modifiable;
import org.richfaces.model.ModifiableModel;
import org.richfaces.model.Ordering;
import org.richfaces.model.SortField2;

public abstract class UIExtendedDataTable
extends UIDataTable
implements Selectable,
Filterable,
Sortable2 {
    public static final String COMPONENT_TYPE = "org.richfaces.ExtendedDataTable";
    public static final String COMPONENT_FAMILY = "org.richfaces.ExtendedDataTable";
    protected ExtendedDataTableState state;

    public abstract Object getActiveRowKey();

    public abstract void setActiveRowKey(Object var1);

    public abstract String getGroupingColumn();

    public abstract void setGroupingColumn(String var1);

    public abstract void setTableState(String var1);

    public abstract String getTableState();

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof AjaxEvent) {
            AjaxContext.getCurrentInstance().addComponentToAjaxRender((UIComponent)this);
        } else if (event instanceof DragDropEvent) {
            this.processDradDrop((DragDropEvent)event);
        } else if (event instanceof ChangeColumnVisibilityEvent) {
            this.processChangeColumnVisibility((ChangeColumnVisibilityEvent)event);
        } else if (event instanceof ColumnResizeEvent) {
            this.processColumnResize((ColumnResizeEvent)event);
        } else if (event instanceof ExtTableSortEvent) {
            this.processSortingChange((ExtTableSortEvent)event);
        } else if (event instanceof ExtTableFilterEvent) {
            this.processFilteringChange((ExtTableFilterEvent)event);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event.getSource() instanceof UIExtendedDataTable) {
            if (event instanceof AjaxEvent) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof DragDropEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof ChangeColumnVisibilityEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof ColumnResizeEvent) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (event instanceof ExtTableSortEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            } else if (event instanceof ExtTableFilterEvent) {
                new AjaxEvent((UIComponent)this).queue();
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public Iterator<UIColumn> getSortedColumns() {
        return new SortedColumnsIterator(this);
    }

    public Iterator<UIColumn> getChildColumns() {
        return new ExtendedTableColumnsIterator(this);
    }

    public void processDradDrop(DragDropEvent event) {
        String dragValue = event.getDragValue().toString();
        String dropValue = event.getDropValue().toString();
        this.getState().changeColumnsOrder(dragValue, dropValue, event.isDropBefore());
    }

    public List<UIComponent> getSortedChildren() {
        return this.getState().sortColumns(this.getFacesContext(), super.getChildren());
    }

    public void processChangeColumnVisibility(ChangeColumnVisibilityEvent event) {
        this.getState().toggleColumnVisibility(this, event.getColumnId());
    }

    public void processSortingChange(ExtTableSortEvent event) {
        DataModel dataModel = this.getDataModel();
        if (dataModel instanceof ExtendedTableDataModifiableModel) {
            ((ExtendedTableDataModifiableModel)dataModel).resetSort();
        } else {
            super.resetDataModel();
        }
        this.getFacesContext().renderResponse();
    }

    public void processFilteringChange(ExtTableFilterEvent event) {
        DataModel dataModel = this.getDataModel();
        if (dataModel instanceof ExtendedTableDataModifiableModel) {
            ((ExtendedTableDataModifiableModel)dataModel).resetFilter();
        } else {
            super.resetDataModel();
        }
        this.resetGroupVisibilityState();
        this.getFacesContext().renderResponse();
    }

    public boolean isColumnVisible(UIComponent column) {
        return this.getState().isColumnVisible(column.getId());
    }

    public void processColumnResize(ColumnResizeEvent event) {
        this.getState().changeColumnSize(this, event.getColumnWidths());
    }

    public String getColumnSize(UIComponent column) {
        return this.getState().getColumnSize(column);
    }

    public boolean isGroupingOn() {
        String groupingColumnId = this.getGroupByColumnId();
        return groupingColumnId != null && !"".equals(groupingColumnId) && !"none".equals(groupingColumnId);
    }

    public String getGroupByColumnId() {
        String id = this.getState().getGroupingColumnId();
        if (id == null) {
            id = this.getGroupingColumn();
        }
        return id;
    }

    public UIColumn getGroupByColumn() {
        if (!this.isGroupingOn()) {
            return null;
        }
        String groupingColumnId = this.getGroupByColumnId();
        Iterator<UIColumn> columns = this.getChildColumns();
        while (columns.hasNext()) {
            UIColumn child = columns.next();
            if (!groupingColumnId.equalsIgnoreCase(child.getId())) continue;
            return child;
        }
        return null;
    }

    public void setGroupByColumn(UIColumn column) {
        if (column == null) {
            this.getState().disableGrouping();
        } else {
            this.getState().groupBy(column.getId(), column.getSortOrder());
        }
    }

    protected void resetGroupVisibilityState() {
        this.getState().resetGroupVisibilityState();
    }

    public void disableGrouping() {
        this.getState().disableGrouping();
    }

    public boolean groupIsExpanded(int index) {
        return this.getState().groupIsExpanded(index);
    }

    public void toggleGroup(int index) {
        this.getState().toggleGroup(index);
    }

    protected Collection<Object> getGroupPriority() {
        Collection<Object> priority = this.getSortPriority();
        if (this.isGroupingOn()) {
            String groupColId;
            UIColumn column = this.getGroupByColumn();
            if (column.getSortOrder() == null || column.getSortOrder().equals((Object)Ordering.UNSORTED)) {
                column.setSortOrder(Ordering.ASCENDING);
            }
            if (priority.contains(groupColId = column.getId())) {
                priority.remove(groupColId);
            }
            if (priority instanceof List) {
                ((List)priority).add(0, groupColId);
            } else {
                priority.add(groupColId);
            }
        }
        return priority;
    }

    public int getVisibleColumnsCount() {
        int count = 0;
        Iterator<UIColumn> iter = this.getChildColumns();
        while (iter.hasNext()) {
            UIColumn column = iter.next();
            if (!column.isRendered()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ExtendedDataModel createDataModel() {
        SortField2 sortField;
        LinkedList<FilterField> filterFields = new LinkedList<FilterField>();
        LinkedHashMap<String, SortField2> sortFieldsMap = new LinkedHashMap<String, SortField2>();
        Collection<Object> sortPriority = this.getGroupPriority();
        List list = this.getChildren();
        for (Object component : list) {
            if (!(component instanceof UIColumn)) continue;
            UIColumn uIColumn = (UIColumn)((Object)component);
            FilterField filterField = uIColumn.getFilterField();
            if (filterField != null) {
                filterFields.add(filterField);
            }
            if ((sortField = uIColumn.getSortField()) == null) continue;
            sortFieldsMap.put(component.getId(), sortField);
        }
        LinkedList<Object> sortFields = new LinkedList<Object>();
        if (sortPriority != null) {
            for (Object e : sortPriority) {
                String id;
                if (!(e instanceof String) || (sortField = (SortField2)sortFieldsMap.get(id = (String)e)) == null) continue;
                sortFields.add(sortField);
                sortFieldsMap.remove(id);
            }
        }
        sortFields.addAll(sortFieldsMap.values());
        this.setFilterFields(filterFields);
        this.setSortFields(sortFields);
        ExtendedDataModel dataModel = (ExtendedDataModel)this.getDataModel();
        if (dataModel instanceof ExtendedTableDataModifiableModel) {
            ((ExtendedTableDataModifiableModel)dataModel).setVar(this.getVar());
        }
        if (filterFields != null && !filterFields.isEmpty() || sortFields != null && !sortFields.isEmpty()) {
            void var7_14;
            FacesContext facesContext;
            Object var7_10 = null;
            if (dataModel instanceof Modifiable) {
                Modifiable modifiable = (Modifiable)dataModel;
            } else if (dataModel instanceof ExtendedTableDataModel) {
                ExtendedTableDataModel tableDataModel = (ExtendedTableDataModel)dataModel;
                ExtendedTableDataModifiableModel modifiableModel = new ExtendedTableDataModifiableModel(tableDataModel, this.getVar());
                dataModel = modifiableModel;
                ExtendedTableDataModifiableModel extendedTableDataModifiableModel = modifiableModel;
            } else {
                ModifiableModel modifiableModel = new ModifiableModel(dataModel, this.getVar());
                dataModel = modifiableModel;
                ModifiableModel modifiableModel2 = modifiableModel;
            }
            if (dataModel instanceof LocaleAware && ContextInitParameters.isDatatableUsesViewLocale((FacesContext)(facesContext = this.getFacesContext()))) {
                UIViewRoot viewRoot = facesContext.getViewRoot();
                ((LocaleAware)dataModel).setLocale(viewRoot.getLocale());
            }
            var7_14.modify(filterFields, sortFields);
        }
        return dataModel;
    }

    protected void resetDataModel() {
        if (!(this.getDataModel() instanceof ExtendedTableDataModel)) {
            super.resetDataModel();
        }
    }

    public void resetState() {
        this.state = null;
        this.setTableState(null);
    }

    @Override
    public Iterator<UIComponent> fixedChildren() {
        IteratorChain chain = new IteratorChain(this.getFacets().values().iterator());
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof Column) && !(kid instanceof UIColumn)) continue;
            chain.addIterator(kid.getFacets().values().iterator());
        }
        return chain;
    }

    public void beforeRenderResponse(FacesContext context) {
        super.beforeRenderResponse(context);
        Iterator<UIColumn> columns = this.getChildColumns();
        while (columns.hasNext()) {
            UIColumn column = columns.next();
            column.setId(column.getId());
            column.setVisible(this.isColumnVisible((UIComponent)column));
        }
        UIColumn groupingColumn = this.getGroupByColumn();
        if (groupingColumn != null && groupingColumn.getSortOrder().equals((Object)Ordering.UNSORTED)) {
            groupingColumn.setSortOrder(Ordering.ASCENDING);
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.updateTableState(context);
    }

    protected void updateTableState(FacesContext context) {
        ValueExpression ve = this.getValueExpression("tableState");
        if (null != ve && !ve.isReadOnly(context.getELContext())) {
            ve.setValue(context.getELContext(), (Object)this.getState().toString());
        }
    }

    protected ExtendedDataTableState getState() {
        if (this.state == null) {
            this.state = ExtendedDataTableState.getExtendedDataTableState(this);
        }
        return this.state;
    }
}

