/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html.scripts;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.QueueRegistry;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSObject;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.html.QueueRendererData;
import org.ajax4jsf.resource.BaseResourceRenderer;
import org.ajax4jsf.resource.InternetResource;

public class QueueScriptResourceRenderer
extends BaseResourceRenderer {
    public static final String QUEUE_SCRIPT_ID = "org.ajax4jsf.queue_script";

    private void encodeQueue(ResponseWriter writer, String queueName, QueueRendererData queueData) throws IOException {
        Map<String, Object> queueAttributes = null;
        Map<String, Object> requestAttributes = null;
        if (queueData != null) {
            queueAttributes = queueData.getQueueAttributes();
            requestAttributes = queueData.getRequestAttributes();
        }
        writer.writeText((Object)("if (!EventQueue.getQueue(" + ScriptUtils.toScript((Object)queueName) + ")) { EventQueue.addQueue("), null);
        writer.writeText((Object)new JSObject("EventQueue", new Object[]{queueName, queueAttributes, requestAttributes}).toScript(), null);
        writer.writeText((Object)") };", null);
    }

    protected void customEncode(InternetResource resource, FacesContext context, Object data) throws IOException {
        super.customEncode(resource, context, data);
        Map queues = (Map)data;
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)"if (typeof A4J != 'undefined') { if (A4J.AJAX) { with (A4J.AJAX) {", null);
        for (Map.Entry entry : queues.entrySet()) {
            this.encodeQueue(writer, (String)entry.getKey(), (QueueRendererData)entry.getValue());
        }
        writer.writeText((Object)"}}};", null);
    }

    protected void doEncode(InternetResource resource, FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
        String resourceKey;
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (requestMap.get(resourceKey = resource.getKey()) == null) {
            String encodedGlobalQueueName;
            requestMap.put(resourceKey, Boolean.TRUE);
            QueueRegistry queueRegistry = QueueRegistry.getInstance((FacesContext)context);
            if (queueRegistry.isShouldCreateDefaultGlobalQueue() && !queueRegistry.containsQueue(encodedGlobalQueueName = context.getExternalContext().encodeNamespace("org.richfaces.queue.global"))) {
                queueRegistry.registerQueue(context, encodedGlobalQueueName, null);
            }
            if (queueRegistry.hasQueuesToEncode()) {
                super.encode(resource, context, (Object)queueRegistry.getRegisteredQueues(context), attributes);
            }
        }
    }

    private String encodeQueueScriptId(FacesContext context) {
        String encodedId = QUEUE_SCRIPT_ID;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (!ajaxContext.isAjaxRequest()) {
            encodedId = context.getExternalContext().encodeNamespace(encodedId);
        }
        return encodedId;
    }

    public void encode(InternetResource resource, FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
        LinkedHashMap<String, Object> newAttributes = new LinkedHashMap<String, Object>(attributes);
        newAttributes.put("id", this.encodeQueueScriptId(context));
        this.doEncode(resource, context, data, newAttributes);
    }

    public void encode(InternetResource resource, FacesContext context, Object data) throws IOException {
        this.doEncode(resource, context, data, Collections.singletonMap("id", this.encodeQueueScriptId(context)));
    }

    protected String[][] getCommonAttrs() {
        return new String[][]{{"type", this.getContentType()}};
    }

    protected String getHrefAttr() {
        return null;
    }

    protected String getTag() {
        return "script";
    }

    public String getContentType() {
        return "text/javascript";
    }
}

