/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.transaction;

import org.apache.logging.log4j.Level;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.monitor.engine.config.LoggerManager;
import org.openspcoop2.monitor.engine.config.MonitorProperties;
import org.openspcoop2.monitor.engine.transaction.TransactionLibrary;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class TransactionProcessor {
    public static void main(String[] args) throws Exception {
        LoggerWrapperFactory.setDefaultConsoleLogConfiguration((Level)Level.ERROR);
        LoggerManager.initLogger();
        Logger logCore = LoggerWrapperFactory.getLogger((String)"org.openspcoop2.monitor.engine.transaction");
        Logger logSql = LoggerWrapperFactory.getLogger((String)"org.openspcoop2.monitor.engine.transaction.sql");
        boolean debug = true;
        int poolSize = 5;
        int msgForThread = 10;
        String protocolloDefault = MonitorProperties.getInstance(logCore).getProperty("org.openspcoop2.monitor.defaultProtocol", false, true);
        ConfigurazionePdD configPdD = new ConfigurazionePdD();
        configPdD.setLoader(new Loader());
        configPdD.setLog(logCore);
        configPdD.setAttesaAttivaJDBC(-1L);
        configPdD.setCheckIntervalJDBC(-1);
        configPdD.setConfigurationDir(null);
        ProtocolFactoryManager.initialize((Logger)logCore, (ConfigurazionePdD)configPdD, (String)protocolloDefault);
        DAOFactory daoFactory = DAOFactory.getInstance((Logger)logSql);
        TransactionLibrary.process(logCore, daoFactory, debug, poolSize, msgForThread);
    }
}

