/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.Date;
import org.openspcoop2.core.statistiche.StatisticaInfo;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.dao.IStatisticaInfoService;
import org.openspcoop2.core.statistiche.dao.IStatisticaInfoServiceSearch;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.slf4j.Logger;

public class StatisticsInfoUtils {
    private StatisticsInfoUtils() {
    }

    public static Date readDataUltimaGenerazioneStatistiche(IStatisticaInfoServiceSearch statisticaInfoSearchDAO, TipoIntervalloStatistico tipoStatistica, Logger logger) throws NotFoundException {
        try {
            IExpression expr = statisticaInfoSearchDAO.newExpression();
            expr.equals(StatisticaInfo.model().TIPO_STATISTICA, (Object)tipoStatistica);
            StatisticaInfo info = (StatisticaInfo)statisticaInfoSearchDAO.find(expr);
            return info.getDataUltimaGenerazione();
        }
        catch (ServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new Date(0L);
    }

    public static void updateDataUltimaGenerazioneStatistiche(IStatisticaInfoServiceSearch statisticaInfoSearchDAO, IStatisticaInfoService statisticaInfoDAO, TipoIntervalloStatistico tipoStatistica, Logger logger, Date date) throws Exception {
        try {
            IExpression expr = statisticaInfoSearchDAO.newExpression();
            expr.equals(StatisticaInfo.model().TIPO_STATISTICA, (Object)tipoStatistica);
            StatisticaInfo info = (StatisticaInfo)statisticaInfoSearchDAO.find(expr);
            info.setDataUltimaGenerazione(date);
            statisticaInfoDAO.update((Object)info);
        }
        catch (ServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            StatisticaInfo info = new StatisticaInfo();
            info.setDataUltimaGenerazione(date);
            info.setTipoStatistica(tipoStatistica);
            statisticaInfoDAO.create((Object)info);
        }
        catch (MultipleResultException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

