/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.Calendar;
import java.util.Date;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.Statistica;
import org.openspcoop2.core.statistiche.StatisticaContenuti;
import org.openspcoop2.core.statistiche.StatisticaSettimanale;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.dao.IDBStatisticaSettimanaleService;
import org.openspcoop2.core.statistiche.dao.IStatisticaSettimanaleService;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.statistic.AbstractStatistiche;
import org.openspcoop2.monitor.engine.statistic.CustomStatisticsSdkGenerator;
import org.openspcoop2.monitor.engine.statistic.StatisticBean;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.StatisticException;
import org.openspcoop2.monitor.sdk.plugins.IStatisticProcessing;
import org.openspcoop2.monitor.sdk.statistic.IStatistic;

public class StatisticheSettimanali
extends AbstractStatistiche {
    public static StatisticheSettimanali getInstanceForUtils() {
        return new StatisticheSettimanali();
    }

    StatisticheSettimanali() {
    }

    @Override
    public void init(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        super.init(config, statisticheSM, transazioniSM, pluginsStatisticheSM, pluginsBaseSM, utilsSM, pluginsTransazioniSM);
        try {
            if (statisticheSM == null) {
                throw new ServiceException("ServiceManager [" + org.openspcoop2.core.statistiche.dao.IServiceManager.class.getName() + "] non inizializzato");
            }
            this.model = StatisticaSettimanale.model().STATISTICA_BASE;
            this.statisticaServiceDAO = this.statisticheSM.getStatisticaSettimanaleService();
            this.statisticaServiceSearchDAO = this.statisticheSM.getStatisticaSettimanaleServiceSearch();
        }
        catch (ServiceException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Calendar truncDate(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        while (2 != cTmp.get(7)) {
            cTmp.add(7, -1);
        }
        cTmp.set(11, 0);
        cTmp.set(12, 0);
        cTmp.set(13, 0);
        cTmp.set(14, 0);
        return cTmp;
    }

    @Override
    public Date truncDate(Date date, boolean print) {
        Calendar cTmp = this.truncDate(date);
        if (print) {
            this.printCalendar(cTmp);
        }
        return cTmp.getTime();
    }

    @Override
    public String getIntervalloStatistica(Date date, boolean print) {
        Calendar cTmp = this.truncDate(date);
        StringBuilder bf = new StringBuilder();
        bf.append("Settimana N.");
        bf.append(cTmp.get(3));
        bf.append(" (");
        switch (cTmp.get(7)) {
            case 2: {
                bf.append("Luned\u00ec");
                break;
            }
            case 3: {
                bf.append("Marted\u00ec");
                break;
            }
            case 4: {
                bf.append("Mercoled\u00ec");
                break;
            }
            case 5: {
                bf.append("Gioved\u00ec");
                break;
            }
            case 6: {
                bf.append("Venerd\u00ec");
                break;
            }
            case 7: {
                bf.append("Sabato");
                break;
            }
            case 1: {
                bf.append("Domenica");
            }
        }
        bf.append(",");
        bf.append(cTmp.get(5));
        bf.append("/");
        bf.append(cTmp.get(2) + 1);
        bf.append("/");
        bf.append(cTmp.get(1));
        bf.append(" - ");
        cTmp.add(6, 7);
        cTmp.add(14, -1);
        switch (cTmp.get(7)) {
            case 2: {
                bf.append("Luned\u00ec");
                break;
            }
            case 3: {
                bf.append("Marted\u00ec");
                break;
            }
            case 4: {
                bf.append("Mercoled\u00ec");
                break;
            }
            case 5: {
                bf.append("Gioved\u00ec");
                break;
            }
            case 6: {
                bf.append("Venerd\u00ec");
                break;
            }
            case 7: {
                bf.append("Sabato");
                break;
            }
            case 1: {
                bf.append("Domenica");
            }
        }
        bf.append(",");
        bf.append(cTmp.get(5));
        bf.append("/");
        bf.append(cTmp.get(2) + 1);
        bf.append("/");
        bf.append(cTmp.get(1));
        bf.append(")");
        return bf.toString();
    }

    @Override
    public Date incrementDate(Date date, boolean print) {
        return this.operation(date, print, 7);
    }

    @Override
    public Date decrementDate(Date date, boolean print) {
        return this.operation(date, print, -7);
    }

    private Date operation(Date date, boolean print, int value) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        if (print) {
            this.logger.debug(">>> incrementDate >>>>");
            this.logger.debug("Before: ");
            this.printCalendar(cTmp);
        }
        cTmp.add(6, value);
        if (print) {
            this.logger.debug("After: ");
            this.printCalendar(cTmp);
            this.logger.debug(">>> incrementDate end >>>>");
        }
        return cTmp.getTime();
    }

    @Override
    public TipoIntervalloStatistico getTipoStatistiche() {
        return TipoIntervalloStatistico.STATISTICHE_SETTIMANALI;
    }

    @Override
    public void callStatisticPluginMethod(IStatisticProcessing statProcessing, StatisticBean stat) throws StatisticException {
        CustomStatisticsSdkGenerator statContext = new CustomStatisticsSdkGenerator(stat, StatisticType.SETTIMANALE, this);
        statProcessing.createWeeklyStatisticData((IStatistic)statContext);
    }

    @Override
    public String getStatisticPluginMethodName() throws StatisticException {
        return "createWeeklyStatisticData";
    }

    @Override
    protected Long insertStatistica(Statistica statistica) throws StatisticException {
        try {
            StatisticaSettimanale stat = new StatisticaSettimanale();
            stat.setStatisticaBase(statistica);
            ((IStatisticaSettimanaleService)this.statisticaServiceDAO).create((Object)stat);
            return stat.getId();
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void updateStatistica(long idStatistica, StatisticaContenuti ... statisticaContenuti) throws StatisticException {
        try {
            StatisticaSettimanale stat = (StatisticaSettimanale)((IDBStatisticaSettimanaleService)this.statisticaServiceDAO).get(idStatistica);
            for (int i = 0; i < statisticaContenuti.length; ++i) {
                statisticaContenuti[i].setData(stat.getStatisticaBase().getData());
                stat.addStatisticaSettimanaleContenuti(statisticaContenuti[i]);
            }
            ((IStatisticaSettimanaleService)this.statisticaServiceDAO).update((Object)stat);
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean isGestioneUltimoIntervallo(StatisticsConfig config) {
        return config.isStatisticheSettimanaliGestioneUltimoIntervallo();
    }

    @Override
    public boolean isEnabled(StatisticsConfig config) {
        return config.isStatisticheSettimanali();
    }
}

