/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.plugins.utils.ProjectInfo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.BasicServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneRisorsaContenuto;
import org.openspcoop2.monitor.engine.exceptions.RegolaDumpNotExistsException;
import org.openspcoop2.monitor.engine.statistic.CustomStatisticsSdkGenerator;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.condition.FilterFactory;
import org.openspcoop2.monitor.sdk.condition.IStatisticFilter;
import org.openspcoop2.monitor.sdk.condition.StatisticsContext;
import org.openspcoop2.monitor.sdk.constants.ParameterType;
import org.openspcoop2.monitor.sdk.exceptions.ParameterException;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.exceptions.StatisticException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.parameters.ParameterFactory;
import org.openspcoop2.monitor.sdk.plugins.StatisticProcessing;
import org.openspcoop2.monitor.sdk.statistic.IStatistic;
import org.slf4j.Logger;

public class StatisticByResource
extends StatisticProcessing {
    public static final String ID = "__StatisticByResource__";
    public static final String LABEL = "Risorse";
    public static final String DESCRIZIONE = "Informazioni Statistiche sulle Risorse associate alle Transazioni";
    public static final String PARAM_RESOURCE = "Risorsa";

    public void createHourlyStatisticData(IStatistic context) throws StatisticException {
        this.createStatisticData(context);
    }

    public void createWeeklyStatisticData(IStatistic context) throws StatisticException {
        this.createStatisticData(context);
    }

    public void createMonthlyStatisticData(IStatistic context) throws StatisticException {
        this.createStatisticData(context);
    }

    public void createDailyStatisticData(IStatistic context) throws StatisticException {
        this.createStatisticData(context);
    }

    private void createStatisticData(IStatistic context) throws StatisticException {
        try {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(context.getTipoServizio(), context.getServizio(), context.getTipoSoggettoDestinatario(), context.getSoggettoDestinatario(), context.getVersioneServizio().intValue());
            idServizio.setAzione(context.getAzione());
            boolean debug = false;
            if (context instanceof CustomStatisticsSdkGenerator) {
                CustomStatisticsSdkGenerator custom = (CustomStatisticsSdkGenerator)context;
                debug = custom.getAbstractStatisticheCore().isDebug();
            }
            List<String> listResources = this.readResources(idServizio, context.getLogger(), debug);
            for (String resourceID : listResources) {
                context.createStatistics(resourceID, resourceID);
            }
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Parameter<?>> getParameters(Context context) throws SearchException, ParameterException {
        List<String> listResources = null;
        try {
            listResources = this.readResources(this.toIDServizio(context), context.getLogger(), false);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
        ArrayList parameters = new ArrayList();
        Parameter pRisorsa = ParameterFactory.createParameter((ParameterType)ParameterType.SELECT_LIST, (String)PARAM_RESOURCE);
        pRisorsa.getRendering().setLabel(PARAM_RESOURCE);
        pRisorsa.getRendering().setSuggestion("Indicare la risorsa per cui si vuole visualizzare le informazioni statistiche");
        pRisorsa.getRendering().setValues(listResources);
        pRisorsa.getRendering().setRequired(true);
        parameters.add(pRisorsa);
        return parameters;
    }

    public IStatisticFilter createSearchFilter(StatisticsContext context) throws StatisticException {
        try {
            Parameter resource = context.getParameter(PARAM_RESOURCE);
            String resourceValue = (String)resource.getValue();
            if (resourceValue == null) {
                throw new StatisticException("Parameter undefined");
            }
            IStatisticFilter filter = FilterFactory.newFilterStatisticRepository((StatisticsContext)context);
            filter.setIdStatistic(resourceValue);
            return filter;
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    private IDServizio toIDServizio(Context context) throws DriverRegistroServiziException {
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(context.getTipoServizio(), context.getServizio(), context.getTipoSoggettoDestinatario(), context.getSoggettoDestinatario(), context.getVersioneServizio().intValue());
        idServizio.setAzione(context.getAzione());
        return idServizio;
    }

    private List<String> readResources(IDServizio idServizio, Logger log, boolean debug) throws Exception {
        TransactionServiceLibrary transactionServiceLibrary = this.getObjectReadFromDB(idServizio, log, debug);
        List<ConfigurazioneTransazioneRisorsaContenuto> list = transactionServiceLibrary.mergeServiceActionTransactionLibrary_resources();
        ArrayList<String> resources = new ArrayList<String>();
        if (list != null) {
            for (ConfigurazioneTransazioneRisorsaContenuto configurazioneTransazioneRisorsaContenuto : list) {
                if (!configurazioneTransazioneRisorsaContenuto.isStatEnabled()) continue;
                resources.add(configurazioneTransazioneRisorsaContenuto.getNome());
            }
        }
        return resources;
    }

    private TransactionServiceLibrary getObjectReadFromDB(IDServizio idServizio, Logger log, boolean debug) throws Exception, RegolaDumpNotExistsException {
        DAOFactory daoFactory = DAOFactory.getInstance((Logger)log);
        IServiceManager jdbcServiceManagerPluginsBase = (IServiceManager)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance());
        org.openspcoop2.core.commons.search.dao.IServiceManager jdbcServiceManagerUtils = (org.openspcoop2.core.commons.search.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
        org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager serviceManagerPluginsTransazioni = (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance());
        BasicServiceLibraryReader basicServiceLibraryReader = new BasicServiceLibraryReader(jdbcServiceManagerPluginsBase, jdbcServiceManagerUtils, debug);
        BasicServiceLibrary basicServiceLibrary = basicServiceLibraryReader.read(idServizio, log);
        if (basicServiceLibrary == null) {
            throw new RegolaDumpNotExistsException("Regola di dump non esiste per servizio [" + String.valueOf(idServizio) + "]");
        }
        TransactionServiceLibraryReader transactionServiceLibraryReader = new TransactionServiceLibraryReader(serviceManagerPluginsTransazioni, debug);
        TransactionServiceLibrary transactionServiceLibrary = transactionServiceLibraryReader.readConfigurazioneTransazione(basicServiceLibrary, log);
        if (transactionServiceLibrary == null) {
            throw new RegolaDumpNotExistsException("Regola di dump (Transaction-Info) non esiste per servizio [" + String.valueOf(idServizio) + "]");
        }
        return transactionServiceLibrary;
    }
}

