/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class PdndTracciamentoSoggetto {
    private IDSoggetto idSoggetto;
    private String statoTracciamento;
    private List<IDSoggetto> idSoggettiAggregati = new ArrayList<IDSoggetto>();

    public PdndTracciamentoSoggetto(IDSoggetto idSoggetto, String statoTracciamento) throws ProtocolException {
        if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null || idSoggetto.getCodicePorta() == null) {
            throw new ProtocolException("Dati forniti  per idSoggetto incompleti (" + String.valueOf(idSoggetto) + ")");
        }
        if (!(statoTracciamento == null || statoTracciamento.equals("-1") || statoTracciamento.equals("1") || statoTracciamento.equals("0"))) {
            throw new ProtocolException("Stato tracciamento '" + statoTracciamento + "' non supportato");
        }
        this.idSoggetto = idSoggetto;
        this.statoTracciamento = statoTracciamento;
    }

    public void addSoggettoAggregato(IDSoggetto idSoggetto) throws ProtocolException {
        int index;
        if (this.idSoggettiAggregati == null) {
            this.idSoggettiAggregati = new ArrayList<IDSoggetto>();
        }
        if ((index = this.getIndexSoggettoAggregato(idSoggetto)) >= 0) {
            throw new ProtocolException("Soggetto '" + String.valueOf(idSoggetto) + "' gi\u00e0 esistente");
        }
        this.idSoggettiAggregati.add(idSoggetto);
    }

    public void removeSoggettoAggregato(IDSoggetto idSoggetto) {
        int index = this.getIndexSoggettoAggregato(idSoggetto);
        if (index >= 0) {
            this.idSoggettiAggregati.remove(index);
        }
    }

    public int getIndexSoggettoAggregato(IDSoggetto idSoggetto) {
        int index = -1;
        if (this.idSoggettiAggregati != null && !this.idSoggettiAggregati.isEmpty()) {
            for (int i = 0; i < this.idSoggettiAggregati.size(); ++i) {
                if (!this.idSoggettiAggregati.get(i).equals((Object)idSoggetto)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public List<IDSoggetto> getIdSoggettiAggregati() {
        return this.idSoggettiAggregati;
    }

    public IDSoggetto getIdSoggetto() {
        return this.idSoggetto;
    }

    public void setIdSoggetto(IDSoggetto idSoggetto) {
        this.idSoggetto = idSoggetto;
    }

    public String getStatoTracciamento() {
        return this.statoTracciamento;
    }

    public void setStatoTracciamento(String statoTracciamento) {
        this.statoTracciamento = statoTracciamento;
    }

    public boolean isTracciamentoDefault() {
        return this.statoTracciamento == null || this.statoTracciamento.equals("-1");
    }

    public boolean isTracciamentoAbilitato() {
        return this.statoTracciamento != null && this.statoTracciamento.equals("1");
    }

    public boolean isTracciamentoDisabilitato() {
        return this.statoTracciamento != null && this.statoTracciamento.equals("0");
    }
}

