/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.mail.BodyPart;
import jakarta.mail.internet.InternetHeaders;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.StatistichePdndTracing;
import org.openspcoop2.core.statistiche.constants.PdndMethods;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiPdnd;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiRichieste;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.dao.IStatistichePdndTracingService;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.monitor.engine.statistic.IStatisticsEngine;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoInfo;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoSoggetto;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoUtils;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsEngineException;
import org.openspcoop2.monitor.engine.statistic.StatisticsInfoUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.mime.MimeMultipart;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class PdndPublicazioneTracciamento
implements IStatisticsEngine {
    private static final String PDND_DATE_FORMAT = "yyyy-MM-dd";
    private static final String TRACING_ID_FIELD = "tracingId";
    private static final String CONNECTION_ERROR = "CONNECTION_ERROR";
    private static final String PDND_PARSING_ERROR = "PDND_PARSING_ERROR";
    private static final String PDND_PUBLISHING_ERROR = "PDND_PUBLISHING_ERROR";
    private IStatistichePdndTracingService pdndStatisticheSM;
    private org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM;
    private Logger logger;
    private StatisticsConfig config;
    private PdndTracciamentoInfo internalPddCodes;
    private Map<Date, StatistichePdndTracing> updateTracingIdStats;
    private static final String PDND_RESPONSE_ERRORS_CLAIM = "errors";

    PdndPublicazioneTracciamento() {
    }

    @Override
    public void init(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        this.logger = config.getLogCore();
        this.config = config;
        this.updateTracingIdStats = new HashMap<Date, StatistichePdndTracing>();
        try {
            this.statisticheSM = statisticheSM;
            this.pdndStatisticheSM = statisticheSM.getStatistichePdndTracingService();
            this.internalPddCodes = PdndTracciamentoUtils.getEnabledPddCodes(utilsSM, this.config);
            PdndTracciamentoUtils.logDebugSoggettiAbilitati(this.internalPddCodes, this.logger);
        }
        catch (Throwable e) {
            this.logger.error("Impossibile inizializzare la classe PdndGenerazioneTracciamento", e);
        }
    }

    private HttpRequest getBaseRequest(String pddCode) {
        PdndTracciamentoSoggetto s = this.internalPddCodes.getInfoByIdentificativoPorta(pddCode, true, false);
        return this.config.getPdndTracciamentoRequestConfig().getBaseRequest(s.getIdSoggetto().getNome());
    }

    private HttpResponse httpInvokeWithException(HttpRequest req) throws UtilsException {
        HttpResponse res = HttpUtilities.httpInvoke((HttpRequest)req);
        if (res == null) {
            throw new UtilsException("HttpResponse is null");
        }
        if (res.getResultHTTPOperation() < 200 || res.getResultHTTPOperation() > 204) {
            throw new UtilsException("HttpResponse return code '" + res.getResultHTTPOperation() + "'");
        }
        if (res.getContent() == null || res.getContent().length <= 0) {
            throw new UtilsException("HttpResponse is empty");
        }
        return res;
    }

    private Iterator<Result<JsonNode, UtilsException>> iteratorHttpList(HttpRequest req) {
        int limit = 50;
        AtomicInteger offset = new AtomicInteger(-50);
        LinkedList list = new LinkedList();
        JSONUtils jsonUtils = JSONUtils.getInstance();
        return ((Stream)Stream.generate(() -> {
            if (list.isEmpty()) {
                offset.addAndGet(50);
                req.addParam("limit", Integer.toString(50));
                req.addParam("offset", Integer.toString(offset.get()));
                try {
                    HttpResponse res = this.httpInvokeWithException(req);
                    JsonNode node = jsonUtils.getAsNode(res.getContent());
                    JsonNode result = node.get("results");
                    for (int i = 0; i < result.size(); ++i) {
                        list.add(result.get(i));
                    }
                }
                catch (Exception e) {
                    this.logger.error("Impossibile ottenere risultati dalla PDND: " + e.getMessage(), (Throwable)e);
                    list.add(null);
                    return new Result(this, new UtilsException((Throwable)e));
                }
            }
            return list.isEmpty() || list.peek() == null ? null : new Result(this, (JsonNode)list.remove());
        }).takeWhile(Objects::nonNull).sequential()).iterator();
    }

    private String getUploadPath(StatistichePdndTracing stat) {
        switch (stat.getMethod()) {
            case REPLACE: {
                return String.format("/tracings/%s/replace", stat.getTracingId());
            }
            case RECOVER: {
                return String.format("/tracings/%s/recover", stat.getTracingId());
            }
            case SUBMIT: {
                return "/tracings/submit";
            }
        }
        return null;
    }

    private MimeMultipart getUploadBody(StatistichePdndTracing stat) throws UtilsException {
        MimeMultipart multipart = new MimeMultipart("form-data");
        InternetHeaders headers = new InternetHeaders();
        headers.addHeader("Content-Type", "text/csv");
        headers.addHeader("Content-Disposition", "form-data; name=\"file\"; filename=\"record.csv\"");
        BodyPart bp = multipart.createBodyPart(headers, stat.getCsv());
        multipart.addBodyPart(bp);
        if (stat.getMethod().equals((Object)PdndMethods.SUBMIT)) {
            SimpleDateFormat pdndDateFormat = new SimpleDateFormat(PDND_DATE_FORMAT);
            headers = new InternetHeaders();
            headers.addHeader("Content-Type", "text/plain");
            headers.addHeader("Content-Disposition", "form-data; name=\"date\"");
            bp = multipart.createBodyPart(headers, pdndDateFormat.format(stat.getDataTracciamento()).getBytes());
            multipart.addBodyPart(bp);
        }
        return multipart;
    }

    private void writePdndError(StatistichePdndTracing stat, JsonNode response) throws StatisticsEngineException {
        ArrayNode errors = (ArrayNode)response.get(PDND_RESPONSE_ERRORS_CLAIM);
        try {
            stat.setErrorDetails(this.getErrorDetails(PDND_PUBLISHING_ERROR, (JsonNode)errors));
        }
        catch (StatisticsEngineException e) {
            stat.setStatoPdnd(PossibiliStatiPdnd.ERROR);
            stat.setErrorDetails(this.getErrorDetails(PDND_PUBLISHING_ERROR, "Il messaggio di errore ricevuto dalla PDND non \u00e8 conforme all'openAPI fornito"));
            return;
        }
        stat.setStatoPdnd(PossibiliStatiPdnd.ERROR);
        if (errors != null) {
            for (JsonNode node : errors) {
                String code = node.get("code").asText();
                if (!code.equals("TRACING_ALREADY_EXISTS")) continue;
                stat.setStatoPdnd(PossibiliStatiPdnd.PENDING);
                this.updateTracingIdStats.put(stat.getDataTracciamento(), stat);
            }
        }
    }

    private String getErrorDetails(String type, JsonNode node) throws StatisticsEngineException {
        JSONUtils json = JSONUtils.getInstance();
        try {
            ObjectNode errorNode = json.newObjectNode();
            errorNode.set("pdnd_details", node);
            errorNode.put("type", type);
            return json.toString((JsonNode)errorNode);
        }
        catch (UtilsException e) {
            throw new StatisticsEngineException("Errore nella generazione del nodeo di errore", e);
        }
    }

    private String getErrorDetails(String type, String errMsg) throws StatisticsEngineException {
        JSONUtils json = JSONUtils.getInstance();
        try {
            ObjectNode errorNode = json.newObjectNode();
            errorNode.put("details", errMsg);
            errorNode.put("type", type);
            return json.toString((JsonNode)errorNode);
        }
        catch (UtilsException e) {
            throw new StatisticsEngineException("Errore nella generazione del nodeo di errore", e);
        }
    }

    private void checkSendTraceResult(StatistichePdndTracing stat, HttpResponse res, String errMsg) throws StatisticsEngineException {
        if (res == null) {
            stat.setErrorDetails(this.getErrorDetails(CONNECTION_ERROR, errMsg));
            stat.setStato(PossibiliStatiRichieste.FAILED);
            return;
        }
        Integer code = res.getResultHTTPOperation();
        byte[] content = res.getContent();
        JsonNode node = null;
        try {
            JSONUtils jsonUtils = JSONUtils.getInstance();
            node = jsonUtils.getAsNode(content);
        }
        catch (UtilsException jsonUtils) {
            // empty catch block
        }
        String baseType = null;
        try {
            baseType = ContentTypeUtilities.readBaseTypeFromContentType((String)res.getContentType());
        }
        catch (Exception e) {
            stat.setErrorDetails(this.getErrorDetails(PDND_PUBLISHING_ERROR, "Content-Type della risposta invalido, content-type: " + res.getContentType() + ", content: " + new String(content)));
            stat.setStato(PossibiliStatiRichieste.FAILED);
            return;
        }
        if (!"application/json".equals(baseType) && !"application/problem+json".equals(baseType)) {
            stat.setErrorDetails(this.getErrorDetails(PDND_PUBLISHING_ERROR, "Content-Type della risposta non di tipo json, content-type: " + res.getContentType() + ", content: " + new String(content)));
            stat.setStato(PossibiliStatiRichieste.FAILED);
        } else if (node == null || node.get(PDND_RESPONSE_ERRORS_CLAIM) == null) {
            stat.setErrorDetails(this.getErrorDetails(PDND_PUBLISHING_ERROR, "Non \u00e8 stato possibile interpretare il contenuto: " + new String(content)));
            stat.setStato(PossibiliStatiRichieste.FAILED);
        } else if (code != 200) {
            this.writePdndError(stat, node);
            stat.setStato(PossibiliStatiRichieste.PUBLISHED);
            stat.setStatoPdnd(PossibiliStatiPdnd.ERROR);
        } else if (node.get(TRACING_ID_FIELD).isNull()) {
            stat.setErrorDetails(this.getErrorDetails(PDND_PUBLISHING_ERROR, "Dal contenuto non \u00e8 stato possibile ottenere il campo tracingId: " + new String(content)));
            stat.setStato(PossibiliStatiRichieste.FAILED);
        } else {
            String tracingId = node.get(TRACING_ID_FIELD).asText();
            stat.setTracingId(tracingId);
            stat.setStato(PossibiliStatiRichieste.PUBLISHED);
            stat.setStatoPdnd(PossibiliStatiPdnd.PENDING);
        }
    }

    private void sendTrace(String pddCode, StatistichePdndTracing stat) throws StatisticsEngineException {
        if (this.config.getPdndTracciamentoMaxAttempt() != null && this.config.getPdndTracciamentoMaxAttempt() <= stat.getTentativiPubblicazione() && !stat.isForcePublish()) {
            return;
        }
        stat.setErrorDetails(null);
        stat.setStato(null);
        if (stat.getMethod().equals((Object)PdndMethods.SUBMIT) && Duration.between(stat.getDataTracciamento().toInstant(), DateManager.getDate().toInstant()).compareTo(Duration.ofDays(2L)) >= 0 || !stat.getMethod().equals((Object)PdndMethods.SUBMIT) && stat.getTracingId() == null) {
            if (stat.getMethod().equals((Object)PdndMethods.SUBMIT)) {
                stat.setMethod(PdndMethods.RECOVER);
            }
            this.updateTracingIdStats.put(stat.getDataTracciamento(), stat);
            return;
        }
        stat.setForcePublish(false);
        HttpResponse res = null;
        String errMsg = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            stat.setTentativiPubblicazione(Integer.valueOf(stat.getTentativiPubblicazione() + 1));
            stat.setDataPubblicazione(DateManager.getDate());
            HttpRequest req = this.getBaseRequest(pddCode);
            req.setMethod(HttpRequestMethod.POST);
            req.setUrl(req.getBaseUrl() + this.getUploadPath(stat));
            MimeMultipart multipart = this.getUploadBody(stat);
            multipart.writeTo((OutputStream)os);
            req.setContentType(multipart.getContentType());
            req.setContent(os.toByteArray());
            res = HttpUtilities.httpInvoke((HttpRequest)req);
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        this.checkSendTraceResult(stat, res, errMsg);
    }

    private void logPublishResults(StatistichePdndTracing stat, String nomeSoggetto) {
        String dataTracciamentoFormat = this.dataTracciamentoFormat(stat.getDataTracciamento());
        if (PossibiliStatiRichieste.FAILED.equals((Object)stat.getStato()) || PossibiliStatiPdnd.ERROR.equals((Object)stat.getStatoPdnd())) {
            this.logger.error("Fallita la pubblicazione del tracciato [{}], soggetto: {}, dettagli: {}", new Object[]{dataTracciamentoFormat, nomeSoggetto, stat.getErrorDetails()});
        } else if (PossibiliStatiRichieste.PUBLISHED.equals((Object)stat.getStato()) && PossibiliStatiPdnd.PENDING.equals((Object)stat.getStatoPdnd())) {
            this.logger.info("Pubblicazione tracciato [{}], soggetto: {}, inviata correttamente alla PDND", (Object)dataTracciamentoFormat, (Object)nomeSoggetto);
        } else {
            this.logger.info("tracciato [{}], soggetto: {}, non inviato in quanto il tracingId non risulta presente nel db riprover\u00f2 nella prossima fase", (Object)dataTracciamentoFormat, (Object)nomeSoggetto);
        }
    }

    private void publishRecords(String nomeSoggetto, String pddCode) throws ServiceException, NotFoundException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, StatisticsEngineException {
        IPaginatedExpression expr = this.pdndStatisticheSM.newPaginatedExpression();
        expr.isNotNull(StatistichePdndTracing.model().CSV);
        expr.equals(StatistichePdndTracing.model().STATO_PDND, (Object)PossibiliStatiPdnd.WAITING);
        expr.equals(StatistichePdndTracing.model().PDD_CODICE, (Object)pddCode);
        expr.equals(StatistichePdndTracing.model().HISTORY, (Object)0);
        if (this.config.getPdndTracciamentoMaxAttempt() != null) {
            IExpression attemptsExpr = this.pdndStatisticheSM.newExpression();
            attemptsExpr.or().lessThan(StatistichePdndTracing.model().TENTATIVI_PUBBLICAZIONE, (Object)this.config.getPdndTracciamentoMaxAttempt());
            attemptsExpr.or().equals(StatistichePdndTracing.model().FORCE_PUBLISH, (Object)true);
            expr.and(new IExpression[]{attemptsExpr});
        }
        expr.addOrder(StatistichePdndTracing.model().DATA_TRACCIAMENTO, SortOrder.ASC);
        List stats = null;
        try {
            stats = this.pdndStatisticheSM.findAll(expr);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NotFoundException || e instanceof NotFoundException) {
                this.logger.debug("Nessun record da pubblicare per il soggetto: {} trovato", (Object)nomeSoggetto);
                return;
            }
            throw new StatisticsEngineException("Errore inaspettato nella ricerca delle transazioni", e);
        }
        this.logger.debug("Trovati {} record da pubblicare per il soggetto: {}", (Object)stats.size(), (Object)nomeSoggetto);
        for (StatistichePdndTracing stat : stats) {
            this.sendTrace(pddCode, stat);
            this.pdndStatisticheSM.update((Object)stat);
            this.logPublishResults(stat, nomeSoggetto);
        }
    }

    private void fixPublishRecords(String nomeSoggetto, String pddCode) throws ServiceException, NotFoundException, NotImplementedException, StatisticsEngineException {
        HttpRequest req = this.getBaseRequest(pddCode);
        req.setMethod(HttpRequestMethod.GET);
        req.setUrl(req.getBaseUrl() + "/tracings");
        Iterator<Result<JsonNode, UtilsException>> itr = this.iteratorHttpList(req);
        if (this.updateTracingIdStats.isEmpty()) {
            this.logger.info("Non ci sono tracciati senza un tracingId valido per il soggetto {}", (Object)nomeSoggetto);
        } else {
            this.logger.info("Individuati {} tracciati senza un tracingId valido per il soggetto: {}, procedo ad interrogare la PDND per ricavarlo", (Object)this.updateTracingIdStats.size(), (Object)nomeSoggetto);
        }
        while (!this.updateTracingIdStats.isEmpty() && itr.hasNext()) {
            try {
                JsonNode node = itr.next().get();
                String tracingId = node.get(TRACING_ID_FIELD).asText();
                SimpleDateFormat pdndDateFormat = new SimpleDateFormat(PDND_DATE_FORMAT);
                String tracingDate = node.get("date").asText();
                Date date = pdndDateFormat.parse(tracingDate);
                StatistichePdndTracing stat = this.updateTracingIdStats.remove(date);
                if (stat == null) continue;
                String formatTracingDate = this.dataTracciamentoFormat(stat.getDataTracciamento());
                stat.setTracingId(tracingId);
                if (!PossibiliStatiRichieste.FAILED.equals((Object)stat.getStato()) && !PossibiliStatiPdnd.ERROR.equals((Object)stat.getStatoPdnd())) {
                    this.logger.info("Individuato tracciato [{}] per il soggetto: {}, senza tracingId valido, tracingId: {} aggiornato, applico l'operazione {}", new Object[]{formatTracingDate, nomeSoggetto, tracingId, stat.getMethod()});
                    this.sendTrace(pddCode, stat);
                }
                this.pdndStatisticheSM.update((Object)stat);
                this.logPublishResults(stat, nomeSoggetto);
            }
            catch (ParseException | UtilsException e) {
                throw new StatisticsEngineException(e, "Errore nella lettura dei tracciati ricevuti dalla PDND");
            }
        }
    }

    private void updateTraceStatus(String pddCode, StatistichePdndTracing stat) throws StatisticsEngineException {
        HttpRequest req = this.getBaseRequest(pddCode);
        req.setMethod(HttpRequestMethod.GET);
        req.setUrl(req.getBaseUrl() + "/tracings/" + stat.getTracingId() + "/errors");
        Iterator<Result<JsonNode, UtilsException>> itr = this.iteratorHttpList(req);
        if (!itr.hasNext()) {
            stat.setStatoPdnd(PossibiliStatiPdnd.OK);
            return;
        }
        try {
            ArrayNode arr = JSONUtils.getInstance().newArrayNode();
            while (itr.hasNext()) {
                JsonNode node = itr.next().get();
                arr.add(node);
            }
            stat.setStatoPdnd(PossibiliStatiPdnd.ERROR);
            stat.setErrorDetails(this.getErrorDetails(PDND_PARSING_ERROR, (JsonNode)arr));
        }
        catch (UtilsException e) {
            stat.setStato(PossibiliStatiRichieste.FAILED);
            stat.setStatoPdnd(PossibiliStatiPdnd.PENDING);
            stat.setErrorDetails(this.getErrorDetails(PDND_PARSING_ERROR, "Errore nel parsing della risposta dalla pdnd: " + e.getMessage()));
        }
    }

    private boolean checkPending(String nomeSoggetto, String pddCode) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, NotFoundException, StatisticsEngineException {
        Map<String, Date> pendingIds = this.getTracingIdStatus(pddCode, "PENDING");
        IPaginatedExpression expr = this.pdndStatisticheSM.newPaginatedExpression();
        expr.equals(StatistichePdndTracing.model().STATO_PDND, (Object)PossibiliStatiPdnd.PENDING);
        expr.equals(StatistichePdndTracing.model().PDD_CODICE, (Object)pddCode);
        expr.equals(StatistichePdndTracing.model().HISTORY, (Object)0);
        expr.addOrder(StatistichePdndTracing.model().DATA_TRACCIAMENTO, SortOrder.ASC);
        List stats = null;
        try {
            stats = this.pdndStatisticheSM.findAll(expr);
        }
        catch (ServiceException e) {
            this.logger.info("Nessun tracciato nello stato PENDING");
            return true;
        }
        this.logger.info("Tracciati con stato PENDING trovati: {}, soggetto: {}", (Object)stats.size(), (Object)nomeSoggetto);
        boolean noMorePending = true;
        for (StatistichePdndTracing stat : stats) {
            String dataTracciamentoFormat = this.dataTracciamentoFormat(stat.getDataTracciamento());
            if (!pendingIds.containsKey(stat.getTracingId())) {
                this.updateTraceStatus(pddCode, stat);
                this.pdndStatisticheSM.update((Object)stat);
                if (PossibiliStatiPdnd.ERROR.equals((Object)stat.getStatoPdnd())) {
                    this.logger.error("La PDND ha rilevato un errore nel tracciato [{}], soggetto: {}, dettagli: {}", new Object[]{dataTracciamentoFormat, nomeSoggetto, stat.getErrorDetails()});
                    continue;
                }
                if (!PossibiliStatiPdnd.OK.equals((Object)stat.getStatoPdnd())) continue;
                this.logger.info("La PDND ha caricato con successo tracciato [{}], soggetto: {}, inviata correttamente all PDND", (Object)dataTracciamentoFormat, (Object)nomeSoggetto);
                continue;
            }
            this.logger.info("Tracciato [{}], soggetto: {}, ancora in stato PENDING, non aggiorno", (Object)dataTracciamentoFormat, (Object)nomeSoggetto);
            noMorePending = false;
        }
        return noMorePending;
    }

    private void updateMissing(String nomeSoggetto, String pddCode) throws StatisticsEngineException, ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, MultipleResultException {
        Map<String, Date> missingIds = this.getTracingIdStatus(pddCode, "MISSING");
        if (!missingIds.isEmpty()) {
            this.logger.info("Le seguenti date [{}], risultano mancanti lato PDND per il soggetto {}, procedo alla creazione di entry vuote", missingIds.values(), (Object)nomeSoggetto);
        } else {
            this.logger.info("Tutti i tracciati per il soggetto {} sono stati caricati, nessun MISSING", (Object)nomeSoggetto);
        }
        for (Map.Entry<String, Date> id : missingIds.entrySet()) {
            StatistichePdndTracing stat = new StatistichePdndTracing();
            stat.setTracingId(id.getKey());
            stat.setDataTracciamento(id.getValue());
            stat.setDataRegistrazione(DateManager.getDate());
            stat.setCsv(null);
            stat.setMethod(PdndMethods.RECOVER);
            stat.setHistory(0);
            stat.setPddCodice(pddCode);
            stat.setStatoPdnd(PossibiliStatiPdnd.WAITING);
            try {
                IExpression expr = this.pdndStatisticheSM.newExpression();
                expr.equals(StatistichePdndTracing.model().PDD_CODICE, (Object)pddCode);
                expr.equals(StatistichePdndTracing.model().DATA_TRACCIAMENTO, (Object)id.getValue());
                expr.equals(StatistichePdndTracing.model().HISTORY, (Object)0);
                this.pdndStatisticheSM.find(expr);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof NotFoundException) && !(e instanceof NotFoundException)) continue;
                this.pdndStatisticheSM.create((Object)stat);
            }
        }
    }

    private Map<String, Date> getTracingIdStatus(String pddCode, String status) throws StatisticsEngineException {
        HttpRequest req = this.getBaseRequest(pddCode);
        req.setMethod(HttpRequestMethod.GET);
        req.addParam("states", status);
        req.setUrl(req.getBaseUrl() + "/tracings");
        Iterator<Result<JsonNode, UtilsException>> itr = this.iteratorHttpList(req);
        HashMap<String, Date> ids = new HashMap<String, Date>();
        while (itr.hasNext()) {
            try {
                JsonNode node = itr.next().get();
                String tracingId = node.get(TRACING_ID_FIELD).asText();
                String tracingDate = node.get("date").asText();
                SimpleDateFormat pdndDateFormat = new SimpleDateFormat(PDND_DATE_FORMAT);
                Date date = pdndDateFormat.parse(tracingDate);
                ids.put(tracingId, date);
            }
            catch (ParseException | UtilsException e) {
                throw new StatisticsEngineException(e, "Errore nella lettura dei tracciati ricevuti dalla PDND");
            }
        }
        return ids;
    }

    private boolean checkPdnd(String pddCode) {
        HttpRequest req = this.getBaseRequest(pddCode);
        req.setUrl(req.getBaseUrl() + "/status");
        req.setMethod(HttpRequestMethod.GET);
        HttpResponse res = null;
        try {
            res = HttpUtilities.httpInvoke((HttpRequest)req);
        }
        catch (UtilsException e) {
            this.logger.error("Errore nella comunicazione con la risorsa /status della PDND tracciamento (url invocata: " + req.getUrl() + ")", (Throwable)e);
            return false;
        }
        int code = res.getResultHTTPOperation();
        if (code != 200) {
            this.logger.error("Errore nella comunicazione con la risorsa /status della PDND tracciamento (url invocata: {}), return code: {}", (Object)req.getUrl(), (Object)code);
            return false;
        }
        return true;
    }

    public void generate(PdndTracciamentoSoggetto soggetto) throws StatisticsEngineException {
        String nomeSoggetto = soggetto.getIdSoggetto().getNome();
        String pddCode = soggetto.getIdSoggetto().getCodicePorta();
        List<String> soggettiAggregati = PdndTracciamentoUtils.getNomiSoggettiAggregati(soggetto);
        this.logger.info("------- FASE 0 [soggetto: {} aggregati: {}] verifica disponibilit\u00e0 pdnd -------", (Object)nomeSoggetto, soggettiAggregati);
        if (!this.checkPdnd(pddCode)) {
            this.logger.info("PDND non disponibile; termino gestione");
            return;
        }
        this.updateTracingIdStats.clear();
        try {
            this.logger.info("------- FASE 1 [soggetto: {} aggregati: {}] pubblicazione record -------", (Object)nomeSoggetto, soggettiAggregati);
            this.publishRecords(nomeSoggetto, pddCode);
            this.logger.info("------- FASE 2 [soggetto: {} aggregati: {}] patch dei record senza tracingId -------", (Object)nomeSoggetto, soggettiAggregati);
            this.fixPublishRecords(nomeSoggetto, pddCode);
            this.logger.info("------- FASE 3 [soggetto: {} aggregati: {}] creazione dei record MISSING -------", (Object)nomeSoggetto, soggettiAggregati);
            this.updateMissing(nomeSoggetto, pddCode);
            this.logger.info("------- FASE 4 [soggetto: {} aggregati: {}] controllo dei record PENDING -------", (Object)nomeSoggetto, soggettiAggregati);
            Integer delayIndex = 0;
            List<Integer> delays = this.config.getPdndTracciamentoPendingCheck();
            boolean checkPendingResult = false;
            do {
                Integer n = delayIndex;
                delayIndex = delayIndex + 1;
                Integer delayI = delays.get(n);
                int delay = Objects.requireNonNullElse(delayI, 0);
                if (delayIndex == 1) {
                    this.logger.info("Aspetto {}s prima di aggiornare i record in PENDING, numero massimo di tentativi da effettuare: {}", (Object)delay, (Object)delays.size());
                } else if (delayIndex <= delays.size()) {
                    this.logger.info("La PDND non ha ancora valutato tutti i tracciati con lo stato PENDING, tentativo: {}, aspetto {}s e riprovo", (Object)delayIndex, (Object)delay);
                }
                if (delay <= 0) continue;
                Utilities.sleep((long)((long)delay * 1000L));
            } while (!(checkPendingResult = this.checkPending(nomeSoggetto, pddCode)) && delayIndex < delays.size());
            if (!checkPendingResult) {
                this.logger.info("La PDND non ha ancora valutato tutti i tracciati con lo stato PENDING ma ho superato i tentativi massimi, riprover\u00f2 alla prossima esecuzione");
            } else {
                this.logger.info("La PDND ha valutato tutti i tracciati con lo stato PENDING, nessun record in PENDING rimasto");
            }
        }
        catch (ExpressionException | ExpressionNotImplementedException | MultipleResultException | NotFoundException | NotImplementedException | ServiceException e) {
            this.logger.error("Errore nella pubblicazione delle tracce, pdd code: {}", (Object)pddCode, (Object)e);
        }
    }

    @Override
    public void generate() throws StatisticsEngineException {
        this.logger.info("********************* INIZIO PUBBLICAZIONE TRACCIATO PDND *********************");
        Date currDate = DateManager.getDate();
        try {
            StatisticsInfoUtils.updateDataUltimaGenerazioneStatistiche(this.statisticheSM.getStatisticaInfoServiceSearch(), this.statisticheSM.getStatisticaInfoService(), TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO, this.config.getLogSql(), currDate);
        }
        catch (Exception e) {
            this.logger.error("Errore nell'aggiornamento della data ultima statistica {}", (Object)TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO, (Object)e);
        }
        for (PdndTracciamentoSoggetto soggetto : this.internalPddCodes.getSoggetti()) {
            this.logger.info("*--------- Gestione soggetto '{}' --------", (Object)soggetto.getIdSoggetto());
            this.generate(soggetto);
            this.logger.info("*--------- Fine gestione soggetto {}  --------", (Object)soggetto.getIdSoggetto());
        }
        this.logger.info("********************* FINE PUBBLICAZIONE TRACCIATO PDND *********************");
    }

    @Override
    public boolean isEnabled(StatisticsConfig config) {
        return config.isPdndTracciamentoPubblicazione();
    }

    private String dataTracciamentoFormat(Date date) {
        return new SimpleDateFormat(PDND_DATE_FORMAT).format(date);
    }

    private class Result<R, T extends Throwable> {
        private final R res;
        private final T error;

        public Result(PdndPublicazioneTracciamento pdndPublicazioneTracciamento, R result) {
            this.res = result;
            this.error = null;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public Result(T error) {
            this.res = null;
            this.error = error;
        }

        public R get() throws T {
            if (this.res == null) {
                throw this.error;
            }
            return this.res;
        }
    }
}

