/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.engine.dynamic.CorePluginLoader;
import org.openspcoop2.monitor.engine.dynamic.IPluginLoader;
import org.openspcoop2.monitor.engine.dynamic.IRegistroPluginsReader;
import org.openspcoop2.monitor.engine.dynamic.PluginManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class PluginLoader
implements IPluginLoader {
    private PluginManager pluginManager = null;
    private Loader loader = null;
    private Logger log;

    public static PluginLoader getInstance() {
        return (PluginLoader)CorePluginLoader.getInstance();
    }

    @Override
    public void init(Loader loader, Logger log) {
        this.loader = loader;
        this.log = log;
    }

    @Override
    public void init(Loader loader, Logger log, IRegistroPluginsReader registroPluginsReader, int expireSeconds) {
        this.init(loader, log);
        this.pluginManager = new PluginManager(registroPluginsReader, expireSeconds);
    }

    @Override
    public void close(Logger log) {
        block3: {
            if (this.pluginManager != null) {
                try {
                    this.pluginManager.close();
                }
                catch (Throwable t) {
                    if (log == null) break block3;
                    log.error("PluginManager close failure: " + t.getMessage(), t);
                }
            }
        }
    }

    public boolean isPluginManagerEnabled() {
        return this.pluginManager != null;
    }

    public void updateFromConsoleConfig(Logger log) throws Exception {
        this.pluginManager.updateFromConsoleConfig(log);
    }

    @Override
    public Class<?> getDynamicClass(String className, TipoPlugin tipoPlugin, String tipo) throws CoreException {
        return this.getDynamicClass(className, tipoPlugin.getValue(), tipo);
    }

    @Override
    public Class<?> getDynamicClass(String className, String tipoPlugin, String tipo) throws CoreException {
        if (className == null) {
            throw new CoreException("Class not found (" + this.getObjectName(tipoPlugin) + " type '" + tipo + "')");
        }
        Class<?> c = null;
        if (this.isPluginManagerEnabled()) {
            if (this.pluginManager == null) {
                throw new CoreException("Plugin manager not initialized");
            }
            try {
                c = this.pluginManager.findClass(this.log, tipoPlugin, className);
            }
            catch (Exception e) {
                throw new CoreException("Class '" + className + "' not found in registry (" + this.getObjectName(tipoPlugin) + " type '" + tipo + "'): " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            c = Class.forName(className);
        }
        catch (Exception e) {
            throw new CoreException("Class '" + className + "' not found in classpath: " + e.getMessage(), (Throwable)e);
        }
        if (c == null) {
            throw new CoreException("Class '" + className + "' not found in registry (" + this.getObjectName(tipoPlugin) + " type '" + tipo + "')");
        }
        return c;
    }

    @Override
    public <T> T newInstance(Class<T> c, TipoPlugin tipoPlugin, String tipo) throws CoreException {
        return this.newInstance(c, tipoPlugin.getValue(), tipo);
    }

    @Override
    public <T> T newInstance(Class<T> c, String tipoPlugin, String tipo) throws CoreException {
        try {
            return (T)this.loader.newInstance(c);
        }
        catch (Throwable e) {
            throw new CoreException("Class '" + c.getClass().getName() + "' new instance error (" + this.getObjectName(tipoPlugin) + " type '" + tipo + "'): " + e.getMessage(), e);
        }
    }

    @Override
    public Object newInstance(String customTipoClasse, String tipo) throws Exception {
        Class<?> c = this.getDynamicClass(null, customTipoClasse, tipo);
        return this.newInstance(c, customTipoClasse, tipo);
    }

    protected String getObjectName(String tipoPluginParam) throws CoreException {
        TipoPlugin tipoPlugin = TipoPlugin.toEnumConstant((String)tipoPluginParam);
        if (tipoPlugin == null) {
            return tipoPluginParam;
        }
        switch (tipoPlugin) {
            case CONNETTORE: {
                return "connector";
            }
            case AUTENTICAZIONE: {
                return "authentication";
            }
            case AUTORIZZAZIONE: {
                return "authorization";
            }
            case AUTORIZZAZIONE_CONTENUTI: {
                return "authorization content";
            }
            case INTEGRAZIONE: {
                return "integration";
            }
            case SERVICE_HANDLER: {
                return "service handler";
            }
            case MESSAGE_HANDLER: {
                return "message handler";
            }
            case BEHAVIOUR: {
                return "behaviour";
            }
            case RATE_LIMITING: {
                return "policy rate limiting";
            }
            case ALLARME: {
                return "alarm";
            }
            case TRANSAZIONE: {
                return "transaction library";
            }
            case RICERCA: {
                return "search library";
            }
            case STATISTICA: {
                return "stats library";
            }
            case TOKEN_DYNAMIC_DISCOVERY: {
                return "token dynamic discovery";
            }
            case TOKEN_VALIDAZIONE: {
                return "token validation policy";
            }
            case TOKEN_NEGOZIAZIONE: {
                return "token retrieve policy";
            }
            case ATTRIBUTE_AUTHORITY: {
                return "attribute authority";
            }
        }
        throw new CoreException("?? Type '" + String.valueOf(tipoPlugin) + "' unsupported ??");
    }
}

