/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.StatisticsServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.config.statistiche.ConfigurazioneStatistica;
import org.openspcoop2.monitor.engine.config.statistiche.dao.IConfigurazioneStatisticaServiceSearch;
import org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager;
import org.openspcoop2.monitor.engine.config.statistiche.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneRisorsaContenuto;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneStato;
import org.slf4j.Logger;

public class StatisticsServiceLibraryReader {
    private Connection connection;
    private DAOFactory daoFactory = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsStatistiche = null;
    private Logger daoFactoryLogger = null;
    private IServiceManager serviceManagerPluginsStatistiche;
    private boolean debug;

    public StatisticsServiceLibraryReader(Connection connection, DAOFactory daoFactory, ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsStatistiche, Logger daoFactoryLogger, boolean debug) {
        this.connection = connection;
        this.daoFactory = daoFactory;
        this.daoFactoryServiceManagerPropertiesPluginsStatistiche = daoFactoryServiceManagerPropertiesPluginsStatistiche;
        this.daoFactoryLogger = daoFactoryLogger;
        this.debug = debug;
    }

    public StatisticsServiceLibraryReader(IServiceManager serviceManagerPluginsStatistiche, boolean debug) {
        this.serviceManagerPluginsStatistiche = serviceManagerPluginsStatistiche;
        this.debug = debug;
    }

    public StatisticsServiceLibrary readConfigurazioneStatistiche(BasicServiceLibrary basicServiceLibrary, TransactionServiceLibrary transactionServiceLibrary, Logger log) throws Exception {
        List<ConfigurazioneStatistica> searchActionAllLibrary;
        StatisticsServiceLibrary searchServiceLibrary;
        block9: {
            List<ConfigurazioneStatistica> searchActionLibrary;
            IDAccordo idAccordo;
            String portType;
            block8: {
                List<ConfigurazioneTransazioneStato> stati;
                searchServiceLibrary = new StatisticsServiceLibrary();
                searchServiceLibrary.setBasicServiceLibrary(basicServiceLibrary);
                String azione = basicServiceLibrary.getAzione();
                portType = basicServiceLibrary.getPortType();
                idAccordo = basicServiceLibrary.getIdAccordoServizioParteComune();
                searchServiceLibrary.setPluginStatiTransazioniEnabled(false);
                if (transactionServiceLibrary != null && (stati = transactionServiceLibrary.mergeServiceActionTransactionLibrary_states()) != null && stati.size() > 0) {
                    searchServiceLibrary.setPluginStatiTransazioniEnabled(true);
                }
                if (transactionServiceLibrary != null) {
                    List<ConfigurazioneTransazioneRisorsaContenuto> risorse = transactionServiceLibrary.mergeServiceActionTransactionLibrary_resources();
                    for (ConfigurazioneTransazioneRisorsaContenuto configurazioneTransazioneRisorsaContenuto : risorse) {
                        if (!configurazioneTransazioneRisorsaContenuto.isStatEnabled()) continue;
                        searchServiceLibrary.getPluginRisorseTransazioni().add(configurazioneTransazioneRisorsaContenuto.getNome());
                    }
                }
                searchActionLibrary = null;
                if (basicServiceLibrary.getServiceActionLibrary() != null) {
                    try {
                        searchActionLibrary = this.getServiceActionSearchLibrary(basicServiceLibrary.getServiceActionLibrary());
                    }
                    catch (NotFoundException notFound) {
                        if (!this.debug) break block8;
                        log.debug("Non risulta configurata una statistica personalizzata per l'azione specifica [" + azione + "] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]", (Throwable)notFound);
                    }
                }
            }
            searchServiceLibrary.setStatisticsActionLibrary(searchActionLibrary);
            searchActionAllLibrary = null;
            try {
                searchActionAllLibrary = this.getServiceActionSearchLibrary(basicServiceLibrary.getServiceActionAllLibrary());
            }
            catch (NotFoundException notFound) {
                if (!this.debug) break block9;
                log.debug("Non risulta configurata una statistica personalizzata per l'azione specifica [*] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]", (Throwable)notFound);
            }
        }
        searchServiceLibrary.setStatisticsActionAllLibrary(searchActionAllLibrary);
        return searchServiceLibrary;
    }

    private List<ConfigurazioneStatistica> getServiceActionSearchLibrary(ConfigurazioneServizioAzione serviceActionLibrary) throws DAOFactoryException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException, ExpressionNotImplementedException, ExpressionException {
        boolean autoCommit = true;
        IServiceManager serviceManager = this.serviceManagerPluginsStatistiche;
        if (serviceManager == null && (serviceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection, autoCommit, this.daoFactoryServiceManagerPropertiesPluginsStatistiche, this.daoFactoryLogger)) instanceof JDBCServiceManager) {
            ((JDBCServiceManager)serviceManager).getJdbcProperties().setShowSql(this.debug);
        }
        IConfigurazioneStatisticaServiceSearch serviceSearch = serviceManager.getConfigurazioneStatisticaServiceSearch();
        IPaginatedExpression pagExpr = serviceSearch.newPaginatedExpression();
        pagExpr.and();
        pagExpr.equals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getAccordo());
        pagExpr.equals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getTipoSoggettoReferente());
        pagExpr.equals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getNomeSoggettoReferente());
        pagExpr.equals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getVersione());
        pagExpr.equals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)serviceActionLibrary.getIdConfigurazioneServizio().getServizio());
        pagExpr.equals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, (Object)serviceActionLibrary.getAzione());
        return serviceSearch.findAll(pagExpr);
    }
}

