/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm.utils;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.utils.PluginsDriverUtils;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeHistoryBean;
import org.slf4j.Logger;

public class AllarmiDriverUtils {
    public static List<ConfigurazioneAllarmeBean> allarmiList(ISearch ricerca, RuoloPorta ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "allarmiList";
        ArrayList<ConfigurazioneAllarmeBean> lista = new ArrayList<ConfigurazioneAllarmeBean>();
        try {
            List findAll = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.allarmiList((ISearch)ricerca, (RuoloPorta)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)log, (String)tipoDB);
            if (findAll != null && findAll.size() > 0) {
                for (Allarme al : findAll) {
                    Plugin plugin = PluginsDriverUtils.getPlugin((String)TipoPlugin.ALLARME.getValue(), (String)al.getTipo(), (boolean)true, (Connection)con, (Logger)log, (String)tipoDB);
                    lista.add(new ConfigurazioneAllarmeBean(al, plugin));
                }
            }
            return lista;
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static ConfigurazioneAllarmeBean getAllarme(Long id, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getAllarme";
        try {
            Allarme al = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.getAllarme((Long)id, (Connection)con, (Logger)log, (String)tipoDB);
            Plugin plugin = PluginsDriverUtils.getPlugin((String)TipoPlugin.ALLARME.getValue(), (String)al.getTipo(), (boolean)true, (Connection)con, (Logger)log, (String)tipoDB);
            return new ConfigurazioneAllarmeBean(al, plugin);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static ConfigurazioneAllarmeBean getAllarme(String nome, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getAllarmeByNome";
        try {
            Allarme al = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.getAllarme((String)nome, (Connection)con, (Logger)log, (String)tipoDB);
            Plugin plugin = PluginsDriverUtils.getPlugin((String)TipoPlugin.ALLARME.getValue(), (String)al.getTipo(), (boolean)true, (Connection)con, (Logger)log, (String)tipoDB);
            return new ConfigurazioneAllarmeBean(al, plugin);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static ConfigurazioneAllarmeBean getAllarme(Allarme allarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "convertAllarme";
        try {
            Plugin plugin = PluginsDriverUtils.getPlugin((String)TipoPlugin.ALLARME.getValue(), (String)allarme.getTipo(), (boolean)true, (Connection)con, (Logger)log, (String)tipoDB);
            return new ConfigurazioneAllarmeBean(allarme, plugin);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static List<ConfigurazioneAllarmeHistoryBean> allarmiHistoryList(ISearch ricerca, Long idAllarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "allarmiHistoryList";
        ArrayList<ConfigurazioneAllarmeHistoryBean> lista = new ArrayList<ConfigurazioneAllarmeHistoryBean>();
        try {
            List findAll = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.allarmiHistoryList((ISearch)ricerca, (Long)idAllarme, (Connection)con, (Logger)log, (String)tipoDB);
            if (findAll != null && findAll.size() > 0) {
                for (AllarmeHistory al : findAll) {
                    lista.add(new ConfigurazioneAllarmeHistoryBean(al));
                }
            }
            return lista;
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static List<ConfigurazioneAllarmeBean> configurazioneAllarmiList(ISearch ricerca, RuoloPorta ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB, String nomeMetodo, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws ServiceException {
        ArrayList<ConfigurazioneAllarmeBean> lista = new ArrayList<ConfigurazioneAllarmeBean>();
        try {
            List findAll = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.configurazioneAllarmiList((ISearch)ricerca, (RuoloPorta)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)log, (String)tipoDB, (String)nomeMetodo, (IDSoggetto)filtroSoggettoFruitore, (IDServizioApplicativo)filtroApplicativoFruitore, (String)filtroRuoloFruitore, (IDSoggetto)filtroSoggettoErogatore, (String)filtroRuoloErogatore, (IDServizio)filtroServizioAzione, (String)filtroRuolo);
            if (findAll != null && findAll.size() > 0) {
                for (Allarme al : findAll) {
                    Plugin plugin = PluginsDriverUtils.getPlugin((String)TipoPlugin.ALLARME.getValue(), (String)al.getTipo(), (boolean)true, (Connection)con, (Logger)log, (String)tipoDB);
                    lista.add(new ConfigurazioneAllarmeBean(al, plugin));
                }
            }
            return lista;
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }
}

