/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.allarmi.dao.IServiceManager;
import org.openspcoop2.core.allarmi.utils.ProjectInfo;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.AlarmLogger;
import org.openspcoop2.monitor.engine.alarm.AlarmManager;
import org.openspcoop2.monitor.engine.alarm.AlarmThreadStatus;
import org.openspcoop2.monitor.sdk.alarm.AlarmStatus;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.monitor.sdk.exceptions.AlarmException;
import org.openspcoop2.monitor.sdk.exceptions.AlarmNotifyException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class AlarmImpl
implements IAlarm {
    private Logger _logger = LoggerWrapperFactory.getLogger(AlarmImpl.class);
    private DAOFactory daoFactory = null;
    private String threadName;
    private String username;
    private AlarmLogger alarmLogger;
    private AlarmThreadStatus alarmThreadStatus;
    private String id = null;
    private String nome = null;
    private Allarme configAllarme;
    private HashMap<String, Parameter<?>> parameters = null;
    private AlarmStatus status = null;
    private String pluginClassName = null;
    private boolean manuallyUpdateState = false;
    private boolean manuallyAckCriteria = false;

    public AlarmImpl(Allarme configAllarme, Logger log, DAOFactory daoFactory) {
        this.id = configAllarme.getNome();
        this.nome = configAllarme.getAlias();
        this.configAllarme = configAllarme;
        this._logger = log;
        this.daoFactory = daoFactory;
        this.threadName = "SDK";
        this.alarmLogger = new AlarmLogger(this.nome, this.id, this.threadName, this._logger, daoFactory != null && daoFactory.getLog() != null ? daoFactory.getLog() : this._logger);
    }

    protected void setThreadName(String threadName) {
        this.threadName = threadName;
        this.alarmLogger.setThreadName(this.threadName);
    }

    public AlarmThreadStatus getActiveThreadStatus() {
        return this.alarmThreadStatus;
    }

    protected void setAlarmThreadStatus(AlarmThreadStatus alarmThreadStatus) {
        this.alarmThreadStatus = alarmThreadStatus;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public AlarmLogger getLogger() {
        return this.alarmLogger;
    }

    public DAOFactory getDAOFactory() {
        return this.daoFactory;
    }

    public void changeStatus(Logger logSql, Connection connection, ServiceManagerProperties smp, AlarmStatus nuovoStatoAllarme) throws AlarmException, AlarmNotifyException {
        this._changeStatus(logSql, connection, smp, nuovoStatoAllarme);
    }

    public void changeStatus(AlarmStatus nuovoStatoAllarme) throws AlarmException, AlarmNotifyException {
        if (this.alarmThreadStatus != null && !this.alarmThreadStatus.isRunning()) {
            this.alarmLogger.info("Cambio di stato non effettuato, poich\u00e8 \u00e8 stato rilevato uno shutdown in corso");
            return;
        }
        this._changeStatus(null, null, null, nuovoStatoAllarme);
    }

    private void _changeStatus(Logger logSql, Connection connection, ServiceManagerProperties smp, AlarmStatus nuovoStatoAllarme) throws AlarmException, AlarmNotifyException {
        IServiceManager allarmiSM = null;
        boolean changeEventFromGateway = false;
        ArrayList<AllarmeHistory> repositoryHistory = null;
        try {
            if (connection == null) {
                allarmiSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance());
            } else {
                allarmiSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), connection, smp, logSql);
                changeEventFromGateway = true;
                repositoryHistory = new ArrayList<AllarmeHistory>();
            }
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
        boolean statusChanged = false;
        statusChanged = this.status == null || this.status.getStatus() == null ? true : !this.status.getStatus().equals((Object)nuovoStatoAllarme.getStatus());
        AlarmManager.changeStatus(nuovoStatoAllarme, this, allarmiSM, this.username, statusChanged, repositoryHistory);
        AlarmStatus oldStatus = null;
        if (this.status != null) {
            oldStatus = (AlarmStatus)this.status.clone();
        }
        this.setStatus(nuovoStatoAllarme);
        if (changeEventFromGateway) {
            this.alarmLogger.debug("Registrazione richiesta notifica su db in corso ...");
            AlarmManager.registraNotifica(this.alarmLogger, this.configAllarme, oldStatus, nuovoStatoAllarme, !repositoryHistory.isEmpty() ? (AllarmeHistory)repositoryHistory.get(0) : null, allarmiSM);
            this.alarmLogger.debug("Registrazione richiesta notifica su db terminata correttamente");
        } else {
            AlarmEngineConfig alarmEngineConfig = AlarmManager.getAlarmEngineConfig();
            if (alarmEngineConfig == null) {
                throw new AlarmException("Configurazione Allarme non fornita, utilizzare il metodo AlarmManager.setAlarmEngineConfig(...)");
            }
            this.alarmLogger.debug("Analisi nuovo stato in corso ...");
            AlarmManager.notifyChangeStatus(alarmEngineConfig, this.configAllarme, this, this.pluginClassName, this.threadName, this.alarmLogger, oldStatus, nuovoStatoAllarme, this.configAllarme != null && TipoAllarme.ATTIVO.equals((Object)this.configAllarme.getTipoAllarme()));
            this.alarmLogger.info("Analisi nuovo stato terminata correttamente");
        }
    }

    public void setStatus(AlarmStatus statoAllarme) throws AlarmException {
        this.status = statoAllarme;
    }

    public AlarmStatus getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getNome() {
        return this.nome;
    }

    public Allarme getConfigAllarme() {
        return this.configAllarme;
    }

    public Parameter<?> getParameter(String paramId) {
        if (this.parameters != null) {
            return this.parameters.get(paramId);
        }
        return null;
    }

    public Map<String, Parameter<?>> getParameters() {
        return this.parameters;
    }

    protected void addParameter(Parameter<?> param) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(param.getId(), param);
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    protected void setPluginClassName(String plugin) {
        this.pluginClassName = plugin;
    }

    public boolean isManuallyUpdateState() {
        return this.manuallyUpdateState;
    }

    public void setManuallyUpdateState(boolean manuallyUpdateState) {
        this.manuallyUpdateState = manuallyUpdateState;
    }

    public boolean isManuallyAckCriteria() {
        return this.manuallyAckCriteria;
    }

    public void setManuallyAckCriteria(boolean manuallyAckCriteria) {
        this.manuallyAckCriteria = manuallyAckCriteria;
    }
}

