/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneSintatticaRest;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.validator.ValidazioneUtils;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class ModIValidazioneAuditClaimValue {
    private String claimName;
    private String v;
    private Object o;
    private ModIAuditClaimConfig modIAuditClaimConfig;

    public ModIValidazioneAuditClaimValue(String claimName, String v, Object o, ModIAuditClaimConfig modIAuditClaimConfig) {
        this.claimName = claimName;
        this.v = v;
        this.o = o;
        this.modIAuditClaimConfig = modIAuditClaimConfig;
    }

    public ModIValidazioneAuditClaimValue(String claimName, String v, ModIAuditClaimConfig modIAuditClaimConfig, String prefix) throws ProtocolException {
        this.claimName = claimName;
        this.v = v;
        this.modIAuditClaimConfig = modIAuditClaimConfig;
        this.parseValue(prefix);
    }

    public String getValore() {
        return this.v;
    }

    public Object getRawObject() {
        return this.o;
    }

    private String getPrefixInvalidFormatValue() {
        return "Invalid format value '" + this.v + "'; ";
    }

    private void parseValue(String prefix) throws ProtocolException {
        if (this.modIAuditClaimConfig.isStringType()) {
            this.o = this.v;
        } else if ("true".equals(this.v)) {
            this.o = true;
        } else if ("false".equals(this.v)) {
            this.o = false;
        } else {
            String expected = "";
            try {
                if (this.v.contains(".")) {
                    expected = "double";
                    double d = Double.parseDouble(this.v);
                    this.o = d;
                } else {
                    expected = "long";
                    long l = Long.parseLong(this.v);
                    this.o = l;
                }
            }
            catch (Exception e) {
                String msgErrore = prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(this.claimName, new Exception(this.getPrefixInvalidFormatValue() + "expected " + expected + " primitive type"));
                this.processException(null, null, msgErrore, e);
            }
        }
    }

    public void validate(String prefix) throws ProtocolException {
        this.validate(null, null, prefix);
    }

    public void validate(ValidazioneUtils validazioneUtils, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        this.validateValueType(validazioneUtils, erroriValidazione, prefix);
        this.validateValueLength(validazioneUtils, erroriValidazione, prefix);
        this.validateValueRegexp(validazioneUtils, erroriValidazione, prefix);
        this.validateValueByEnum(validazioneUtils, erroriValidazione, prefix);
    }

    private void processException(ValidazioneUtils validazioneUtils, List<Eccezione> erroriValidazione, String msgErrore) throws ProtocolException {
        this.processException(validazioneUtils, erroriValidazione, msgErrore, null);
    }

    private void processException(ValidazioneUtils validazioneUtils, List<Eccezione> erroriValidazione, String msgErrore, Exception e) throws ProtocolException {
        if (validazioneUtils == null) {
            if (e != null) {
                throw new ProtocolException(msgErrore, (Throwable)e);
            }
            throw new ProtocolException(msgErrore);
        }
        erroriValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, msgErrore));
    }

    private void validateValueType(ValidazioneUtils validazioneUtils, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        if (this.modIAuditClaimConfig.isStringType()) {
            if (!(this.o instanceof TextNode) && !(this.o instanceof String)) {
                String msgErrore = prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(this.claimName, new Exception(this.getPrefixInvalidFormatValue() + "expected string type, found '" + this.o.getClass().getName() + "'"));
                this.processException(validazioneUtils, erroriValidazione, msgErrore);
            }
        } else if (this.o instanceof TextNode) {
            String msgErrore = prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(this.claimName, new Exception(this.getPrefixInvalidFormatValue() + "expected primitive type, found string"));
            this.processException(validazioneUtils, erroriValidazione, msgErrore);
        }
    }

    private void validateValueLength(ValidazioneUtils validazioneUtils, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        String msgErrore;
        int lengthV;
        int n = lengthV = this.v != null ? this.v.length() : 0;
        if (this.modIAuditClaimConfig.getMinLength() > 0 && lengthV < this.modIAuditClaimConfig.getMinLength()) {
            msgErrore = prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(this.claimName, new Exception("Invalid value '" + this.v + "'; min length requirement '" + this.modIAuditClaimConfig.getMinLength() + "' not met"));
            this.processException(validazioneUtils, erroriValidazione, msgErrore);
        }
        if (this.modIAuditClaimConfig.getMaxLength() > 0 && lengthV > this.modIAuditClaimConfig.getMaxLength()) {
            msgErrore = prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(this.claimName, new Exception("Invalid value '" + this.v + "'; max length requirement '" + this.modIAuditClaimConfig.getMaxLength() + "' not met"));
            this.processException(validazioneUtils, erroriValidazione, msgErrore);
        }
    }

    private void validateValueRegexp(ValidazioneUtils validazioneUtils, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        if (this.modIAuditClaimConfig.getRegexp() != null && StringUtils.isNotEmpty((CharSequence)this.modIAuditClaimConfig.getRegexp())) {
            try {
                if (!RegularExpressionEngine.isMatch((String)this.v, (String)this.modIAuditClaimConfig.getRegexp())) {
                    throw new ProtocolException("Validation by regexp '" + this.modIAuditClaimConfig.getRegexp() + "' failed: invalid value '" + this.v + "'");
                }
            }
            catch (Exception e) {
                String msgErrore = prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(this.claimName, e);
                this.processException(validazioneUtils, erroriValidazione, msgErrore, e);
            }
        }
    }

    private void validateValueByEnum(ValidazioneUtils validazioneUtils, List<Eccezione> erroriValidazione, String prefix) throws ProtocolException {
        if (this.modIAuditClaimConfig.getValues() != null && !this.modIAuditClaimConfig.getValues().isEmpty() && !this.modIAuditClaimConfig.getValues().contains(this.v)) {
            String msgErrore = prefix + ModIValidazioneSintatticaRest.getErroreTokenClaimNonValido(this.claimName, new Exception("Validation by enum-list failed: value '" + this.v + "' unknown"));
            this.processException(validazioneUtils, erroriValidazione, msgErrore);
        }
    }
}

