/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.utils.ModIPropertiesUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.transport.http.HttpUtilities;

public class ModITruststoreConfig {
    private String securityMessageTruststoreType = null;
    private boolean securityMessageTruststoreHSM = false;
    private boolean securityMessageTruststoreJWK = false;
    private boolean securityMessageTruststoreRemote = false;
    private String securityMessageTruststorePath = null;
    private String securityMessageTruststorePassword = null;
    private String securityMessageTruststoreCRLs = null;
    private String securityMessageTruststoreOCSPPolicy = null;

    public ModITruststoreConfig(boolean fruizione, IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps, boolean ssl) throws ProtocolException {
        try {
            List<ProtocolProperty> listProtocolProperties = ModIPropertiesUtils.getProtocolProperties(fruizione, soggettoFruitore, asps);
            String prefix = "TrustStore Certificati";
            if (ssl) {
                prefix = "TrustStore SSL";
            }
            String mode = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)(ssl ? "modipaSslTruststoreMode" : "modipaTruststoreMode"));
            boolean ridefinisci = "ridefinisci".equals(mode);
            boolean undefined = "-".equals(mode);
            ModIProperties modIproperties = ModIProperties.getInstance();
            if (ridefinisci) {
                this.securityMessageTruststoreType = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)(ssl ? "modipaSslTruststoreType" : "modipaTruststoreType"));
                this.securityMessageTruststoreHSM = HSMUtils.isKeystoreHSM((String)this.securityMessageTruststoreType);
                if (!this.securityMessageTruststoreHSM) {
                    this.securityMessageTruststoreJWK = CostantiDB.KEYSTORE_TYPE_JWK.equals(this.securityMessageTruststoreType);
                    if (!this.securityMessageTruststoreJWK) {
                        this.securityMessageTruststoreRemote = modIproperties.isRemoteStore(this.securityMessageTruststoreType);
                    }
                }
                if (this.securityMessageTruststoreHSM) {
                    this.securityMessageTruststorePath = "HSM-" + this.securityMessageTruststoreType;
                    this.securityMessageTruststorePassword = "-";
                } else {
                    if (!this.securityMessageTruststoreRemote) {
                        this.securityMessageTruststorePath = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)(ssl ? "modipaSslTruststorePath" : "modipaTruststorePath"));
                        try {
                            HttpUtilities.validateUri((String)this.securityMessageTruststorePath, (boolean)true);
                        }
                        catch (Exception e) {
                            throw new ProtocolException(prefix + " [" + this.securityMessageTruststorePath + "] " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!this.securityMessageTruststoreJWK && !this.securityMessageTruststoreRemote) {
                        boolean required = true;
                        if (KeystoreType.JKS.isType(this.securityMessageTruststoreType) && !DBUtils.isTruststoreJksPasswordRequired() || KeystoreType.PKCS12.isType(this.securityMessageTruststoreType) && !DBUtils.isTruststorePkcs12PasswordRequired()) {
                            required = false;
                        }
                        this.securityMessageTruststorePassword = required ? ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(listProtocolProperties, (String)(ssl ? "modipaSslTruststorePassword" : "modipaTruststorePassword")) : ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, (String)(ssl ? "modipaSslTruststorePassword" : "modipaTruststorePassword"));
                    }
                }
                if (!this.securityMessageTruststoreJWK && !this.securityMessageTruststoreRemote) {
                    this.securityMessageTruststoreCRLs = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, (String)(ssl ? "modipaSslTruststoreCRLs" : "modipaTruststoreCRLs"));
                    this.securityMessageTruststoreOCSPPolicy = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolProperties, (String)(ssl ? "modipaSslTruststoreOCSP" : "modipaTruststoreOCSP"));
                }
            } else if (undefined) {
                if (!ssl) {
                    throw new ProtocolException(prefix + " non definito");
                }
            } else {
                String string = this.securityMessageTruststoreType = ssl ? modIproperties.getSicurezzaMessaggioSslTrustStoreTipo() : modIproperties.getSicurezzaMessaggioCertificatiTrustStoreTipo();
                if (this.securityMessageTruststoreType != null) {
                    this.securityMessageTruststoreHSM = HSMUtils.isKeystoreHSM((String)this.securityMessageTruststoreType);
                    if (this.securityMessageTruststoreHSM) {
                        this.securityMessageTruststorePath = "HSM-" + this.securityMessageTruststoreType;
                        this.securityMessageTruststorePassword = "-";
                    } else {
                        this.securityMessageTruststorePath = ssl ? modIproperties.getSicurezzaMessaggioSslTrustStorePath() : modIproperties.getSicurezzaMessaggioCertificatiTrustStorePath();
                        try {
                            HttpUtilities.validateUri((String)this.securityMessageTruststorePath, (boolean)true);
                        }
                        catch (Exception e) {
                            throw new ProtocolException(prefix + " [" + this.securityMessageTruststorePath + "] " + e.getMessage(), (Throwable)e);
                        }
                        this.securityMessageTruststorePassword = ssl ? modIproperties.getSicurezzaMessaggioSslTrustStorePassword() : modIproperties.getSicurezzaMessaggioCertificatiTrustStorePassword();
                    }
                    this.securityMessageTruststoreCRLs = ssl ? modIproperties.getSicurezzaMessaggioSslTrustStoreCrls() : modIproperties.getSicurezzaMessaggioCertificatiTrustStoreCrls();
                    String string2 = this.securityMessageTruststoreOCSPPolicy = ssl ? modIproperties.getSicurezzaMessaggioSslTrustStoreOcspPolicy() : modIproperties.getSicurezzaMessaggioCertificatiTrustStoreOcspPolicy();
                }
            }
            if (!ssl) {
                if (this.securityMessageTruststoreType == null) {
                    throw new ProtocolException(prefix + " non definito");
                }
                if (this.securityMessageTruststorePath == null && !this.securityMessageTruststoreRemote) {
                    throw new ProtocolException(prefix + " (path) non definito");
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    public String getSecurityMessageTruststorePath() {
        return this.securityMessageTruststorePath;
    }

    public String getSecurityMessageTruststoreType() {
        return this.securityMessageTruststoreType;
    }

    public boolean isSecurityMessageTruststoreHSM() {
        return this.securityMessageTruststoreHSM;
    }

    public boolean isSecurityMessageTruststoreJWK() {
        return this.securityMessageTruststoreJWK;
    }

    public boolean isSecurityMessageTruststoreRemote() {
        return this.securityMessageTruststoreRemote;
    }

    public String getSecurityMessageTruststorePassword() {
        return this.securityMessageTruststorePassword;
    }

    public String getSecurityMessageTruststoreCRLs() {
        return this.securityMessageTruststoreCRLs;
    }

    public String getSecurityMessageTruststoreOCSPPolicy() {
        return this.securityMessageTruststoreOCSPPolicy;
    }
}

