/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModIConsoleCostanti;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.ConsoleItemInfo;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.utils.LoggerWrapperFactory;

public class ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities {
    private ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities() {
    }

    static void addProfiloSicurezzaMessaggio(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean rest, boolean action, String schemaAuditImpostatoInAPIoAltreAzioni) throws ProtocolException {
        configuration.addConsoleItem(ProtocolPropertiesFactory.newSubTitleItem((String)"modipaProfiloSicurezzaSubTitleId", (String)"Sicurezza Messaggio"));
        String labelSelezione = "Pattern";
        boolean corniceSicurezza = modiProperties.isSicurezzaMessaggioCorniceSicurezzaEnabled();
        if (action) {
            labelSelezione = "";
            StringConsoleItem modeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageProfileActionMode", (String)"Pattern");
            modeItem.addLabelValue("Usa pattern API", (Object)"default");
            modeItem.addLabelValue("Ridefinito", (Object)"ridefinisci");
            modeItem.setDefaultValue((Object)"default");
            modeItem.setReloadOnChange(true);
            configuration.addConsoleItem((BaseConsoleItem)modeItem);
        }
        StringConsoleItem profiloSicurezzaMessaggioItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageProfile", (String)labelSelezione);
        if (action) {
            profiloSicurezzaMessaggioItem.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaMessaggioItem.addLabelValue("-", (Object)"-");
        if (rest) {
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAR01" : "ID_AUTH_REST_01", (Object)"idam01");
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAR02" : "ID_AUTH_REST_02", (Object)"idam02");
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAR03 con IDAR01" : "INTEGRITY_REST_01 con ID_AUTH_REST_01", (Object)"idam0301");
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAR03 con IDAR02" : "INTEGRITY_REST_01 con ID_AUTH_REST_02", (Object)"idam0302");
            profiloSicurezzaMessaggioItem.addLabelValue("INTEGRITY_REST_02 con ID_AUTH_REST_01", (Object)"idam0401");
            profiloSicurezzaMessaggioItem.addLabelValue("INTEGRITY_REST_02 con ID_AUTH_REST_02", (Object)"idam0402");
        } else {
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAS01" : "ID_AUTH_SOAP_01", (Object)"idam01");
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAS02" : "ID_AUTH_SOAP_02", (Object)"idam02");
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAS03 con IDAS01" : "INTEGRITY_SOAP_01 con ID_AUTH_SOAP_01", (Object)"idam0301");
            profiloSicurezzaMessaggioItem.addLabelValue(modiProperties.isModIVersioneBozza() != null && modiProperties.isModIVersioneBozza() != false ? "IDAS03 con IDAS02" : "INTEGRITY_SOAP_01 con ID_AUTH_SOAP_02", (Object)"idam0302");
        }
        profiloSicurezzaMessaggioItem.setDefaultValue((Object)"-");
        if ("idam01".equals("-")) {
            profiloSicurezzaMessaggioItem.setNote(rest ? "Direct Trust con certificato X.509" : "Direct Trust con certificato X.509");
        } else if ("idam02".equals("-")) {
            profiloSicurezzaMessaggioItem.setNote(rest ? "Direct Trust con certificato X.509 con unicit\u00e0 del token" : "Direct Trust con certificato X.509 con unicit\u00e0 del messaggio");
        } else if ("idam0301".equals("-")) {
            profiloSicurezzaMessaggioItem.setNote(rest ? "Integrit\u00e0 payload del messaggio" : "Integrit\u00e0 payload del messaggio");
        } else if ("idam0302".equals("-")) {
            profiloSicurezzaMessaggioItem.setNote(rest ? "Integrit\u00e0 payload del messaggio + unicit\u00e0 del token" : "Integrit\u00e0 payload del messaggio + unicit\u00e0 del messaggio");
        } else if ("idam0401".equals("-") && rest) {
            profiloSicurezzaMessaggioItem.setNote("Integrit\u00e0 payload del messaggio");
        } else if ("idam0402".equals("-") && rest) {
            profiloSicurezzaMessaggioItem.setNote("Integrit\u00e0 payload del messaggio + unicit\u00e0 del token");
        }
        profiloSicurezzaMessaggioItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioItem);
        StringConsoleItem profiloSicurezzaMessaggioSorgenteTokenIdAuthItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageSorgenteToken", (String)"Generazione Token");
        profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.addLabelValue("Authorization ModI", (Object)"locale");
        profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.addLabelValue("Authorization PDND", (Object)"pdnd");
        profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.addLabelValue("Authorization OAuth", (Object)"oauth");
        profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setDefaultValue((Object)"locale");
        if ("locale".equals("locale")) {
            profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setNote("Token ID_AUTH generato dal mittente secondo le Linee Guida 'ModI'");
        } else if ("locale".equals("pdnd")) {
            profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setNote("Token ID_AUTH negoziato con la PDND");
        } else if ("locale".equals("oauth")) {
            profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setNote("Token ID_AUTH negoziato con un Authorization Server OAuth");
        }
        profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioSorgenteTokenIdAuthItem);
        if (rest) {
            StringConsoleItem profiloSicurezzaMessaggioHeaderItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageHeaderName", (String)"Header HTTP del Token");
            profiloSicurezzaMessaggioHeaderItem.addLabelValue("Letto da property".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"modipa");
            profiloSicurezzaMessaggioHeaderItem.addLabelValue("Authorization Bearer", (Object)"authorization");
            if (ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza03or04("-")) {
                profiloSicurezzaMessaggioHeaderItem.setDefaultValue((Object)"autonlyreq_modipa");
                profiloSicurezzaMessaggioHeaderItem.addLabelValue("Letto da property + Authorization Bearer".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"autonlyreq_modipa");
                profiloSicurezzaMessaggioHeaderItem.addLabelValue("Letto da property + Authorization Bearer anche nella risposta".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"authorization_modipa");
                profiloSicurezzaMessaggioHeaderItem.addLabelValue("Custom-JWT-Signature", (Object)"custom");
                profiloSicurezzaMessaggioHeaderItem.addLabelValue("Custom-JWT-Signature + Authorization Bearer", (Object)"autonlyreq_custom");
                profiloSicurezzaMessaggioHeaderItem.addLabelValue("Custom-JWT-Signature + Authorization Bearer anche nella risposta", (Object)"authorization_custom");
                profiloSicurezzaMessaggioHeaderItem.setReloadOnChange(true);
            } else if (ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza01("-") || ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza02("-")) {
                profiloSicurezzaMessaggioHeaderItem.setDefaultValue((Object)"authorization");
            } else {
                profiloSicurezzaMessaggioHeaderItem.setType(ConsoleItemType.HIDDEN);
            }
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioHeaderItem);
            StringConsoleItem profiloSicurezzaMessaggioHeaderCustomItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"modipaSecurityMessageHeaderCustomName", (String)"Custom-JWT-Signature");
            profiloSicurezzaMessaggioHeaderCustomItem.setDefaultValue((Object)modiProperties.getRestSecurityTokenHeaderModI());
            profiloSicurezzaMessaggioHeaderCustomItem.setType(ConsoleItemType.HIDDEN);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioHeaderCustomItem);
            StringConsoleItem profiloSicurezzaMessaggioHeaderCustomModeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageHeaderCustomMode", (String)"");
            profiloSicurezzaMessaggioHeaderCustomModeItem.addLabelValue("Presente solo con payload HTTP", (Object)"payload");
            profiloSicurezzaMessaggioHeaderCustomModeItem.addLabelValue("Presente sempre", (Object)"always");
            profiloSicurezzaMessaggioHeaderCustomModeItem.addLabelValue("Presente su richieste con payload e su qualsiasi risposta", (Object)"requestPayload");
            profiloSicurezzaMessaggioHeaderCustomModeItem.addLabelValue("Presente su qualsiasi richiesta e su risposte con payload", (Object)"responsePayload");
            profiloSicurezzaMessaggioHeaderCustomModeItem.setDefaultValue((Object)"payload");
            profiloSicurezzaMessaggioHeaderCustomModeItem.setType(ConsoleItemType.HIDDEN);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioHeaderCustomModeItem);
        }
        StringConsoleItem profiloSicurezzaMessaggioConfigurazioneItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageConfig", (String)"Applicabilit\u00e0");
        profiloSicurezzaMessaggioConfigurazioneItem.addLabelValue("Richiesta e Risposta", (Object)"entrambi");
        profiloSicurezzaMessaggioConfigurazioneItem.addLabelValue("Richiesta", (Object)"richiesta");
        profiloSicurezzaMessaggioConfigurazioneItem.addLabelValue("Risposta", (Object)"risposta");
        if (!rest && ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza03("-")) {
            profiloSicurezzaMessaggioConfigurazioneItem.addLabelValue("Richiesta e Risposta (con firma degli allegati)", (Object)"entrambi_attachments");
            profiloSicurezzaMessaggioConfigurazioneItem.addLabelValue("Richiesta (con firma degli allegati)", (Object)"richiesta_attachments");
            profiloSicurezzaMessaggioConfigurazioneItem.addLabelValue("Risposta (con firma degli allegati)", (Object)"risposta_attachments");
        }
        if (rest) {
            profiloSicurezzaMessaggioConfigurazioneItem.addLabelValue("Personalizza criteri di applicabilit\u00e0", (Object)"custom");
            profiloSicurezzaMessaggioConfigurazioneItem.setReloadOnChange(true);
        }
        profiloSicurezzaMessaggioConfigurazioneItem.setDefaultValue((Object)"entrambi");
        if (!(ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza01("-") || ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza02("-") || ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza03("-") || ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza04("-"))) {
            profiloSicurezzaMessaggioConfigurazioneItem.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaMessaggioConfigurazioneItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioConfigurazioneItem);
        BooleanConsoleItem profiloSicurezzaMessaggioRequestDigest = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaSecurityMessageRequestDigest", (String)"Digest Richiesta");
        if (!ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza03or04("-")) {
            profiloSicurezzaMessaggioRequestDigest.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaMessaggioRequestDigest.setDefaultValue((Object)false);
        ConsoleItemInfo cDigest = new ConsoleItemInfo("Digest Richiesta");
        cDigest.setHeaderBody(rest ? "Questa funzionalit\u00e0 consente di estendere il pattern aggiungendo all\u2019interno del token di sicurezza della risposta il digest della richiesta.<BR/>La funzionalit\u00e0 consente di implementare la soluzione per la non ripudiabilit\u00e0 della trasmissione come suggerito nelle linee guida di interoperabilit\u00e0<BR/>Il digest della richiesta viene aggiunto nel token della risposta all'interno del claim 'request_digest'." : "Questa funzionalit\u00e0 consente di estendere il pattern aggiungendo all\u2019interno dell'header di sicurezza tutti i digest della richiesta.<BR/>La funzionalit\u00e0 consente di implementare la soluzione per la non ripudiabilit\u00e0 della trasmissione come suggerito nelle linee guida di interoperabilit\u00e0<BR/>I digest della richiesta sono inseriti in un header 'X-RequestDigest' firmato.");
        profiloSicurezzaMessaggioRequestDigest.setInfo(cDigest);
        profiloSicurezzaMessaggioRequestDigest.setLabelRight("Non ripudiabilit\u00e0 della trasmissione");
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioRequestDigest);
        BooleanConsoleItem profiloSicurezzaMessaggioCorniceSicurezza = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaSecurityMessageCorniceSicurezza", (String)"Informazioni Audit");
        profiloSicurezzaMessaggioCorniceSicurezza.setDefaultValue((Object)false);
        profiloSicurezzaMessaggioCorniceSicurezza.setLabelRight("Dati del dominio del fruitore");
        profiloSicurezzaMessaggioCorniceSicurezza.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioCorniceSicurezza);
        boolean showConfigurazione = true;
        if (!"custom".equals("entrambi")) {
            showConfigurazione = false;
        }
        BaseConsoleItem subTitleRichiesta = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSicurezzaRichiestaSubTitleId", (String)"Sicurezza Messaggio nella Richiesta");
        if (!showConfigurazione) {
            subTitleRichiesta.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem(subTitleRichiesta);
        StringConsoleItem profiloSicurezzaRichiestaConfigurazioneItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityRequest", (String)"Stato");
        profiloSicurezzaRichiestaConfigurazioneItem.addLabelValue("Abilitato", (Object)"true");
        profiloSicurezzaRichiestaConfigurazioneItem.addLabelValue("Disabilitato", (Object)"false");
        profiloSicurezzaRichiestaConfigurazioneItem.addLabelValue("Personalizza Criteri", (Object)"custom");
        profiloSicurezzaRichiestaConfigurazioneItem.setDefaultValue((Object)"true");
        if (!showConfigurazione) {
            profiloSicurezzaRichiestaConfigurazioneItem.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaRichiestaConfigurazioneItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaRichiestaConfigurazioneItem);
        StringConsoleItem profiloSicurezzaRichiestaConfigurazioneContentTypeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TAGS, (String)"modipaSecurityRequestContentType", (String)"Content-Type");
        profiloSicurezzaRichiestaConfigurazioneContentTypeItem.setInfo(ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.buildConsoleItemInfoSicurezzaContentType("Content-Type"));
        if (!"Personalizza Criteri".equals("true")) {
            profiloSicurezzaRichiestaConfigurazioneContentTypeItem.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaRichiestaConfigurazioneContentTypeItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaRichiestaConfigurazioneContentTypeItem);
        BaseConsoleItem subTitleRisposta = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSicurezzaRispostaSubTitleId", (String)"Sicurezza Messaggio nella Risposta");
        if (!showConfigurazione) {
            subTitleRisposta.setType(ConsoleItemType.HIDDEN);
        }
        configuration.addConsoleItem(subTitleRisposta);
        StringConsoleItem profiloSicurezzaRispostaConfigurazioneItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityResponse", (String)"Stato");
        profiloSicurezzaRispostaConfigurazioneItem.addLabelValue("Abilitato", (Object)"true");
        profiloSicurezzaRispostaConfigurazioneItem.addLabelValue("Disabilitato", (Object)"false");
        profiloSicurezzaRispostaConfigurazioneItem.addLabelValue("Personalizza Criteri", (Object)"custom");
        profiloSicurezzaRispostaConfigurazioneItem.setDefaultValue((Object)"true");
        if (!showConfigurazione) {
            profiloSicurezzaRispostaConfigurazioneItem.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaRispostaConfigurazioneItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaRispostaConfigurazioneItem);
        StringConsoleItem profiloSicurezzaRispostaConfigurazioneContentTypeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TAGS, (String)"modipaSecurityResponseContentType", (String)"Content-Type");
        profiloSicurezzaRispostaConfigurazioneContentTypeItem.setInfo(ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.buildConsoleItemInfoSicurezzaContentType("Content-Type"));
        if (!"Personalizza Criteri".equals("true")) {
            profiloSicurezzaRispostaConfigurazioneContentTypeItem.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaRispostaConfigurazioneContentTypeItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaRispostaConfigurazioneContentTypeItem);
        StringConsoleItem profiloSicurezzaRispostaConfigurazioneReturnCodeItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TAGS, (String)"modipaSecurityResponseReturnCode", (String)"Codice Risposta");
        ConsoleItemInfo cRT = new ConsoleItemInfo("Codice Risposta");
        cRT.setHeaderBody("Lista di codici di risposta HTTP per i quali la sicurezza messaggio verr\u00e0 utilizzata; \u00e8 possibile indicare un codice http puntuale (es. 200) o un intervallo fornendo due codici separati dal trattino (es. 200-299).");
        profiloSicurezzaRispostaConfigurazioneReturnCodeItem.setInfo(cRT);
        if (!"Personalizza Criteri".equals("true")) {
            profiloSicurezzaRispostaConfigurazioneReturnCodeItem.setType(ConsoleItemType.HIDDEN);
        }
        profiloSicurezzaRispostaConfigurazioneReturnCodeItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaRispostaConfigurazioneReturnCodeItem);
        BaseConsoleItem subTitleCorniceSicurezza = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSecurityMessageCorniceSicurezzaSubTitleId", (String)"Informazioni Audit");
        subTitleCorniceSicurezza.setType(ConsoleItemType.HIDDEN);
        configuration.addConsoleItem(subTitleCorniceSicurezza);
        StringConsoleItem profiloSicurezzaCorniceSicurezzaPatternItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageCorniceSicurezzaPattern", (String)"Pattern");
        profiloSicurezzaCorniceSicurezzaPatternItem.addLabelValue("AUDIT_REST_01", (Object)"audit01");
        profiloSicurezzaCorniceSicurezzaPatternItem.addLabelValue("AUDIT_REST_02", (Object)"audit02");
        if (corniceSicurezza && ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza03("-")) {
            profiloSicurezzaCorniceSicurezzaPatternItem.addLabelValue("AUDIT_LEGACY", (Object)"old");
        }
        profiloSicurezzaCorniceSicurezzaPatternItem.setDefaultValue((Object)"audit01");
        profiloSicurezzaCorniceSicurezzaPatternItem.setType(ConsoleItemType.HIDDEN);
        profiloSicurezzaCorniceSicurezzaPatternItem.setReloadOnChange(true);
        if ("audit01".equals("old")) {
            ConsoleItemInfo consoleItemInfoCorniceSicurezza = new ConsoleItemInfo("Informazioni Audit");
            consoleItemInfoCorniceSicurezza.setHeaderBody(rest ? "Questa funzionalit\u00e0 consente di estendere il pattern aggiungendo all\u2019interno del token di sicurezza le informazioni sull\u2019utente che ha effettuato la richiesta. Le informazioni sono veicolate nei seguenti claims:" : "Questa funzionalit\u00e0 consente di estendere il pattern aggiungendo all\u2019interno dell'header di sicurezza un'asserzione SAML firmata contenente le informazioni sull\u2019utente che ha effettuato la richiesta. Le informazioni sono presenti, all'interno dell'asserzione, nelle seguenti posizioni:");
            consoleItemInfoCorniceSicurezza.setListBody(rest ? ModIConsoleCostanti.getModipaProfiloSicurezzaMessaggioCorniceSicurezzaRestInfoValori() : ModIConsoleCostanti.getModipaProfiloSicurezzaMessaggioCorniceSicurezzaSoapInfoValori());
            profiloSicurezzaMessaggioCorniceSicurezza.setInfo(consoleItemInfoCorniceSicurezza);
        }
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaCorniceSicurezzaPatternItem);
        List<ModIAuditConfig> listConfig = modiProperties.getAuditConfig();
        if (listConfig != null && !listConfig.isEmpty()) {
            StringConsoleItem profiloSicurezzaCorniceSicurezzaSchemaItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityMessageCorniceSicurezzaSchema", (String)"Schema Dati");
            for (ModIAuditConfig modIAuditConfig : listConfig) {
                if (schemaAuditImpostatoInAPIoAltreAzioni != null && StringUtils.isNotEmpty((CharSequence)schemaAuditImpostatoInAPIoAltreAzioni)) {
                    if (!schemaAuditImpostatoInAPIoAltreAzioni.equals(modIAuditConfig.getNome())) continue;
                    profiloSicurezzaCorniceSicurezzaSchemaItem.addLabelValue(modIAuditConfig.getLabel(), (Object)modIAuditConfig.getNome());
                    continue;
                }
                profiloSicurezzaCorniceSicurezzaSchemaItem.addLabelValue(modIAuditConfig.getLabel(), (Object)modIAuditConfig.getNome());
            }
            profiloSicurezzaCorniceSicurezzaSchemaItem.setDefaultValue((Object)listConfig.get(0).getNome());
            profiloSicurezzaCorniceSicurezzaSchemaItem.setReloadOnChange(true);
            profiloSicurezzaCorniceSicurezzaSchemaItem.setType(ConsoleItemType.HIDDEN);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaCorniceSicurezzaSchemaItem);
        }
        BooleanConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaOpzionale = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaSecurityMessageCorniceSicurezzaOpzionale", (String)"Opzionale");
        profiloSicurezzaMessaggioCorniceSicurezzaOpzionale.setDefaultValue((Object)false);
        profiloSicurezzaMessaggioCorniceSicurezzaOpzionale.setReloadOnChange(false);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioCorniceSicurezzaOpzionale);
    }

    static boolean isProfiloSicurezza01(String value) {
        return "idam01".equals(value);
    }

    static boolean isProfiloSicurezza02(String value) {
        return "idam02".equals(value);
    }

    static boolean isProfiloSicurezza03or04(String value) {
        return ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza03(value) || ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza04(value);
    }

    static boolean isProfiloSicurezza03(String value) {
        return "idam0301".equals(value) || "idam0302".equals(value);
    }

    static boolean isProfiloSicurezza04(String value) {
        return "idam0401".equals(value) || "idam0402".equals(value);
    }

    static ConsoleItemInfo buildConsoleItemInfoSicurezzaContentType(String label) {
        try {
            ConsoleItemInfo c = new ConsoleItemInfo(label);
            c.setHeaderBody("Lista di Content-Type per i quali la sicurezza messaggio verr\u00e0 utilizzata; di seguito i formati utilizzabili:");
            c.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_INFO_CONTENT_TYPE_VALORI);
            return c;
        }
        catch (Exception t) {
            try {
                LoggerWrapperFactory.getLogger((String)"govwayConsole.core").error(t.getMessage(), (Throwable)t);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    static void updateProfiloSicurezzaMessaggio(ModIProperties modiProperties, ConsoleConfiguration consoleConfiguration, IConsoleHelper consoleHelper, ProtocolProperties properties, boolean rest, boolean action) throws ProtocolException {
        block157: {
            BooleanProperty profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItemValue;
            BooleanConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItem;
            StringProperty profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue;
            StringConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem;
            StringProperty profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue;
            StringConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaPatternItem;
            BaseConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaSubTitle;
            BooleanProperty profiloSicurezzaMessaggioCorniceSicurezzaItemValue;
            AbstractConsoleItem profiloSicurezzaMessaggioCorniceSicurezzaItem;
            boolean sicurezzaSullaRichiesta;
            block154: {
                block155: {
                    String schemaSelected;
                    List<ModIAuditConfig> listConfig;
                    block156: {
                        boolean infoUtenteAbilitata;
                        String secValue;
                        StringProperty profiloSicurezzaMessaggioConfigurazioneItemValue;
                        String sicurezzaMessaggioPatternValue;
                        String postBackElementName = null;
                        try {
                            postBackElementName = consoleHelper.getPostBackElementName();
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                        boolean corniceSicurezza = modiProperties.isSicurezzaMessaggioCorniceSicurezzaEnabled();
                        StringProperty profiloSicurezzaMessaggioItemValue = null;
                        AbstractConsoleItem profiloSicurezzaMessaggioItemModifyNote = null;
                        boolean ridefinito = false;
                        if (action) {
                            StringProperty modeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageProfileActionMode");
                            AbstractConsoleItem profiloSicurezzaMessaggioItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageProfile");
                            profiloSicurezzaMessaggioItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageProfile");
                            if (modeItemValue != null && "ridefinisci".equals(modeItemValue.getValue())) {
                                profiloSicurezzaMessaggioItem.setType(ConsoleItemType.SELECT);
                                profiloSicurezzaMessaggioItemModifyNote = profiloSicurezzaMessaggioItem;
                                ridefinito = true;
                            } else {
                                if (profiloSicurezzaMessaggioItem != null) {
                                    profiloSicurezzaMessaggioItem.setType(ConsoleItemType.HIDDEN);
                                }
                                if (profiloSicurezzaMessaggioItemValue != null) {
                                    profiloSicurezzaMessaggioItemValue.setValue(null);
                                }
                            }
                        } else {
                            profiloSicurezzaMessaggioItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageProfile");
                            profiloSicurezzaMessaggioItemModifyNote = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageProfile");
                        }
                        String string = sicurezzaMessaggioPatternValue = profiloSicurezzaMessaggioItemValue != null ? (String)profiloSicurezzaMessaggioItemValue.getValue() : null;
                        if (profiloSicurezzaMessaggioItemModifyNote != null) {
                            if ("idam01".equals(sicurezzaMessaggioPatternValue)) {
                                profiloSicurezzaMessaggioItemModifyNote.setNote(rest ? "Direct Trust con certificato X.509" : "Direct Trust con certificato X.509");
                            } else if ("idam02".equals(sicurezzaMessaggioPatternValue)) {
                                profiloSicurezzaMessaggioItemModifyNote.setNote(rest ? "Direct Trust con certificato X.509 con unicit\u00e0 del token" : "Direct Trust con certificato X.509 con unicit\u00e0 del messaggio");
                            } else if ("idam0301".equals(sicurezzaMessaggioPatternValue)) {
                                profiloSicurezzaMessaggioItemModifyNote.setNote(rest ? "Integrit\u00e0 payload del messaggio" : "Integrit\u00e0 payload del messaggio");
                            } else if ("idam0302".equals(sicurezzaMessaggioPatternValue)) {
                                profiloSicurezzaMessaggioItemModifyNote.setNote(rest ? "Integrit\u00e0 payload del messaggio + unicit\u00e0 del token" : "Integrit\u00e0 payload del messaggio + unicit\u00e0 del messaggio");
                            } else if ("idam0401".equals(sicurezzaMessaggioPatternValue) && rest) {
                                profiloSicurezzaMessaggioItemModifyNote.setNote("Integrit\u00e0 payload del messaggio");
                            } else if ("idam0402".equals(sicurezzaMessaggioPatternValue) && rest) {
                                profiloSicurezzaMessaggioItemModifyNote.setNote("Integrit\u00e0 payload del messaggio + unicit\u00e0 del token");
                            }
                        }
                        boolean isSicurezza01 = false;
                        boolean isSicurezza02 = false;
                        boolean isSicurezza03 = false;
                        boolean isSicurezza04 = false;
                        if (profiloSicurezzaMessaggioItemValue != null && profiloSicurezzaMessaggioItemValue.getValue() != null) {
                            isSicurezza01 = ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza01((String)profiloSicurezzaMessaggioItemValue.getValue());
                            isSicurezza02 = ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza02((String)profiloSicurezzaMessaggioItemValue.getValue());
                            isSicurezza03 = ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza03((String)profiloSicurezzaMessaggioItemValue.getValue());
                            isSicurezza04 = ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.isProfiloSicurezza04((String)profiloSicurezzaMessaggioItemValue.getValue());
                        }
                        boolean isSicurezza03or04 = isSicurezza03 || isSicurezza04;
                        boolean sicurezzaSoloSullaRispostaPerIdar04 = false;
                        if (isSicurezza04 && (profiloSicurezzaMessaggioConfigurazioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageConfig")) != null && ("risposta".equals(secValue = (String)profiloSicurezzaMessaggioConfigurazioneItemValue.getValue()) || "risposta_attachments".equals(secValue))) {
                            sicurezzaSoloSullaRispostaPerIdar04 = true;
                        }
                        StringConsoleItem profiloSicurezzaMessaggioSorgenteTokenIdAuthItem = (StringConsoleItem)ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageSorgenteToken");
                        boolean sorgenteTokenLocale = true;
                        if (profiloSicurezzaMessaggioSorgenteTokenIdAuthItem != null) {
                            String sorgenteTokenIdAuthValue;
                            StringProperty profiloSicurezzaMessaggioSorgenteTokenIdAuthItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageSorgenteToken");
                            if (profiloSicurezzaMessaggioSorgenteTokenIdAuthItemValue != null && "modipaSecurityMessageProfile".equals(postBackElementName) && ("idam0401".equals(sicurezzaMessaggioPatternValue) || "idam0402".equals(sicurezzaMessaggioPatternValue))) {
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItemValue.setValue((Object)"pdnd");
                            }
                            profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.clearMapLabelValues();
                            if (!isSicurezza04) {
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.addLabelValue("Authorization ModI", (Object)"locale");
                            }
                            profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.addLabelValue("Authorization PDND", (Object)"pdnd");
                            profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.addLabelValue("Authorization OAuth", (Object)"oauth");
                            String string2 = sorgenteTokenIdAuthValue = profiloSicurezzaMessaggioSorgenteTokenIdAuthItemValue != null ? (String)profiloSicurezzaMessaggioSorgenteTokenIdAuthItemValue.getValue() : null;
                            if ("locale".equals(sorgenteTokenIdAuthValue)) {
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setNote("Token ID_AUTH generato dal mittente secondo le Linee Guida 'ModI'");
                            } else if ("pdnd".equals(sorgenteTokenIdAuthValue)) {
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setNote("Token ID_AUTH negoziato con la PDND");
                                sorgenteTokenLocale = false;
                            } else if ("oauth".equals(sorgenteTokenIdAuthValue)) {
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setNote("Token ID_AUTH negoziato con un Authorization Server OAuth");
                                sorgenteTokenLocale = false;
                            }
                            if (isSicurezza01 || isSicurezza02 || isSicurezza03 || isSicurezza04 && !sicurezzaSoloSullaRispostaPerIdar04) {
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setType(ConsoleItemType.SELECT);
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setReloadOnChange(true);
                            } else {
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setType(ConsoleItemType.HIDDEN);
                                profiloSicurezzaMessaggioSorgenteTokenIdAuthItem.setReloadOnChange(false);
                                if (profiloSicurezzaMessaggioSorgenteTokenIdAuthItemValue != null) {
                                    profiloSicurezzaMessaggioSorgenteTokenIdAuthItemValue.setValue(null);
                                }
                            }
                        }
                        if (rest) {
                            AbstractConsoleItem profiloSicurezzaMessaggioHeaderItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageHeaderName");
                            AbstractConsoleItem profiloSicurezzaMessaggioHeaderCustomItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageHeaderCustomName");
                            AbstractConsoleItem profiloSicurezzaMessaggioHeaderCustomModeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageHeaderCustomMode");
                            if (isSicurezza01 || isSicurezza02 || isSicurezza03 || isSicurezza04) {
                                if (profiloSicurezzaMessaggioHeaderItem != null) {
                                    profiloSicurezzaMessaggioHeaderItem.setType(ConsoleItemType.SELECT);
                                }
                                if ((profiloSicurezzaMessaggioHeaderItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHeaderName")) != null && "modipaSecurityMessageProfile".equals(postBackElementName)) {
                                    String headerSelezionato = (String)profiloSicurezzaMessaggioHeaderItemValue.getValue();
                                    boolean agidPresente = "autonlyreq_modipa".equals(headerSelezionato) || "authorization_modipa".equals(headerSelezionato) || "modipa".equals(headerSelezionato) || "autonlyreq_custom".equals(headerSelezionato) || "authorization_custom".equals(headerSelezionato) || "custom".equals(headerSelezionato);
                                    boolean authorizationOnlyPresente = "authorization".equals(headerSelezionato);
                                    if (isSicurezza01 || isSicurezza02) {
                                        if (!authorizationOnlyPresente) {
                                            profiloSicurezzaMessaggioHeaderItemValue.setValue(null);
                                        }
                                    } else if (isSicurezza03or04 && !agidPresente) {
                                        profiloSicurezzaMessaggioHeaderItemValue.setValue(null);
                                    }
                                }
                                if (profiloSicurezzaMessaggioHeaderItem != null) {
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).clearMapLabelValues();
                                }
                                if (sicurezzaSoloSullaRispostaPerIdar04) {
                                    profiloSicurezzaMessaggioHeaderItem.setType(ConsoleItemType.SELECT);
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Letto da property".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"modipa");
                                    if (profiloSicurezzaMessaggioHeaderItemValue != null && (profiloSicurezzaMessaggioHeaderItemValue.getValue() == null || StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaMessaggioHeaderItemValue.getValue())))) {
                                        profiloSicurezzaMessaggioHeaderItemValue.setValue((Object)"modipa");
                                    }
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).setReloadOnChange(false);
                                } else if (isSicurezza03or04) {
                                    profiloSicurezzaMessaggioHeaderItem.setType(ConsoleItemType.SELECT);
                                    if (sorgenteTokenLocale) {
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Letto da property".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"modipa");
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Authorization Bearer", (Object)"authorization");
                                    }
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Letto da property + Authorization Bearer".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"autonlyreq_modipa");
                                    if (sorgenteTokenLocale) {
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Letto da property + Authorization Bearer anche nella risposta".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"authorization_modipa");
                                    }
                                    if (sorgenteTokenLocale) {
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Custom-JWT-Signature", (Object)"custom");
                                    }
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Custom-JWT-Signature + Authorization Bearer", (Object)"autonlyreq_custom");
                                    if (sorgenteTokenLocale) {
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Custom-JWT-Signature + Authorization Bearer anche nella risposta", (Object)"authorization_custom");
                                    }
                                    if (profiloSicurezzaMessaggioHeaderItemValue != null && (profiloSicurezzaMessaggioHeaderItemValue.getValue() == null || StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaMessaggioHeaderItemValue.getValue())))) {
                                        profiloSicurezzaMessaggioHeaderItemValue.setValue((Object)"autonlyreq_modipa");
                                    }
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).setDefaultValue((Object)"autonlyreq_modipa");
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).setReloadOnChange(true);
                                } else if (isSicurezza01 || isSicurezza02) {
                                    if (sorgenteTokenLocale) {
                                        profiloSicurezzaMessaggioHeaderItem.setType(ConsoleItemType.SELECT);
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Authorization Bearer", (Object)"authorization");
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).addLabelValue("Letto da property".replace("Letto da property", modiProperties.getRestSecurityTokenHeaderModI()), (Object)"modipa");
                                    } else {
                                        profiloSicurezzaMessaggioHeaderItem.setType(ConsoleItemType.HIDDEN);
                                    }
                                    if (profiloSicurezzaMessaggioHeaderItemValue != null && (profiloSicurezzaMessaggioHeaderItemValue.getValue() == null || StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaMessaggioHeaderItemValue.getValue())))) {
                                        profiloSicurezzaMessaggioHeaderItemValue.setValue((Object)"authorization");
                                    }
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).setDefaultValue((Object)"authorization");
                                    ((StringConsoleItem)profiloSicurezzaMessaggioHeaderItem).setReloadOnChange(false);
                                }
                                boolean custom = false;
                                if (isSicurezza03or04 && profiloSicurezzaMessaggioHeaderItemValue != null && profiloSicurezzaMessaggioHeaderItemValue.getValue() != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)profiloSicurezzaMessaggioHeaderItemValue.getValue()))) {
                                    boolean bl = custom = sorgenteTokenLocale && "custom".equals(profiloSicurezzaMessaggioHeaderItemValue.getValue()) || "autonlyreq_custom".equals(profiloSicurezzaMessaggioHeaderItemValue.getValue()) || sorgenteTokenLocale && "authorization_custom".equals(profiloSicurezzaMessaggioHeaderItemValue.getValue());
                                }
                                if (custom) {
                                    if (profiloSicurezzaMessaggioHeaderCustomItem != null) {
                                        StringProperty profiloSicurezzaMessaggioHeaderCustomItemValue;
                                        profiloSicurezzaMessaggioHeaderCustomItem.setType(ConsoleItemType.TEXT_EDIT);
                                        profiloSicurezzaMessaggioHeaderCustomItem.setRequired(true);
                                        ((StringConsoleItem)profiloSicurezzaMessaggioHeaderCustomItem).setDefaultValue((Object)modiProperties.getRestSecurityTokenHeaderModI());
                                        if (postBackElementName != null && postBackElementName.equals("modipaSecurityMessageHeaderName") && (profiloSicurezzaMessaggioHeaderCustomItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHeaderCustomName")) != null && (profiloSicurezzaMessaggioHeaderCustomItemValue.getValue() == null || StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaMessaggioHeaderCustomItemValue.getValue())))) {
                                            profiloSicurezzaMessaggioHeaderCustomItemValue.setValue((Object)modiProperties.getRestSecurityTokenHeaderModI());
                                        }
                                    }
                                    if (profiloSicurezzaMessaggioHeaderCustomModeItem != null) {
                                        profiloSicurezzaMessaggioHeaderCustomModeItem.setType(ConsoleItemType.SELECT);
                                    }
                                    if (profiloSicurezzaMessaggioHeaderItem != null) {
                                        profiloSicurezzaMessaggioHeaderItem.setNote("Attenzione: la gestione dell'integrit\u00e0 (Digest e signed_header) \u00e8 demandata all'applicazione");
                                    }
                                } else {
                                    if (profiloSicurezzaMessaggioHeaderCustomItem != null) {
                                        profiloSicurezzaMessaggioHeaderCustomItem.setType(ConsoleItemType.HIDDEN);
                                        profiloSicurezzaMessaggioHeaderCustomItem.setRequired(false);
                                        StringProperty profiloSicurezzaMessaggioHeaderCustomItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHeaderCustomName");
                                        if (profiloSicurezzaMessaggioHeaderCustomItemValue != null) {
                                            profiloSicurezzaMessaggioHeaderCustomItemValue.setValue(null);
                                        }
                                    }
                                    if (profiloSicurezzaMessaggioHeaderCustomModeItem != null) {
                                        if (isSicurezza03or04) {
                                            profiloSicurezzaMessaggioHeaderCustomModeItem.setType(ConsoleItemType.SELECT);
                                        } else {
                                            profiloSicurezzaMessaggioHeaderCustomModeItem.setType(ConsoleItemType.HIDDEN);
                                            StringProperty profiloSicurezzaMessaggioHeaderCustomModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHeaderCustomMode");
                                            if (profiloSicurezzaMessaggioHeaderCustomModeItemValue != null) {
                                                profiloSicurezzaMessaggioHeaderCustomModeItemValue.setValue(null);
                                            }
                                        }
                                    }
                                    if (profiloSicurezzaMessaggioHeaderItem != null) {
                                        profiloSicurezzaMessaggioHeaderItem.setNote(null);
                                    }
                                }
                            } else {
                                profiloSicurezzaMessaggioHeaderItem.setType(ConsoleItemType.HIDDEN);
                                if (!ridefinito && (profiloSicurezzaMessaggioHeaderItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHeaderName")) != null) {
                                    profiloSicurezzaMessaggioHeaderItemValue.setValue(null);
                                }
                                if (profiloSicurezzaMessaggioHeaderCustomItem != null) {
                                    profiloSicurezzaMessaggioHeaderCustomItem.setType(ConsoleItemType.HIDDEN);
                                    StringProperty profiloSicurezzaMessaggioHeaderCustomItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHeaderCustomName");
                                    if (profiloSicurezzaMessaggioHeaderCustomItemValue != null) {
                                        profiloSicurezzaMessaggioHeaderCustomItemValue.setValue(null);
                                    }
                                }
                                if (profiloSicurezzaMessaggioHeaderCustomModeItem != null) {
                                    profiloSicurezzaMessaggioHeaderCustomModeItem.setType(ConsoleItemType.HIDDEN);
                                    StringProperty profiloSicurezzaMessaggioHeaderCustomModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageHeaderCustomMode");
                                    if (profiloSicurezzaMessaggioHeaderCustomModeItemValue != null) {
                                        profiloSicurezzaMessaggioHeaderCustomModeItemValue.setValue(null);
                                    }
                                }
                            }
                        }
                        AbstractConsoleItem profiloSicurezzaConfigurazioneItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageConfig");
                        StringProperty profiloSicurezzaMessaggioConfigurazioneItemValue2 = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageConfig");
                        if (!rest) {
                            if (isSicurezza03) {
                                if (!((StringConsoleItem)profiloSicurezzaConfigurazioneItem).getMapLabelValues().containsKey("Richiesta e Risposta (con firma degli allegati)")) {
                                    ((StringConsoleItem)profiloSicurezzaConfigurazioneItem).addLabelValue("Richiesta e Risposta (con firma degli allegati)", (Object)"entrambi_attachments");
                                }
                                if (!((StringConsoleItem)profiloSicurezzaConfigurazioneItem).getMapLabelValues().containsKey("Richiesta (con firma degli allegati)")) {
                                    ((StringConsoleItem)profiloSicurezzaConfigurazioneItem).addLabelValue("Richiesta (con firma degli allegati)", (Object)"richiesta_attachments");
                                }
                                if (!((StringConsoleItem)profiloSicurezzaConfigurazioneItem).getMapLabelValues().containsKey("Risposta (con firma degli allegati)")) {
                                    ((StringConsoleItem)profiloSicurezzaConfigurazioneItem).addLabelValue("Risposta (con firma degli allegati)", (Object)"risposta_attachments");
                                }
                            } else {
                                String v;
                                ((StringConsoleItem)profiloSicurezzaConfigurazioneItem).removeLabelValue("Richiesta e Risposta (con firma degli allegati)");
                                ((StringConsoleItem)profiloSicurezzaConfigurazioneItem).removeLabelValue("Richiesta (con firma degli allegati)");
                                ((StringConsoleItem)profiloSicurezzaConfigurazioneItem).removeLabelValue("Risposta (con firma degli allegati)");
                                if (profiloSicurezzaMessaggioConfigurazioneItemValue2 != null && profiloSicurezzaMessaggioConfigurazioneItemValue2.getValue() != null && !StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaMessaggioConfigurazioneItemValue2.getValue())) && ("entrambi_attachments".equals(v = (String)profiloSicurezzaMessaggioConfigurazioneItemValue2.getValue()) || "richiesta_attachments".equals(v) || "risposta_attachments".equals(v))) {
                                    profiloSicurezzaMessaggioConfigurazioneItemValue2.setValue((Object)"entrambi");
                                }
                            }
                        }
                        sicurezzaSullaRichiesta = false;
                        boolean sicurezzaSullaRisposta = false;
                        boolean configurazionePersonalizzata = false;
                        if (isSicurezza01 || isSicurezza02 || isSicurezza03 || isSicurezza04) {
                            if (sorgenteTokenLocale || isSicurezza03 || isSicurezza04) {
                                profiloSicurezzaConfigurazioneItem.setType(ConsoleItemType.SELECT);
                                profiloSicurezzaConfigurazioneItem.setReloadOnChange(true);
                                ((StringConsoleItem)profiloSicurezzaConfigurazioneItem).setDefaultValue((Object)"entrambi");
                                String secValue2 = "entrambi";
                                if (profiloSicurezzaMessaggioConfigurazioneItemValue2 != null) {
                                    if (profiloSicurezzaMessaggioConfigurazioneItemValue2.getValue() == null || StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaMessaggioConfigurazioneItemValue2.getValue()))) {
                                        profiloSicurezzaMessaggioConfigurazioneItemValue2.setValue((Object)"entrambi");
                                    } else {
                                        secValue2 = (String)profiloSicurezzaMessaggioConfigurazioneItemValue2.getValue();
                                    }
                                    if ("custom".equals(secValue2)) {
                                        configurazionePersonalizzata = true;
                                    }
                                }
                                if ("entrambi".equals(secValue2) || "entrambi_attachments".equals(secValue2)) {
                                    sicurezzaSullaRichiesta = true;
                                    sicurezzaSullaRisposta = true;
                                } else if ("richiesta".equals(secValue2) || "richiesta_attachments".equals(secValue2)) {
                                    sicurezzaSullaRichiesta = true;
                                } else if ("risposta".equals(secValue2) || "risposta_attachments".equals(secValue2)) {
                                    sicurezzaSullaRisposta = true;
                                }
                            } else {
                                profiloSicurezzaConfigurazioneItem.setType(ConsoleItemType.HIDDEN);
                                profiloSicurezzaConfigurazioneItem.setReloadOnChange(false);
                                if (profiloSicurezzaMessaggioConfigurazioneItemValue2 != null) {
                                    profiloSicurezzaMessaggioConfigurazioneItemValue2.setValue((Object)"richiesta");
                                }
                                sicurezzaSullaRichiesta = true;
                            }
                        } else {
                            profiloSicurezzaConfigurazioneItem.setType(ConsoleItemType.HIDDEN);
                            if (profiloSicurezzaMessaggioConfigurazioneItemValue2 != null) {
                                profiloSicurezzaMessaggioConfigurazioneItemValue2.setValue(null);
                            }
                        }
                        BaseConsoleItem subTitleRichiesta = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSicurezzaRichiestaSubTitleId");
                        subTitleRichiesta.setType(configurazionePersonalizzata ? ConsoleItemType.SUBTITLE : ConsoleItemType.HIDDEN);
                        AbstractConsoleItem profiloSicurezzaRichiestaConfigurazioneItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityRequest");
                        profiloSicurezzaRichiestaConfigurazioneItem.setType(configurazionePersonalizzata ? ConsoleItemType.SELECT : ConsoleItemType.HIDDEN);
                        if (configurazionePersonalizzata) {
                            ((StringConsoleItem)profiloSicurezzaRichiestaConfigurazioneItem).setDefaultValue((Object)"true");
                        }
                        StringProperty profiloSicurezzaRichiestaConfigurazioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityRequest");
                        boolean richiestaPersonalizzata = false;
                        if (configurazionePersonalizzata) {
                            String secValue3 = "true";
                            if (profiloSicurezzaRichiestaConfigurazioneItemValue != null) {
                                if (profiloSicurezzaRichiestaConfigurazioneItemValue.getValue() == null || StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaRichiestaConfigurazioneItemValue.getValue()))) {
                                    profiloSicurezzaRichiestaConfigurazioneItemValue.setValue((Object)"true");
                                } else {
                                    secValue3 = (String)profiloSicurezzaRichiestaConfigurazioneItemValue.getValue();
                                }
                                if ("custom".equals(secValue3)) {
                                    richiestaPersonalizzata = true;
                                }
                            }
                            if ("true".equals(secValue3) || "custom".equals(secValue3)) {
                                sicurezzaSullaRichiesta = true;
                            }
                        } else if (profiloSicurezzaRichiestaConfigurazioneItemValue != null) {
                            profiloSicurezzaRichiestaConfigurazioneItemValue.setValue(null);
                        }
                        AbstractConsoleItem profiloSicurezzaRichiestaConfigurazioneContentTypeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityRequestContentType");
                        profiloSicurezzaRichiestaConfigurazioneContentTypeItem.setType(richiestaPersonalizzata ? ConsoleItemType.TAGS : ConsoleItemType.HIDDEN);
                        StringProperty profiloSicurezzaRichiestaConfigurazioneContentTypeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityRequestContentType");
                        if (!richiestaPersonalizzata && profiloSicurezzaRichiestaConfigurazioneContentTypeItemValue != null) {
                            profiloSicurezzaRichiestaConfigurazioneContentTypeItemValue.setValue(null);
                        }
                        BaseConsoleItem subTitleRisposta = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSicurezzaRispostaSubTitleId");
                        subTitleRisposta.setType(configurazionePersonalizzata ? ConsoleItemType.SUBTITLE : ConsoleItemType.HIDDEN);
                        AbstractConsoleItem profiloSicurezzaRispostaConfigurazioneItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityResponse");
                        profiloSicurezzaRispostaConfigurazioneItem.setType(configurazionePersonalizzata ? ConsoleItemType.SELECT : ConsoleItemType.HIDDEN);
                        if (configurazionePersonalizzata) {
                            ((StringConsoleItem)profiloSicurezzaRispostaConfigurazioneItem).setDefaultValue((Object)"true");
                        }
                        StringProperty profiloSicurezzaRispostaConfigurazioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityResponse");
                        boolean rispostaPersonalizzata = false;
                        if (configurazionePersonalizzata) {
                            String secValue4 = "true";
                            if (profiloSicurezzaRispostaConfigurazioneItemValue != null) {
                                if (profiloSicurezzaRispostaConfigurazioneItemValue.getValue() == null || StringUtils.isEmpty((CharSequence)((CharSequence)profiloSicurezzaRispostaConfigurazioneItemValue.getValue()))) {
                                    profiloSicurezzaRispostaConfigurazioneItemValue.setValue((Object)"true");
                                } else {
                                    secValue4 = (String)profiloSicurezzaRispostaConfigurazioneItemValue.getValue();
                                }
                                if ("custom".equals(secValue4)) {
                                    rispostaPersonalizzata = true;
                                }
                            }
                            if ("true".equals(secValue4) || "custom".equals(secValue4)) {
                                sicurezzaSullaRisposta = true;
                            }
                        } else if (profiloSicurezzaRispostaConfigurazioneItemValue != null) {
                            profiloSicurezzaRispostaConfigurazioneItemValue.setValue(null);
                        }
                        AbstractConsoleItem profiloSicurezzaRispostaConfigurazioneContentTypeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityResponseContentType");
                        profiloSicurezzaRispostaConfigurazioneContentTypeItem.setType(rispostaPersonalizzata ? ConsoleItemType.TAGS : ConsoleItemType.HIDDEN);
                        StringProperty profiloSicurezzaRispostaConfigurazioneContentTypeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityResponseContentType");
                        if (!rispostaPersonalizzata && profiloSicurezzaRispostaConfigurazioneContentTypeItemValue != null) {
                            profiloSicurezzaRispostaConfigurazioneContentTypeItemValue.setValue(null);
                        }
                        AbstractConsoleItem profiloSicurezzaRispostaConfigurazioneReturnCodeItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityResponseReturnCode");
                        profiloSicurezzaRispostaConfigurazioneReturnCodeItem.setType(rispostaPersonalizzata ? ConsoleItemType.TAGS : ConsoleItemType.HIDDEN);
                        StringProperty profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityResponseReturnCode");
                        if (!rispostaPersonalizzata && profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue != null) {
                            profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue.setValue(null);
                        }
                        AbstractConsoleItem profiloSicurezzaMessaggioRequestDigestItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageRequestDigest");
                        BooleanProperty profiloSicurezzaMessaggioRequestDigestItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageRequestDigest");
                        if (isSicurezza03or04 && sicurezzaSullaRichiesta && sicurezzaSullaRisposta) {
                            profiloSicurezzaMessaggioRequestDigestItem.setType(ConsoleItemType.CHECKBOX);
                        } else {
                            if (profiloSicurezzaMessaggioRequestDigestItem != null) {
                                profiloSicurezzaMessaggioRequestDigestItem.setType(ConsoleItemType.HIDDEN);
                            }
                            if (profiloSicurezzaMessaggioRequestDigestItemValue != null) {
                                profiloSicurezzaMessaggioRequestDigestItemValue.setValue(null);
                            }
                        }
                        profiloSicurezzaMessaggioCorniceSicurezzaItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezza");
                        profiloSicurezzaMessaggioCorniceSicurezzaItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezza");
                        profiloSicurezzaMessaggioCorniceSicurezzaSubTitle = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaSubTitleId");
                        profiloSicurezzaMessaggioCorniceSicurezzaPatternItem = (StringConsoleItem)ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaPattern");
                        profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaPattern");
                        profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem = (StringConsoleItem)ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaSchema");
                        profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaSchema");
                        profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItem = (BooleanConsoleItem)ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageCorniceSicurezzaOpzionale");
                        profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageCorniceSicurezzaOpzionale");
                        boolean bl = infoUtenteAbilitata = profiloSicurezzaMessaggioCorniceSicurezzaItemValue != null && profiloSicurezzaMessaggioCorniceSicurezzaItemValue.getValue() != null && (Boolean)profiloSicurezzaMessaggioCorniceSicurezzaItemValue.getValue() != false;
                        if (infoUtenteAbilitata && profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue != null && profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue() == null) {
                            profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.setValue((Object)"old");
                        }
                        if (!sicurezzaSullaRichiesta || !infoUtenteAbilitata) break block154;
                        if (profiloSicurezzaMessaggioCorniceSicurezzaItem != null) {
                            profiloSicurezzaMessaggioCorniceSicurezzaItem.setType(ConsoleItemType.CHECKBOX);
                        }
                        if (profiloSicurezzaMessaggioCorniceSicurezzaSubTitle != null) {
                            profiloSicurezzaMessaggioCorniceSicurezzaSubTitle.setType(ConsoleItemType.SUBTITLE);
                        }
                        if (profiloSicurezzaMessaggioCorniceSicurezzaPatternItem != null) {
                            profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.setType(ConsoleItemType.SELECT);
                            if (sorgenteTokenLocale) {
                                profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.removeLabelValue("AUDIT_REST_02");
                            } else {
                                profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.addLabelValue("AUDIT_REST_02", (Object)"audit02");
                            }
                            if (corniceSicurezza && isSicurezza03or04) {
                                profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.addLabelValue("AUDIT_LEGACY", (Object)"old");
                                if (profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue != null && profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue() != null && "old".equals(profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue())) {
                                    ConsoleItemInfo consoleItemInfoCorniceSicurezza = new ConsoleItemInfo("Informazioni Audit");
                                    consoleItemInfoCorniceSicurezza.setHeaderBody(rest ? "Questa funzionalit\u00e0 consente di estendere il pattern aggiungendo all\u2019interno del token di sicurezza le informazioni sull\u2019utente che ha effettuato la richiesta. Le informazioni sono veicolate nei seguenti claims:" : "Questa funzionalit\u00e0 consente di estendere il pattern aggiungendo all\u2019interno dell'header di sicurezza un'asserzione SAML firmata contenente le informazioni sull\u2019utente che ha effettuato la richiesta. Le informazioni sono presenti, all'interno dell'asserzione, nelle seguenti posizioni:");
                                    consoleItemInfoCorniceSicurezza.setListBody(rest ? ModIConsoleCostanti.getModipaProfiloSicurezzaMessaggioCorniceSicurezzaRestInfoValori() : ModIConsoleCostanti.getModipaProfiloSicurezzaMessaggioCorniceSicurezzaSoapInfoValori());
                                    profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.setInfo(consoleItemInfoCorniceSicurezza);
                                } else {
                                    profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.setInfo(null);
                                }
                            } else {
                                profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.removeLabelValue("AUDIT_LEGACY");
                                profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.setInfo(null);
                                if (profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue != null && profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue() != null && "old".equals(profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue())) {
                                    profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.setValue(null);
                                }
                            }
                        }
                        if (profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem == null || (listConfig = modiProperties.getAuditConfig()) == null || listConfig.isEmpty()) break block155;
                        if (profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue == null || profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue() == null || !"old".equals(profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue())) break block156;
                        profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem.setType(ConsoleItemType.HIDDEN);
                        profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem.setInfo(null);
                        if (profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue == null) break block155;
                        profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue.setValue(null);
                        break block155;
                    }
                    profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem.setType(ConsoleItemType.SELECT);
                    String string = schemaSelected = profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue != null ? (String)profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue.getValue() : null;
                    if ((schemaSelected == null || StringUtils.isEmpty((CharSequence)schemaSelected)) && profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue != null) {
                        schemaSelected = listConfig.get(0).getNome();
                        profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue.setValue((Object)schemaSelected);
                    }
                    if (schemaSelected != null && StringUtils.isNotEmpty((CharSequence)schemaSelected)) {
                        for (ModIAuditConfig modIAuditConfig : listConfig) {
                            if (!modIAuditConfig.getNome().equals(schemaSelected)) continue;
                            if (modIAuditConfig.getClaims() == null || modIAuditConfig.getClaims().isEmpty()) break;
                            ConsoleItemInfo consoleItemInfoCorniceSicurezza = new ConsoleItemInfo("Informazioni Audit");
                            consoleItemInfoCorniceSicurezza.setHeaderBody("Il pattern selezionato consente di aggiungere all\u2019interno del token di sicurezza di Audit le informazioni sul fruitore che ha effettuato la richiesta. Le informazioni sono veicolate nei seguenti claims:");
                            ArrayList<String> body = new ArrayList<String>();
                            for (ModIAuditClaimConfig claim : modIAuditConfig.getClaims()) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("<b>");
                                sb.append(claim.getNome());
                                sb.append("</b>: ");
                                sb.append(claim.getInfo());
                                body.add(sb.toString());
                            }
                            consoleItemInfoCorniceSicurezza.setListBody(body);
                            profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem.setInfo(consoleItemInfoCorniceSicurezza);
                            break;
                        }
                    }
                }
                if (profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItem != null) {
                    String pattern;
                    String string = pattern = profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue != null ? (String)profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue() : null;
                    if (pattern == null || "old".equals(profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.getValue())) {
                        profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItem.setType(ConsoleItemType.HIDDEN);
                        if (profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItemValue != null) {
                            profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItemValue.setValue(null);
                        }
                    } else {
                        profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItem.setType(ConsoleItemType.CHECKBOX);
                    }
                }
                break block157;
            }
            if (!sicurezzaSullaRichiesta) {
                if (profiloSicurezzaMessaggioCorniceSicurezzaItem != null) {
                    profiloSicurezzaMessaggioCorniceSicurezzaItem.setType(ConsoleItemType.HIDDEN);
                }
                if (profiloSicurezzaMessaggioCorniceSicurezzaItemValue != null) {
                    profiloSicurezzaMessaggioCorniceSicurezzaItemValue.setValue(null);
                }
            } else if (profiloSicurezzaMessaggioCorniceSicurezzaItem != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaItem.setType(ConsoleItemType.CHECKBOX);
            }
            if (profiloSicurezzaMessaggioCorniceSicurezzaSubTitle != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaSubTitle.setType(ConsoleItemType.HIDDEN);
            }
            if (profiloSicurezzaMessaggioCorniceSicurezzaPatternItem != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaPatternItem.setType(ConsoleItemType.HIDDEN);
            }
            if (profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaPatternItemValue.setValue(null);
            }
            if (profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaSchemaItem.setType(ConsoleItemType.HIDDEN);
            }
            if (profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaSchemaItemValue.setValue(null);
            }
            if (profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItem != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItem.setType(ConsoleItemType.HIDDEN);
            }
            if (profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItemValue != null) {
                profiloSicurezzaMessaggioCorniceSicurezzaOpzionaleItemValue.setValue(null);
            }
        }
    }

    static void validateProfiloSicurezzaMessaggio(ProtocolProperties properties, boolean rest) throws ProtocolException {
        StringProperty profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue;
        if (rest && (profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityResponseReturnCode")) != null && profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue.getValue() != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue.getValue()))) {
            String v = (String)profiloSicurezzaRispostaConfigurazioneReturnCodeItemValue.getValue();
            ArrayList<String> codici = new ArrayList<String>();
            if (v.contains(",")) {
                String[] tmp = v.split(",");
                for (int i = 0; i < tmp.length; ++i) {
                    codici.add(tmp[i].trim());
                }
            } else {
                codici.add(v.trim());
            }
            if (!codici.isEmpty()) {
                for (String codice : codici) {
                    if (codice.contains("-")) {
                        String[] tmp = codice.split("-");
                        if (tmp == null || tmp.length != 2) {
                            throw new ProtocolException("Codice Risposta '" + codice + "' possiede un formato errato; atteso: codiceMin-codiceMax");
                        }
                        String codiceMin = tmp[0];
                        String codiceMax = tmp[1];
                        if (codiceMin == null || StringUtils.isEmpty((CharSequence)codiceMin.trim())) {
                            throw new ProtocolException("Codice Risposta '" + codice + "' possiede un formato errato (intervallo minimo non definito); atteso: codiceMin-codiceMax");
                        }
                        if (codiceMax == null || StringUtils.isEmpty((CharSequence)codiceMax.trim())) {
                            throw new ProtocolException("Codice Risposta '" + codice + "' possiede un formato errato (intervallo massimo non definito); atteso: codiceMin-codiceMax");
                        }
                        codiceMin = codiceMin.trim();
                        codiceMax = codiceMax.trim();
                        int codiceMinInt = -1;
                        try {
                            codiceMinInt = Integer.valueOf(codiceMin);
                        }
                        catch (Exception e) {
                            throw new ProtocolException("Codice Risposta '" + codice + "' contiene un intervallo minimo '" + codiceMin + "' che non \u00e8 un numero intero");
                        }
                        int codiceMaxInt = -1;
                        try {
                            codiceMaxInt = Integer.valueOf(codiceMax);
                        }
                        catch (Exception e) {
                            throw new ProtocolException("Codice Risposta '" + codice + "' contiene un intervallo massimo '" + codiceMax + "' che non \u00e8 un numero intero");
                        }
                        if (codiceMaxInt > codiceMinInt) continue;
                        throw new ProtocolException("Codice Risposta '" + codice + "' contiene un intervallo massimo '" + codiceMax + "' minore o uguale all'intervallo minimo '" + codiceMin + "'");
                    }
                    try {
                        int tmp = Integer.parseInt(codice);
                    }
                    catch (Exception e) {
                        throw new ProtocolException("Codice Risposta '" + codice + "' non \u00e8 un numero intero");
                    }
                }
            }
        }
    }
}

