/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.byok.BYOKUnwrapPolicyUtilities;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.TokenCacheItem;
import org.openspcoop2.protocol.modipa.builder.ModIJWTToken;
import org.openspcoop2.protocol.modipa.builder.ModIJWTTokenClaims;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.constants.ModIHeaderType;
import org.openspcoop2.protocol.modipa.utils.ModIKeystoreConfig;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneAuditClaimValue;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.RestMessageSecurityToken;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.engine.MessageSecurityContext_impl;
import org.openspcoop2.security.message.jose.MessageSecuritySender_jose;
import org.openspcoop2.security.message.utils.SignatureBean;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.digest.DigestUtils;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.random.RandomGenerator;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class ModIImbustamentoRest {
    private Logger log;
    private ModIProperties modiProperties;
    private static final String RICHIESTO_NON_BLOCCANTE_PUSH = ", richiesto dal profilo non bloccante PUSH, non trovato";

    public ModIImbustamentoRest(Logger log) throws ProtocolException {
        this.log = log;
        this.modiProperties = ModIProperties.getInstance();
    }

    public void addSyncInteractionProfile(OpenSPCoop2Message msg, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        if (!RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
            boolean is4xx5xx;
            String returnCode = null;
            int returnCodeInt = -1;
            if (msg.getTransportResponseContext() != null && (returnCode = msg.getTransportResponseContext().getCodiceTrasporto()) != null) {
                try {
                    returnCodeInt = Integer.valueOf(returnCode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Integer[] returnCodeAttesi = this.modiProperties.getRestBloccanteHttpStatus();
            boolean bl = is4xx5xx = returnCodeInt >= 400 && returnCodeInt <= 599;
            if (!is4xx5xx && returnCodeAttesi != null) {
                boolean found = false;
                for (Integer integer : returnCodeAttesi) {
                    if (integer == -2) {
                        if (returnCodeInt < 200 || returnCodeInt > 299) continue;
                        found = true;
                        break;
                    }
                    if (integer != returnCodeInt) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    StringBuilder sb = new StringBuilder();
                    for (Integer integer : returnCodeAttesi) {
                        if (integer == -2) {
                            sb = new StringBuilder();
                            sb.append("2xx");
                            break;
                        }
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(integer);
                    }
                    ProtocolException pe = new ProtocolException("HTTP Status '" + returnCodeInt + "' differente da quello atteso per il profilo bloccante (atteso: " + sb.toString() + ")");
                    pe.setInteroperabilityError(true);
                    throw pe;
                }
            }
        }
    }

    private static String getHeaderHttpPrefix(String hdr) {
        return "Header http '" + hdr + "'";
    }

    private ProtocolException newProtocolExceptionAccessoKeystoreNonRiuscito(String type, String path) {
        return new ProtocolException("Accesso al keystore [" + type + "] '" + path + "' non riuscito");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAsyncInteractionProfile(OpenSPCoop2Message msg, Busta busta, RuoloMessaggio ruoloMessaggio, String asyncInteractionType, String asyncInteractionRole, String replyTo, AccordoServizioParteComune apiContenenteRisorsa, String azione) throws ProtocolException {
        if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
            String correlationIdExtracted;
            Object urlInvocata;
            if ("PUSH".equals(asyncInteractionType)) {
                if ("Richiesta".equals(asyncInteractionRole)) {
                    String headerReplyName = this.modiProperties.getRestReplyToHeader();
                    if (this.modiProperties.isRestSecurityTokenPushReplyToUpdateOrCreateInFruizione()) {
                        msg.getTransportRequestContext().removeHeader(headerReplyName);
                        msg.forceTransportHeader(headerReplyName, replyTo);
                        busta.addProperty("ProfiloInterazioneAsincrona-ReplyTo", replyTo);
                        return;
                    }
                    String replyToFound = msg.getTransportRequestContext().getHeaderFirstValue(headerReplyName);
                    if (replyToFound != null && !"".equals(replyToFound)) {
                        busta.addProperty("ProfiloInterazioneAsincrona-ReplyTo", replyToFound);
                        return;
                    }
                    ProtocolException pe = new ProtocolException(ModIImbustamentoRest.getHeaderHttpPrefix(headerReplyName) + RICHIESTO_NON_BLOCCANTE_PUSH);
                    pe.setInteroperabilityError(true);
                    throw pe;
                }
                if (!"Risposta".equals(asyncInteractionRole)) return;
                String headerCorrelationId = this.modiProperties.getRestCorrelationIdHeader();
                String correlationIdFound = msg.getTransportRequestContext().getHeaderFirstValue(headerCorrelationId);
                if (correlationIdFound != null && !"".equals(correlationIdFound)) {
                    busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", correlationIdFound);
                    if (correlationIdFound.length() > 255) return;
                    busta.setCollaborazione(correlationIdFound);
                    return;
                }
                if (busta.getCollaborazione() != null) {
                    busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", busta.getCollaborazione());
                    msg.forceTransportHeader(headerCorrelationId, busta.getCollaborazione());
                    return;
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    busta.setCollaborazione(busta.getRiferimentoMessaggio());
                    busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", busta.getRiferimentoMessaggio());
                    msg.forceTransportHeader(headerCorrelationId, busta.getRiferimentoMessaggio());
                    return;
                }
                ProtocolException pe = new ProtocolException(ModIImbustamentoRest.getHeaderHttpPrefix(headerCorrelationId) + RICHIESTO_NON_BLOCCANTE_PUSH);
                pe.setInteroperabilityError(true);
                throw pe;
            }
            if (!"RichiestaStato".equals(asyncInteractionRole)) {
                if (!"Risposta".equals(asyncInteractionRole)) return;
            }
            if ((urlInvocata = msg.getTransportRequestContext().getFunctionParameters()) == null) return;
            if ("".equals(urlInvocata)) return;
            String resourcePathAzione = null;
            for (Resource r : apiContenenteRisorsa.getResourceList()) {
                if (!r.getNome().equals(azione)) continue;
                resourcePathAzione = r.getPath();
                break;
            }
            if (!((String)urlInvocata).startsWith("/")) {
                urlInvocata = "/" + (String)urlInvocata;
            }
            if ((correlationIdExtracted = ModIUtilities.extractCorrelationIdFromLocation(resourcePathAzione, (String)urlInvocata, false, this.log)) == null) return;
            if (correlationIdExtracted.length() > 255) return;
            busta.setCollaborazione(correlationIdExtracted);
            return;
        }
        String returnCode = null;
        int returnCodeInt = -1;
        if (msg != null && msg.getTransportResponseContext() != null && (returnCode = msg.getTransportResponseContext().getCodiceTrasporto()) != null) {
            try {
                returnCodeInt = Integer.valueOf(returnCode);
            }
            catch (Exception correlationIdExtracted) {
                // empty catch block
            }
        }
        boolean is4xx5xx = returnCodeInt >= 400 && returnCodeInt <= 599;
        Integer[] returnCodeAttesi = null;
        if (!is4xx5xx) {
            if ("PUSH".equals(asyncInteractionType)) {
                if ("Richiesta".equals(asyncInteractionRole)) {
                    String headerCorrelationId = this.modiProperties.getRestCorrelationIdHeader();
                    String string = msg.getTransportResponseContext().getHeaderFirstValue(headerCorrelationId);
                    if (string != null && !"".equals(string) && !"__@@SkipValidation##__".equals(string)) {
                        busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", string);
                        busta.setCollaborazione(string);
                    } else {
                        if (!this.modiProperties.isRestSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists()) {
                            ProtocolException pe = new ProtocolException(ModIImbustamentoRest.getHeaderHttpPrefix(headerCorrelationId) + RICHIESTO_NON_BLOCCANTE_PUSH);
                            pe.setInteroperabilityError(true);
                            throw pe;
                        }
                        String idTransazione = msg.getTransactionId();
                        msg.forceTransportHeader(headerCorrelationId, idTransazione);
                        busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", idTransazione);
                        busta.setCollaborazione(idTransazione);
                    }
                    returnCodeAttesi = this.modiProperties.getRestNonBloccantePushRequestHttpStatus();
                } else {
                    returnCodeAttesi = this.modiProperties.getRestNonBloccantePushResponseHttpStatus();
                }
            } else {
                String location = null;
                Object var14_27 = null;
                if ("Richiesta".equals(asyncInteractionRole) || "RichiestaStato".equals(asyncInteractionRole)) {
                    String string = this.modiProperties.getRestLocationHeader();
                    if (msg != null && msg.getTransportResponseContext() != null) {
                        location = msg.getTransportResponseContext().getHeaderFirstValue(string);
                    }
                }
                if ("Richiesta".equals(asyncInteractionRole)) {
                    if (location == null || "".equals(location)) {
                        ProtocolException pe = new ProtocolException(ModIImbustamentoRest.getHeaderHttpPrefix((String)var14_29) + ", richiesto dal profilo non bloccante PULL, non trovato");
                        pe.setInteroperabilityError(true);
                        throw pe;
                    }
                    busta.addProperty("ProfiloInterazioneAsincrona-Location", location);
                    String correlationIdExtracted = ModIUtilities.extractCorrelationId(location, apiContenenteRisorsa, azione, asyncInteractionRole, this.log);
                    if (correlationIdExtracted != null && correlationIdExtracted.length() <= 255) {
                        busta.setCollaborazione(correlationIdExtracted);
                    }
                    returnCodeAttesi = this.modiProperties.getRestNonBloccantePullRequestHttpStatus();
                } else if (!"RichiestaStato".equals(asyncInteractionRole)) {
                    returnCodeAttesi = this.modiProperties.getRestNonBloccantePullResponseHttpStatus();
                } else {
                    Integer[] returnCodeResourceReady = this.modiProperties.getRestNonBloccantePullRequestStateOkHttpStatus();
                    boolean isReady = false;
                    for (Integer integer : returnCodeResourceReady) {
                        if (integer != returnCodeInt) continue;
                        isReady = true;
                        break;
                    }
                    if (isReady) {
                        if (location == null || "".equals(location)) {
                            ProtocolException pe = new ProtocolException(ModIImbustamentoRest.getHeaderHttpPrefix((String)var14_29) + ", richiesto dal profilo non bloccante PULL, non trovato");
                            pe.setInteroperabilityError(true);
                            throw pe;
                        }
                        busta.addProperty("ProfiloInterazioneAsincrona-Location", location);
                        String correlationIdExtracted = ModIUtilities.extractCorrelationId(location, apiContenenteRisorsa, azione, asyncInteractionRole, this.log);
                        if (correlationIdExtracted != null && correlationIdExtracted.length() <= 255) {
                            busta.setCollaborazione(correlationIdExtracted);
                        }
                        returnCodeAttesi = returnCodeResourceReady;
                    } else {
                        int j;
                        Integer[] returnCodeAttesiNotReady = this.modiProperties.getRestNonBloccantePullRequestStateNotReadyHttpStatus();
                        returnCodeAttesi = new Integer[returnCodeResourceReady.length + returnCodeAttesiNotReady.length];
                        int i = 0;
                        for (j = 0; j < returnCodeAttesiNotReady.length; ++i, ++j) {
                            returnCodeAttesi[i] = returnCodeAttesiNotReady[j];
                        }
                        for (j = 0; j < returnCodeResourceReady.length; ++i, ++j) {
                            returnCodeAttesi[i] = returnCodeResourceReady[j];
                        }
                    }
                }
            }
        }
        if (returnCodeAttesi == null) return;
        boolean found = false;
        for (Integer integer : returnCodeAttesi) {
            if (integer != returnCodeInt) continue;
            found = true;
            break;
        }
        if (found) return;
        StringBuilder stringBuilder = new StringBuilder();
        Integer[] returnCodeResourceReady = returnCodeAttesi;
        int n = returnCodeResourceReady.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                ProtocolException pe = new ProtocolException("HTTP Status '" + returnCodeInt + "' differente da quello atteso per il profilo non bloccante '" + asyncInteractionType + "' con ruolo '" + asyncInteractionRole + "' (atteso: " + stringBuilder.toString() + ")");
                pe.setInteroperabilityError(true);
                throw pe;
            }
            Integer integer = returnCodeResourceReady[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(integer);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ModIJWTToken addToken(OpenSPCoop2Message msg, boolean request, Context context, ModIKeystoreConfig keystoreConfig, ModISecurityConfig securityConfig, Busta busta, String securityMessageProfile, boolean useKIDtokenHeader, String headerTokenRest, boolean corniceSicurezza, String corniceSicurezzaPattern, String corniceSicurezzaSchema, RuoloMessaggio ruoloMessaggio, boolean includiRequestDigest, Long nowParam, String jti, ModIHeaderType headerType, boolean integritaCustom, String integrityMode, Map<String, Object> dynamicMap, RequestInfo requestInfo, String purposeId, boolean sicurezzaRidefinitaOperazione) throws ProtocolException {
        String securityTokenHeader;
        Object key;
        ProtocolException pe;
        boolean integrita;
        if (busta == null) {
            throw new ProtocolException("Param busta is null");
        }
        boolean integritaX509 = "idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile);
        boolean integritaKid = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
        boolean bl = integrita = integritaX509 || integritaKid;
        if (integrita && integritaCustom) {
            busta.addProperty("ProfiloSicurezzaMessaggio-Custom-JWT-Signature", headerTokenRest);
        }
        boolean filtroDuplicati = "idam02".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
        boolean headerDuplicati = headerType.isHeaderDuplicati();
        boolean headerAuthentication = headerType.isUsabledForAuthentication();
        boolean tokenAudit = corniceSicurezza && !"old".equals(corniceSicurezzaPattern) && corniceSicurezzaSchema != null;
        boolean audit02 = tokenAudit && "audit02".equals(corniceSicurezzaPattern);
        boolean apiSoap = ServiceBinding.SOAP.equals((Object)msg.getServiceBinding());
        boolean cacheable = false;
        String cacheMetodoChiamante = null;
        if (tokenAudit) {
            cacheable = this.modiProperties.isTokenAuditCacheable();
            cacheMetodoChiamante = "AUDIT";
        } else if (!integrita && !filtroDuplicati) {
            cacheable = this.modiProperties.isTokenAuthCacheable();
            cacheMetodoChiamante = "AUTH";
        }
        String idTransazione = msg.getTransactionId();
        if (idTransazione == null && context != null && context.containsKey(Costanti.ID_TRANSAZIONE)) {
            idTransazione = Context.getValue((MapKey)Costanti.ID_TRANSAZIONE, (Context)context);
        }
        ModIJWTToken modiToken = new ModIJWTToken(idTransazione);
        String nomePorta = null;
        if (requestInfo != null && requestInfo.getProtocolContext() != null) {
            nomePorta = requestInfo.getProtocolContext().getInterfaceName();
        }
        ModIJWTTokenClaims modiTokenClaims = new ModIJWTTokenClaims(tokenAudit, idTransazione, request, nomePorta, busta.getAzione(), sicurezzaRidefinitaOperazione);
        modiToken.setClaims(modiTokenClaims);
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode payloadToken = null;
        try {
            payloadToken = jsonUtils.newObjectNode();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        long nowMs = nowParam != null ? nowParam : DateManager.getTimeMillis();
        long nowSeconds = nowMs / 1000L;
        Date nowDateUsatoPerProprietaTraccia = new Date(nowSeconds * 1000L);
        Date iatDateUsatoPerProprietaTraccia = new Date(nowSeconds * 1000L);
        payloadToken.put("iat", nowSeconds);
        String iatValue = DateUtils.getSimpleDateFormatMs().format(nowDateUsatoPerProprietaTraccia);
        if (!headerDuplicati || "Authorization".equalsIgnoreCase(headerTokenRest)) {
            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-IssuedAt" : "ProfiloSicurezzaMessaggio-IssuedAt", iatValue);
        } else {
            String iatAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-IssuedAt");
            if (!iatValue.equals(iatAuthorization)) {
                busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityIssuedAt", iatValue);
            }
        }
        modiTokenClaims.setIat(nowDateUsatoPerProprietaTraccia);
        modiTokenClaims.setIatValue(iatValue);
        payloadToken.put("nbf", nowSeconds);
        String nbfValue = DateUtils.getSimpleDateFormatMs().format(nowDateUsatoPerProprietaTraccia);
        if (!headerDuplicati || "Authorization".equalsIgnoreCase(headerTokenRest)) {
            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-NotBefore" : "ProfiloSicurezzaMessaggio-NotBefore", nbfValue);
        } else {
            String nbfAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-NotBefore");
            if (!nbfValue.equals(nbfAuthorization)) {
                busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityNotBefore", nbfValue);
            }
        }
        modiTokenClaims.setNbf(nowDateUsatoPerProprietaTraccia);
        modiTokenClaims.setNbfValue(nbfValue);
        long expired = nowSeconds + (long)securityConfig.getTtlSeconds();
        Date expiredDateUsatoPerProprietaTraccia = new Date(expired * 1000L);
        payloadToken.put("exp", expired);
        String expValue = DateUtils.getSimpleDateFormatMs().format(expiredDateUsatoPerProprietaTraccia);
        if (!headerDuplicati || "Authorization".equalsIgnoreCase(headerTokenRest)) {
            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Expiration" : "ProfiloSicurezzaMessaggio-Expiration", expValue);
        } else {
            String expAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-Expiration");
            if (!expValue.equals(expAuthorization)) {
                busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityExpiration", nbfValue);
            }
        }
        modiToken.setIat(iatDateUsatoPerProprietaTraccia);
        modiToken.setExp(expiredDateUsatoPerProprietaTraccia);
        modiTokenClaims.setExp(expiredDateUsatoPerProprietaTraccia);
        modiTokenClaims.setExpValue(expValue);
        if (jti != null) {
            payloadToken.put("jti", jti);
            if (tokenAudit) {
                busta.addProperty("ProfiloSicurezzaMessaggioAudit-MessageId", jti);
            } else if (headerDuplicati && (busta == null || !jti.equals(busta.getID()))) {
                if (integrita) {
                    busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityMessageId", jti);
                } else {
                    busta.addProperty("ProfiloSicurezzaMessaggio-AuthorizationMessageId", jti);
                }
            } else {
                busta.addProperty("ProfiloSicurezzaMessaggio-MessageId", jti);
            }
            modiTokenClaims.setJti(jti);
        }
        String audience = null;
        if (tokenAudit) {
            audience = securityConfig.getCorniceSicurezzaAudience();
            try {
                audience = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggioAudit-Audience", audience, dynamicMap, context);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                ProtocolException pe3 = new ProtocolException(e.getMessage());
                pe3.setInteroperabilityError(true);
                throw pe3;
            }
            sbAudience = new StringBuilder();
            this.addAudienceClaim(jsonUtils, payloadToken, audience, sbAudience);
            String audAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-Audience");
            String audDaAggiungereInBusta = sbAudience.toString();
            if (audAuthorization == null || !audDaAggiungereInBusta.equals(audAuthorization)) {
                busta.addProperty("ProfiloSicurezzaMessaggioAudit-Audience", audDaAggiungereInBusta);
            }
        } else if (securityConfig.getAudience() != null) {
            audience = securityConfig.getAudience();
            try {
                audience = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Audience", audience, dynamicMap, context);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                ProtocolException pe4 = new ProtocolException(e.getMessage());
                pe4.setInteroperabilityError(true);
                throw pe4;
            }
            sbAudience = new StringBuilder();
            this.addAudienceClaim(jsonUtils, payloadToken, audience, sbAudience);
            String audDaAggiungereInBusta = sbAudience.toString();
            if (!headerDuplicati || "Authorization".equalsIgnoreCase(headerTokenRest)) {
                busta.addProperty("ProfiloSicurezzaMessaggio-Audience", audDaAggiungereInBusta);
            } else {
                String audAuthorization = busta.getProperty("ProfiloSicurezzaMessaggio-Audience");
                if (!audDaAggiungereInBusta.equals(audAuthorization)) {
                    busta.addProperty("ProfiloSicurezzaMessaggio-IntegrityAudience", audDaAggiungereInBusta);
                }
            }
        }
        modiTokenClaims.setAudience(audience);
        boolean addClientId = false;
        addClientId = tokenAudit ? (useKIDtokenHeader ? securityConfig.getCorniceSicurezzaSchemaConfig().isClientIdOAuth() : securityConfig.getCorniceSicurezzaSchemaConfig().isClientIdLocale()) : true;
        String clientId = null;
        boolean clientIdNotGenerate = false;
        if (securityConfig.getClientId() != null) {
            clientIdNotGenerate = "${notGenerate}".equalsIgnoreCase(securityConfig.getClientId());
            if (!clientIdNotGenerate) {
                clientId = securityConfig.getClientId();
            }
            if (tokenAudit) {
                clientIdNotGenerate = false;
            }
        }
        boolean clientIdKid = false;
        if (!clientIdNotGenerate && (integritaKid || useKIDtokenHeader || tokenAudit)) {
            String clientIdIntegritaKid = securityConfig.getTokenClientId();
            if (clientIdIntegritaKid != null) {
                try {
                    clientIdIntegritaKid = ModIUtilities.getDynamicValue(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-ClientId" : "ProfiloSicurezzaMessaggio-ClientId", clientIdIntegritaKid, dynamicMap, context);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    ProtocolException pe5 = new ProtocolException(e.getMessage());
                    pe5.setInteroperabilityError(true);
                    throw pe5;
                }
            }
            if (clientIdIntegritaKid != null && StringUtils.isNotEmpty((CharSequence)clientIdIntegritaKid)) {
                clientId = clientIdIntegritaKid;
                clientIdKid = true;
            }
        }
        if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && clientId != null && !clientIdKid) {
            try {
                clientId = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-ClientId", clientId, dynamicMap, context);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                ProtocolException pe6 = new ProtocolException(e.getMessage());
                pe6.setInteroperabilityError(true);
                throw pe6;
            }
        }
        if (addClientId && clientId != null) {
            String claimName = this.modiProperties.getRestSecurityTokenClaimsClientIdHeader();
            payloadToken.put(claimName, clientId);
            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-ClientId" : "ProfiloSicurezzaMessaggio-ClientId", clientId);
            modiTokenClaims.setClientId(clientId);
        }
        String kid = null;
        if ((integritaKid || useKIDtokenHeader) && (kid = securityConfig.getTokenKid()) != null) {
            try {
                kid = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Kid", kid, dynamicMap, context);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                ProtocolException pe7 = new ProtocolException(e.getMessage());
                pe7.setInteroperabilityError(true);
                throw pe7;
            }
            modiTokenClaims.setKid(kid);
        }
        if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio)) {
            corniceSicurezza = false;
        }
        boolean addIss = true;
        boolean addSub = true;
        if (integrita && RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && includiRequestDigest && context.containsKey(ModICostanti.MODIPA_CONTEXT_REQUEST_DIGEST)) {
            Object o = context.getObject(ModICostanti.MODIPA_CONTEXT_REQUEST_DIGEST);
            String value2 = (String)o;
            String claimNameRequestDigest = this.modiProperties.getRestSecurityTokenClaimRequestDigest();
            payloadToken.put(claimNameRequestDigest, value2);
            modiTokenClaims.setRequestDigest(value2);
        }
        if (corniceSicurezza) {
            if ("old".equals(corniceSicurezzaPattern)) {
                addIss = this.addCorniceSicurezzaLegacyCodiceEnte(securityConfig, dynamicMap, context, payloadToken, busta, modiTokenClaims);
                addSub = this.addCorniceSicurezzaLegacyUser(securityConfig, dynamicMap, context, payloadToken, busta, modiTokenClaims);
                this.addCorniceSicurezzaLegacyIpUser(securityConfig, dynamicMap, context, payloadToken, busta, modiTokenClaims);
            } else if (tokenAudit) {
                cacheable = this.addCorniceSicurezzaSchema(securityConfig, dynamicMap, context, payloadToken, busta, corniceSicurezzaSchema, modiTokenClaims);
                if (corniceSicurezzaSchema != null && StringUtils.isNotEmpty((CharSequence)corniceSicurezzaSchema)) {
                    if (useKIDtokenHeader) {
                        addIss = securityConfig.getCorniceSicurezzaSchemaConfig().isIssOAuth();
                        addSub = securityConfig.getCorniceSicurezzaSchemaConfig().isSubOAuth();
                    } else {
                        addIss = securityConfig.getCorniceSicurezzaSchemaConfig().isIssLocale();
                        addSub = securityConfig.getCorniceSicurezzaSchemaConfig().isSubLocale();
                    }
                }
            }
        }
        if (addIss) {
            String issuer = null;
            if (tokenAudit) {
                if (clientId == null) {
                    ProtocolException pe2 = new ProtocolException("ClientId undefined; required in audit token 'iss' claim");
                    pe2.setInteroperabilityError(true);
                    throw pe2;
                }
                issuer = clientId;
            } else if (securityConfig.getIssuer() != null && !"${notGenerate}".equalsIgnoreCase(securityConfig.getIssuer())) {
                try {
                    issuer = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Issuer", securityConfig.getIssuer(), dynamicMap, context);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    pe = new ProtocolException(e.getMessage());
                    pe.setInteroperabilityError(true);
                    throw pe;
                }
            }
            if (issuer != null) {
                payloadToken.put("iss", issuer);
                busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Issuer" : "ProfiloSicurezzaMessaggio-Issuer", issuer);
                modiTokenClaims.setIss(issuer);
            }
        }
        if (addSub) {
            String subject = null;
            if (tokenAudit) {
                if (clientId == null) {
                    ProtocolException pe2 = new ProtocolException("ClientId undefined; required in audit token 'sub' claim");
                    pe2.setInteroperabilityError(true);
                    throw pe2;
                }
                subject = clientId;
            } else if (securityConfig.getSubject() != null && !"${notGenerate}".equalsIgnoreCase(securityConfig.getSubject())) {
                try {
                    subject = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Subject", securityConfig.getSubject(), dynamicMap, context);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    pe = new ProtocolException(e.getMessage());
                    pe.setInteroperabilityError(true);
                    throw pe;
                }
            }
            if (subject != null) {
                payloadToken.put("sub", subject);
                busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Subject" : "ProfiloSicurezzaMessaggio-Subject", subject);
                modiTokenClaims.setSub(subject);
            }
        }
        if (purposeId != null) {
            boolean addPurposeId = false;
            if (tokenAudit) {
                addPurposeId = this.modiProperties.isSecurityTokenAuditAddPurposeId();
            } else if (integritaX509) {
                addPurposeId = this.modiProperties.isSecurityTokenIntegrity01AddPurposeId();
            } else if (integritaKid) {
                addPurposeId = this.modiProperties.isSecurityTokenIntegrity02AddPurposeId();
            }
            if (addPurposeId) {
                String purposeValue = null;
                try {
                    purposeValue = ModIUtilities.getDynamicValue(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-PurposeId" : "ProfiloSicurezzaMessaggio-IntegrityPurposeId", purposeId, dynamicMap, context);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    ProtocolException pe8 = new ProtocolException(e.getMessage());
                    pe8.setInteroperabilityError(true);
                    throw pe8;
                }
                if (purposeValue != null) {
                    payloadToken.put("purposeId", purposeValue);
                    busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-PurposeId" : "ProfiloSicurezzaMessaggio-IntegrityPurposeId", purposeValue);
                    modiTokenClaims.setPurposeId(purposeValue);
                }
            }
        }
        if (audit02) {
            String dNonce = RandomGenerator.getDefaultInstance().nextRandomInt(this.modiProperties.getSecurityTokenAuditDnonceSize());
            long dNonceInt = Long.parseLong(dNonce);
            payloadToken.put("dnonce", dNonceInt);
            modiTokenClaims.setdNonce(dNonce);
        }
        HashMap<Object, String> claimsCustom = new HashMap<Object, String>();
        if (securityConfig.getMultipleHeaderClaims() != null && !securityConfig.getMultipleHeaderClaims().isEmpty()) {
            for (Object oKeyP : securityConfig.getMultipleHeaderClaims().keySet()) {
                if (!(oKeyP instanceof String)) continue;
                key = (String)oKeyP;
                String string = securityConfig.getMultipleHeaderClaims().getProperty((String)key);
                claimsCustom.put(key, string);
            }
        }
        if (securityConfig.getClaims() != null && !securityConfig.getClaims().isEmpty()) {
            for (Object oKeyP : securityConfig.getClaims().keySet()) {
                if (!(oKeyP instanceof String)) continue;
                key = (String)oKeyP;
                String string = securityConfig.getClaims().getProperty((String)key);
                if (claimsCustom.containsKey(key)) continue;
                claimsCustom.put(key, string);
            }
        }
        if (!claimsCustom.isEmpty()) {
            List<String> blackListRegistrazioneCustomClaims = null;
            boolean tracciaCustomClaims = this.modiProperties.isGenerazioneTracceRegistraCustomClaims();
            if (tracciaCustomClaims) {
                blackListRegistrazioneCustomClaims = this.modiProperties.getGenerazioneTracceRegistraCustomClaimsBlackList();
            }
            for (Map.Entry entry : claimsCustom.entrySet()) {
                String key2 = (String)entry.getKey();
                String value3 = (String)claimsCustom.get(key2);
                try {
                    value3 = ModIUtilities.getDynamicValue("Claims - " + key2, value3, dynamicMap, context);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    ProtocolException pe9 = new ProtocolException(e.getMessage());
                    pe9.setInteroperabilityError(true);
                    throw pe9;
                }
                if (value3 == null) continue;
                try {
                    jsonUtils.putValue(payloadToken, key2, value3);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (tracciaCustomClaims && (blackListRegistrazioneCustomClaims == null || blackListRegistrazioneCustomClaims.isEmpty() || !blackListRegistrazioneCustomClaims.contains(key2))) {
                    busta.addProperty("ProfiloSicurezzaMessaggio-Claim-" + key2, value3);
                }
                modiTokenClaims.addCustomClaim(key2, value3);
            }
        }
        if (integrita && !integritaCustom) {
            void var65_100;
            String digestValue = null;
            boolean hasContent = false;
            try {
                hasContent = msg.castAsRest().hasContent();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            byte[] content = null;
            boolean bl2 = false;
            if (hasContent) {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)bout, false);
                    bout.flush();
                    bout.close();
                    content = bout.toByteArray();
                    boolean bl3 = true;
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            } else if ("always".equals(integrityMode) || request && "responsePayload".equals(integrityMode) || !request && "requestPayload".equals(integrityMode)) {
                content = "".getBytes();
                boolean bl4 = true;
            }
            if (var65_100 != false) {
                try {
                    digestValue = HttpUtilities.getDigestHeaderValue((byte[])content, (String)securityConfig.getDigestAlgorithm(), (DigestEncoding)securityConfig.getDigestEncoding());
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                msg.forceTransportHeader("Digest", digestValue);
                busta.addProperty("ProfiloSicurezzaMessaggio-Digest", digestValue);
            }
            if (securityConfig.getHttpHeaders() != null && !securityConfig.getHttpHeaders().isEmpty()) {
                ArrayNode signedHeaders = null;
                try {
                    signedHeaders = jsonUtils.newArrayNode();
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                Map mapForceTransportHeaders = msg.getForceTransportHeaders();
                for (String httpHeader : securityConfig.getHttpHeaders()) {
                    ObjectNode httpHeaderNode = null;
                    String hdrName = null;
                    ArrayList<String> hdrValues = new ArrayList<String>();
                    if (httpHeader.equalsIgnoreCase("Digest")) {
                        List digestValueHEAD;
                        if (digestValue != null) {
                            hdrName = "Digest";
                            hdrValues.add(digestValue);
                        } else if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && msg.getTransportResponseContext() != null && msg.getTransportRequestContext() != null && HttpRequestMethod.HEAD.equals(msg.getTransportRequestContext().getRequestType()) && this.modiProperties.isRestSecurityTokenResponseDigestHEADuseServerHeader() && (digestValueHEAD = msg.getTransportResponseContext().getHeaderValues("Digest")) != null && !digestValueHEAD.isEmpty()) {
                            hdrName = "Digest";
                            hdrValues.addAll(digestValueHEAD);
                        }
                    } else if (httpHeader.equalsIgnoreCase("Content-Type")) {
                        String ct = null;
                        try {
                            ct = msg.getContentType();
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                        if (ct != null) {
                            hdrName = httpHeader;
                            hdrValues.add(ct);
                        }
                    } else {
                        List<String> values = ModIImbustamentoRest.getHeaderValues(ruoloMessaggio, msg, mapForceTransportHeaders, httpHeader);
                        if (values != null && !values.isEmpty()) {
                            hdrName = httpHeader;
                            hdrValues.addAll(values);
                        }
                    }
                    if (hdrName == null) continue;
                    for (String hdrValue : hdrValues) {
                        try {
                            httpHeaderNode = jsonUtils.newObjectNode();
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                        String hdrNameLowerCase = hdrName.toLowerCase();
                        httpHeaderNode.put(hdrNameLowerCase, hdrValue);
                        if ("Authorization".equalsIgnoreCase(hdrNameLowerCase) && headerDuplicati) {
                            ModIUtilities.addHeaderProperty(busta, hdrNameLowerCase, "Bearer ...TOKEN...");
                        } else {
                            ModIUtilities.addHeaderProperty(busta, hdrNameLowerCase, hdrValue);
                        }
                        signedHeaders.add((JsonNode)httpHeaderNode);
                    }
                }
                if (signedHeaders.size() > 0) {
                    String claimSignedHeader = this.modiProperties.getRestSecurityTokenClaimSignedHeaders();
                    payloadToken.set(claimSignedHeader, (JsonNode)signedHeaders);
                }
            }
        }
        MessageSecuritySender_jose joseSignature = new MessageSecuritySender_jose();
        MessageSecurityContextParameters messageSecurityContextParameters = new MessageSecurityContextParameters();
        MessageSecurityContext_impl messageSecurityContext = new MessageSecurityContext_impl(messageSecurityContextParameters);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("securityEngine", "jose");
        hashMap.put("action", "Signature");
        hashMap.put("signatureMode", "compact");
        hashMap.put("signatureDetached", "false");
        hashMap.put("joseUseHeaders", "true");
        hashMap.put("joseContentType", "false");
        hashMap.put("joseType", "JWT");
        String algorithm = null;
        algorithm = tokenAudit && apiSoap ? securityConfig.getAlgorithmConvertForREST() : securityConfig.getAlgorithm();
        hashMap.put("signatureAlgorithm", algorithm);
        modiTokenClaims.setAlgorithm(algorithm);
        boolean richiestaConfigurazioneX509 = false;
        if (integritaKid || useKIDtokenHeader) {
            if (kid == null && (kid = keystoreConfig.getSecurityMessageKeyAlias()) == null) {
                throw new ProtocolException("Il pattern configurato richiede la definizione di un KID");
            }
            hashMap.put("joseKeyIdCustom", kid);
            modiTokenClaims.setKid(kid);
        } else {
            boolean x5u;
            boolean x5t;
            boolean x5c;
            boolean addKid;
            richiestaConfigurazioneX509 = true;
            boolean bl5 = addKid = tokenAudit ? this.modiProperties.isSecurityTokenAuditX509AddKid() : this.modiProperties.isSecurityTokenX509AddKid();
            if (addKid) {
                hashMap.put("joseKeyId", "true");
            }
            modiTokenClaims.setAddKid(addKid);
            boolean bl6 = x5c = tokenAudit && apiSoap ? this.modiProperties.isSecurityTokenAuditApiSoapX509RiferimentoX5c() : securityConfig.isX5c();
            if (x5c) {
                boolean x5cUseSingleCertificate;
                hashMap.put("joseIncludeCert", "true");
                boolean bl7 = x5cUseSingleCertificate = tokenAudit && apiSoap ? this.modiProperties.isSecurityTokenAuditApiSoapX509RiferimentoX5cSingleCertificate() : securityConfig.isUseSingleCertificate();
                if (!x5cUseSingleCertificate) {
                    hashMap.put("joseIncludeCertChain", "true");
                }
                modiTokenClaims.setAddX5cChain(!x5cUseSingleCertificate);
            }
            modiTokenClaims.setAddX5c(x5c);
            boolean bl8 = x5t = tokenAudit && apiSoap ? this.modiProperties.isSecurityTokenAuditApiSoapX509RiferimentoX5t() : securityConfig.isX5t();
            if (x5t) {
                hashMap.put("joseIncludeCertSHA", "sha256");
            }
            modiTokenClaims.setAddX5t(x5t);
            boolean bl9 = x5u = tokenAudit && apiSoap ? this.modiProperties.isSecurityTokenAuditApiSoapX509RiferimentoX5u() : securityConfig.isX5u();
            if (x5u) {
                String url = securityConfig.getX5url();
                hashMap.put("joseX509Url", url);
                modiTokenClaims.setX5uUrl(url);
            }
            modiTokenClaims.setAddX5u(x5u);
        }
        SignatureBean signatureBean = new SignatureBean();
        KeyStore ks = null;
        JWKSet jwkSet = null;
        String keyAlias = keystoreConfig.getSecurityMessageKeyAlias();
        if (keystoreConfig.getSecurityMessageKeystorePath() != null || keystoreConfig.isSecurityMessageKeystoreHSM()) {
            if (richiestaConfigurazioneX509 && (CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(keystoreConfig.getSecurityMessageKeystoreType()) || CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(keystoreConfig.getSecurityMessageKeystoreType()))) {
                String type = CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(keystoreConfig.getSecurityMessageKeystoreType()) ? KeystoreType.KEY_PAIR.getLabel() : KeystoreType.JWK_SET.getLabel();
                String pattern = tokenAudit ? "audit" : securityMessageProfile;
                throw new ProtocolException("Configuration error; pattern '" + pattern + "' require x509 certificate, found '" + type + "' key");
            }
            String keystoreByokPolicy = keystoreConfig.getSecurityMessageKeystoreByokPolicy();
            BYOKRequestParams byokParams = null;
            try {
                byokParams = BYOKUnwrapPolicyUtilities.getBYOKRequestParams((String)keystoreByokPolicy, dynamicMap);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(keystoreConfig.getSecurityMessageKeystoreType())) {
                try {
                    JWKSetStore jwtStore = GestoreKeystoreCache.getJwkSetStore((RequestInfo)requestInfo, (String)keystoreConfig.getSecurityMessageKeystorePath(), (BYOKRequestParams)byokParams);
                    if (jwtStore == null) {
                        throw this.newProtocolExceptionAccessoKeystoreNonRiuscito(keystoreConfig.getSecurityMessageKeystoreType(), keystoreConfig.getSecurityMessageKeystorePath());
                    }
                    jwkSet = jwtStore.getJwkSet();
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            } else if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(keystoreConfig.getSecurityMessageKeystoreType())) {
                try {
                    KeyPairStore keyPairStore = GestoreKeystoreCache.getKeyPairStore((RequestInfo)requestInfo, (String)keystoreConfig.getSecurityMessageKeystorePath(), (String)keystoreConfig.getSecurityMessageKeystorePathPublicKey(), (String)keystoreConfig.getSecurityMessageKeyPassword(), (String)keystoreConfig.getSecurityMessageKeystoreKeyAlgorithm(), (BYOKRequestParams)byokParams);
                    if (keyPairStore == null) {
                        throw this.newProtocolExceptionAccessoKeystoreNonRiuscito(keystoreConfig.getSecurityMessageKeystoreType(), keystoreConfig.getSecurityMessageKeystorePath());
                    }
                    jwkSet = keyPairStore.getJwkSet();
                    keyAlias = keyPairStore.getJwkSetKid();
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)keystoreConfig.getSecurityMessageKeystorePath(), (String)keystoreConfig.getSecurityMessageKeystoreType(), (String)keystoreConfig.getSecurityMessageKeystorePassword(), (BYOKRequestParams)byokParams);
                    if (merlinKs == null) {
                        throw this.newProtocolExceptionAccessoKeystoreNonRiuscito(keystoreConfig.getSecurityMessageKeystoreType(), keystoreConfig.getSecurityMessageKeystorePath());
                    }
                    ks = merlinKs.getKeyStore();
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            try {
                MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (byte[])keystoreConfig.getSecurityMessageKeystoreArchive(), (String)keystoreConfig.getSecurityMessageKeystoreType(), (String)keystoreConfig.getSecurityMessageKeystorePassword());
                if (merlinKs == null) {
                    throw new ProtocolException("Accesso al keystore non riuscito");
                }
                ks = merlinKs.getKeyStore();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        signatureBean.setKeystore(ks);
        signatureBean.setJwkSet(jwkSet);
        signatureBean.setUser(keyAlias);
        signatureBean.setPassword(keystoreConfig.getSecurityMessageKeyPassword());
        messageSecurityContext.setSignatureBean(signatureBean);
        X509Certificate x509 = null;
        if (ks != null) {
            if (!richiestaConfigurazioneX509 && kid != null && StringUtils.isNotEmpty((CharSequence)kid)) {
                busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Kid" : "ProfiloSicurezzaMessaggio-Kid", kid);
            }
            Certificate certificate = null;
            try {
                certificate = ks.getCertificate(keystoreConfig.getSecurityMessageKeyAlias());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (certificate instanceof X509Certificate) {
                x509 = (X509Certificate)certificate;
                busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-X509-Subject" : "ProfiloSicurezzaMessaggio-X509-Subject", x509.getSubjectX500Principal().toString());
                if (x509.getIssuerX500Principal() != null) {
                    busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-X509-Issuer" : "ProfiloSicurezzaMessaggio-X509-Issuer", x509.getIssuerX500Principal().toString());
                }
                if (cacheable) {
                    try {
                        String pem = CertificateUtils.toPEM((X509Certificate)x509);
                        modiTokenClaims.setPem(pem);
                    }
                    catch (Exception e) {
                        throw new ProtocolException("X509 to PEM serialization failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (jwkSet != null) {
            busta.addProperty(tokenAudit ? "ProfiloSicurezzaMessaggioAudit-Kid" : "ProfiloSicurezzaMessaggio-Kid", kid);
            if (cacheable) {
                try {
                    modiTokenClaims.setJwk(jwkSet.getJson());
                }
                catch (Exception e) {
                    throw new ProtocolException("JWK to Json serialization failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        boolean prelevatoDallaCache = false;
        String funzioneCache = "ModI-" + (tokenAudit ? "Audit" : "Authorization");
        String keyCache = null;
        Date nowCacheDate = null;
        if (cacheable) {
            keyCache = modiTokenClaims.toCacheKey();
            ModIJWTToken moditokenFromCache = null;
            try {
                nowCacheDate = new Date(nowMs);
                moditokenFromCache = (ModIJWTToken)GestoreToken.getTokenCacheItem((String)keyCache, (String)funzioneCache, (Date)nowCacheDate, (String)cacheMetodoChiamante, (Integer)this.modiProperties.getGestioneRetrieveTokenRefreshTokenBeforeExpirePercent(), (Integer)this.modiProperties.getGestioneRetrieveTokenRefreshTokenBeforeExpireSeconds());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (moditokenFromCache != null) {
                moditokenFromCache.getClaims().setInfoNonCachableInBusta(busta);
                modiToken = moditokenFromCache;
                prelevatoDallaCache = true;
            }
        }
        if (!prelevatoDallaCache) {
            OpenSPCoop2Message payload = null;
            try {
                String jsonPayload = jsonUtils.toString((JsonNode)payloadToken);
                payload = msg.getFactory().createMessage(MessageType.JSON, MessageRole.NONE, "application/json", jsonPayload.getBytes(), null, null).getMessage_throwParseException();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            try {
                messageSecurityContext.setOutgoingProperties(hashMap, false);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            try {
                DynamicMapBuilderUtils.injectDynamicMap((Busta)busta, (RequestInfo)requestInfo, (org.openspcoop2.utils.Map)context, (Logger)this.log);
                joseSignature.process((MessageSecurityContext)messageSecurityContext, payload, (org.openspcoop2.utils.Map)context);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                payload.writeTo((OutputStream)bout, true);
                bout.flush();
                bout.close();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            String token = bout.toString();
            modiToken.setToken(token);
            if (audit02) {
                try {
                    String digestAlgorithm = this.modiProperties.getSecurityTokenAuditDigestAlgorithm();
                    String digestAuditValue = DigestUtils.getDigestValue((byte[])token.getBytes(), (String)digestAlgorithm, (DigestEncoding)DigestEncoding.HEX, (boolean)false);
                    modiToken.setDigestAlgorithm(digestAlgorithm);
                    modiToken.setDigest(digestAuditValue);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (cacheable) {
                GestoreToken.putTokenCacheItem((TokenCacheItem)modiToken, (String)keyCache, (String)funzioneCache, (Date)nowCacheDate, (String)cacheMetodoChiamante, (Integer)this.modiProperties.getGestioneRetrieveTokenRefreshTokenBeforeExpirePercent(), (Integer)this.modiProperties.getGestioneRetrieveTokenRefreshTokenBeforeExpireSeconds());
            }
        }
        if ("Authorization".equalsIgnoreCase(securityTokenHeader = headerTokenRest)) {
            msg.forceTransportHeader(securityTokenHeader, "Bearer " + modiToken.getToken());
        } else {
            msg.forceTransportHeader(securityTokenHeader, modiToken.getToken());
        }
        if (audit02) {
            try {
                context.put(ModICostanti.MODIPA_CONTEXT_AUDIT_DIGEST, (Object)modiToken.getDigest());
                context.put(ModICostanti.MODIPA_CONTEXT_AUDIT_DIGEST_ALGO, (Object)modiToken.getDigestAlgorithm());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        if (request && context != null) {
            SecurityToken securityTokenForContext = ModIUtilities.newSecurityToken(context);
            RestMessageSecurityToken restSecurityToken = new RestMessageSecurityToken();
            if (x509 != null) {
                restSecurityToken.setCertificate(new CertificateInfo(x509, securityTokenHeader));
            }
            if (kid != null) {
                restSecurityToken.setKid(kid);
            }
            restSecurityToken.setToken((Serializable)((Object)modiToken.getToken()));
            restSecurityToken.setHttpHeaderName(securityTokenHeader);
            if (tokenAudit) {
                securityTokenForContext.setAudit(restSecurityToken);
            } else if (headerDuplicati) {
                if (headerAuthentication) {
                    securityTokenForContext.setAuthorization(restSecurityToken);
                } else {
                    securityTokenForContext.setIntegrity(restSecurityToken);
                }
            } else if ("Authorization".equalsIgnoreCase(securityTokenHeader)) {
                securityTokenForContext.setAuthorization(restSecurityToken);
            } else {
                securityTokenForContext.setIntegrity(restSecurityToken);
            }
        }
        return modiToken;
    }

    private void addAudienceClaim(JSONUtils jsonUtils, ObjectNode payloadToken, String audience, StringBuilder sbAudience) throws ProtocolException {
        if (audience != null) {
            List<String> lArray = ModIUtilities.getArrayStringAsList(audience = audience.trim(), true);
            if (lArray != null && !lArray.isEmpty()) {
                ArrayNode values = null;
                try {
                    values = jsonUtils.newArrayNode();
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                sbAudience.append("[");
                for (int i = 0; i < lArray.size(); ++i) {
                    String v = lArray.get(i);
                    values.add(v);
                    if (i > 0) {
                        sbAudience.append(",");
                    }
                    sbAudience.append("\"").append(v).append("\"");
                }
                sbAudience.append("]");
                payloadToken.set("aud", (JsonNode)values);
                return;
            }
            payloadToken.put("aud", audience);
            sbAudience.append(audience);
        }
    }

    public static List<String> getHeaderValues(RuoloMessaggio ruoloMessaggio, OpenSPCoop2Message msg, Map<String, List<String>> mapForceTransportHeaders, String httpHeader) {
        List v;
        List values = null;
        if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) && msg.getTransportRequestContext() != null) {
            values = msg.getTransportRequestContext().getHeaderValues(httpHeader);
        } else if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && msg.getTransportResponseContext() != null) {
            values = msg.getTransportResponseContext().getHeaderValues(httpHeader);
        }
        if (mapForceTransportHeaders != null && !mapForceTransportHeaders.isEmpty() && (v = (List)TransportUtils.getRawObject(mapForceTransportHeaders, (String)httpHeader)) != null && !v.isEmpty()) {
            values = v;
        }
        return values;
    }

    private boolean addCorniceSicurezzaSchema(ModISecurityConfig securityConfig, Map<String, Object> dynamicMap, Context context, ObjectNode payloadToken, Busta busta, String corniceSicurezzaSchema, ModIJWTTokenClaims modiTokenClaims) throws ProtocolException {
        if (corniceSicurezzaSchema != null && StringUtils.isNotEmpty((CharSequence)corniceSicurezzaSchema)) {
            return this.addCorniceSicurezzaSchema(dynamicMap, context, payloadToken, busta, securityConfig.getCorniceSicurezzaSchemaConfig() != null ? securityConfig.getCorniceSicurezzaSchemaConfig().getClaims() : null, modiTokenClaims);
        }
        return false;
    }

    private boolean addCorniceSicurezzaSchema(Map<String, Object> dynamicMap, Context context, ObjectNode payloadToken, Busta busta, List<ModIAuditClaimConfig> schemas, ModIJWTTokenClaims modiTokenClaims) throws ProtocolException {
        if (schemas != null && !schemas.isEmpty()) {
            boolean cacheable = true;
            for (ModIAuditClaimConfig modIAuditClaimConfig : schemas) {
                boolean claimCacheable = this.addCorniceSicurezzaSchemaRule(dynamicMap, context, payloadToken, busta, modIAuditClaimConfig, modiTokenClaims);
                if (claimCacheable) continue;
                cacheable = false;
            }
            return cacheable;
        }
        return false;
    }

    private boolean addCorniceSicurezzaSchemaRule(Map<String, Object> dynamicMap, Context context, ObjectNode payloadToken, Busta busta, ModIAuditClaimConfig modIAuditClaimConfig, ModIJWTTokenClaims modiTokenClaims) throws ProtocolException {
        String headerTokenAudit = this.modiProperties.getSecurityTokenHeaderModIAudit();
        String prefix = "[Token '" + headerTokenAudit + "'] ";
        String claimName = modIAuditClaimConfig.getNome();
        ModIValidazioneAuditClaimValue valoreIntegrazione = null;
        try {
            List<String> claimRules = modIAuditClaimConfig.getRules();
            if (claimRules == null || claimRules.isEmpty()) {
                throw new ProtocolException("Rules not available for claim '" + claimName + "'");
            }
            valoreIntegrazione = this.readCorniceSicurezzaSchemaPayloadValue(dynamicMap, context, modIAuditClaimConfig, claimName, claimRules, prefix);
        }
        catch (Exception e) {
            if (modIAuditClaimConfig.isRequired()) {
                this.log.error(e.getMessage(), (Throwable)e);
                ProtocolException pe = new ProtocolException(e.getMessage());
                pe.setInteroperabilityError(true);
                throw pe;
            }
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        try {
            if (valoreIntegrazione != null) {
                valoreIntegrazione.validate(prefix);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            ProtocolException pe = new ProtocolException(e.getMessage());
            pe.setInteroperabilityError(true);
            throw pe;
        }
        try {
            if (valoreIntegrazione != null) {
                String valore = this.addCorniceSicurezzaSchemaPayload(payloadToken, claimName, valoreIntegrazione, modiTokenClaims);
                if (modIAuditClaimConfig.isTrace()) {
                    busta.addProperty("ProfiloSicurezzaMessaggioAudit-" + claimName, valore);
                }
                return modIAuditClaimConfig.isCacheable();
            }
            return !modIAuditClaimConfig.isRequired();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw new ProtocolException(e.getMessage());
        }
    }

    private ModIValidazioneAuditClaimValue readCorniceSicurezzaSchemaPayloadValue(Map<String, Object> dynamicMap, Context context, ModIAuditClaimConfig modIAuditClaimConfig, String claimName, List<String> rules, String prefix) throws ProtocolException {
        String valore = ModIUtilities.getDynamicValue("Informazioni Audit - " + modIAuditClaimConfig.getLabel(), rules, dynamicMap, context);
        return new ModIValidazioneAuditClaimValue(claimName, valore, modIAuditClaimConfig, prefix);
    }

    private String addCorniceSicurezzaSchemaPayload(ObjectNode payloadToken, String claimName, ModIValidazioneAuditClaimValue value, ModIJWTTokenClaims modiTokenClaims) {
        if (value.getRawObject() instanceof String) {
            String valore = (String)value.getRawObject();
            payloadToken.put(claimName, valore);
        } else if (value.getRawObject() instanceof Boolean) {
            boolean valore = (Boolean)value.getRawObject();
            payloadToken.put(claimName, valore);
        } else if (value.getRawObject() instanceof Double) {
            double valore = (Double)value.getRawObject();
            payloadToken.put(claimName, valore);
        } else if (value.getRawObject() instanceof Float) {
            float valore = ((Float)value.getRawObject()).floatValue();
            payloadToken.put(claimName, valore);
        } else if (value.getRawObject() instanceof Long) {
            long valore = (Long)value.getRawObject();
            payloadToken.put(claimName, valore);
        } else if (value.getRawObject() instanceof Integer) {
            int valore = (Integer)value.getRawObject();
            payloadToken.put(claimName, valore);
        }
        modiTokenClaims.addCorniceSicurezzaAudit(claimName, value.getValore());
        return value.getValore();
    }

    private boolean addCorniceSicurezzaLegacyCodiceEnte(ModISecurityConfig securityConfig, Map<String, Object> dynamicMap, Context context, ObjectNode payloadToken, Busta busta, ModIJWTTokenClaims modiTokenClaims) throws ProtocolException {
        boolean addIss = true;
        String claimNameCodiceEnte = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestCodiceEnte();
        if ("iss".equals(claimNameCodiceEnte)) {
            addIss = false;
        }
        String codiceEnte = null;
        try {
            codiceEnte = ModIUtilities.getDynamicValue("Informazioni Audit - Codice Ente", securityConfig.getCorniceSicurezzaCodiceEnteRule(), dynamicMap, context);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            ProtocolException pe = new ProtocolException(e.getMessage());
            pe.setInteroperabilityError(true);
            throw pe;
        }
        payloadToken.put(claimNameCodiceEnte, codiceEnte);
        busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-Ente", codiceEnte);
        modiTokenClaims.addCorniceSicurezzaAudit(claimNameCodiceEnte, codiceEnte);
        return addIss;
    }

    private boolean addCorniceSicurezzaLegacyUser(ModISecurityConfig securityConfig, Map<String, Object> dynamicMap, Context context, ObjectNode payloadToken, Busta busta, ModIJWTTokenClaims modiTokenClaims) throws ProtocolException {
        boolean addSub = true;
        String claimNameUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestUser();
        if ("sub".equals(claimNameUser)) {
            addSub = false;
        }
        String utente = null;
        try {
            utente = ModIUtilities.getDynamicValue("Informazioni Audit - UserID Utente", securityConfig.getCorniceSicurezzaUserRule(), dynamicMap, context);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            ProtocolException pe = new ProtocolException(e.getMessage());
            pe.setInteroperabilityError(true);
            throw pe;
        }
        payloadToken.put(claimNameUser, utente);
        busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-User", utente);
        modiTokenClaims.addCorniceSicurezzaAudit(claimNameUser, utente);
        return addSub;
    }

    private void addCorniceSicurezzaLegacyIpUser(ModISecurityConfig securityConfig, Map<String, Object> dynamicMap, Context context, ObjectNode payloadToken, Busta busta, ModIJWTTokenClaims modiTokenClaims) throws ProtocolException {
        String claimNameIpUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaRestIpuser();
        String indirizzoIpPostazione = null;
        try {
            indirizzoIpPostazione = ModIUtilities.getDynamicValue("Informazioni Audit - Indirizzo IP Utente", securityConfig.getCorniceSicurezzaIpUserRule(), dynamicMap, context);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            ProtocolException pe = new ProtocolException(e.getMessage());
            pe.setInteroperabilityError(true);
            throw pe;
        }
        payloadToken.put(claimNameIpUser, indirizzoIpPostazione);
        busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-UserIP", indirizzoIpPostazione);
        modiTokenClaims.addCorniceSicurezzaAudit(claimNameIpUser, indirizzoIpPostazione);
    }
}

