/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml2json.test;

import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;

public class JsonXmlPathExpressionEngineTest {
    public static void main(String[] args) throws Exception {
        JsonXmlPathExpressionEngineTest.test();
    }

    public static void test() throws Exception {
        Logger log = LoggerWrapperFactory.getLogger(JsonXmlPathExpressionEngineTest.class);
        String testJsonSemplice = "{prova:\"test1\",prova2:23}";
        System.out.println("======== TEST ==========");
        String pattern = "$.prova";
        JsonXmlPathExpressionEngine.validate(pattern, log);
        String v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonSemplice, pattern, log);
        if (v != null && !"".equals(v)) {
            if (!"test1".equals(v)) {
                throw new Exception("Test 'default' con namespace fallito; ritornato valore inatteso: " + v);
            }
        } else {
            throw new Exception("Test 'default' con namespace fallito");
        }
        System.out.println("Test 'default' con namespace completato con successo: " + v);
        pattern = "xpath /json2xml/prova/text()";
        JsonXmlPathExpressionEngine.validate(pattern, log);
        v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonSemplice, pattern, log);
        if (v != null && !"".equals(v)) {
            if (!"test1".equals(v)) {
                throw new Exception("Test 'default' con namespace fallito; ritornato valore inatteso: " + v);
            }
        } else {
            throw new Exception("Test 'default' con namespace fallito");
        }
        System.out.println("Test 'default' con namespace completato con successo: " + v);
        pattern = "xpath //prova/text()";
        JsonXmlPathExpressionEngine.validate(pattern, log);
        v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonSemplice, pattern, log);
        if (v != null && !"".equals(v)) {
            if (!"test1".equals(v)) {
                throw new Exception("Test 'default' con namespace fallito; ritornato valore inatteso: " + v);
            }
        } else {
            throw new Exception("Test 'default' con namespace fallito");
        }
        System.out.println("Test 'default' con namespace completato con successo: " + v);
        pattern = "xpath /json2xml/*";
        JsonXmlPathExpressionEngine.validate(pattern, log);
        v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonSemplice, pattern, log);
        if (v != null && !"".equals(v)) {
            if (!"<prova>test1</prova><prova2>23</prova2>".equals(v)) {
                throw new Exception("Test 'default' con namespace fallito; ritornato valore inatteso: " + v);
            }
        } else {
            throw new Exception("Test 'default' con namespace fallito");
        }
        System.out.println("Test 'default' con namespace completato con successo: " + v);
        pattern = "xpath local-name(/json2xml/*[last()])";
        JsonXmlPathExpressionEngine.validate(pattern, log);
        v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonSemplice, pattern, log);
        if (v != null && !"".equals(v)) {
            if (!"prova2".equals(v)) {
                throw new Exception("Test 'default' con namespace fallito; ritornato valore inatteso: " + v);
            }
        } else {
            throw new Exception("Test 'default' con namespace fallito");
        }
        System.out.println("Test 'default' con namespace completato con successo: " + v);
        System.out.println("======== TEST NAMESPACE ==========");
        String testJsonComplessoConNamespace = "{\n\"m:NomeAzioneTestRequest\":\n{\n\"bodyWithNS\" : \"true\",\n\"xmlns:m\": \"http://testNamespace\",\n\"prodotto\": {\n\"codice\":\"26\",\n\"altro:codice3\":\"34\",\n\"xmlns:altro\" : \"http://testNamespaceAltro\"\n}\n}\n}";
        pattern = "xpath namespace(m:http://testNamespace, altro:http://altro) substring-before(local-name(//json2xml/*),\"Request\")";
        JsonXmlPathExpressionEngine.validate(pattern, log);
        v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonComplessoConNamespace, pattern, log);
        if (v != null && !"".equals(v)) {
            if (!"NomeAzioneTest".equals(v)) {
                throw new Exception("Test 'default' con namespace fallito; ritornato valore inatteso: " + v);
            }
        } else {
            throw new Exception("Test con namespace fallito");
        }
        System.out.println("Test con namespace completato con successo: " + v);
        pattern = "xpath substring-before(local-name(//json2xml/*),\"Request\")";
        JsonXmlPathExpressionEngine.validate(pattern, log);
        try {
            v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonComplessoConNamespace, pattern, log);
            throw new Exception("Atteso eccezione");
        }
        catch (Exception e) {
            if (!e.getMessage().contains("The prefix \"m\" for element \"m:NomeAzioneTestRequest\" is not bound")) {
                throw e;
            }
            System.out.println("Test con namespace, senza dichiarazione dei namespace, completato con successo; riscontrato errore atteso");
            pattern = "xpath namespace(altro:http://altro) substring-before(local-name(//json2xml/*),\"Request\")";
            JsonXmlPathExpressionEngine.validate(pattern, log);
            try {
                v = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(testJsonComplessoConNamespace, pattern, log);
                throw new Exception("Atteso eccezione");
            }
            catch (Exception e2) {
                if (!e2.getMessage().contains("The prefix \"m\" for element \"m:NomeAzioneTestRequest\" is not bound")) {
                    throw e2;
                }
                System.out.println("Test con namespace, senza dichiarazione dei namespace, completato con successo; riscontrato errore atteso");
                pattern = "xpath namespace(altro:) substring-before(local-name(//json2xml/*),\"Request\")";
                try {
                    JsonXmlPathExpressionEngine.validate(pattern, log);
                    throw new Exception("Atteso eccezione");
                }
                catch (Exception e3) {
                    Object msgError = "Espressione '" + pattern + "' da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: attesa dichiarazione namespace. (altro:) (altro:)";
                    if (!e3.getMessage().contains((CharSequence)msgError)) {
                        throw e3;
                    }
                    System.out.println("Test validazione pattern errato, caso 1; riscontrato errore atteso");
                    pattern = "xpath namespace(sa) substring-before(local-name(//json2xml/*),\"Request\")";
                    try {
                        JsonXmlPathExpressionEngine.validate(pattern, log);
                        throw new Exception("Atteso eccezione");
                    }
                    catch (Exception e4) {
                        msgError = "Espressione '" + pattern + "' da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: atteso ':' separator. (sa) (sa)";
                        if (!e4.getMessage().contains((CharSequence)msgError)) {
                            throw e4;
                        }
                        System.out.println("Test validazione pattern errato, caso 2; riscontrato errore atteso");
                        pattern = "xpath dedee/";
                        try {
                            JsonXmlPathExpressionEngine.validate(pattern, log);
                            throw new Exception("Atteso eccezione");
                        }
                        catch (Exception e5) {
                            msgError = "Trasformazione json2xml 'Mapped' fallita: Validazione dell'xpath indicato [dedee/] fallita: Compilazione dell'espressione XPATH ha causato un errore (A location step was expected following the '/' or '//' token.)";
                            if (!e5.getMessage().contains((CharSequence)msgError)) {
                                throw e5;
                            }
                            System.out.println("Test validazione pattern errato, caso xpath 1; riscontrato errore atteso");
                            pattern = "xpath namespace(altro:http://altro) altro/TEXT()";
                            try {
                                JsonXmlPathExpressionEngine.validate(pattern, log);
                                throw new Exception("Atteso eccezione");
                            }
                            catch (Exception e6) {
                                msgError = "Trasformazione json2xml 'Mapped' fallita: Validazione dell'xpath indicato [altro/TEXT()] fallita: Compilazione dell'espressione XPATH ha causato un errore (Unknown nodetype: TEXT)";
                                if (!e6.getMessage().contains((CharSequence)msgError)) {
                                    throw e6;
                                }
                                System.out.println("Test validazione pattern errato, caso xpath 2; riscontrato errore atteso");
                                pattern = "$. DE$$";
                                try {
                                    JsonXmlPathExpressionEngine.validate(pattern, log);
                                    throw new Exception("Atteso eccezione");
                                }
                                catch (Exception e7) {
                                    msgError = "Validazione del jsonPath indicato [$. DE$$] fallita: Could not parse token starting at position 2";
                                    if (!e7.getMessage().contains((CharSequence)msgError)) {
                                        throw e7;
                                    }
                                    System.out.println("Test validazione pattern errato, caso jsonpath 1; riscontrato errore atteso");
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

