/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml2json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jettison.mapped.SimpleConverter;
import org.codehaus.jettison.mapped.TypeConverter;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.xml2json.AbstractMappedConverter;
import org.openspcoop2.utils.xml2json.IXml2Json;
import org.openspcoop2.utils.xml2json.MappedXml2Json;
import org.openspcoop2.utils.xml2json.Xml2JsonFactory;
import org.w3c.dom.Node;

public class Xml2JsonMappedConverter
extends AbstractMappedConverter {
    private boolean ignoreNamespaces = true;
    private boolean attributeAsElement = true;
    private boolean dropRootElement = true;
    private boolean convertAllValuesAsString = false;

    public void setIgnoreNamespaces(boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
    }

    public void setAttributeAsElement(boolean attributeAsElement) {
        this.attributeAsElement = attributeAsElement;
    }

    public void setDropRootElement(boolean dropRootElement) {
        this.dropRootElement = dropRootElement;
    }

    public void setConvertAllValuesAsString(boolean convertAllValuesAsString) {
        this.convertAllValuesAsString = convertAllValuesAsString;
    }

    public String convert(Node xml) throws UtilsException {
        String json = this.getXml2Json().xml2json(xml);
        return this._convert(json);
    }

    public String convert(String xml) throws UtilsException {
        String json = this.getXml2Json().xml2json(xml);
        return this._convert(json);
    }

    private IXml2Json getXml2Json() {
        IXml2Json xml2json = Xml2JsonFactory.getXml2JsonMapped();
        ((MappedXml2Json)xml2json).getConfiguration().setIgnoreNamespaces(this.ignoreNamespaces);
        ((MappedXml2Json)xml2json).getConfiguration().setSupressAtAttributes(this.attributeAsElement);
        ((MappedXml2Json)xml2json).getConfiguration().setDropRootElement(this.dropRootElement);
        if (this.convertAllValuesAsString) {
            ((MappedXml2Json)xml2json).getConfiguration().setTypeConverter((TypeConverter)new SimpleConverter());
        }
        return xml2json;
    }

    private String _convert(String json) throws UtilsException {
        JSONUtils utils = JSONUtils.getInstance(this.prettyPrint);
        JsonNode node = utils.getAsNode(json);
        List<String> arrays_renamed = this.arrays;
        List<String> reorderChildren_renamed = this.reorderChildren.keys();
        if (!this.renameFields.isEmpty()) {
            Iterator<String> keys = this.renameFields.keys();
            Collections.sort(keys, Comparator.reverseOrder());
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                String newName = (String)this.renameFields.get(path);
                boolean forceReorder = this.forceReorder;
                utils.renameFieldByPath(node, path, newName, forceReorder, false);
            }
            if (!arrays_renamed.isEmpty()) {
                arrays_renamed = this.correctPath("arrays", arrays_renamed);
            }
            if (!reorderChildren_renamed.isEmpty()) {
                reorderChildren_renamed = this.correctPath("reorder", reorderChildren_renamed);
            }
        }
        if (!arrays_renamed.isEmpty()) {
            for (String path : arrays_renamed) {
                utils.convertFieldToArrayByPath(node, path, this.forceReorder, false);
            }
        }
        if (!reorderChildren_renamed.isEmpty()) {
            for (String path : reorderChildren_renamed) {
                String[] children = (String[])this.reorderChildren.get(path);
                utils.reorderFieldChildrenByPath(node, path, false, children);
            }
        }
        if (this.camelCase) {
            boolean forceReorder = this.forceReorder;
            utils.renameFieldInCamelCase(node, this.camelCase_firstLower, forceReorder);
        }
        return utils.toString(node);
    }
}

