/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.xml.AbstractXMLDiff;
import org.openspcoop2.utils.xml.XMLDiff;
import org.openspcoop2.utils.xml.XMLDiffImplType;
import org.openspcoop2.utils.xml.XMLDiffOptions;

public class XMLDiffClientTest {
    private static final String XML_ORIGINAL = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<soapenv:Header xmlns:prova=\"http://prova.openspcoop2.org\">\n<a:example1 xmlns:a=\"http://www.openspcoop2.org\" soapenv:actor=\"http://www.prova.it\" soapenv:mustUnderstand=\"0\" >prova</a:example1>\n<b:example2 xmlns:b=\"http://www.openspcoop2.org\" soapenv:actor=\"http://www.prova.it\" soapenv:mustUnderstand=\"0\" >prova2</b:example2>\n</soapenv:Header>\n<soapenv:Body>\n\t<!-- PROVA -->\n\t<ns1:getQuote xmlns:ns1=\"urn:xmethods-delayed-quotes\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:se=\"http://schemas.xmlsoap.org/soap/envelope/\" se:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n\t\t<symbol a=\"1\" xsi:type=\"xsd:string\">VALORE</symbol>\n\n\n\t\t\t<prova2>CIAOCIAO</prova2>\n\t\t\t<altro><si>234</si></altro>\n\t\t\t<!-- Doppia commento -->\n\t</ns1:getQuote>\n\t<test/>\n\t<test2/>\n\t<tag1>\n\t\t<tag2>\n\t\t<![CDATA[  Some data ]]>\n\t\t</tag2>\n\t</tag1>\n</soapenv:Body>\n</soapenv:Envelope>\n";
    private static final String XML_COMPARE = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n<soapenv:Header xmlns:prova=\"http://prova.openspcoop2.org\">\n<a:example1 xmlns:a=\"http://www.openspcoop2.org\" soapenv:actor=\"http://www.prova.it\" soapenv:mustUnderstand=\"0\" >prova</a:example1>\n<b:example2 xmlns:b=\"http://www.openspcoop2.org\" soapenv:actor=\"http://www.prova.it\" soapenv:mustUnderstand=\"0\" >prova2</b:example2>\n</soapenv:Header>\n<soapenv:Body>\n\t<!-- PROVA -->\n\t<ns1:getQuote xmlns:ns1=\"urn:xmethods-delayed-quotes\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:se=\"http://schemas.xmlsoap.org/soap/envelope/\" se:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n\t\t<symbol xsi:type=\"xsd:string\" a=\"1\" >VALORE</symbol>\n\n\t\t\t<prova2>CIAOCIAO</prova2>\n\t\t\t<altro>\n\t\t\t\t<si>234</si>\n\t\t\t</altro>\n\n<!-- Doppia commento -->\n\t</ns1:getQuote>\n\t<test/>\n\t<test2/>\n\t\t<tag1><tag2>  Some data </tag2></tag1>\n</soapenv:Body>\n<!-- ALTRO commento -->\n</soapenv:Envelope>\n";
    private static final String XML_COMPARE_2 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<soapenv:Header xmlns:prova=\"http://prova.openspcoop2.org\">\n<a:example1 xmlns:a=\"http://www.openspcoop2.org\" soapenv:actor=\"http://www.prova.it\" soapenv:mustUnderstand=\"0\" >prova</a:example1>\n<b:example2 xmlns:b=\"http://www.openspcoop2.org\" soapenv:actor=\"http://www.prova.it\" soapenv:mustUnderstand=\"0\" >prova2</b:example2>\n</soapenv:Header>\n<soapenv:Body>\n\t<!-- PROVA -->\n\t<ns1:getQuote xmlns:ns1=\"urn:xmethods-delayed-quotes\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:se=\"http://schemas.xmlsoap.org/soap/envelope/\" se:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n\t\t<symbol xsi:type=\"xsd:string\" a=\"1\" >VALORE</symbol>\n\n\n\t\t\t<prova2>CIAOCIAO</prova2>\n\t\t\t<altro><si>234</si></altro>\n\t\t\t<!-- Doppia commento -->\n\t</ns1:getQuote>\n\t<test/>\n\t<test2/>\n\t<tag1>\n\t\t<tag2>\n\t\t  Some data \n\t\t</tag2>\n\t</tag1>\n</soapenv:Body><!-- ALTRO commento -->\n</soapenv:Envelope>\n";

    public static void main(String[] args) throws Exception {
        XMLDiffClientTest.test();
    }

    public static void test() throws Exception {
        File originalFile = File.createTempFile("src", ".xml");
        FileSystemUtilities.writeFile(originalFile, XML_ORIGINAL.getBytes());
        File compareFile = File.createTempFile("test", ".compare");
        FileSystemUtilities.writeFile(compareFile, XML_COMPARE.getBytes());
        XMLDiffOptions xmlDiffOptions = new XMLDiffOptions();
        XMLDiff xmlDiffEngine = new XMLDiff();
        xmlDiffEngine.initialize(XMLDiffImplType.XML_UNIT, xmlDiffOptions);
        XMLDiffClientTest.test(xmlDiffEngine, originalFile, compareFile, true);
        File compare2File = File.createTempFile("test", ".compare2");
        FileSystemUtilities.writeFile(compare2File, XML_COMPARE_2.getBytes());
        xmlDiffEngine.initialize(XMLDiffImplType.ORG_W3C_DOM_DOCUMENT, xmlDiffOptions);
        XMLDiffClientTest.test(xmlDiffEngine, originalFile, compare2File, false);
    }

    private static void test(XMLDiff xmlDiffEngine, File originalFile, File compareFile, boolean printDiff) throws Exception {
        System.out.println("\n\n\n*************** TESTSUITE **********************");
        System.out.println("========= AS DOCUMENT / DOCUMENT ==========");
        boolean result = xmlDiffEngine.diff(xmlDiffEngine.getXMLUtils().newDocument(originalFile), xmlDiffEngine.getXMLUtils().newDocument(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS ELEMENT / ELEMENT ===========");
        result = xmlDiffEngine.diff(xmlDiffEngine.getXMLUtils().newElement(originalFile), xmlDiffEngine.getXMLUtils().newElement(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS NODE / NODE ===========");
        result = xmlDiffEngine.diff(xmlDiffEngine.getXMLUtils().newDocument(originalFile).getDocumentElement().getLastChild(), xmlDiffEngine.getXMLUtils().newDocument(compareFile).getDocumentElement().getLastChild());
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS FILE / FILE ===========");
        result = xmlDiffEngine.diff(originalFile, compareFile);
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS INPUT STREAM  / INPUT STREAM ===========");
        result = xmlDiffEngine.diff(new FileInputStream(originalFile), new FileInputStream(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS FILE / INPUT STREAM ===========");
        result = xmlDiffEngine.diff((Object)originalFile, (Object)new FileInputStream(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS INPUT STREAM / FILE ===========");
        result = xmlDiffEngine.diff((Object)new FileInputStream(originalFile), (Object)compareFile);
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS READER / READER ===========");
        result = xmlDiffEngine.diff(new FileReader(originalFile), new FileReader(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS STRING / STRING ===========");
        result = xmlDiffEngine.diff(FileSystemUtilities.readFile(originalFile), FileSystemUtilities.readFile(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS READER / STRING ===========");
        result = xmlDiffEngine.diff((Object)new FileReader(originalFile), (Object)FileSystemUtilities.readFile(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS STRING / READER ===========");
        result = xmlDiffEngine.diff((Object)FileSystemUtilities.readFile(originalFile), (Object)new FileReader(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS STRING / DOCUMENT ===========");
        result = xmlDiffEngine.diff((Object)FileSystemUtilities.readFile(originalFile), (Object)xmlDiffEngine.getXMLUtils().newDocument(compareFile));
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("======== AS INPUT STREAM / NODE ===========");
        result = xmlDiffEngine.diff((Object)new FileInputStream(originalFile), (Object)xmlDiffEngine.getXMLUtils().newDocument(compareFile).getDocumentElement().getLastChild());
        if (result) {
            System.out.println("OK");
        } else if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
            System.out.println("ERRORE Differenze non attese: " + xmlDiffEngine.getDifferenceDetails());
        } else {
            System.out.println("ERRORE Differenze non attese");
        }
        System.out.println("\n\n\n*************** TESTSUITE CASI ERRATI **********************");
        File compareErrato = File.createTempFile("compareErrato", ".xml");
        FileSystemUtilities.writeFile(compareErrato, XML_COMPARE.replace(" a=", " b=\"3\" a=").getBytes());
        result = xmlDiffEngine.diff(originalFile, compareErrato);
        if (!result) {
            if (XMLDiffImplType.XML_UNIT.equals((Object)AbstractXMLDiff.getImplType())) {
                System.out.println("Trovate differenze come previsto dal test: ");
                System.out.println(xmlDiffEngine.getDifferenceDetails());
            } else {
                System.out.println("Trovate differenze come previsto dal test");
            }
        } else {
            System.out.println("ERRORE: era previsto di trovare differenze, ma non ne sono state trovate");
        }
    }
}

