/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JaxbUtils {
    private static Map<String, JAXBContext> mapJAXBContext = new ConcurrentHashMap<String, JAXBContext>();

    private static synchronized void initJAXBContext(String packageName) throws JAXBException {
        if (!mapJAXBContext.containsKey(packageName)) {
            mapJAXBContext.put(packageName, JAXBContext.newInstance((String)packageName));
        }
    }

    private static JAXBContext getJAXBContext(String packageName) throws JAXBException {
        if (!mapJAXBContext.containsKey(packageName)) {
            JaxbUtils.initJAXBContext(packageName);
        }
        return mapJAXBContext.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object xmlToObj(String xmlFileName, Class<?> classType) throws FileNotFoundException, JAXBException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Unmarshaller uctx = jc.createUnmarshaller();
        FileInputStream fis = new FileInputStream(xmlFileName);
        Object objectRead = null;
        try {
            objectRead = uctx.unmarshal((InputStream)fis);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        if (objectRead instanceof JAXBElement) {
            return ((JAXBElement)objectRead).getValue();
        }
        return objectRead;
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object) throws FileNotFoundException, JAXBException {
        JaxbUtils.objToXml(xmlFileName, classType, object, false);
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object, boolean prettyDocument) throws FileNotFoundException, JAXBException {
        File file = new File(xmlFileName);
        if (!file.exists() || !file.delete()) {
            // empty if block
        }
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Marshaller uctx = jc.createMarshaller();
        if (prettyDocument) {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        } else {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        }
        uctx.marshal(object, file);
    }

    public static void objToXml(String xmlFileName, byte[] object) throws FileNotFoundException, IOException {
        File file = new File(xmlFileName);
        if (!file.exists() || !file.delete()) {
            // empty if block
        }
        FileOutputStream fileOut = new FileOutputStream(xmlFileName);
        try {
            fileOut.write(object);
            fileOut.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fileOut.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object xmlToObj(InputStream i, Class<?> classType) throws FileNotFoundException, JAXBException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Unmarshaller uctx = jc.createUnmarshaller();
        Object objectRead = null;
        try {
            objectRead = uctx.unmarshal(i);
        }
        finally {
            try {
                i.close();
            }
            catch (Exception exception) {}
        }
        if (objectRead instanceof JAXBElement) {
            return ((JAXBElement)objectRead).getValue();
        }
        return objectRead;
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object) throws FileNotFoundException, JAXBException {
        JaxbUtils.objToXml(out, classType, object, false);
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object, boolean prettyDocument) throws FileNotFoundException, JAXBException {
        JaxbUtils.objToXml(out, classType, object, prettyDocument, false);
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object, boolean prettyDocument, boolean omitXmlDeclaration) throws FileNotFoundException, JAXBException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Marshaller uctx = jc.createMarshaller();
        if (prettyDocument) {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        } else {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        }
        if (omitXmlDeclaration) {
            uctx.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        uctx.marshal(object, out);
    }
}

