/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xacml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.api.PDP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.context.RequestMarshaller;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResponseType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.EvaluatableID;
import org.herasaf.xacml.core.policy.PolicyMarshaller;
import org.herasaf.xacml.core.policy.impl.EvaluatableIDImpl;
import org.herasaf.xacml.core.policy.impl.PolicyType;
import org.herasaf.xacml.core.simplePDP.MapBasedSimplePolicyRepository;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.SimplePDPFactory;
import org.herasaf.xacml.core.simplePDP.initializers.InitializerExecutor;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.xacml.CachedMapBasedSimplePolicyRepository;
import org.openspcoop2.utils.xacml.PolicyException;
import org.openspcoop2.utils.xacml.XacmlRequest;
import org.slf4j.Logger;

public class PolicyDecisionPoint {
    private static final String SINGLE = "SINGLE";
    private Map<String, PDP> pdp;
    private boolean singlePDP;
    private Logger log;

    public static void runInitializers() {
        InitializerExecutor.runInitializers();
    }

    public PolicyDecisionPoint() throws PolicyException {
        this(LoggerWrapperFactory.getLogger(PolicyDecisionPoint.class));
    }

    public PolicyDecisionPoint(Logger log) throws PolicyException {
        this(log, true);
    }

    public PolicyDecisionPoint(boolean singlePDP) throws PolicyException {
        this(LoggerWrapperFactory.getLogger(PolicyDecisionPoint.class), singlePDP);
    }

    public PolicyDecisionPoint(Logger log, boolean singlePDP) throws PolicyException {
        PolicyDecisionPoint.runInitializers();
        this.singlePDP = singlePDP;
        this.pdp = new HashMap<String, PDP>();
        this.log = log;
        if (singlePDP) {
            this.pdp.put(SINGLE, this.newPDP());
        }
    }

    private PDP newPDP() throws PolicyException {
        SimplePDPConfiguration configuration = new SimplePDPConfiguration();
        CachedMapBasedSimplePolicyRepository policyRetrievalPoint = new CachedMapBasedSimplePolicyRepository(this.log);
        configuration.setPolicyRetrievalPoint((PolicyRetrievalPoint)policyRetrievalPoint);
        return SimplePDPFactory.getSimplePDP((SimplePDPConfiguration)configuration);
    }

    public List<ResultType> evaluate(String requestString) throws PolicyException {
        RequestType request;
        try {
            request = PolicyDecisionPoint._unmarshalRequest(requestString);
        }
        catch (SyntaxException e) {
            throw new PolicyException((Exception)((Object)e));
        }
        return this._evaluate(request);
    }

    public List<ResultType> evaluate(XacmlRequest request) throws PolicyException {
        return this.evaluate(request.getXacmlRequest());
    }

    public List<ResultType> evaluate(RequestType request) throws PolicyException {
        return this._evaluate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestType _unmarshalRequest(String requestString) throws PolicyException, SyntaxException {
        ByteArrayInputStream bais = null;
        try {
            InitializerExecutor.runInitializers();
            bais = new ByteArrayInputStream(requestString.getBytes());
            RequestType requestType = RequestMarshaller.unmarshal((InputStream)bais);
            return requestType;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isValidRequest(String requestString) throws PolicyException {
        try {
            PolicyDecisionPoint._unmarshalRequest(requestString);
        }
        catch (SyntaxException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Evaluatable _unmarshalPolicy(String policyString) throws PolicyException, SyntaxException {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(policyString.getBytes());
            InitializerExecutor.runInitializers();
            Evaluatable evaluatable = PolicyMarshaller.unmarshal((InputStream)bais);
            return evaluatable;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addPolicy(Evaluatable eval, String key) throws PolicyException {
        this._addPolicy(eval, key);
    }

    public void addPolicy(String policyString, String key) throws PolicyException {
        try {
            Evaluatable eval = PolicyDecisionPoint._unmarshalPolicy(policyString);
            ((PolicyType)eval).setPolicyId((EvaluatableID)new EvaluatableIDImpl(key));
            this._addPolicy(eval, key);
        }
        catch (SyntaxException e) {
            throw new PolicyException((Exception)((Object)e));
        }
    }

    private void _addPolicy(Evaluatable eval, String key) throws PolicyException {
        EvaluatableIDImpl policyId = new EvaluatableIDImpl(key);
        ((PolicyType)eval).setPolicyId((EvaluatableID)policyId);
        if (this.singlePDP) {
            PDP pdp = this.getPDP(SINGLE);
            MapBasedSimplePolicyRepository repo = (MapBasedSimplePolicyRepository)pdp.getPolicyRepository();
            repo.deploy(eval);
        } else {
            PDP newPDP = this.newPDP();
            MapBasedSimplePolicyRepository repo = (MapBasedSimplePolicyRepository)newPDP.getPolicyRepository();
            repo.deploy(eval);
            this.pdp.put(key, newPDP);
        }
    }

    private List<ResultType> _evaluate(RequestType request) throws PolicyException {
        PDP pdp = this.singlePDP ? this.getPDP(SINGLE) : this.getPDP(request);
        ResponseType response = pdp.evaluate(request);
        return response.getResults();
    }

    private PDP getPDP(RequestType request) throws PolicyException {
        if (request == null) {
            throw new PolicyException("request non puo essere null");
        }
        if (request.getAction() == null) {
            throw new PolicyException("request.action non puo essere null");
        }
        if (request.getAction().getAttributes() == null || request.getAction().getAttributes().isEmpty()) {
            throw new PolicyException("request.action.attributes non puo essere null o vuoto");
        }
        if (((AttributeType)request.getAction().getAttributes().get(0)).getAttributeValues() == null || ((AttributeType)request.getAction().getAttributes().get(0)).getAttributeValues().isEmpty()) {
            throw new PolicyException("request.action.attributes[0].attributeValues non puo essere null o vuoto");
        }
        if (((AttributeValueType)((AttributeType)request.getAction().getAttributes().get(0)).getAttributeValues().get(0)).getContent() == null || ((AttributeValueType)((AttributeType)request.getAction().getAttributes().get(0)).getAttributeValues().get(0)).getContent().isEmpty()) {
            throw new PolicyException("request.action.attributes[0].attributeValues[0].content non puo essere null o vuoto");
        }
        String key = (String)((AttributeValueType)((AttributeType)request.getAction().getAttributes().get(0)).getAttributeValues().get(0)).getContent().get(0);
        return this.pdp.get(key);
    }

    private PDP getPDP(String key) {
        return this.pdp.get(key);
    }
}

