/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.ldap.test;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.NormalizingComparator;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.loader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.factory.JdbmPartitionFactory;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.springframework.core.io.Resource;

public class LdapServerTest {
    private LdapServer server;
    private String host = "127.0.0.1";
    private int port = 9321;
    private Resource ldif;
    private File workingDirector;
    private String rootPartition = "dc=example,dc=com";

    public LdapServerTest(Resource ldif) {
        this.ldif = ldif;
    }

    public LdapServerTest(Resource ldif, Level level) throws IOException, UtilsException {
        this.ldif = ldif;
        String propertiesLog = "logger.apacheds.name = org.apache.directory.server\nlogger.apacheds.level=" + level.name() + "\nlogger.apacheds.additivity = false";
        Properties p = new Properties();
        p.load(new StringReader(propertiesLog));
        LoggerWrapperFactory.setLogConfiguration(p);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRootPartition(String rootPartition) {
        this.rootPartition = rootPartition;
    }

    public void start(String path) throws Exception {
        this.start(path, false);
    }

    public void start(String path, boolean allowAnonymousAccess) throws Exception {
        DefaultDirectoryService directoryService = new DefaultDirectoryService();
        this.workingDirector = new File(path);
        FileSystemUtilities.mkdir(this.workingDirector);
        InstanceLayout instanceLayout = new InstanceLayout(this.workingDirector);
        directoryService.setInstanceLayout(instanceLayout);
        File schemaRepository = new File(this.workingDirector, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(this.workingDirector);
        try {
            extractor.extractOrCopy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        schemaManager.loadAllEnabled();
        ComparatorRegistry comparatorRegistry = schemaManager.getComparatorRegistry();
        for (LdapComparator comparator : comparatorRegistry) {
            if (!(comparator instanceof NormalizingComparator)) continue;
            ((NormalizingComparator)comparator).setOnServer();
        }
        directoryService.setSchemaManager((SchemaManager)schemaManager);
        LdifPartition ldifPartition = new LdifPartition((SchemaManager)schemaManager, directoryService.getDnFactory());
        ldifPartition.setPartitionPath(new File(this.workingDirector, "schema").toURI());
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        directoryService.setSchemaPartition(schemaPartition);
        LdifPartition userPartition = new LdifPartition((SchemaManager)schemaManager, directoryService.getDnFactory());
        userPartition.setPartitionPath(new File(this.workingDirector, "user").toURI());
        userPartition.setSuffixDn(new Dn(new String[]{this.rootPartition}));
        directoryService.addPartition((Partition)userPartition);
        JdbmPartitionFactory partitionFactory = new JdbmPartitionFactory();
        JdbmPartition systemPartition = partitionFactory.createPartition(directoryService.getSchemaManager(), directoryService.getDnFactory(), "system", "ou=system", 500, new File(directoryService.getInstanceLayout().getPartitionsDirectory(), "system"));
        systemPartition.setSchemaManager(directoryService.getSchemaManager());
        partitionFactory.addIndex((Partition)systemPartition, "objectClass", 100);
        directoryService.setSystemPartition((Partition)systemPartition);
        this.server = new LdapServer();
        this.server.setDirectoryService((DirectoryService)directoryService);
        this.server.setServiceName("DefaultLDAP");
        TcpTransport tcp = new TcpTransport(this.host, this.port, 1, 5);
        this.server.addTransports(new Transport[]{tcp});
        if (allowAnonymousAccess) {
            directoryService.setAllowAnonymousAccess(true);
        }
        directoryService.startup();
        LdifFileLoader ldifLoader = new LdifFileLoader(directoryService.getAdminSession(), this.ldif.getFile().getPath());
        ldifLoader.execute();
        this.server.start();
    }

    public void shutdown(boolean dropWorkingDirectory) {
        if (this.server.isStarted()) {
            this.server.stop();
        }
        for (int index = 0; this.server.isStarted() && index < 1000; ++index) {
            Utilities.sleep(100L);
        }
        if (dropWorkingDirectory) {
            FileSystemUtilities.deleteDirNotEmpty(this.workingDirector, 10);
            FileSystemUtilities.deleteDir(this.workingDirector);
        }
    }

    public String getURL() {
        return "ldap://" + this.host + ":" + this.port;
    }
}

