/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.ldap;

import java.net.URI;
import java.util.List;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.openspcoop2.utils.transport.ldap.LdapClientInterface;
import org.openspcoop2.utils.transport.ldap.LdapQuery;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.query.LdapQueryBuilder;

public class LdapSpringClient
implements LdapClientInterface {
    private LdapContextSource context = new LdapContextSource();
    private LdapTemplate template = new LdapTemplate();

    public LdapSpringClient() {
        this.template.setContextSource(null);
    }

    private LdapTemplate getTemplate() {
        if (this.template.getContextSource() == null) {
            this.context.afterPropertiesSet();
            this.template.setContextSource((ContextSource)this.context);
        }
        return this.template;
    }

    @Override
    public List<Attributes> search(LdapQuery query) {
        LdapTemplate ldapTemplate = this.getTemplate();
        LdapQueryBuilder queryBuilder = LdapQueryBuilder.query();
        if (query.getLimit() != null) {
            queryBuilder.countLimit(query.getLimit().intValue());
        }
        if (!query.getAttributes().isEmpty()) {
            queryBuilder.attributes(query.getAttributes().toArray(new String[0]));
        }
        if (query.getBase() != null) {
            queryBuilder.base((Name)query.getBase());
        }
        return ldapTemplate.search(queryBuilder.filter(query.getFilter().toString()), attrs -> attrs);
    }

    @Override
    public LdapClientInterface base(LdapName base) {
        this.context.setBase(base.toString());
        return this;
    }

    @Override
    public LdapClientInterface uri(URI uri) {
        this.context.setUrl(uri.toString());
        return this;
    }

    @Override
    public LdapClientInterface username(LdapName username) {
        this.context.setUserDn(username.toString());
        return this;
    }

    @Override
    public LdapClientInterface password(String password) {
        this.context.setPassword(password);
        return this;
    }
}

