/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;

class XPoweredByResponseProxy
extends HttpServletResponseWrapper {
    private final HttpServletResponse response;
    private String value;

    public XPoweredByResponseProxy(HttpServletResponse resp, String value) {
        super(resp);
        this.response = resp;
        this.value = value;
    }

    public void sendError(int sc) throws IOException {
        this.setXPoweredBy();
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setXPoweredBy();
        super.sendError(sc, msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.setXPoweredBy();
        super.sendRedirect(location);
    }

    public PrintWriter getWriter() throws IOException {
        this.setXPoweredBy();
        return super.getWriter();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.setXPoweredBy();
        return super.getOutputStream();
    }

    private void setXPoweredBy() {
        this.response.setHeader("X-Powered-By", this.value);
    }
}

