/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.lang3.NotImplementedException;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.transport.Credential;
import org.slf4j.Logger;

public class HttpServletCredential
extends Credential
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_REQUEST_X509CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    private transient HttpServletRequest httpServletRequest;

    public HttpServletCredential() {
    }

    public HttpServletCredential(HttpServletRequest req, Logger log) {
        this(req, log, false);
    }

    public HttpServletCredential(HttpServletRequest req, Logger log, boolean debug) {
        X509Certificate[] certs;
        this.httpServletRequest = req;
        String auth = req.getHeader("Authorization");
        if (auth != null && auth.toLowerCase().startsWith("Basic ".toLowerCase())) {
            String cValue = auth.substring("Basic ".length());
            String decodeAuth = null;
            try {
                decodeAuth = new String(Base64Utilities.decode(cValue));
            }
            catch (Throwable e) {
                log.error("Password non estraibile dalla stringa ricevuta '" + cValue + "', decodifica base-64 non riuscita: " + e.getMessage(), e);
            }
            if (decodeAuth != null) {
                String[] decodeAuthSplit = decodeAuth.split(":");
                if (decodeAuthSplit.length > 1) {
                    this.username = decodeAuthSplit[0];
                    try {
                        this.password = decodeAuth.substring(decodeAuth.indexOf(":") + 1, decodeAuth.length());
                    }
                    catch (Throwable e) {
                        log.error("Password non estraibile dalla stringa ricevuta '" + decodeAuth + "'");
                    }
                }
                if (debug && log != null) {
                    log.info("BasicAuthentication presente nella richiesta, username [" + this.username + "] e password [" + this.password + "]");
                }
            }
        }
        if (auth != null && auth.toLowerCase().startsWith("Bearer ".toLowerCase())) {
            this.bearerToken = auth.substring("Bearer ".length());
        }
        if ((certs = (X509Certificate[])req.getAttribute(SERVLET_REQUEST_X509CERTIFICATE)) != null) {
            if (debug && log != null) {
                try {
                    StringBuilder bf = new StringBuilder();
                    CertificateUtils.printCertificate(bf, certs);
                    log.info(bf.toString());
                }
                catch (Throwable e) {
                    log.error("Print info certs error: " + e.getMessage(), e);
                }
            }
            if (certs.length > 0) {
                this.subject = certs[0].getSubjectX500Principal().toString();
                this.issuer = certs[0].getIssuerX500Principal().toString();
                ArrayList<X509Certificate> chains = new ArrayList<X509Certificate>();
                if (certs.length > 1) {
                    for (int i = 1; i < certs.length; ++i) {
                        chains.add(certs[i]);
                    }
                }
                this.certificate = new Certificate("transport", certs[0], chains);
            }
        } else if (debug && log != null) {
            log.info("Certificati non presenti nella richiesta");
        }
        if (req.getUserPrincipal() != null) {
            this.principal = req.getUserPrincipal();
            this.principalName = this.principal.getName();
        }
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this.httpServletRequest != null) {
            return this.httpServletRequest.isUserInRole(role);
        }
        throw new NotImplementedException();
    }

    @Override
    public Object getAttribute(String attributeName) {
        if (this.httpServletRequest != null) {
            return this.httpServletRequest.getAttribute(attributeName);
        }
        throw new NotImplementedException();
    }
}

