/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpRequest;

public class HttpRequestConfig {
    private final PropertiesReader props;
    private final Function<String, String> propSupplier;
    private String prefix;
    private static final String PROP_URL = "baseUrl";
    private static final String PROP_LIBRARY = "httpLibrary";
    private static final String PROP_READ_TIMEOUT = "readTimeout";
    private static final String PROP_CONNECTION_TIMEOUT = "connectTimeout";
    private static final String PROP_HTTP_USERNAME = "http.username";
    private static final String PROP_HTTP_PASSWORD = "http.password";
    private static final String PROP_HTTP_QUERY = "http.queryParameters";
    private static final String PROP_HTTP_HEADER = "http.headers";
    private static final String PROP_HTTPS_HOSTNAME_VERIFIER = "https.hostnameVerifier";
    private static final String PROP_HTTPS_TRUST_ALL_CERTS = "https.trustAllCerts";
    private static final String PROP_HTTPS_TRUSTSTORE = "https.trustStore";
    private static final String PROP_HTTPS_TRUSTSTORE_PASSWORD = "https.trustStore.password";
    private static final String PROP_HTTPS_TRUSTSTORE_TYPE = "https.trustStore.type";
    private static final String PROP_HTTPS_CRL = "https.trustStore.crl";
    private static final String PROP_HTTPS_KEYSTORE = "https.keyStore";
    private static final String PROP_HTTPS_KEYSTORE_PASSWORD = "https.keyStore.password";
    private static final String PROP_HTTPS_KEYSTORE_TYPE = "https.keyStore.type";
    private static final String PROP_HTTPS_KEY_ALIAS = "https.key.alias";
    private static final String PROP_HTTPS_KEY_PASSWORD = "https.key.password";

    public HttpRequestConfig(String prefix, PropertiesReader props) {
        this.prefix = prefix;
        this.props = props;
        this.propSupplier = null;
    }

    public HttpRequestConfig(String prefix, UnaryOperator<String> props) {
        this.prefix = prefix;
        this.props = null;
        this.propSupplier = props;
    }

    private String getProperty(String code, String key) {
        return this.getProperty(code, key, true);
    }

    private String getProperty(String code, String baseKey, boolean searchDefault) {
        String value = null;
        String key = code == null ? this.prefix + "." + baseKey : this.prefix + "." + code + "." + baseKey;
        if (this.props != null) {
            try {
                value = this.props.getValue(key);
            }
            catch (UtilsException e) {
                value = null;
            }
        }
        if (this.propSupplier != null) {
            value = this.propSupplier.apply(key);
        }
        if (!searchDefault || value != null) {
            return value;
        }
        return this.getProperty(null, baseKey, false);
    }

    private void fillHttpProperties(HttpRequest req, String code) {
        req.setUsername(this.getProperty(code, PROP_HTTP_USERNAME));
        req.setPassword(this.getProperty(code, PROP_HTTP_PASSWORD));
    }

    private void fillHttpsProperties(HttpRequest req, String code) {
        String trustAllCerts;
        String hostnameVerifier = this.getProperty(code, PROP_HTTPS_HOSTNAME_VERIFIER);
        if (hostnameVerifier != null) {
            req.setHostnameVerifier(Boolean.valueOf(hostnameVerifier));
        }
        if ((trustAllCerts = this.getProperty(code, PROP_HTTPS_TRUST_ALL_CERTS)) != null) {
            req.setTrustAllCerts(Boolean.valueOf(trustAllCerts));
        }
        req.setTrustStorePath(this.getProperty(code, PROP_HTTPS_TRUSTSTORE));
        req.setTrustStorePassword(this.getProperty(code, PROP_HTTPS_TRUSTSTORE_PASSWORD));
        req.setTrustStoreType(this.getProperty(code, PROP_HTTPS_TRUSTSTORE_TYPE));
        req.setCrlPath(this.getProperty(code, PROP_HTTPS_CRL));
        req.setKeyStorePath(this.getProperty(code, PROP_HTTPS_KEYSTORE));
        req.setKeyStorePassword(this.getProperty(code, PROP_HTTPS_KEYSTORE_PASSWORD));
        req.setKeyStoreType(this.getProperty(code, PROP_HTTPS_KEYSTORE_TYPE));
        req.setKeyAlias(this.getProperty(code, PROP_HTTPS_KEY_ALIAS));
        req.setKeyPassword(this.getProperty(code, PROP_HTTPS_KEY_PASSWORD));
    }

    public HttpRequest getBaseRequest() {
        return this.getBaseRequest(null);
    }

    public HttpRequest getBaseRequest(String code) {
        String libName;
        String headers;
        String readTimeout;
        HttpRequest req = new HttpRequest();
        req.setUrl(this.getProperty(code, PROP_URL));
        String connectTimeout = this.getProperty(code, PROP_CONNECTION_TIMEOUT);
        if (!"false".equals(connectTimeout)) {
            req.setConnectTimeout(Integer.valueOf(connectTimeout));
        }
        if (!"false".equals(readTimeout = this.getProperty(code, PROP_READ_TIMEOUT))) {
            req.setReadTimeout(Integer.valueOf(readTimeout));
        }
        this.fillHttpProperties(req, code);
        this.fillHttpsProperties(req, code);
        String queryParameters = this.getProperty(code, PROP_HTTP_QUERY);
        if (queryParameters != null) {
            Arrays.stream(queryParameters.split(";")).map(str -> str.split(":")).forEach(arr -> req.addParam(arr[0], arr[1]));
        }
        if ((headers = this.getProperty(code, PROP_HTTP_HEADER)) != null) {
            Arrays.stream(headers.split(";")).map(str -> str.split(":")).forEach(arr -> req.addHeader(arr[0], arr[1]));
        }
        if ((libName = this.getProperty(code, PROP_LIBRARY)) != null) {
            req.setHttpLibrary(HttpLibrary.fromName(libName));
        }
        return req;
    }
}

