/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql.test;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.sql.Case;
import org.openspcoop2.utils.sql.CastColumnType;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class ClientTest {
    private static boolean systemOut = true;
    private static int ROW = 21;
    private static Logger log = null;
    private static String PRIMA_COLONNA = "Prima colonna valorizzata";
    private static String ULTIMA_COLONNA = "Ultima colonna valorizzata";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String driverJdbcCustom;
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        File logFile = File.createTempFile("runSQLQueryObjectTest_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%m %n");
        log = LoggerWrapperFactory.getLogger(ClientTest.class);
        DateManager.initializeDataManager(SystemDate.class.getName(), new Properties(), log);
        TipiDatabase tipoDatabase = null;
        if (args.length > 0 && !"${tipoDatabase}".equals(args[0].trim())) {
            tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        }
        if (tipoDatabase == null) {
            throw new Exception("TipoDatabase non fornito");
        }
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        switch (tipoDatabase) {
            case POSTGRESQL: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case MYSQL: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case ORACLE: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case HSQL: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case DERBY: {
                url = "jdbc:derby:sample";
                driver = "org.apache.derby.jdbc.EmbeddedDriver";
                userName = "";
                password = "";
                break;
            }
            case SQLSERVER: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case DB2: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        if (args.length > 4 && !"${driverJdbc}".equals(driverJdbcCustom = args[4].trim())) {
            driver = driverJdbcCustom;
        }
        System.out.println("URL:" + url);
        System.out.println("UserName:" + userName);
        System.out.println("Password:" + password);
        System.out.println("DriverJDBC:" + driver);
        ClassLoaderUtilities.newInstance(driver);
        Connection con = null;
        Statement stmtDelete = null;
        Statement stmtInsert = null;
        try {
            long increment;
            int index;
            String campoVuoto;
            Object descrizione;
            int i;
            con = DriverManager.getConnection(url, userName, password);
            String caratteriStraniParte1 = "- { ( [ _ % ^ \\ / # | & \u00e0 \u00e8 @ . : ; , < parolaCasualeMAIUSCOLA > \u00e9 \u00f9 \u00ec ^ \" ' ? ! ] ) } -";
            String caratteriStraniParte2 = "\n \t \r \b Un  po di parole Maiuscole Minuscole \u00a7 \u00b0 \u00e7 \u00a3";
            String rigaCaratteriStrani = "------" + caratteriStraniParte1 + "-----" + caratteriStraniParte2 + "-----";
            String delete = "delete from msgdiagnostici";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            stmtDelete.close();
            delete = "delete from tracce";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            stmtDelete.close();
            Object rigaCompletaCaratteriStrani = null;
            for (i = 0; i < ROW; ++i) {
                String insertMsgDiagnosticoWithGdo = "INSERT INTO msgdiagnostici (descrizione,gdo,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?,?)";
                String insertMsgDiagnosticoWithoutGdo = "INSERT INTO msgdiagnostici (descrizione,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?)";
                descrizione = "descrizione esempio " + i;
                if (i > 9) {
                    descrizione = "descrizione esempio uguale";
                }
                if (i == 20) {
                    rigaCompletaCaratteriStrani = descrizione = "descrizione con caratteri particolari: " + rigaCaratteriStrani;
                }
                campoVuoto = null;
                if (i == 0) {
                    campoVuoto = PRIMA_COLONNA;
                }
                if (i > 10) {
                    campoVuoto = "";
                }
                if (i == ROW - 1) {
                    campoVuoto = ULTIMA_COLONNA;
                }
                stmtInsert = i % 2 == 0 ? con.prepareStatement(insertMsgDiagnosticoWithGdo) : con.prepareStatement(insertMsgDiagnosticoWithoutGdo);
                index = 1;
                stmtInsert.setString(index++, (String)descrizione);
                if (i % 2 == 0) {
                    stmtInsert.setTimestamp(index++, DateManager.getTimestamp());
                    increment = 10368000000L * (long)(i + 1);
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + increment + (long)(200101 * (i + 1))));
                } else {
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + (long)(23 * (i + 1))));
                }
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoMittente" + i / 2);
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoDestinatario" + i / 2);
                stmtInsert.setString(index++, campoVuoto);
                stmtInsert.execute();
                stmtInsert.close();
            }
            for (i = 0; i < ROW; ++i) {
                String insertTracciaWithGdo = "INSERT INTO tracce (descrizione,gdo,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?,?)";
                String insertTracciaWithoutGdo = "INSERT INTO tracce (descrizione,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario,campo_vuoto) VALUES (?,?,?,?,?,?,?)";
                descrizione = "descrizione esempio " + i;
                if (i > 9) {
                    descrizione = "descrizione esempio uguale";
                }
                if (i == 20) {
                    descrizione = "descrizione con caratteri particolari: " + rigaCaratteriStrani;
                }
                campoVuoto = null;
                if (i == 0) {
                    campoVuoto = PRIMA_COLONNA;
                }
                if (i > 10) {
                    campoVuoto = "";
                }
                if (i == ROW - 1) {
                    campoVuoto = ULTIMA_COLONNA;
                }
                stmtInsert = i % 2 == 0 ? con.prepareStatement(insertTracciaWithGdo) : con.prepareStatement(insertTracciaWithoutGdo);
                index = 1;
                stmtInsert.setString(index++, (String)descrizione);
                if (i % 2 == 0) {
                    stmtInsert.setTimestamp(index++, DateManager.getTimestamp());
                    increment = 10368000000L * (long)(i + 1);
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + increment + (long)(200101 * (i + 1))));
                } else {
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + (long)(23 * (i + 1))));
                }
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoMittente" + i / 2);
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoDestinatario" + i / 2);
                stmtInsert.setString(index++, campoVuoto);
                stmtInsert.execute();
                stmtInsert.close();
            }
            for (i = 0; i < 2; ++i) {
                boolean selectForUpdate = false;
                if (i == 1) {
                    selectForUpdate = true;
                }
                ClientTest.info(log, systemOut, "\n\n@@@ SELECT FOR UPDATE: " + selectForUpdate);
                ClientTest.testUnixTime_engine(tipoDatabase, "msgdiagnostici", con, selectForUpdate);
                ClientTest.testUnixTime_engine(tipoDatabase, "tracce", con, selectForUpdate);
                ClientTest.testFromTable_engine(tipoDatabase, "msgdiagnostici", con, selectForUpdate);
                ClientTest.testLikeEscapeChar_engine(tipoDatabase, "msgdiagnostici", con, selectForUpdate, caratteriStraniParte1, caratteriStraniParte2);
                ClientTest.testLikeEscapeChar_likeConfig_engine(tipoDatabase, "msgdiagnostici", con, selectForUpdate, caratteriStraniParte1, caratteriStraniParte2, (String)rigaCompletaCaratteriStrani);
                ClientTest.test_coalesce_case(tipoDatabase, con, selectForUpdate);
                ClientTest.test_extract_partDateTime(tipoDatabase, con, selectForUpdate);
                ClientTest.test_constantDateTime(tipoDatabase, con);
                ClientTest.test0_engine(tipoDatabase, con, selectForUpdate);
                ClientTest.test1_engine(tipoDatabase, false, con, selectForUpdate);
                ClientTest.test1_engine(tipoDatabase, true, con, selectForUpdate);
                ClientTest.testUnion_engine(tipoDatabase, false, true, con, selectForUpdate);
                ClientTest.testUnion_engine(tipoDatabase, true, true, con, selectForUpdate);
                ClientTest.testUnion_engine(tipoDatabase, false, false, con, selectForUpdate);
                ClientTest.testUnion_engine(tipoDatabase, true, false, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine(tipoDatabase, false, true, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine(tipoDatabase, true, true, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine(tipoDatabase, false, false, con, selectForUpdate);
                ClientTest.testUnionWithGroupBy_engine(tipoDatabase, true, false, con, selectForUpdate);
                ClientTest.testEmptyNull_engine(tipoDatabase, "msgdiagnostici", con, selectForUpdate);
                ClientTest.testCase_engine(tipoDatabase, i == 0 ? "msgdiagnostici" : "tracce", con, false);
            }
        }
        finally {
            try {
                stmtDelete.close();
            }
            catch (Exception exception) {}
            try {
                stmtInsert.close();
            }
            catch (Exception exception) {}
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        ClientTest.info(log, true, "Testsuite completata");
    }

    private static void info(Logger log, boolean systemOut, String msg) {
        log.info(msg);
        if (systemOut) {
            System.out.println(msg);
        }
    }

    private static SQLQueryObjectCore createSQLQueryObjectCore(TipiDatabase tipo, boolean selectForUpdate) throws Exception {
        SQLQueryObjectCore sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
        if (selectForUpdate) {
            sqlQueryObject.setSelectForUpdate(true);
        }
        return sqlQueryObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testUnixTime_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            boolean check;
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectAliasField(sqlQueryObject.getUnixTimestampConversion("gdo"), "unixtime");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testUnixTime = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " unixtime:\n\t" + testUnixTime);
            stmtQuery = con.prepareStatement(testUnixTime);
            rs = stmtQuery.executeQuery();
            int index = 0;
            if (!rs.next()) {
                log.error("Query: " + sqlQueryObject.toString());
                throw new Exception("UnixTime [checkDB] test1 failed");
            }
            String format = "yyyy-MM-dd_HH:mm:ss.SSSZ";
            SimpleDateFormat dateformat = new SimpleDateFormat(format);
            Timestamp timestamp = rs.getTimestamp("gdo");
            String s = dateformat.format(timestamp);
            long timeStampValue = timestamp.getTime();
            long timeStampValueWithTimeZone = -1L;
            if (timestamp.getTimezoneOffset() != 0) {
                timeStampValueWithTimeZone = timestamp.getTimezoneOffset() < 0 ? timestamp.getTime() + (long)(-1 * timestamp.getTimezoneOffset() * 60 * 1000) : timestamp.getTime() + (long)(timestamp.getTimezoneOffset() * 60 * 1000);
            }
            long unixAtteso = dateformat.parse(s).getTime() - (long)(dateformat.parse(s).getTimezoneOffset() * 60 * 1000);
            long unixAttesoCalcolatoViaDB = rs.getLong("unixtime");
            ClientTest.info(log, systemOut, "Data[" + s + "]");
            ClientTest.info(log, systemOut, "timeStampValue[" + timeStampValue + "] offset[" + timestamp.getTimezoneOffset() + "] timeStampValueWithTimeZone[" + timeStampValueWithTimeZone + "]");
            ClientTest.info(log, systemOut, "unixEpoqueAtteso[" + unixAtteso + "] unixEpoqueCalcolato[" + unixAttesoCalcolatoViaDB + "]");
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + " timeValue:" + timeStampValue + ") (" + unixAttesoCalcolatoViaDB + ")");
            boolean bl = check = timeStampValue == unixAttesoCalcolatoViaDB;
            if (!check && timeStampValueWithTimeZone != -1L) {
                boolean bl2 = check = timeStampValueWithTimeZone == unixAttesoCalcolatoViaDB;
            }
            if (!check) {
                if (!TipiDatabase.ORACLE.equals((Object)tipo)) {
                    log.error("Query: " + sqlQueryObject.toString());
                    throw new Exception("UnixTime [checkDB] test failed diff(" + (unixAttesoCalcolatoViaDB - timeStampValue) + ")");
                }
                if (timeStampValue != unixAttesoCalcolatoViaDB - 1000L) {
                    log.error("Query: " + sqlQueryObject.toString());
                    throw new Exception("UnixTime [checkDB] test failed diff(" + (unixAttesoCalcolatoViaDB - timeStampValue) + ")");
                }
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectAvgTimestampField("gdo", "unixtimeavg");
            sqlQueryObject.addSelectMinTimestampField("gdo", "unixtimemin");
            sqlQueryObject.addSelectMaxTimestampField("gdo", "unixtimemax");
            sqlQueryObject.addSelectSumTimestampField("gdo", "unixtimesum");
            sqlQueryObject.addGroupBy("descrizione");
            testUnixTime = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest2-" + table + " unixtime:\n\t" + testUnixTime);
            stmtQuery = con.prepareStatement(testUnixTime);
            rs = stmtQuery.executeQuery();
            index = 0;
            while (rs.next()) {
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " [min:" + rs.getLong("unixtimemin") + " max:" + rs.getLong("unixtimemax") + " avg:" + rs.getDouble("unixtimeavg") + " sum:" + rs.getLong("unixtimesum") + "]");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            SimpleDateFormat dateformat2 = DateUtils.getSimpleDateFormatMs();
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("gdo2");
            sqlQueryObject.addSelectAliasField(sqlQueryObject.getDiffUnixTimestamp("gdo2", "gdo"), "latenza");
            sqlQueryObject.addOrderBy(sqlQueryObject.getDiffUnixTimestamp("gdo2", "gdo"));
            sqlQueryObject.setSortType(true);
            testUnixTime = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest3-" + table + " unixtime:\n\t" + testUnixTime);
            long oldLatenza = 0L;
            stmtQuery = con.prepareStatement(testUnixTime);
            rs = stmtQuery.executeQuery();
            int index2 = 0;
            while (true) {
                if (!rs.next()) {
                    rs.close();
                    rs = null;
                    stmtQuery.close();
                    stmtQuery = null;
                    return;
                }
                long latenza = rs.getLong("latenza");
                ClientTest.info(log, systemOut, "riga[" + index2++ + "]=" + rs.getString("descrizione") + " gdo[" + dateformat2.format(rs.getTimestamp("gdo")) + "] gdo2[" + dateformat2.format(rs.getTimestamp("gdo2")) + "] [msLatenza:" + latenza + " humanReadable:" + Utilities.convertSystemTimeIntoStringMillisecondi(latenza, true) + "]");
                if (latenza <= oldLatenza) {
                    throw new Exception("Attesa latenza con ordinamento crescente. Latenza della entry precedente aveva [" + oldLatenza + "]");
                }
                if (index2 > 10 && latenza < 10000000000L) {
                    throw new Exception("Attesa latenza enorme, riscontro non avvenuto");
                }
                oldLatenza = latenza;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFromTable_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            SQLQueryObjectCore sqlQueryObjectExternal = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObjectExternal.addFromTable(sqlQueryObject);
            String test = sqlQueryObjectExternal.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest-" + table + " fromTable:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void testLikeEscapeChar_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate, String caratteriStraniParte1, String caratteriStraniParte2) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            boolean escape = true;
            boolean contains = true;
            boolean caseInsensitive = true;
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String ricerca = caratteriStraniParte1;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            String test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte1)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2;
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2.toLowerCase();
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, escape, contains, !caseInsensitive);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte2)-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            return;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void testLikeEscapeChar_likeConfig_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate, String caratteriStraniParte1, String caratteriStraniParte2, String rigaCompletaCaratteriStrani) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            boolean escape = true;
            boolean contains = true;
            boolean caseInsensitive = true;
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String ricerca = caratteriStraniParte1;
            LikeConfig likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            String test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte1)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1.toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte1)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2;
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte2)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2.toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte2)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1;
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte1)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte1.toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte1)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2;
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte2)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = caratteriStraniParte2.toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setContains(contains);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte2)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(0, 100);
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setStartsWith(true);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte3)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(0, 100).toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setStartsWith(true);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte3)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(0, 100);
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setStartsWith(true);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte4)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(0, 100).toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setStartsWith(true);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte4)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(0, 100);
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setEndsWith(true);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte4 errore)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(50, rigaCompletaCaratteriStrani.length());
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setEndsWith(true);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte5)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(50, rigaCompletaCaratteriStrani.length()).toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setEndsWith(true);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte5)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(50, rigaCompletaCaratteriStrani.length());
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setEndsWith(true);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest (Parte6)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(50, rigaCompletaCaratteriStrani.length()).toLowerCase();
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setEndsWith(true);
            likeConfig.setCaseInsensitive(!caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte6)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            ricerca = rigaCompletaCaratteriStrani.substring(50, rigaCompletaCaratteriStrani.length());
            likeConfig = new LikeConfig();
            likeConfig.setEscape(escape);
            likeConfig.setStartsWith(true);
            likeConfig.setCaseInsensitive(caseInsensitive);
            sqlQueryObject.addWhereLikeCondition("descrizione", ricerca, likeConfig);
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntestLower (Parte6 errore)-" + table + " escapeLikeConfig:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            index = 0;
            if (rs.next()) {
                if (!TipiDatabase.MYSQL.equals((Object)tipo) && !TipiDatabase.SQLSERVER.equals((Object)tipo)) throw new Exception("Atteso fallimento del test");
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            } else {
                ClientTest.info(log, systemOut, "Nessuna riga trovata: risultato atteso");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            return;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test_coalesce_case(TipiDatabase tipo, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            String testCoalesce;
            String campoVuoto;
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectAliasField("aliasMSG", "campo_vuoto", "testCampoVuoto");
            sqlQueryObject.addSelectCoalesceField("aliasMSG", "campo_vuoto", "testCoalesce", "VALORE_DEFAULT_COALESCE");
            Case caseValue = new Case(CastColumnType.STRING, true, "CASE_DEFAULT");
            caseValue.addCase("aliasMSG.campo_vuoto='" + PRIMA_COLONNA + "'", "CASE_PRIMO");
            caseValue.addCase("aliasMSG.campo_vuoto='" + ULTIMA_COLONNA + "'", "CASE_ULTIMO");
            sqlQueryObject.addSelectCaseField(caseValue, "testCase");
            ClientTest.info(log, systemOut, "");
            String test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            try {
                while (rs.next()) {
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (coalesce:" + rs.getString("testCoalesce") + ") (case:" + rs.getString("testCase") + ")");
                    campoVuoto = rs.getString("testCampoVuoto");
                    testCoalesce = rs.getString("testCoalesce");
                    String testCase = rs.getString("testCase");
                    if (campoVuoto == null && !"VALORE_DEFAULT_COALESCE".equals(testCoalesce)) {
                        throw new Exception("Test failed; expected testCoalesce '" + testCoalesce + "' con il valore di default 'VALORE_DEFAULT_COALESCE'");
                    }
                    if (PRIMA_COLONNA.equals(campoVuoto)) {
                        if ("CASE_PRIMO".equals(testCase)) continue;
                        throw new Exception("Test failed; expected testCase '" + testCase + "' con il valore 'CASE_PRIMO' per la colonna con valore '" + campoVuoto + "'");
                    }
                    if (ULTIMA_COLONNA.equals(campoVuoto)) {
                        if ("CASE_ULTIMO".equals(testCase)) continue;
                        throw new Exception("Test failed; expected testCase '" + testCase + "' con il valore 'CASE_ULTIMO' per la colonna con valore '" + campoVuoto + "'");
                    }
                    if ("CASE_DEFAULT".equals(testCase)) continue;
                    throw new Exception("Test failed; expected testCase '" + testCase + "' con il valore 'CASE_DEFAULT' per la colonna con valore '" + campoVuoto + "'");
                }
            }
            finally {
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            if (index == 0) {
                throw new Exception("Test failed");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectAliasField("aliasMSG", "campo_vuoto", "testCampoVuoto");
            sqlQueryObject.addSelectCoalesceField("aliasMSG", "campo_vuoto", "testCoalesce", "VALORE_DEFAULT_COALESCE");
            caseValue = new Case(CastColumnType.LONG, false, "23");
            caseValue.addCase("aliasMSG.campo_vuoto='" + PRIMA_COLONNA + "'", "11");
            caseValue.addCase("aliasMSG.campo_vuoto='" + ULTIMA_COLONNA + "'", "99");
            sqlQueryObject.addSelectCaseField(caseValue, "testCase");
            ClientTest.info(log, systemOut, "");
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            try {
                while (rs.next()) {
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (coalesce:" + rs.getString("testCoalesce") + ") (case:" + rs.getLong("testCase") + ")");
                    campoVuoto = rs.getString("testCampoVuoto");
                    testCoalesce = rs.getString("testCoalesce");
                    long testCase = rs.getLong("testCase");
                    if (campoVuoto == null && !"VALORE_DEFAULT_COALESCE".equals(testCoalesce)) {
                        throw new Exception("Test failed; expected testCoalesce '" + testCoalesce + "' con il valore di default 'VALORE_DEFAULT_COALESCE'");
                    }
                    if (PRIMA_COLONNA.equals(campoVuoto)) {
                        if (testCase == 11L) continue;
                        throw new Exception("Test failed; expected testCase '" + testCase + "' con il valore '11' per la colonna con valore '" + campoVuoto + "'");
                    }
                    if (ULTIMA_COLONNA.equals(campoVuoto)) {
                        if (testCase == 99L) continue;
                        throw new Exception("Test failed; expected testCase '" + testCase + "' con il valore '99' per la colonna con valore '" + campoVuoto + "'");
                    }
                    if (testCase == 23L) continue;
                    throw new Exception("Test failed; expected testCase '" + testCase + "' con il valore '23' per la colonna con valore '" + campoVuoto + "'");
                }
            }
            finally {
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            if (index == 0) {
                throw new Exception("Test failed");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectAliasField("aliasMSG", "campo_vuoto", "testCampoVuoto");
            sqlQueryObject.addSelectCoalesceField("aliasMSG", "campo_vuoto", "testCoalesce", "VALORE_DEFAULT_COALESCE");
            caseValue = new Case(CastColumnType.STRING, false, "null");
            caseValue.addCase("aliasMSG.campo_vuoto='" + PRIMA_COLONNA + "'", "aliasMSG.campo_vuoto");
            caseValue.addCase("aliasMSG.campo_vuoto='" + ULTIMA_COLONNA + "'", "null");
            sqlQueryObject.addSelectCaseField(caseValue, "testCase");
            ClientTest.info(log, systemOut, "");
            test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            index = 0;
            try {
                while (rs.next()) {
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (coalesce:" + rs.getString("testCoalesce") + ") (case:" + rs.getString("testCase") + ")");
                    campoVuoto = rs.getString("testCampoVuoto");
                    testCoalesce = rs.getString("testCoalesce");
                    String testCase = rs.getString("testCase");
                    if (campoVuoto == null && !"VALORE_DEFAULT_COALESCE".equals(testCoalesce)) {
                        throw new Exception("Test failed; expected testCoalesce '" + testCoalesce + "' con il valore di default 'VALORE_DEFAULT_COALESCE'");
                    }
                    if (PRIMA_COLONNA.equals(campoVuoto)) {
                        if (campoVuoto.equals(testCase)) continue;
                        throw new Exception("Test failed; expected testCase '" + testCase + "' con lo stesso valore della colonna campo_vuoto:'" + campoVuoto + "'");
                    }
                    if (!(ULTIMA_COLONNA.equals(campoVuoto) ? testCase != null : testCase != null)) continue;
                    throw new Exception("Test failed; expected testCase '" + testCase + "' con null value per la colonna con valore '" + campoVuoto + "'");
                }
            }
            finally {
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            if (index == 0) {
                throw new Exception("Test failed");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test_extract_partDateTime(TipiDatabase tipo, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        String yearColonnaWhere = null;
        String monthColonnaWhere = null;
        String dayColonnaWhere = null;
        String hourColonnaWhere = null;
        String minuteColonnaWhere = null;
        String secondColonnaWhere = null;
        String fullDayNameColonnaWhere = null;
        String shortDayNameColonnaWhere = null;
        String dayOfYearColonnaWhere = null;
        String dayOfWeekColonnaWhere = null;
        try {
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectAliasField("aliasMSG", "gdo", "data");
            sqlQueryObject.addSelectYearTimestampField("gdo", "yearColonna");
            sqlQueryObject.addSelectYearTimestampField("aliasMSG", "gdo", "yearColonnaTabella");
            sqlQueryObject.addSelectMonthTimestampField("gdo", "monthColonna");
            sqlQueryObject.addSelectMonthTimestampField("aliasMSG", "gdo", "monthColonnaTabella");
            sqlQueryObject.addSelectDayTimestampField("gdo", "dayColonna");
            sqlQueryObject.addSelectDayTimestampField("aliasMSG", "gdo", "dayColonnaTabella");
            sqlQueryObject.addSelectHourTimestampField("gdo", "hourColonna");
            sqlQueryObject.addSelectHourTimestampField("aliasMSG", "gdo", "hourColonnaTabella");
            sqlQueryObject.addSelectMinuteTimestampField("gdo", "minuteColonna");
            sqlQueryObject.addSelectMinuteTimestampField("aliasMSG", "gdo", "minuteColonnaTabella");
            sqlQueryObject.addSelectSecondTimestampField("gdo", "secondColonna");
            sqlQueryObject.addSelectSecondTimestampField("aliasMSG", "gdo", "secondColonnaTabella");
            sqlQueryObject.addSelectFullDayNameTimestampField("gdo", "fullDayNameColonna");
            sqlQueryObject.addSelectFullDayNameTimestampField("aliasMSG", "gdo", "fullDayNameColonnaTabella");
            sqlQueryObject.addSelectShortDayNameTimestampField("gdo", "shortDayNameColonna");
            sqlQueryObject.addSelectShortDayNameTimestampField("aliasMSG", "gdo", "shortDayNameColonnaTabella");
            sqlQueryObject.addSelectDayOfYearTimestampField("gdo", "dayOfYearColonna");
            sqlQueryObject.addSelectDayOfYearTimestampField("aliasMSG", "gdo", "dayOfYearColonnaTabella");
            sqlQueryObject.addSelectDayOfWeekTimestampField("gdo", "dayOfWeekColonna");
            sqlQueryObject.addSelectDayOfWeekTimestampField("aliasMSG", "gdo", "dayOfWeekColonnaTabella");
            ClientTest.info(log, systemOut, "");
            String test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            try {
                while (rs.next()) {
                    String format = "yyyy-MM-dd HH:mm:ss.SSS";
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    Timestamp data = rs.getTimestamp("data");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (data:" + sdf.format(data) + ")");
                    Instant instant = ((Date)data).toInstant();
                    ZoneId zoneId = ZoneId.systemDefault();
                    LocalDateTime ld = instant.atZone(zoneId).toLocalDateTime();
                    String year = "" + ld.getYear();
                    String yearColonna = rs.getString("yearColonna");
                    String yearColonnaTabella = rs.getString("yearColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (yearColonna:" + yearColonna + ") (yearColonnaTabella:" + yearColonnaTabella + ")");
                    if (!year.equals(yearColonna)) {
                        throw new Exception("Test failed; expected yearColonna '" + year + "', trovato '" + yearColonna + "'");
                    }
                    if (!year.equals(yearColonnaTabella)) {
                        throw new Exception("Test failed; expected yearColonnaTabella '" + year + "', trovato '" + yearColonnaTabella + "'");
                    }
                    yearColonnaWhere = yearColonna;
                    String month = "" + ld.getMonthValue();
                    String monthColonna = rs.getString("monthColonna");
                    String monthColonnaTabella = rs.getString("monthColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (monthColonna:" + monthColonna + ") (monthColonnaTabella:" + monthColonnaTabella + ")");
                    if (!month.equals(monthColonna)) {
                        throw new Exception("Test failed; expected monthColonna '" + month + "', trovato '" + monthColonna + "'");
                    }
                    if (!month.equals(monthColonnaTabella)) {
                        throw new Exception("Test failed; expected monthColonnaTabella '" + month + "', trovato '" + monthColonnaTabella + "'");
                    }
                    monthColonnaWhere = monthColonna;
                    String day = "" + ld.getDayOfMonth();
                    String dayColonna = rs.getString("dayColonna");
                    String dayColonnaTabella = rs.getString("dayColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (dayColonna:" + dayColonna + ") (dayColonnaTabella:" + dayColonnaTabella + ")");
                    if (!day.equals(dayColonna)) {
                        throw new Exception("Test failed; expected dayColonna '" + day + "', trovato '" + dayColonna + "'");
                    }
                    if (!day.equals(dayColonnaTabella)) {
                        throw new Exception("Test failed; expected dayColonnaTabella '" + day + "', trovato '" + dayColonnaTabella + "'");
                    }
                    dayColonnaWhere = dayColonna;
                    String hour = "" + ld.getHour();
                    String hourColonna = rs.getString("hourColonna");
                    String hourColonnaTabella = rs.getString("hourColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (hourColonna:" + hourColonna + ") (hourColonnaTabella:" + hourColonnaTabella + ")");
                    if (!hour.equals(hourColonna)) {
                        throw new Exception("Test failed; expected hourColonna '" + hour + "', trovato '" + hourColonna + "'");
                    }
                    if (!hour.equals(hourColonnaTabella)) {
                        throw new Exception("Test failed; expected hourColonnaTabella '" + hour + "', trovato '" + hourColonnaTabella + "'");
                    }
                    hourColonnaWhere = hourColonna;
                    String minute = "" + ld.getMinute();
                    String minuteColonna = rs.getString("minuteColonna");
                    String minuteColonnaTabella = rs.getString("minuteColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (minuteColonna:" + minuteColonna + ") (minuteColonnaTabella:" + minuteColonnaTabella + ")");
                    if (!minute.equals(minuteColonna)) {
                        throw new Exception("Test failed; expected minuteColonna '" + minute + "', trovato '" + minuteColonna + "'");
                    }
                    if (!minute.equals(minuteColonnaTabella)) {
                        throw new Exception("Test failed; expected minuteColonnaTabella '" + minute + "', trovato '" + minuteColonnaTabella + "'");
                    }
                    minuteColonnaWhere = minuteColonna;
                    String second = "" + ld.getSecond();
                    String secondMillisecond = ld.getSecond() + ".";
                    String secondColonna = rs.getString("secondColonna");
                    String secondColonnaTabella = rs.getString("secondColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (secondColonna:" + secondColonna + ") (secondColonnaTabella:" + secondColonnaTabella + ")");
                    if (!second.equals(secondColonna) && secondColonna != null && !secondColonna.startsWith(secondMillisecond)) {
                        throw new Exception("Test failed; expected secondColonna '" + second + "', trovato '" + secondColonna + "'");
                    }
                    if (!second.equals(secondColonnaTabella) && secondColonnaTabella != null && !secondColonnaTabella.startsWith(secondMillisecond)) {
                        throw new Exception("Test failed; expected secondColonnaTabella '" + second + "', trovato '" + secondColonnaTabella + "'");
                    }
                    secondColonnaWhere = secondColonna;
                    SimpleDateFormat sdfFullDayName = new SimpleDateFormat("EEEE");
                    String fullDayName = sdfFullDayName.format(data);
                    String fullDayNameColonna = rs.getString("fullDayNameColonna");
                    String fullDayNameColonnaTabella = rs.getString("fullDayNameColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (fullDayNameColonna:" + fullDayNameColonna + ") (fullDayNameColonnaTabella:" + fullDayNameColonnaTabella + ")");
                    if (!fullDayName.equalsIgnoreCase(fullDayNameColonna)) {
                        throw new Exception("Test failed; expected fullDayNameColonna '" + fullDayName + "', trovato '" + fullDayNameColonna + "'");
                    }
                    if (!fullDayName.equalsIgnoreCase(fullDayNameColonnaTabella)) {
                        throw new Exception("Test failed; expected fullDayNameColonnaTabella '" + fullDayName + "', trovato '" + fullDayNameColonnaTabella + "'");
                    }
                    fullDayNameColonnaWhere = fullDayNameColonna;
                    SimpleDateFormat sdfshortDayName = new SimpleDateFormat("E");
                    String shortDayName = sdfshortDayName.format(data);
                    String shortDayNameColonna = rs.getString("shortDayNameColonna");
                    String shortDayNameColonnaTabella = rs.getString("shortDayNameColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (shortDayNameColonna:" + shortDayNameColonna + ") (shortDayNameColonnaTabella:" + shortDayNameColonnaTabella + ")");
                    if (!shortDayName.equalsIgnoreCase(shortDayNameColonna)) {
                        throw new Exception("Test failed; expected shortDayNameColonna '" + shortDayName + "', trovato '" + shortDayNameColonna + "'");
                    }
                    if (!shortDayName.equalsIgnoreCase(shortDayNameColonnaTabella)) {
                        throw new Exception("Test failed; expected shortDayNameColonnaTabella '" + shortDayName + "', trovato '" + shortDayNameColonnaTabella + "'");
                    }
                    shortDayNameColonnaWhere = shortDayNameColonna;
                    Object dayOfYear = "" + ld.getDayOfYear();
                    dayOfYear = ClientTest.normalizeDayOfYear(tipo, (String)dayOfYear);
                    String dayOfYearColonna = rs.getString("dayOfYearColonna");
                    String dayOfYearColonnaTabella = rs.getString("dayOfYearColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (dayOfYearColonna:" + dayOfYearColonna + ") (dayOfYearColonnaTabella:" + dayOfYearColonnaTabella + ")");
                    if (!((String)dayOfYear).equals(dayOfYearColonna)) {
                        throw new Exception("Test failed; expected dayOfYearColonna '" + (String)dayOfYear + "', trovato '" + dayOfYearColonna + "'");
                    }
                    if (!((String)dayOfYear).equals(dayOfYearColonnaTabella)) {
                        throw new Exception("Test failed; expected dayOfYearColonnaTabella '" + (String)dayOfYear + "', trovato '" + dayOfYearColonnaTabella + "'");
                    }
                    dayOfYearColonnaWhere = dayOfYearColonna;
                    Object dayOfWeek = "";
                    dayOfWeek = ld.getDayOfWeek().getValue() == 7 ? "1" : "" + (ld.getDayOfWeek().getValue() + 1);
                    String dayOfWeekColonna = rs.getString("dayOfWeekColonna");
                    String dayOfWeekColonnaTabella = rs.getString("dayOfWeekColonnaTabella");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (dayOfWeekColonna:" + dayOfWeekColonna + ") (dayOfWeekColonnaTabella:" + dayOfWeekColonnaTabella + ")");
                    if (!((String)dayOfWeek).equals(dayOfWeekColonna)) {
                        throw new Exception("Test failed; expected dayOfWeekColonna '" + (String)dayOfWeek + "', trovato '" + dayOfWeekColonna + "'");
                    }
                    if (!((String)dayOfWeek).equals(dayOfWeekColonnaTabella)) {
                        throw new Exception("Test failed; expected dayOfWeekColonnaTabella '" + (String)dayOfWeek + "', trovato '" + dayOfWeekColonnaTabella + "'");
                    }
                    dayOfWeekColonnaWhere = dayOfWeekColonna;
                }
            }
            finally {
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            if (index == 0) {
                throw new Exception("Test failed");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception sqlQueryObject) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception sqlQueryObject) {}
        }
        int numeroControlli = 10;
        for (int i = 0; i < numeroControlli; ++i) {
            stmtQuery = null;
            rs = null;
            try {
                SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addSelectAliasField("aliasMSG", "gdo", "data");
                sqlQueryObject.addSelectYearTimestampField("gdo", "yearColonna");
                sqlQueryObject.addSelectYearTimestampField("aliasMSG", "gdo", "yearColonnaTabella");
                sqlQueryObject.addSelectMonthTimestampField("gdo", "monthColonna");
                sqlQueryObject.addSelectMonthTimestampField("aliasMSG", "gdo", "monthColonnaTabella");
                sqlQueryObject.addSelectDayTimestampField("gdo", "dayColonna");
                sqlQueryObject.addSelectDayTimestampField("aliasMSG", "gdo", "dayColonnaTabella");
                sqlQueryObject.addSelectHourTimestampField("gdo", "hourColonna");
                sqlQueryObject.addSelectHourTimestampField("aliasMSG", "gdo", "hourColonnaTabella");
                sqlQueryObject.addSelectMinuteTimestampField("gdo", "minuteColonna");
                sqlQueryObject.addSelectMinuteTimestampField("aliasMSG", "gdo", "minuteColonnaTabella");
                sqlQueryObject.addSelectSecondTimestampField("gdo", "secondColonna");
                sqlQueryObject.addSelectSecondTimestampField("aliasMSG", "gdo", "secondColonnaTabella");
                sqlQueryObject.addSelectFullDayNameTimestampField("gdo", "fullDayNameColonna");
                sqlQueryObject.addSelectFullDayNameTimestampField("aliasMSG", "gdo", "fullDayNameColonnaTabella");
                sqlQueryObject.addSelectShortDayNameTimestampField("gdo", "shortDayNameColonna");
                sqlQueryObject.addSelectShortDayNameTimestampField("aliasMSG", "gdo", "shortDayNameColonnaTabella");
                sqlQueryObject.addSelectDayOfYearTimestampField("gdo", "dayOfYearColonna");
                sqlQueryObject.addSelectDayOfYearTimestampField("aliasMSG", "gdo", "dayOfYearColonnaTabella");
                sqlQueryObject.addSelectDayOfWeekTimestampField("gdo", "dayOfWeekColonna");
                sqlQueryObject.addSelectDayOfWeekTimestampField("aliasMSG", "gdo", "dayOfWeekColonnaTabella");
                String whereType = null;
                if (i == 0) {
                    sqlQueryObject.addWhereYearCondition("gdo", yearColonnaWhere);
                    whereType = "YearCondition";
                } else if (i == 1) {
                    sqlQueryObject.addWhereMonthCondition("gdo", monthColonnaWhere);
                    whereType = "MonthCondition";
                } else if (i == 2) {
                    sqlQueryObject.addWhereDayCondition("gdo", dayColonnaWhere);
                    whereType = "DayCondition";
                } else if (i == 3) {
                    sqlQueryObject.addWhereHourCondition("gdo", hourColonnaWhere);
                    whereType = "HourCondition";
                } else if (i == 4) {
                    sqlQueryObject.addWhereMinuteCondition("gdo", minuteColonnaWhere);
                    whereType = "MinuteCondition";
                } else if (i == 5) {
                    sqlQueryObject.addWhereSecondCondition("gdo", secondColonnaWhere);
                    whereType = "SecondCondition";
                } else if (i == 6) {
                    sqlQueryObject.addWhereFullDayNameCondition("gdo", fullDayNameColonnaWhere);
                    whereType = "FullDayNameCondition";
                } else if (i == 7) {
                    sqlQueryObject.addWhereShortDayNameCondition("gdo", shortDayNameColonnaWhere);
                    whereType = "ShortDayNameCondition";
                } else if (i == 8) {
                    sqlQueryObject.addWhereDayOfYearCondition("gdo", dayOfYearColonnaWhere);
                    whereType = "DayOfYearCondition";
                } else if (i == 9) {
                    sqlQueryObject.addWhereDayOfWeekCondition("gdo", dayOfWeekColonnaWhere);
                    whereType = "DayOfWeekCondition";
                }
                ClientTest.info(log, systemOut, "");
                String test = sqlQueryObject.createSQLQuery();
                ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
                boolean find = false;
                stmtQuery = con.createStatement();
                if (stmtQuery == null) {
                    throw new Exception("Statement is null");
                }
                rs = stmtQuery.executeQuery(test);
                int index = 0;
                try {
                    while (rs.next()) {
                        find = true;
                        String format = "yyyy-MM-dd HH:mm:ss.SSS";
                        SimpleDateFormat sdf = new SimpleDateFormat(format);
                        Timestamp data = rs.getTimestamp("data");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (data:" + sdf.format(data) + ")");
                        Instant instant = ((Date)data).toInstant();
                        ZoneId zoneId = ZoneId.systemDefault();
                        LocalDateTime ld = instant.atZone(zoneId).toLocalDateTime();
                        String year = "" + ld.getYear();
                        String yearColonna = rs.getString("yearColonna");
                        String yearColonnaTabella = rs.getString("yearColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (yearColonna:" + yearColonna + ") (yearColonnaTabella:" + yearColonnaTabella + ")");
                        if (!year.equals(yearColonna)) {
                            throw new Exception("Test failed; expected yearColonna '" + year + "', trovato '" + yearColonna + "'");
                        }
                        if (!year.equals(yearColonnaTabella)) {
                            throw new Exception("Test failed; expected yearColonnaTabella '" + year + "', trovato '" + yearColonnaTabella + "'");
                        }
                        yearColonnaWhere = yearColonna;
                        String month = "" + ld.getMonthValue();
                        String monthColonna = rs.getString("monthColonna");
                        String monthColonnaTabella = rs.getString("monthColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (monthColonna:" + monthColonna + ") (monthColonnaTabella:" + monthColonnaTabella + ")");
                        if (!month.equals(monthColonna)) {
                            throw new Exception("Test failed; expected monthColonna '" + month + "', trovato '" + monthColonna + "'");
                        }
                        if (!month.equals(monthColonnaTabella)) {
                            throw new Exception("Test failed; expected monthColonnaTabella '" + month + "', trovato '" + monthColonnaTabella + "'");
                        }
                        monthColonnaWhere = monthColonna;
                        String day = "" + ld.getDayOfMonth();
                        String dayColonna = rs.getString("dayColonna");
                        String dayColonnaTabella = rs.getString("dayColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (dayColonna:" + dayColonna + ") (dayColonnaTabella:" + dayColonnaTabella + ")");
                        if (!day.equals(dayColonna)) {
                            throw new Exception("Test failed; expected dayColonna '" + day + "', trovato '" + dayColonna + "'");
                        }
                        if (!day.equals(dayColonnaTabella)) {
                            throw new Exception("Test failed; expected dayColonnaTabella '" + day + "', trovato '" + dayColonnaTabella + "'");
                        }
                        dayColonnaWhere = dayColonna;
                        String hour = "" + ld.getHour();
                        String hourColonna = rs.getString("hourColonna");
                        String hourColonnaTabella = rs.getString("hourColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (hourColonna:" + hourColonna + ") (hourColonnaTabella:" + hourColonnaTabella + ")");
                        if (!hour.equals(hourColonna)) {
                            throw new Exception("Test failed; expected hourColonna '" + hour + "', trovato '" + hourColonna + "'");
                        }
                        if (!hour.equals(hourColonnaTabella)) {
                            throw new Exception("Test failed; expected hourColonnaTabella '" + hour + "', trovato '" + hourColonnaTabella + "'");
                        }
                        hourColonnaWhere = hourColonna;
                        String minute = "" + ld.getMinute();
                        String minuteColonna = rs.getString("minuteColonna");
                        String minuteColonnaTabella = rs.getString("minuteColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (minuteColonna:" + minuteColonna + ") (minuteColonnaTabella:" + minuteColonnaTabella + ")");
                        if (!minute.equals(minuteColonna)) {
                            throw new Exception("Test failed; expected minuteColonna '" + minute + "', trovato '" + minuteColonna + "'");
                        }
                        if (!minute.equals(minuteColonnaTabella)) {
                            throw new Exception("Test failed; expected minuteColonnaTabella '" + minute + "', trovato '" + minuteColonnaTabella + "'");
                        }
                        minuteColonnaWhere = minuteColonna;
                        String second = "" + ld.getSecond();
                        String secondMillisecond = ld.getSecond() + ".";
                        String secondColonna = rs.getString("secondColonna");
                        String secondColonnaTabella = rs.getString("secondColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (secondColonna:" + secondColonna + ") (secondColonnaTabella:" + secondColonnaTabella + ")");
                        if (!second.equals(secondColonna) && secondColonna != null && !secondColonna.startsWith(secondMillisecond)) {
                            throw new Exception("Test failed; expected secondColonna '" + second + "', trovato '" + secondColonna + "'");
                        }
                        if (!second.equals(secondColonnaTabella) && secondColonnaTabella != null && !secondColonnaTabella.startsWith(secondMillisecond)) {
                            throw new Exception("Test failed; expected secondColonnaTabella '" + second + "', trovato '" + secondColonnaTabella + "'");
                        }
                        secondColonnaWhere = secondColonna;
                        SimpleDateFormat sdfFullDayName = new SimpleDateFormat("EEEE");
                        String fullDayName = sdfFullDayName.format(data);
                        String fullDayNameColonna = rs.getString("fullDayNameColonna");
                        String fullDayNameColonnaTabella = rs.getString("fullDayNameColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (fullDayNameColonna:" + fullDayNameColonna + ") (fullDayNameColonnaTabella:" + fullDayNameColonnaTabella + ")");
                        if (!fullDayName.equalsIgnoreCase(fullDayNameColonna)) {
                            throw new Exception("Test failed; expected fullDayNameColonna '" + fullDayName + "', trovato '" + fullDayNameColonna + "'");
                        }
                        if (!fullDayName.equalsIgnoreCase(fullDayNameColonnaTabella)) {
                            throw new Exception("Test failed; expected fullDayNameColonnaTabella '" + fullDayName + "', trovato '" + fullDayNameColonnaTabella + "'");
                        }
                        fullDayNameColonnaWhere = fullDayNameColonna;
                        SimpleDateFormat sdfshortDayName = new SimpleDateFormat("E");
                        String shortDayName = sdfshortDayName.format(data);
                        String shortDayNameColonna = rs.getString("shortDayNameColonna");
                        String shortDayNameColonnaTabella = rs.getString("shortDayNameColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (shortDayNameColonna:" + shortDayNameColonna + ") (shortDayNameColonnaTabella:" + shortDayNameColonnaTabella + ")");
                        if (!shortDayName.equalsIgnoreCase(shortDayNameColonna)) {
                            throw new Exception("Test failed; expected shortDayNameColonna '" + shortDayName + "', trovato '" + shortDayNameColonna + "'");
                        }
                        if (!shortDayName.equalsIgnoreCase(shortDayNameColonnaTabella)) {
                            throw new Exception("Test failed; expected shortDayNameColonnaTabella '" + shortDayName + "', trovato '" + shortDayNameColonnaTabella + "'");
                        }
                        shortDayNameColonnaWhere = shortDayNameColonna;
                        Object dayOfYear = "" + ld.getDayOfYear();
                        dayOfYear = ClientTest.normalizeDayOfYear(tipo, (String)dayOfYear);
                        String dayOfYearColonna = rs.getString("dayOfYearColonna");
                        String dayOfYearColonnaTabella = rs.getString("dayOfYearColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (dayOfYearColonna:" + dayOfYearColonna + ") (dayOfYearColonnaTabella:" + dayOfYearColonnaTabella + ")");
                        if (!((String)dayOfYear).equals(dayOfYearColonna)) {
                            throw new Exception("Test failed; expected dayOfYearColonna '" + (String)dayOfYear + "', trovato '" + dayOfYearColonna + "'");
                        }
                        if (!((String)dayOfYear).equals(dayOfYearColonnaTabella)) {
                            throw new Exception("Test failed; expected dayOfYearColonnaTabella '" + (String)dayOfYear + "', trovato '" + dayOfYearColonnaTabella + "'");
                        }
                        dayOfYearColonnaWhere = dayOfYearColonna;
                        Object dayOfWeek = "";
                        dayOfWeek = ld.getDayOfWeek().getValue() == 7 ? "1" : "" + (ld.getDayOfWeek().getValue() + 1);
                        String dayOfWeekColonna = rs.getString("dayOfWeekColonna");
                        String dayOfWeekColonnaTabella = rs.getString("dayOfWeekColonnaTabella");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + whereType + "] (dayOfWeekColonna:" + dayOfWeekColonna + ") (dayOfWeekColonnaTabella:" + dayOfWeekColonnaTabella + ")");
                        if (!((String)dayOfWeek).equals(dayOfWeekColonna)) {
                            throw new Exception("Test failed; expected dayOfWeekColonna '" + (String)dayOfWeek + "', trovato '" + dayOfWeekColonna + "'");
                        }
                        if (!((String)dayOfWeek).equals(dayOfWeekColonnaTabella)) {
                            throw new Exception("Test failed; expected dayOfWeekColonnaTabella '" + (String)dayOfWeek + "', trovato '" + dayOfWeekColonnaTabella + "'");
                        }
                        dayOfWeekColonnaWhere = dayOfWeekColonna;
                    }
                }
                finally {
                    rs.close();
                    rs = null;
                    stmtQuery.close();
                    stmtQuery = null;
                }
                if (index == 0) {
                    throw new Exception("Test failed");
                }
                if (find) continue;
                throw new Exception("Test failed, no record find for test where type '" + whereType + "'");
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String normalizeDayOfYear(TipiDatabase tipo, String dayOfYear) {
        if (TipiDatabase.POSTGRESQL.equals((Object)tipo) || TipiDatabase.ORACLE.equals((Object)tipo)) {
            if (((String)dayOfYear).length() <= 1) {
                dayOfYear = "00" + (String)dayOfYear;
            } else if (((String)dayOfYear).length() <= 2) {
                dayOfYear = "0" + (String)dayOfYear;
            }
        }
        return dayOfYear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test_constantDateTime(TipiDatabase tipo, Connection con) throws Exception {
        SQLQueryObjectCore sqlQueryObject2;
        Statement stmtQuery = null;
        ResultSet rs = null;
        Statement pstmt = null;
        String format = "yyyy-MM-dd HH:mm:ss.SSS";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String dataPast = "2022-01-01 12:34:56.789";
        String dataFuture = "2092-10-31 17:34:56.789";
        Date now = DateManager.getDate();
        Date past = sdf.parse(dataPast);
        Date future = sdf.parse(dataFuture);
        String dataNow = sdf.format(now);
        String aliasNow = "data_attuale";
        String aliasPassata = "data_passata";
        String aliasFutura = "data_futura";
        try {
            sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject2.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject2.addSelectTimestampConstantField(now, aliasNow);
            sqlQueryObject2.addSelectTimestampConstantField(past, aliasPassata);
            sqlQueryObject2.addSelectTimestampConstantField(future, aliasFutura);
            ClientTest.info(log, systemOut, "");
            String test = sqlQueryObject2.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            try {
                while (rs.next()) {
                    Timestamp readNow = rs.getTimestamp(aliasNow);
                    Timestamp readPast = rs.getTimestamp(aliasPassata);
                    Timestamp readFuture = rs.getTimestamp(aliasFutura);
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (now:" + sdf.format(readNow) + ") (past:" + sdf.format(readPast) + ") (future:" + sdf.format(readFuture) + ")");
                    String readAsS = sdf.format(readNow);
                    if (((Date)readNow).getTime() != now.getTime()) {
                        throw new Exception("Test failed; expected now '" + dataNow + "', trovato '" + readAsS + "'");
                    }
                    if (!readAsS.equals(dataNow)) {
                        throw new Exception("Test failed (string); expected now '" + dataNow + "', trovato '" + readAsS + "'");
                    }
                    readAsS = sdf.format(readPast);
                    if (((Date)readPast).getTime() != past.getTime()) {
                        throw new Exception("Test failed; expected past '" + dataPast + "', trovato '" + readAsS + "'");
                    }
                    if (!readAsS.equals(dataPast)) {
                        throw new Exception("Test failed (string); expected past '" + dataPast + "', trovato '" + readAsS + "'");
                    }
                    readAsS = sdf.format(readFuture);
                    if (((Date)readFuture).getTime() != future.getTime()) {
                        throw new Exception("Test failed; expected future '" + dataFuture + "', trovato '" + readAsS + "'");
                    }
                    if (!readAsS.equals(dataFuture)) {
                        throw new Exception("Test failed (string); expected future '" + dataFuture + "', trovato '" + readAsS + "'");
                    }
                    ++index;
                }
            }
            finally {
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            if (index == 0) {
                throw new Exception("Test failed");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception sqlQueryObject2) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception sqlQueryObject2) {}
        }
        stmtQuery = null;
        rs = null;
        try {
            sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject2.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject2.addSelectTimestampConstantField(now, aliasNow);
            sqlQueryObject2.addSelectTimestampConstantField(past, aliasPassata);
            sqlQueryObject2.addSelectTimestampConstantField(future, aliasFutura);
            String costanteNow = sqlQueryObject2.getSelectTimestampConstantField(now);
            String costanteFuture = sqlQueryObject2.getSelectTimestampConstantField(future);
            String costantePast = sqlQueryObject2.getSelectTimestampConstantField(past);
            sqlQueryObject2.addWhereCondition(costanteNow + "=?");
            sqlQueryObject2.addWhereCondition(costantePast + "<?");
            sqlQueryObject2.addWhereCondition(costanteFuture + ">?");
            sqlQueryObject2.setANDLogicOperator(true);
            ClientTest.info(log, systemOut, "");
            String test = sqlQueryObject2.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
            pstmt = con.prepareStatement(test);
            if (pstmt == null) {
                throw new Exception("Statement is null");
            }
            pstmt.setTimestamp(1, new Timestamp(now.getTime()));
            pstmt.setTimestamp(2, new Timestamp(now.getTime()));
            pstmt.setTimestamp(3, new Timestamp(now.getTime()));
            rs = pstmt.executeQuery();
            int index = 0;
            try {
                while (rs.next()) {
                    Timestamp readNow = rs.getTimestamp(aliasNow);
                    Timestamp readPast = rs.getTimestamp(aliasPassata);
                    Timestamp readFuture = rs.getTimestamp(aliasFutura);
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (now:" + sdf.format(readNow) + ") (past:" + sdf.format(readPast) + ") (future:" + sdf.format(readFuture) + ")");
                    String readAsS = sdf.format(readNow);
                    if (((Date)readNow).getTime() != now.getTime()) {
                        throw new Exception("Test failed; expected now '" + dataNow + "', trovato '" + readAsS + "'");
                    }
                    if (!readAsS.equals(dataNow)) {
                        throw new Exception("Test failed (string); expected now '" + dataNow + "', trovato '" + readAsS + "'");
                    }
                    readAsS = sdf.format(readPast);
                    if (((Date)readPast).getTime() != past.getTime()) {
                        throw new Exception("Test failed; expected past '" + dataPast + "', trovato '" + readAsS + "'");
                    }
                    if (!readAsS.equals(dataPast)) {
                        throw new Exception("Test failed (string); expected past '" + dataPast + "', trovato '" + readAsS + "'");
                    }
                    readAsS = sdf.format(readFuture);
                    if (((Date)readFuture).getTime() != future.getTime()) {
                        throw new Exception("Test failed; expected future '" + dataFuture + "', trovato '" + readAsS + "'");
                    }
                    if (!readAsS.equals(dataFuture)) {
                        throw new Exception("Test failed (string); expected future '" + dataFuture + "', trovato '" + readAsS + "'");
                    }
                    ++index;
                }
            }
            finally {
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            if (index == 0) {
                throw new Exception("Test failed");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test0_engine(TipiDatabase tipo, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectCountField("aliasMSG", "id", "cont", true);
            sqlQueryObject.addSelectAvgField("aliasMSG", "id", "avgMedio");
            sqlQueryObject.addSelectField("aliasMSG", "mittente");
            sqlQueryObject.addSelectAliasField("aliasMSG", "destinatario", "ALIASDEST");
            sqlQueryObject.addWhereIsNotNullCondition("tracce.tipo_mittente");
            sqlQueryObject.addGroupBy("aliasMSG.mittente");
            sqlQueryObject.addGroupBy("ALIASDEST");
            sqlQueryObject.addOrderBy("cont", false);
            sqlQueryObject.addOrderBy("avgMedio");
            sqlQueryObject.addOrderBy("mittente", true);
            sqlQueryObject.addOrderBy("ALIASDEST", false);
            sqlQueryObject.setSortType(true);
            List<String> trovato = sqlQueryObject.getFieldsName();
            ClientTest.info(log, systemOut, "(test0_engine) [" + tipo.toString() + "] getFieldsName: \t" + String.valueOf(trovato));
            String atteso = "cont, mittente, ALIASDEST";
            if (atteso.equals(trovato.toString())) {
                throw new Exception("Test failed (getFieldsName) trovato[" + trovato.toString() + "] atteso[" + atteso + "]");
            }
            trovato = sqlQueryObject.getTablesName();
            ClientTest.info(log, systemOut, "(test0_engine) [" + tipo.toString() + "] getTablesName: \t" + String.valueOf(trovato));
            atteso = "tracce, aliasMSG";
            if (atteso.equals(trovato.toString())) {
                throw new Exception("Test failed (getTablesName) trovato[" + trovato.toString() + "] atteso[" + atteso + "]");
            }
            ClientTest.info(log, systemOut, "");
            String test = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            if (stmtQuery == null) {
                throw new Exception("Statement is null");
            }
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (rs.next()) {
                ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + "->" + rs.getString("ALIASDEST") + ") (count:" + rs.getLong("cont") + ")");
                while (rs.next()) {
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + "->" + rs.getString("ALIASDEST") + ") (count:" + rs.getLong("cont") + ")");
                }
            } else {
                throw new Exception("Test failed");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test1_engine(TipiDatabase tipo, boolean distinct, Connection con, boolean selectForUpdate) throws Exception {
        block250: {
            String test;
            int limit;
            String mittente;
            ISQLQueryObject sqlQueryObject2;
            ResultSet rs;
            Statement stmtQuery;
            block249: {
                block248: {
                    int index;
                    String test2;
                    int index2;
                    String test3;
                    int limit2;
                    stmtQuery = null;
                    rs = null;
                    try {
                        ClientTest.info(log, systemOut, "\n\na. ** Query normale");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate && !distinct);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        String test4 = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryNormale]:\n\t" + test4);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test4);
                        int index3 = 0;
                        if (rs.next()) {
                            ClientTest.info(log, systemOut, "riga[" + index3++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index3++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (distinct) {
                            if (index3 != ROW / 2 + 1) {
                                throw new Exception("Test failed (expected " + (ROW / 2 + 1) + " rows, found:" + index3 + ")");
                            }
                        } else if (index3 != ROW) {
                            throw new Exception("Test failed (expected " + ROW + " rows, found:" + index3 + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject2) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject2) {}
                    }
                    try {
                        ClientTest.info(log, systemOut, "\n\nb. ** Query con limit/offset");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject2.setLimit(limit2);
                        sqlQueryObject2.setOffset(0);
                        test3 = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimitOffset]:\n\t" + test3);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject3) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject3) {}
                    }
                    try {
                        ClientTest.info(log, systemOut, "\n\nb. ** Query con limit/offset (unixTimestamp)");
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addSelectField("gdo2");
                        sqlQueryObject2.addSelectField("gdo");
                        sqlQueryObject2.addSelectAliasField(sqlQueryObject2.getDiffUnixTimestamp("gdo2", "gdo"), "latenza");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.addOrderBy(sqlQueryObject2.getDiffUnixTimestamp("gdo2", "gdo"));
                        sqlQueryObject2.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject2.setLimit(limit2);
                        sqlQueryObject2.setOffset(0);
                        test3 = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimitOffset]:\n\t" + test3);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")(" + rs.getLong("latenza") + ")");
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")(" + rs.getLong("latenza") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject4) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject4) {}
                    }
                    try {
                        ClientTest.info(log, systemOut, "\n\nc. ** Query con limit");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject2.setLimit(limit2);
                        test3 = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimit]:\n\t" + test3);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject5) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject5) {}
                    }
                    try {
                        ClientTest.info(log, systemOut, "\n\nd. ** Query con offset");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectAliasField("tracce", "tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("tracce.destinatario");
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setOffset(2);
                        test2 = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryOffset]:\n\t" + test2);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test2);
                        index = 0;
                        if (rs.next()) {
                            String mittente2;
                            if (distinct) {
                                String mittente3;
                                String mittente4;
                                if (index == 0 && !(mittente4 = rs.getString("mittente")).endsWith("10")) {
                                    throw new Exception("Test failed (atteso un nome di mittente che termina con 10)");
                                }
                                if (index == 1 && !(mittente3 = rs.getString("mittente")).endsWith("2")) {
                                    throw new Exception("Test failed (atteso un nome di mittente che termina con 2)");
                                }
                            } else if (!(index != 0 && index != 1 || (mittente2 = rs.getString("mittente")).endsWith("1"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 1)");
                            }
                            ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ")(" + rs.getString("TIPODEST") + ")(" + rs.getString("destinatario") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (distinct) {
                            if (index != (ROW - 2) / 2) {
                                throw new Exception("Test failed (expected " + (ROW - 2) / 2 + " rows, found:" + index + ")");
                            }
                        } else if (index != ROW - 2) {
                            throw new Exception("Test failed (expected " + (ROW - 2) + " rows, found:" + index + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject6) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject6) {}
                    }
                    try {
                        ClientTest.info(log, systemOut, "\n\ne. ** Query groupBy");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectCountField("id", "cont", true);
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addSelectAliasField("tracce.tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("destinatario");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.addGroupBy("mittente");
                        sqlQueryObject2.addGroupBy("TIPODEST");
                        sqlQueryObject2.addGroupBy("tracce.destinatario");
                        test2 = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [GroupBy]:\n\t" + test2);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test2);
                        index = 0;
                        if (rs.next()) {
                            ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                            if (2L != rs.getLong("cont")) {
                                throw new Exception("Test failed row[" + index + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                                if (rs.getString("mittente").endsWith("10")) {
                                    if (1L == rs.getLong("cont")) continue;
                                    long cont = rs.getLong("cont");
                                    rs.close();
                                    rs = null;
                                    stmtQuery.close();
                                    stmtQuery = null;
                                    throw new Exception("Test failed row[" + index + "] found:" + cont + " expected:1");
                                }
                                if (2L == rs.getLong("cont")) continue;
                                long cont = rs.getLong("cont");
                                rs.close();
                                rs = null;
                                stmtQuery.close();
                                stmtQuery = null;
                                throw new Exception("Test failed row[" + index + "] found:" + cont + " expected:2");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index != ROW / 2 + 1) {
                            throw new Exception("Test failed (expected " + (ROW / 2 + 1) + " rows, found:" + index + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject7) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject7) {}
                    }
                    try {
                        ClientTest.info(log, systemOut, "\n\nf. ** Query groupBy con limit/offset");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addSelectCountField("id", "cont", true);
                        sqlQueryObject2.addSelectField("mittente");
                        sqlQueryObject2.addSelectAliasField("tracce.tipo_destinatario", "TIPODEST");
                        sqlQueryObject2.addSelectField("destinatario");
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("TIPODEST", false);
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.addGroupBy("mittente");
                        sqlQueryObject2.addGroupBy("TIPODEST");
                        sqlQueryObject2.addGroupBy("tracce.destinatario");
                        int limit3 = 5;
                        sqlQueryObject2.setLimit(limit3);
                        sqlQueryObject2.setOffset(1);
                        String test5 = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [GroupByLimitOffset]:\n\t" + test5);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test5);
                        int index4 = 0;
                        if (rs.next()) {
                            ClientTest.info(log, systemOut, "riga[" + index4++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                            if (2L != rs.getLong("cont")) {
                                throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index4++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont"));
                                if (rs.getString("mittente").endsWith("10")) {
                                    if (1L == rs.getLong("cont")) continue;
                                    long cont = rs.getLong("cont");
                                    rs.close();
                                    rs = null;
                                    stmtQuery.close();
                                    stmtQuery = null;
                                    throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + cont + " expected:1");
                                }
                                if (2L == rs.getLong("cont")) continue;
                                long cont = rs.getLong("cont");
                                rs.close();
                                rs = null;
                                stmtQuery.close();
                                stmtQuery = null;
                                throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + cont + " expected:2");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index4 != limit3) {
                            throw new Exception("Test failed (expected " + limit3 + " rows, found:" + index4 + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject8) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject8) {}
                    }
                    try {
                        ClientTest.info(log, systemOut, "\n\ng. ** Query con select*");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate && !distinct);
                        sqlQueryObject2.addFromTable("tracce");
                        sqlQueryObject2.setSelectDistinct(distinct);
                        sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("tipo_destinatario");
                        sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        String test6 = null;
                        try {
                            test6 = sqlQueryObject2.createSQLQuery();
                            ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*]:\n\t" + test6);
                            if (distinct) {
                                throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                            }
                        }
                        catch (SQLQueryObjectException s) {
                            if (distinct) {
                                if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                                    throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                                }
                            }
                            throw s;
                        }
                        if (distinct) break block248;
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test6);
                        int index5 = 0;
                        if (rs.next()) {
                            ClientTest.info(log, systemOut, "riga[" + index5++ + "]= (" + rs.getString("mittente") + ")");
                            while (rs.next()) {
                                ClientTest.info(log, systemOut, "riga[" + index5++ + "]= (" + rs.getString("mittente") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index5 != ROW) {
                            throw new Exception("Test failed (expected " + ROW + " rows, found:" + index5 + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception sqlQueryObject9) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception sqlQueryObject9) {}
                    }
                }
                try {
                    ClientTest.info(log, systemOut, "\n\nh. ** Query con select* e offset/limit");
                    sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject2.addFromTable("tracce");
                    sqlQueryObject2.setSelectDistinct(distinct);
                    sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.addOrderBy("tipo_destinatario");
                    sqlQueryObject2.addOrderBy("tracce.destinatario", false);
                    sqlQueryObject2.setSortType(true);
                    limit = 10;
                    sqlQueryObject2.setLimit(limit);
                    sqlQueryObject2.setOffset(0);
                    test = null;
                    try {
                        test = sqlQueryObject2.createSQLQuery();
                        ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*LimitOffset*]:\n\t" + test);
                        if (distinct) {
                            throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                        }
                    }
                    catch (SQLQueryObjectException s) {
                        if (distinct) {
                            if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                                throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                            }
                        }
                        throw s;
                    }
                    if (distinct) break block249;
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index = 0;
                    if (rs.next()) {
                        if (!(index != 0 && index != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                            throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                        }
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                        while (rs.next()) {
                            ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index != limit) {
                        throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                    }
                    rs.close();
                    rs = null;
                    stmtQuery.close();
                    stmtQuery = null;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (Exception sqlQueryObject10) {}
                    try {
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    catch (Exception sqlQueryObject10) {}
                }
            }
            try {
                ClientTest.info(log, systemOut, "\n\ni. ** Query con select* e offset/limit e alias");
                sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject2.addFromTable("tracce", "tr");
                sqlQueryObject2.setSelectDistinct(distinct);
                sqlQueryObject2.addWhereIsNotNullCondition("tipo_mittente");
                sqlQueryObject2.addOrderBy("mittente");
                sqlQueryObject2.addOrderBy("tipo_destinatario");
                sqlQueryObject2.addOrderBy("tr.destinatario", false);
                sqlQueryObject2.setSortType(true);
                limit = 10;
                sqlQueryObject2.setLimit(limit);
                sqlQueryObject2.setOffset(0);
                test = null;
                try {
                    test = sqlQueryObject2.createSQLQuery();
                    ClientTest.info(log, systemOut, "\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*LimitOffsetAlias*]:\n\t" + test);
                    if (distinct) {
                        throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                    }
                }
                catch (SQLQueryObjectException s) {
                    if (distinct) {
                        if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                            throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                        }
                    }
                    throw s;
                }
                if (distinct) break block250;
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                int index = 0;
                if (rs.next()) {
                    if (!(index != 0 && index != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                        throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                    }
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                    while (rs.next()) {
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (index != limit) {
                    throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                }
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static ISQLQueryObject prepareForUnion(ISQLQueryObject sqlQueryObject, int limit) throws SQLQueryObjectException {
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.addSelectCountField("id", "cont", true);
        sqlQueryObject.addSelectField("mittente");
        sqlQueryObject.addSelectField("destinatario");
        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
        sqlQueryObject.addOrderBy("mittente");
        sqlQueryObject.addOrderBy("destinatario", false);
        sqlQueryObject.setSortType(true);
        sqlQueryObject.addGroupBy("mittente");
        sqlQueryObject.addGroupBy("destinatario");
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(0);
        sqlQueryObject.setSelectForUpdate(false);
        return sqlQueryObject;
    }

    private static ISQLQueryObject prepareForUnionSelectForUpdate(ISQLQueryObject sqlQueryObject, int limit) throws SQLQueryObjectException {
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.addSelectField("mittente");
        sqlQueryObject.addSelectField("destinatario");
        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
        sqlQueryObject.addOrderBy("mittente");
        sqlQueryObject.addOrderBy("destinatario", false);
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(0);
        return sqlQueryObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testUnion_engine(TipiDatabase tipo, boolean count, boolean unionAll, Connection con, boolean selectForUpdate) throws Exception {
        ResultSet rs;
        Statement stmtQuery;
        block193: {
            int index;
            SQLQueryObjectCore sqlQueryObject;
            ISQLQueryObject prepare2;
            ISQLQueryObject prepare1;
            block191: {
                long cont;
                String mit;
                block190: {
                    block189: {
                        stmtQuery = null;
                        rs = null;
                        try {
                            ClientTest.info(log, systemOut, "\n\na. ** Query Union (unionCount:" + count + " unionAll:" + unionAll + ")");
                            int limit = 5;
                            prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                            sqlQueryObject.addSelectAliasField("mittente", "mit");
                            sqlQueryObject.addSelectField("cont");
                            if (!count) {
                                sqlQueryObject.addOrderBy("mittente");
                                sqlQueryObject.addOrderBy("destinatario", false);
                                sqlQueryObject.setSortType(true);
                            }
                            String test = null;
                            test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                            ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                            stmtQuery = con.createStatement();
                            rs = stmtQuery.executeQuery(test);
                            index = 0;
                            if (rs.next()) {
                                if (count) {
                                    long cont2 = rs.getLong("aliasUnion");
                                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + cont2 + "]");
                                    if (unionAll) {
                                        if (cont2 != (long)(limit * 2)) {
                                            throw new Exception("Expected " + limit * 2 + ", found " + cont2);
                                        }
                                    } else if (cont2 != (long)limit) {
                                        throw new Exception("Expected " + limit + ", found " + cont2);
                                    }
                                } else {
                                    String mit2 = rs.getString("mit");
                                    long cont3 = rs.getLong("cont");
                                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                    if (mit2.endsWith("10")) {
                                        if (cont3 != 1L) {
                                            throw new Exception("Expected 1, found " + cont3);
                                        }
                                    } else if (cont3 != 2L) {
                                        throw new Exception("Expected 2, found " + cont3);
                                    }
                                    while (rs.next()) {
                                        mit2 = rs.getString("mit");
                                        cont3 = rs.getLong("cont");
                                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                        if (mit2.endsWith("10")) {
                                            if (cont3 == 1L) continue;
                                            rs.close();
                                            rs = null;
                                            stmtQuery.close();
                                            stmtQuery = null;
                                            throw new Exception("Expected 1, found " + cont3);
                                        }
                                        if (cont3 == 2L) continue;
                                        rs.close();
                                        rs = null;
                                        stmtQuery.close();
                                        stmtQuery = null;
                                        throw new Exception("Expected 2, found " + cont3);
                                    }
                                }
                            } else {
                                throw new Exception("Test failed");
                            }
                            if (count) {
                                if (index != 1) {
                                    throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                                }
                            } else if (unionAll) {
                                if (index != limit * 2) {
                                    throw new Exception("Test failed (expected " + limit * 2 + " rows, found:" + index + ")");
                                }
                            } else if (index != limit) {
                                throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                            }
                            rs.close();
                            rs = null;
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                            }
                            catch (Exception limit) {}
                            try {
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                            }
                            catch (Exception limit) {}
                        }
                        try {
                            if (count) break block189;
                            ClientTest.info(log, systemOut, "\n\nb. ** Query Union OffSetLimit (unionCount:" + count + " unionAll:" + unionAll + ")");
                            int limit = 5;
                            prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                            sqlQueryObject.addSelectAliasField("mittente", "mit");
                            sqlQueryObject.addSelectField("cont");
                            sqlQueryObject.addOrderBy("mittente");
                            sqlQueryObject.addOrderBy("destinatario", false);
                            sqlQueryObject.setSortType(true);
                            int limitEsterno = 6;
                            int offset = 2;
                            if (!unionAll) {
                                limitEsterno /= 2;
                                offset /= 2;
                            }
                            sqlQueryObject.setLimit(limitEsterno);
                            sqlQueryObject.setOffset(offset);
                            String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                            ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSetLimit UnionAll]:\n\t" + test);
                            stmtQuery = con.createStatement();
                            rs = stmtQuery.executeQuery(test);
                            int index2 = 0;
                            if (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("cont");
                                ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (cont != 1L) {
                                        throw new Exception("Expected 1, found " + cont);
                                    }
                                } else if (cont != 2L) {
                                    throw new Exception("Expected 2, found " + cont);
                                }
                                while (rs.next()) {
                                    mit = rs.getString("mit");
                                    cont = rs.getLong("cont");
                                    ClientTest.info(log, systemOut, "riga[" + index2++ + "]= (" + mit + "):[" + cont + "]");
                                    if (mit.endsWith("10")) {
                                        if (cont == 1L) continue;
                                        rs.close();
                                        rs = null;
                                        stmtQuery.close();
                                        stmtQuery = null;
                                        throw new Exception("Expected 1, found " + cont);
                                    }
                                    if (cont == 2L) continue;
                                    rs.close();
                                    rs = null;
                                    stmtQuery.close();
                                    stmtQuery = null;
                                    throw new Exception("Expected 2, found " + cont);
                                }
                            } else {
                                throw new Exception("Test failed");
                            }
                            if (index2 != limitEsterno) {
                                throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index2 + ")");
                            }
                            rs.close();
                            rs = null;
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                            }
                            catch (Exception limit) {}
                            try {
                                if (stmtQuery != null) {
                                    stmtQuery.close();
                                    stmtQuery = null;
                                }
                            }
                            catch (Exception limit) {}
                        }
                    }
                    try {
                        if (count) break block190;
                        ClientTest.info(log, systemOut, "\n\nc. ** Query Union OffSet (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectField("cont");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("destinatario", false);
                        sqlQueryObject.setSortType(true);
                        int offset = 2;
                        if (!unionAll) {
                            offset /= 2;
                        }
                        int numeroEntriesRisultato = limit * 2 - offset;
                        if (!unionAll) {
                            numeroEntriesRisultato = limit - offset;
                        }
                        sqlQueryObject.setOffset(offset);
                        String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test);
                        int index3 = 0;
                        if (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("cont");
                            ClientTest.info(log, systemOut, "riga[" + index3++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont != 1L) {
                                    throw new Exception("Expected 1, found " + cont);
                                }
                            } else if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                            while (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("cont");
                                ClientTest.info(log, systemOut, "riga[" + index3++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (cont == 1L) continue;
                                    throw new Exception("Expected 1, found " + cont);
                                }
                                if (cont == 2L) continue;
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index3 != numeroEntriesRisultato) {
                            throw new Exception("Test failed (expected " + numeroEntriesRisultato + " rows, found:" + index3 + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception limit) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception limit) {}
                    }
                }
                try {
                    if (count) break block191;
                    ClientTest.info(log, systemOut, "\n\nd. ** Query Union Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject.addSelectAliasField("mittente", "mit");
                    sqlQueryObject.addSelectField("cont");
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                    int limitEsterno = 4;
                    if (!unionAll) {
                        limitEsterno /= 2;
                    }
                    sqlQueryObject.setLimit(limitEsterno);
                    String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                    ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index4 = 0;
                    boolean foundEndsWith10 = false;
                    if (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("cont");
                        ClientTest.info(log, systemOut, "riga[" + index4++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            foundEndsWith10 = true;
                            if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("cont");
                            ClientTest.info(log, systemOut, "riga[" + index4++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont == 1L) continue;
                                rs.close();
                                rs = null;
                                stmtQuery.close();
                                stmtQuery = null;
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (cont == 2L) continue;
                            rs.close();
                            rs = null;
                            stmtQuery.close();
                            stmtQuery = null;
                            throw new Exception("Expected 2, found " + cont);
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index4 != limitEsterno) {
                        throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index4 + ")");
                    }
                    if (foundEndsWith10) {
                        throw new Exception("Test failed, unexpected element ends with 10");
                    }
                    rs.close();
                    rs = null;
                    stmtQuery.close();
                    stmtQuery = null;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (Exception limit) {}
                    try {
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    catch (Exception limit) {}
                }
            }
            try {
                ClientTest.info(log, systemOut, "\n\ne. ** Query Union con select* (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                if (!count) {
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                }
                String test = null;
                test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                index = 0;
                if (rs.next()) {
                    if (count) {
                        long cont = rs.getLong("aliasUnion");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + cont + "]");
                        if (unionAll) {
                            if (cont != (long)(limit * 2)) {
                                throw new Exception("Expected " + limit * 2 + ", found " + cont);
                            }
                        } else if (cont != (long)limit) {
                            throw new Exception("Expected " + limit + ", found " + cont);
                        }
                    } else {
                        String mit = rs.getString("mittente");
                        long cont = rs.getLong("cont");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mittente");
                            cont = rs.getLong("cont");
                            ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont == 1L) continue;
                                rs.close();
                                rs = null;
                                stmtQuery.close();
                                stmtQuery = null;
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (cont == 2L) continue;
                            rs.close();
                            rs = null;
                            stmtQuery.close();
                            stmtQuery = null;
                            throw new Exception("Expected 2, found " + cont);
                        }
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (count) {
                    if (index != 1) {
                        throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                    }
                } else if (unionAll) {
                    if (index != limit * 2) {
                        throw new Exception("Test failed (expected " + limit * 2 + " rows, found:" + index + ")");
                    }
                } else if (index != limit) {
                    throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                }
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception limit) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception limit) {}
            }
            if (!count) {
                String msgOffset = "Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union";
                String msgLimit = "Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union";
                ClientTest.info(log, systemOut, "\n\nf. ** Query Union con select* e LimitOffset (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                ISQLQueryObject prepare12 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                ISQLQueryObject prepare22 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                SQLQueryObjectCore sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject2.addOrderBy("mittente");
                sqlQueryObject2.addOrderBy("destinatario", false);
                sqlQueryObject2.setSortType(true);
                sqlQueryObject2.setLimit(10);
                sqlQueryObject2.setOffset(2);
                try {
                    ClientTest.info(log, systemOut, "[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                    throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                }
                catch (SQLQueryObjectException s) {
                    if (!s.getMessage().equals(msgOffset)) {
                        throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s.getMessage() + "]");
                    }
                    ClientTest.info(log, systemOut, "\n\ng. ** Query Union con select* e Offset (unionCount:" + count + " unionAll:" + unionAll + ")");
                    sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.addOrderBy("destinatario", false);
                    sqlQueryObject2.setSortType(true);
                    sqlQueryObject2.setOffset(2);
                    try {
                        ClientTest.info(log, systemOut, "[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                        throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                    }
                    catch (SQLQueryObjectException s2) {
                        if (!s2.getMessage().equals(msgOffset)) {
                            throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s2.getMessage() + "]");
                        }
                        ClientTest.info(log, systemOut, "\n\nh. ** Query Union con select* e Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setLimit(10);
                        try {
                            ClientTest.info(log, systemOut, "[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                            throw new Exception("Attesa eccezione: Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
                        }
                        catch (SQLQueryObjectException s3) {
                            if (s3.getMessage().equals(msgLimit) || s3.getMessage().equals(msgOffset)) break block193;
                            throw new Exception("Attesa eccezione: [" + msgLimit + "] oppure [" + msgOffset + "]. Trovata: [" + s3.getMessage() + "]");
                        }
                    }
                }
            }
        }
        if (selectForUpdate) {
            boolean findError = false;
            try {
                ClientTest.info(log, systemOut, "\n\ni. ** Query Union per test SelectForUpdate (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                ISQLQueryObject prepare1 = ClientTest.prepareForUnionSelectForUpdate(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                ISQLQueryObject prepare2 = ClientTest.prepareForUnionSelectForUpdate(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject.addSelectAliasField("mittente", "mit");
                sqlQueryObject.addSelectAliasField("destinatario", "dest");
                if (!count) {
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                }
                String test = null;
                test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
            }
            catch (Exception e) {
                findError = true;
                ClientTest.info(log, systemOut, "ERRORE ATTESO: " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception exception) {}
            }
            if (!findError) {
                throw new Exception("Atteso errore utilizzo select for update non permesso in union");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testUnionWithGroupBy_engine(TipiDatabase tipo, boolean count, boolean unionAll, Connection con, boolean selectForUpdate) throws Exception {
        SQLQueryObjectCore sqlQueryObject;
        ISQLQueryObject prepare2;
        ISQLQueryObject prepare1;
        block160: {
            long cont;
            String mit;
            ResultSet rs;
            Statement stmtQuery;
            block159: {
                block158: {
                    stmtQuery = null;
                    rs = null;
                    try {
                        ClientTest.info(log, systemOut, "\n\na. ** Query UnionGroupBy (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                        if (!count) {
                            sqlQueryObject.addOrderBy("mittente");
                            sqlQueryObject.addOrderBy("destinatario", false);
                            sqlQueryObject.setSortType(true);
                        }
                        sqlQueryObject.addGroupBy("mittente");
                        sqlQueryObject.addGroupBy("destinatario");
                        String test = null;
                        test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                        stmtQuery = con.createStatement();
                        if (stmtQuery == null) {
                            throw new Exception("Statement is null");
                        }
                        rs = stmtQuery.executeQuery(test);
                        int index = 0;
                        if (rs.next()) {
                            if (count) {
                                long cont2 = rs.getLong("aliasUnion");
                                ClientTest.info(log, systemOut, "riga[" + index++ + "]= [" + cont2 + "]");
                                if (cont2 != (long)limit) {
                                    throw new Exception("Expected " + limit + ", found " + cont2);
                                }
                            } else {
                                String mit2 = rs.getString("mit");
                                long cont3 = rs.getLong("contRisultatoGroupBy");
                                ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                if (mit2.endsWith("10")) {
                                    if (unionAll) {
                                        if (cont3 != 2L) {
                                            throw new Exception("Expected 2, found " + cont3);
                                        }
                                    } else if (cont3 != 1L) {
                                        throw new Exception("Expected 1, found " + cont3);
                                    }
                                } else if (unionAll) {
                                    if (cont3 != 4L) {
                                        throw new Exception("Expected 4, found " + cont3);
                                    }
                                } else if (cont3 != 2L) {
                                    throw new Exception("Expected 2, found " + cont3);
                                }
                                while (rs.next()) {
                                    mit2 = rs.getString("mit");
                                    cont3 = rs.getLong("contRisultatoGroupBy");
                                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                    if (mit2.endsWith("10")) {
                                        if (unionAll) {
                                            if (cont3 == 2L) continue;
                                            rs.close();
                                            rs = null;
                                            stmtQuery.close();
                                            stmtQuery = null;
                                            throw new Exception("Expected 2, found " + cont3);
                                        }
                                        if (cont3 == 1L) continue;
                                        rs.close();
                                        rs = null;
                                        stmtQuery.close();
                                        stmtQuery = null;
                                        throw new Exception("Expected 1, found " + cont3);
                                    }
                                    if (unionAll) {
                                        if (cont3 == 4L) continue;
                                        rs.close();
                                        rs = null;
                                        stmtQuery.close();
                                        stmtQuery = null;
                                        throw new Exception("Expected 4, found " + cont3);
                                    }
                                    if (cont3 == 2L) continue;
                                    rs.close();
                                    rs = null;
                                    stmtQuery.close();
                                    stmtQuery = null;
                                    throw new Exception("Expected 2, found " + cont3);
                                }
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (count) {
                            if (index != 1) {
                                throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                            }
                        } else if (index != limit) {
                            throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception limit) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception limit) {}
                    }
                    try {
                        if (count) break block158;
                        ClientTest.info(log, systemOut, "\n\nb. ** Query UnionGroupBy OffSetLimit (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                        sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("destinatario", false);
                        sqlQueryObject.setSortType(true);
                        sqlQueryObject.addGroupBy("mittente");
                        sqlQueryObject.addGroupBy("destinatario");
                        int limitEsterno = 6;
                        int offset = 2;
                        sqlQueryObject.setLimit(limitEsterno /= 2);
                        sqlQueryObject.setOffset(offset /= 2);
                        String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSetLimit UnionAll]:\n\t" + test);
                        stmtQuery = con.createStatement();
                        if (stmtQuery == null) {
                            throw new Exception("Statement is null");
                        }
                        rs = stmtQuery.executeQuery(test);
                        int index = 0;
                        if (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("contRisultatoGroupBy");
                            ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (unionAll) {
                                    if (cont != 2L) {
                                        throw new Exception("Expected 2, found " + cont);
                                    }
                                } else if (cont != 1L) {
                                    throw new Exception("Expected 1, found " + cont);
                                }
                            } else if (unionAll) {
                                if (cont != 4L) {
                                    throw new Exception("Expected 4, found " + cont);
                                }
                            } else if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                            while (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("contRisultatoGroupBy");
                                ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (unionAll) {
                                        if (cont == 2L) continue;
                                        rs.close();
                                        rs = null;
                                        stmtQuery.close();
                                        stmtQuery = null;
                                        throw new Exception("Expected 2, found " + cont);
                                    }
                                    if (cont == 1L) continue;
                                    rs.close();
                                    rs = null;
                                    stmtQuery.close();
                                    stmtQuery = null;
                                    throw new Exception("Expected 1, found " + cont);
                                }
                                if (unionAll) {
                                    if (cont == 4L) continue;
                                    rs.close();
                                    rs = null;
                                    stmtQuery.close();
                                    stmtQuery = null;
                                    throw new Exception("Expected 4, found " + cont);
                                }
                                if (cont == 2L) continue;
                                rs.close();
                                rs = null;
                                stmtQuery.close();
                                stmtQuery = null;
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index != limitEsterno) {
                            throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index + ")");
                        }
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception limit) {}
                        try {
                            if (stmtQuery != null) {
                                stmtQuery.close();
                                stmtQuery = null;
                            }
                        }
                        catch (Exception limit) {}
                    }
                }
                try {
                    if (count) break block159;
                    ClientTest.info(log, systemOut, "\n\nc. ** Query UnionGroupBy  OffSet (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject.addSelectAliasField("mittente", "mit");
                    sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("destinatario", false);
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.addGroupBy("mittente");
                    sqlQueryObject.addGroupBy("destinatario");
                    int offset = 2;
                    int numeroEntriesRisultato = limit * 2 - (offset /= 2);
                    numeroEntriesRisultato = limit - offset;
                    sqlQueryObject.setOffset(offset);
                    String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                    ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                    if ((stmtQuery = con.createStatement()) == null) {
                        throw new Exception("Statement is null");
                    }
                    rs = stmtQuery.executeQuery(test);
                    int index = 0;
                    if (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("contRisultatoGroupBy");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (unionAll) {
                                if (cont != 2L) {
                                    throw new Exception("Expected 2, found " + cont);
                                }
                            } else if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (unionAll) {
                            if (cont != 4L) {
                                throw new Exception("Expected 4, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("contRisultatoGroupBy");
                            ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (unionAll) {
                                    if (cont == 2L) continue;
                                    throw new Exception("Expected 2, found " + cont);
                                }
                                if (cont == 1L) continue;
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (unionAll) {
                                if (cont == 4L) continue;
                                throw new Exception("Expected 4, found " + cont);
                            }
                            if (cont == 2L) continue;
                            throw new Exception("Expected 2, found " + cont);
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index != numeroEntriesRisultato) {
                        throw new Exception("Test failed (expected " + numeroEntriesRisultato + " rows, found:" + index + ")");
                    }
                    rs.close();
                    rs = null;
                    stmtQuery.close();
                    stmtQuery = null;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    catch (Exception limit) {}
                    try {
                        if (stmtQuery != null) {
                            stmtQuery.close();
                            stmtQuery = null;
                        }
                    }
                    catch (Exception limit) {}
                }
            }
            try {
                if (count) break block160;
                ClientTest.info(log, systemOut, "\n\nd. ** Query UnionGroupBy Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
                sqlQueryObject.addSelectAliasField("mittente", "mit");
                sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                sqlQueryObject.addOrderBy("mittente");
                sqlQueryObject.addOrderBy("destinatario", false);
                sqlQueryObject.setSortType(true);
                sqlQueryObject.addGroupBy("mittente");
                sqlQueryObject.addGroupBy("destinatario");
                int limitEsterno = 4;
                sqlQueryObject.setLimit(limitEsterno /= 2);
                String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
                if ((stmtQuery = con.createStatement()) == null) {
                    throw new Exception("Statement is null");
                }
                rs = stmtQuery.executeQuery(test);
                int index = 0;
                boolean foundEndsWith10 = false;
                if (rs.next()) {
                    mit = rs.getString("mit");
                    cont = rs.getLong("contRisultatoGroupBy");
                    ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                    if (mit.endsWith("10")) {
                        if (unionAll) {
                            if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else if (cont != 1L) {
                            throw new Exception("Expected 1, found " + cont);
                        }
                    } else if (unionAll) {
                        if (cont != 4L) {
                            throw new Exception("Expected 4, found " + cont);
                        }
                    } else if (cont != 2L) {
                        throw new Exception("Expected 2, found " + cont);
                    }
                    while (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("contRisultatoGroupBy");
                        ClientTest.info(log, systemOut, "riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (unionAll) {
                                if (cont == 2L) continue;
                                rs.close();
                                rs = null;
                                stmtQuery.close();
                                stmtQuery = null;
                                throw new Exception("Expected 2, found " + cont);
                            }
                            if (cont == 1L) continue;
                            rs.close();
                            rs = null;
                            stmtQuery.close();
                            stmtQuery = null;
                            throw new Exception("Expected 1, found " + cont);
                        }
                        if (unionAll) {
                            if (cont == 4L) continue;
                            rs.close();
                            rs = null;
                            stmtQuery.close();
                            stmtQuery = null;
                            throw new Exception("Expected 4, found " + cont);
                        }
                        if (cont == 2L) continue;
                        rs.close();
                        rs = null;
                        stmtQuery.close();
                        stmtQuery = null;
                        throw new Exception("Expected 2, found " + cont);
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (index != limitEsterno) {
                    throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index + ")");
                }
                if (foundEndsWith10) {
                    throw new Exception("Test failed, unexpected element ends with 10");
                }
                rs.close();
                rs = null;
                stmtQuery.close();
                stmtQuery = null;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception limit) {}
                try {
                    if (stmtQuery != null) {
                        stmtQuery.close();
                        stmtQuery = null;
                    }
                }
                catch (Exception limit) {}
            }
        }
        try {
            ClientTest.info(log, systemOut, "\n\ne. ** Query UnionGroupBy con select* (unionCount:" + count + " unionAll:" + unionAll + ")");
            int limit = 5;
            prepare1 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
            prepare2 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, false);
            if (!count) {
                sqlQueryObject.addOrderBy("mittente");
                sqlQueryObject.addOrderBy("destinatario", false);
                sqlQueryObject.setSortType(true);
            }
            sqlQueryObject.addGroupBy("mittente");
            sqlQueryObject.addGroupBy("destinatario");
            String test = null;
            test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
            ClientTest.info(log, systemOut, "\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
            throw new Exception("Attesa eccezione: Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field");
        }
        catch (SQLQueryObjectException s) {
            block161: {
                if (!s.getMessage().equals("Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field")) {
                    throw new Exception("Attesa eccezione: Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field. Trovata: " + s.getMessage());
                }
                if (!count) {
                    String msgOffset = "Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union";
                    String msgLimit = "Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union";
                    ClientTest.info(log, systemOut, "\n\nf. ** Query UnionGroupBy con select* e LimitOffset (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    ISQLQueryObject prepare12 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    ISQLQueryObject prepare22 = ClientTest.prepareForUnion(ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate), limit);
                    SQLQueryObjectCore sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.addOrderBy("destinatario", false);
                    sqlQueryObject2.setSortType(true);
                    sqlQueryObject2.setLimit(10);
                    sqlQueryObject2.setOffset(2);
                    sqlQueryObject2.addGroupBy("mittente");
                    sqlQueryObject2.addGroupBy("destinatario");
                    try {
                        ClientTest.info(log, systemOut, "[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                        throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                    }
                    catch (SQLQueryObjectException s2) {
                        if (!s2.getMessage().equals(msgOffset)) {
                            throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s2.getMessage() + "]");
                        }
                        ClientTest.info(log, systemOut, "\n\ng. ** Query UnionGroupBy con select* e Offset (unionCount:" + count + " unionAll:" + unionAll + ")");
                        sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.addOrderBy("destinatario", false);
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setOffset(2);
                        sqlQueryObject2.addGroupBy("mittente");
                        sqlQueryObject2.addGroupBy("destinatario");
                        try {
                            ClientTest.info(log, systemOut, "[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                            throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                        }
                        catch (SQLQueryObjectException s3) {
                            if (!s3.getMessage().equals(msgOffset)) {
                                throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s3.getMessage() + "]");
                            }
                            ClientTest.info(log, systemOut, "\n\nh. ** Query UnionGroupBy con select* e Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                            sqlQueryObject2 = ClientTest.createSQLQueryObjectCore(tipo, false);
                            sqlQueryObject2.addOrderBy("mittente");
                            sqlQueryObject2.addOrderBy("destinatario", false);
                            sqlQueryObject2.setSortType(true);
                            sqlQueryObject2.setLimit(10);
                            sqlQueryObject2.addGroupBy("mittente");
                            sqlQueryObject2.addGroupBy("destinatario");
                            try {
                                ClientTest.info(log, systemOut, "[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                                throw new Exception("Attesa eccezione: Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
                            }
                            catch (SQLQueryObjectException s4) {
                                if (s4.getMessage().equals(msgLimit) || s4.getMessage().equals(msgOffset)) break block161;
                                throw new Exception("Attesa eccezione: [" + msgLimit + "] oppure [" + msgOffset + "]. Trovata: [" + s4.getMessage() + "]");
                            }
                        }
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testEmptyNull_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            ClientTest.info(log, systemOut, "\n\nh. ** Test IS NULL / IS EMPTY");
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsNullCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsNull = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " isNull:\n\t" + testIsNull);
            stmtQuery = con.prepareStatement(testIsNull);
            rs = stmtQuery.executeQuery();
            int index = 0;
            while (rs.next()) {
                ClientTest.info(log, systemOut, "riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            int attesi = 10;
            if (TipiDatabase.ORACLE.equals((Object)tipo)) {
                attesi = 19;
            }
            ClientTest.info(log, systemOut, "Attesi [" + attesi + "] trovati[" + index + "]");
            if (attesi != index) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + index + "]");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsNotNullCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsNotNull = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest2-" + table + " isNotNull:\n\t" + testIsNotNull);
            stmtQuery = con.prepareStatement(testIsNotNull);
            rs = stmtQuery.executeQuery();
            int index2 = 0;
            while (rs.next()) {
                ClientTest.info(log, systemOut, "riga[" + index2++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            int attesi2 = 11;
            if (TipiDatabase.ORACLE.equals((Object)tipo)) {
                attesi2 = 2;
            }
            ClientTest.info(log, systemOut, "Attesi [" + attesi2 + "] trovati[" + index2 + "]");
            if (attesi2 != index2) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + index2 + "]");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsEmptyCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsEmpty = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest3-" + table + " isEmpty:\n\t" + testIsEmpty);
            stmtQuery = con.prepareStatement(testIsEmpty);
            rs = stmtQuery.executeQuery();
            int index3 = 0;
            while (rs.next()) {
                ClientTest.info(log, systemOut, "riga[" + index3++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            int attesi3 = 9;
            if (TipiDatabase.ORACLE.equals((Object)tipo)) {
                attesi3 = 19;
            }
            ClientTest.info(log, systemOut, "Attesi [" + attesi3 + "] trovati[" + index3 + "]");
            if (attesi3 != index3) {
                throw new Exception("Attesi [" + attesi3 + "] trovati[" + index3 + "]");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addWhereIsNotEmptyCondition("campo_vuoto");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testIsNotEmpty = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest4-" + table + " isNotEmpty:\n\t" + testIsNotEmpty);
            stmtQuery = con.prepareStatement(testIsNotEmpty);
            rs = stmtQuery.executeQuery();
            int index4 = 0;
            while (rs.next()) {
                ClientTest.info(log, systemOut, "riga[" + index4++ + "]=" + rs.getString("descrizione") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + " campo_vuoto:(" + rs.getString("campo_vuoto") + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            int attesi4 = 2;
            if (TipiDatabase.ORACLE.equals((Object)tipo)) {
                attesi4 = 2;
            }
            ClientTest.info(log, systemOut, "Attesi [" + attesi4 + "] trovati[" + index4 + "]");
            if (attesi4 != index4) {
                throw new Exception("Attesi [" + attesi4 + "] trovati[" + index4 + "]");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCase_engine(TipiDatabase tipo, String table, Connection con, boolean selectForUpdate) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            int valoreInt;
            ClientTest.info(log, systemOut, "\n\nh. ** Test CASE");
            SQLQueryObjectCore sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("mittente");
            sqlQueryObject.addSelectField("destinatario");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.addWhereIsNullCondition("campo_update");
            sqlQueryObject.addWhereIsNullCondition("campo_int_update");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSortType(true);
            String testQuery = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + testQuery);
            stmtQuery = con.prepareStatement(testQuery);
            rs = stmtQuery.executeQuery();
            int index = 0;
            while (rs.next()) {
                ClientTest.info(log, systemOut, "riga[" + index++ + "] mittente:" + rs.getString("mittente") + " destinatario:" + rs.getString("destinatario") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            int attesi = ROW;
            ClientTest.info(log, systemOut, "Attesi [" + attesi + "] trovati[" + index + "]");
            if (attesi != index) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + index + "]");
            }
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addUpdateTable(table);
            Case caseSql = new Case(CastColumnType.STRING, false, "?");
            caseSql.addCase("mittente=?", "?");
            caseSql.addCase("mittente=?", "?");
            sqlQueryObject.addUpdateField("campo_update", caseSql);
            Case caseSqlInt = new Case(CastColumnType.INT, false, "?");
            caseSqlInt.addCase("mittente=? OR destinatario=?", "?");
            caseSqlInt.addCase("mittente=? OR destinatario=?", "?");
            sqlQueryObject.addUpdateField("campo_int_update", caseSqlInt);
            String update = sqlQueryObject.createSQLUpdate();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + update);
            stmtQuery = con.prepareStatement(update);
            int index2 = 1;
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "CASO_0");
            stmtQuery.setString(index2++, "SoggettoMittente1");
            stmtQuery.setString(index2++, "CASO_1");
            stmtQuery.setString(index2++, "CASO_DEFAULT");
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "SoggettoDestinatario1");
            stmtQuery.setInt(index2++, 22);
            stmtQuery.setString(index2++, "SoggettoMittente2");
            stmtQuery.setString(index2++, "SoggettoDestinatario3");
            stmtQuery.setInt(index2++, 33);
            stmtQuery.setInt(index2++, 11);
            stmtQuery.executeUpdate();
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("mittente");
            sqlQueryObject.addSelectField("destinatario");
            sqlQueryObject.addSelectField("campo_update");
            sqlQueryObject.addSelectField("campo_int_update");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.addWhereIsNotNullCondition("campo_update");
            sqlQueryObject.addWhereIsNotNullCondition("campo_int_update");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSortType(true);
            testQuery = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + testQuery);
            stmtQuery = con.prepareStatement(testQuery);
            rs = stmtQuery.executeQuery();
            int index3 = 0;
            int stringCasoA = 0;
            int stringCasoB = 0;
            int stringCasoDefault = 0;
            int intCasoA = 0;
            int intCasoB = 0;
            int intCasoDefault = 0;
            while (rs.next()) {
                String valoreString = rs.getString("campo_update");
                valoreInt = rs.getInt("campo_int_update");
                if ("CASO_0".equals(valoreString)) {
                    ++stringCasoA;
                } else if ("CASO_1".equals(valoreString)) {
                    ++stringCasoB;
                } else if ("CASO_DEFAULT".equals(valoreString)) {
                    ++stringCasoDefault;
                }
                if (valoreInt == 22) {
                    ++intCasoA;
                } else if (valoreInt == 33) {
                    ++intCasoB;
                } else if (valoreInt == 11) {
                    ++intCasoDefault;
                }
                ClientTest.info(log, systemOut, "riga[" + index3++ + "] (string:" + valoreString + " int:" + valoreInt + ") mittente:" + rs.getString("mittente") + " destinatario:" + rs.getString("destinatario") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            int attesi2 = ROW;
            ClientTest.info(log, systemOut, "Attesi [" + attesi2 + "] trovati[" + index3 + "]");
            if (attesi2 != index3) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + index3 + "]");
            }
            attesi2 = 2;
            int trovati = stringCasoA;
            ClientTest.info(log, systemOut, "(stringCasoA) Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            if (attesi2 != trovati) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            }
            attesi2 = 2;
            trovati = stringCasoB;
            ClientTest.info(log, systemOut, "(stringCasoB) Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            if (attesi2 != trovati) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            }
            attesi2 = ROW - 4;
            trovati = stringCasoDefault;
            ClientTest.info(log, systemOut, "(stringCasoDefault) Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            if (attesi2 != trovati) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            }
            attesi2 = 4;
            trovati = intCasoA;
            ClientTest.info(log, systemOut, "(intCasoA) Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            if (attesi2 != trovati) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            }
            attesi2 = 4;
            trovati = intCasoB;
            ClientTest.info(log, systemOut, "(intCasoB) Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            if (attesi2 != trovati) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            }
            attesi2 = ROW - 8;
            trovati = intCasoDefault;
            ClientTest.info(log, systemOut, "(intCasoDefault) Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            if (attesi2 != trovati) {
                throw new Exception("Attesi [" + attesi2 + "] trovati[" + trovati + "]");
            }
            ClientTest.info(log, systemOut, "\n\nh. ** Test CASE SENZA ELSE");
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addUpdateTable(table);
            sqlQueryObject.addUpdateField("campo_update", "?");
            sqlQueryObject.addUpdateField("campo_int_update", "?");
            update = sqlQueryObject.createSQLUpdate();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + update);
            stmtQuery = con.prepareStatement(update);
            index2 = 1;
            stmtQuery.setString(index2++, null);
            stmtQuery.setInt(index2++, -1);
            stmtQuery.executeUpdate();
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addUpdateTable(table);
            caseSql = new Case(CastColumnType.STRING);
            caseSql.addCase("mittente=?", "?");
            caseSql.addCase("mittente=?", "?");
            sqlQueryObject.addUpdateField("campo_update", caseSql);
            caseSqlInt = new Case(CastColumnType.INT);
            caseSqlInt.addCase("mittente=? OR destinatario=?", "?");
            caseSqlInt.addCase("mittente=? OR destinatario=?", "?");
            sqlQueryObject.addUpdateField("campo_int_update", caseSqlInt);
            update = sqlQueryObject.createSQLUpdate();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + update);
            stmtQuery = con.prepareStatement(update);
            index2 = 1;
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "CASO_0");
            stmtQuery.setString(index2++, "SoggettoMittente1");
            stmtQuery.setString(index2++, "CASO_1");
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "SoggettoDestinatario1");
            stmtQuery.setInt(index2++, 22);
            stmtQuery.setString(index2++, "SoggettoMittente2");
            stmtQuery.setString(index2++, "SoggettoDestinatario3");
            stmtQuery.setInt(index2++, 33);
            stmtQuery.executeUpdate();
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("mittente");
            sqlQueryObject.addSelectField("destinatario");
            sqlQueryObject.addSelectField("campo_update");
            sqlQueryObject.addSelectField("campo_int_update");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSortType(true);
            testQuery = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + testQuery);
            stmtQuery = con.prepareStatement(testQuery);
            rs = stmtQuery.executeQuery();
            index = 0;
            stringCasoA = 0;
            stringCasoB = 0;
            stringCasoDefault = 0;
            intCasoA = 0;
            intCasoB = 0;
            intCasoDefault = 0;
            while (rs.next()) {
                String valoreString = rs.getString("campo_update");
                valoreInt = rs.getInt("campo_int_update");
                if ("CASO_0".equals(valoreString)) {
                    ++stringCasoA;
                } else if ("CASO_1".equals(valoreString)) {
                    ++stringCasoB;
                } else if ("CASO_DEFAULT".equals(valoreString)) {
                    ++stringCasoDefault;
                }
                if (valoreInt == 22) {
                    ++intCasoA;
                } else if (valoreInt == 33) {
                    ++intCasoB;
                } else if (valoreInt == 11) {
                    ++intCasoDefault;
                }
                ClientTest.info(log, systemOut, "riga[" + index++ + "] (string:" + valoreString + " int:" + valoreInt + ") mittente:" + rs.getString("mittente") + " destinatario:" + rs.getString("destinatario") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            attesi = ROW;
            ClientTest.info(log, systemOut, "Attesi [" + attesi + "] trovati[" + index + "]");
            if (attesi != index) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + index + "]");
            }
            attesi = 2;
            trovati = stringCasoA;
            ClientTest.info(log, systemOut, "(stringCasoA) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 2;
            trovati = stringCasoB;
            ClientTest.info(log, systemOut, "(stringCasoB) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 0;
            trovati = stringCasoDefault;
            ClientTest.info(log, systemOut, "(stringCasoDefault) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 4;
            trovati = intCasoA;
            ClientTest.info(log, systemOut, "(intCasoA) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 4;
            trovati = intCasoB;
            ClientTest.info(log, systemOut, "(intCasoB) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 0;
            trovati = intCasoDefault;
            ClientTest.info(log, systemOut, "(intCasoDefault) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            ClientTest.info(log, systemOut, "\n\nh. ** Test CASE senza ?");
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addUpdateTable(table);
            sqlQueryObject.addUpdateField("campo_update", "?");
            sqlQueryObject.addUpdateField("campo_int_update", "?");
            update = sqlQueryObject.createSQLUpdate();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + update);
            stmtQuery = con.prepareStatement(update);
            index2 = 1;
            stmtQuery.setString(index2++, null);
            stmtQuery.setInt(index2++, -1);
            stmtQuery.executeUpdate();
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addUpdateTable(table);
            caseSql = new Case(CastColumnType.STRING, true, "CASO_DEFAULT");
            caseSql.addCase("mittente=?", "CASO_0");
            caseSql.addCase("mittente=?", "CASO_1");
            sqlQueryObject.addUpdateField("campo_update", caseSql);
            caseSqlInt = new Case(CastColumnType.INT, false, "11");
            caseSqlInt.addCase("mittente=? OR destinatario=?", "22");
            caseSqlInt.addCase("mittente=? OR destinatario=?", "33");
            sqlQueryObject.addUpdateField("campo_int_update", caseSqlInt);
            update = sqlQueryObject.createSQLUpdate();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + update);
            stmtQuery = con.prepareStatement(update);
            index2 = 1;
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "SoggettoMittente1");
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "SoggettoDestinatario1");
            stmtQuery.setString(index2++, "SoggettoMittente2");
            stmtQuery.setString(index2++, "SoggettoDestinatario3");
            stmtQuery.executeUpdate();
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("mittente");
            sqlQueryObject.addSelectField("destinatario");
            sqlQueryObject.addSelectField("campo_update");
            sqlQueryObject.addSelectField("campo_int_update");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.addWhereIsNotNullCondition("campo_update");
            sqlQueryObject.addWhereIsNotNullCondition("campo_int_update");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSortType(true);
            testQuery = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + testQuery);
            stmtQuery = con.prepareStatement(testQuery);
            rs = stmtQuery.executeQuery();
            index = 0;
            stringCasoA = 0;
            stringCasoB = 0;
            stringCasoDefault = 0;
            intCasoA = 0;
            intCasoB = 0;
            intCasoDefault = 0;
            while (rs.next()) {
                String valoreString = rs.getString("campo_update");
                valoreInt = rs.getInt("campo_int_update");
                if ("CASO_0".equals(valoreString)) {
                    ++stringCasoA;
                } else if ("CASO_1".equals(valoreString)) {
                    ++stringCasoB;
                } else if ("CASO_DEFAULT".equals(valoreString)) {
                    ++stringCasoDefault;
                }
                if (valoreInt == 22) {
                    ++intCasoA;
                } else if (valoreInt == 33) {
                    ++intCasoB;
                } else if (valoreInt == 11) {
                    ++intCasoDefault;
                }
                ClientTest.info(log, systemOut, "riga[" + index++ + "] (string:" + valoreString + " int:" + valoreInt + ") mittente:" + rs.getString("mittente") + " destinatario:" + rs.getString("destinatario") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            attesi = ROW;
            ClientTest.info(log, systemOut, "Attesi [" + attesi + "] trovati[" + index + "]");
            if (attesi != index) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + index + "]");
            }
            attesi = 2;
            trovati = stringCasoA;
            ClientTest.info(log, systemOut, "(stringCasoA) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 2;
            trovati = stringCasoB;
            ClientTest.info(log, systemOut, "(stringCasoB) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = ROW - 4;
            trovati = stringCasoDefault;
            ClientTest.info(log, systemOut, "(stringCasoDefault) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 4;
            trovati = intCasoA;
            ClientTest.info(log, systemOut, "(intCasoA) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 4;
            trovati = intCasoB;
            ClientTest.info(log, systemOut, "(intCasoB) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = ROW - 8;
            trovati = intCasoDefault;
            ClientTest.info(log, systemOut, "(intCasoDefault) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            ClientTest.info(log, systemOut, "\n\nh. ** Test CASE SENZA ELSE senza ?");
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addUpdateTable(table);
            sqlQueryObject.addUpdateField("campo_update", "?");
            sqlQueryObject.addUpdateField("campo_int_update", "?");
            update = sqlQueryObject.createSQLUpdate();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + update);
            stmtQuery = con.prepareStatement(update);
            index2 = 1;
            stmtQuery.setString(index2++, null);
            stmtQuery.setInt(index2++, -1);
            stmtQuery.executeUpdate();
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addUpdateTable(table);
            caseSql = new Case(CastColumnType.STRING);
            caseSql.setStringValueType(true);
            caseSql.addCase("mittente=?", "CASO_0");
            caseSql.addCase("mittente=?", "CASO_1");
            sqlQueryObject.addUpdateField("campo_update", caseSql);
            caseSqlInt = new Case(CastColumnType.INT);
            caseSqlInt.addCase("mittente=? OR destinatario=?", "22");
            caseSqlInt.addCase("mittente=? OR destinatario=?", "33");
            sqlQueryObject.addUpdateField("campo_int_update", caseSqlInt);
            update = sqlQueryObject.createSQLUpdate();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + update);
            stmtQuery = con.prepareStatement(update);
            index2 = 1;
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "SoggettoMittente1");
            stmtQuery.setString(index2++, "SoggettoMittente0");
            stmtQuery.setString(index2++, "SoggettoDestinatario1");
            stmtQuery.setString(index2++, "SoggettoMittente2");
            stmtQuery.setString(index2++, "SoggettoDestinatario3");
            stmtQuery.executeUpdate();
            sqlQueryObject = ClientTest.createSQLQueryObjectCore(tipo, selectForUpdate);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("campo_vuoto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("mittente");
            sqlQueryObject.addSelectField("destinatario");
            sqlQueryObject.addSelectField("campo_update");
            sqlQueryObject.addSelectField("campo_int_update");
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSortType(true);
            testQuery = sqlQueryObject.createSQLQuery();
            ClientTest.info(log, systemOut, "\ntest1-" + table + " case:\n\t" + testQuery);
            stmtQuery = con.prepareStatement(testQuery);
            rs = stmtQuery.executeQuery();
            index = 0;
            stringCasoA = 0;
            stringCasoB = 0;
            stringCasoDefault = 0;
            intCasoA = 0;
            intCasoB = 0;
            intCasoDefault = 0;
            while (rs.next()) {
                String valoreString = rs.getString("campo_update");
                valoreInt = rs.getInt("campo_int_update");
                if ("CASO_0".equals(valoreString)) {
                    ++stringCasoA;
                } else if ("CASO_1".equals(valoreString)) {
                    ++stringCasoB;
                } else if ("CASO_DEFAULT".equals(valoreString)) {
                    ++stringCasoDefault;
                }
                if (valoreInt == 22) {
                    ++intCasoA;
                } else if (valoreInt == 33) {
                    ++intCasoB;
                } else if (valoreInt == 11) {
                    ++intCasoDefault;
                }
                ClientTest.info(log, systemOut, "riga[" + index++ + "] (string:" + valoreString + " int:" + valoreInt + ") mittente:" + rs.getString("mittente") + " destinatario:" + rs.getString("destinatario") + " (time:" + String.valueOf(rs.getTimestamp("gdo")) + ")");
            }
            rs.close();
            rs = null;
            stmtQuery.close();
            stmtQuery = null;
            attesi = ROW;
            ClientTest.info(log, systemOut, "Attesi [" + attesi + "] trovati[" + index + "]");
            if (attesi != index) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + index + "]");
            }
            attesi = 2;
            trovati = stringCasoA;
            ClientTest.info(log, systemOut, "(stringCasoA) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 2;
            trovati = stringCasoB;
            ClientTest.info(log, systemOut, "(stringCasoB) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 0;
            trovati = stringCasoDefault;
            ClientTest.info(log, systemOut, "(stringCasoDefault) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 4;
            trovati = intCasoA;
            ClientTest.info(log, systemOut, "(intCasoA) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 4;
            trovati = intCasoB;
            ClientTest.info(log, systemOut, "(intCasoB) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
            attesi = 0;
            trovati = intCasoDefault;
            ClientTest.info(log, systemOut, "(intCasoDefault) Attesi [" + attesi + "] trovati[" + trovati + "]");
            if (attesi != trovati) {
                throw new Exception("Attesi [" + attesi + "] trovati[" + trovati + "]");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                    stmtQuery = null;
                }
            }
            catch (Exception exception) {}
        }
    }
}

