/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.util.Date;
import java.util.Iterator;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.sql.CastColumnType;
import org.openspcoop2.utils.sql.DayFormatEnum;
import org.openspcoop2.utils.sql.EscapeSQLConfiguration;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class DB2QueryObject
extends SQLQueryObjectCore {
    private static final String DAY_FORMAT_FULL_DAY_NAME = "%A";
    private static final String DAY_FORMAT_SHORT_DAY_NAME = "%a";

    public DB2QueryObject(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    protected String getPrefixCastValue(CastColumnType type, int length) {
        switch (type) {
            case INT: 
            case LONG: 
            case STRING: 
            case TIMESTAMP: {
                return "CAST( ";
            }
            case NONE: {
                return "";
            }
        }
        return "";
    }

    @Override
    protected String getSuffixCastValue(CastColumnType type, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(" AS ");
        switch (type) {
            case INT: {
                sb.append("INT");
                break;
            }
            case LONG: {
                sb.append("BIGINT");
                break;
            }
            case STRING: {
                sb.append("VARCHAR");
                break;
            }
            case TIMESTAMP: {
                sb.append("TIMESTAMP");
                break;
            }
            case NONE: {
                return "";
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getSelectTimestampConstantField(Date date) throws SQLQueryObjectException {
        DateTimeFormatterWrapper sqlDateformat = DateUtils.getDefaultDateTimeFormatter("yyyy-MM-dd HH:mm:ss.SSS");
        return "TIMESTAMP('" + sqlDateformat.format(date) + "', 'YYYY-MM-DD HH24:MI:SS.FF3')";
    }

    @Override
    public String getUnixTimestampConversion(String column) {
        return "((((CAST (DAYS(" + column + "-CURRENT_TIMEZONE) - DAYS('1970-01-01') AS BIGINT)*86400)+MIDNIGHT_SECONDS(" + column + "-CURRENT_TIMEZONE))*1000)+(MICROSECOND(" + column + ")/1000))";
    }

    @Override
    public String getDiffUnixTimestamp(String columnMax, String columnMin) {
        return "( " + this.getUnixTimestampConversion(columnMax) + " - " + this.getUnixTimestampConversion(columnMin) + " )";
    }

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "avg(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "max(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "min(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "sum(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(ISQLQueryObject subSelect) throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append(" ( ");
        bf.append(subSelect.createSQLQuery());
        bf.append(" ) ");
        StringBuilder subselectalias = new StringBuilder();
        subselectalias.append("tabella");
        for (int count = 0; count < 3; ++count) {
            int rnd = SQLQueryObjectCore.getRandom().nextInt(52);
            int base = rnd < 26 ? 65 : 97;
            subselectalias.append((char)(base + rnd % 26));
        }
        this.addFromTable(bf.toString(), subselectalias.toString());
        return this;
    }

    @Override
    protected EscapeSQLConfiguration getEscapeSQLConfiguration() {
        EscapeSQLConfiguration config = new EscapeSQLConfiguration();
        config.addCharacter('_');
        config.addCharacter('%');
        config.addCharacter('\\');
        config.setUseEscapeClausole(true);
        config.setEscape('\\');
        config.addCharacterWithOtherEscapeChar('\'', '\'');
        return config;
    }

    private SQLQueryObjectException newSQLQueryObjectExceptionDayFormatEnum(DayFormatEnum dayFormat) {
        return new SQLQueryObjectException("DayFormatEnum '" + String.valueOf((Object)dayFormat) + "' unknown");
    }

    @Override
    protected String getDayFormat(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        switch (dayFormat) {
            case FULL_DAY_NAME: {
                return DAY_FORMAT_FULL_DAY_NAME;
            }
            case SHORT_DAY_NAME: {
                return DAY_FORMAT_SHORT_DAY_NAME;
            }
        }
        throw this.newSQLQueryObjectExceptionDayFormatEnum(dayFormat);
    }

    @Override
    public String getExtractDayFormatFromTimestampFieldPrefix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (dayFormat == null) {
            throw new SQLQueryObjectException("dayFormat undefined");
        }
        switch (dayFormat) {
            case FULL_DAY_NAME: 
            case SHORT_DAY_NAME: {
                return super.getExtractDayFormatFromTimestampFieldPrefix(dayFormat);
            }
            case DAY_OF_YEAR: {
                return "DAYOFYEAR(";
            }
            case DAY_OF_WEEK: {
                return "DAYOFWEEK(";
            }
        }
        throw this.newSQLQueryObjectExceptionDayFormatEnum(dayFormat);
    }

    @Override
    public String getExtractDayFormatFromTimestampFieldSuffix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (dayFormat == null) {
            throw new SQLQueryObjectException("dayFormat undefined");
        }
        switch (dayFormat) {
            case FULL_DAY_NAME: 
            case SHORT_DAY_NAME: {
                return super.getExtractDayFormatFromTimestampFieldSuffix(dayFormat);
            }
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: {
                return ")";
            }
        }
        throw this.newSQLQueryObjectExceptionDayFormatEnum(dayFormat);
    }

    @Override
    public String createSQLQuery() throws SQLQueryObjectException {
        return this.createSQLQuery(false);
    }

    private String createSQLQuery(boolean union) throws SQLQueryObjectException {
        this.precheckBuildQuery();
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT ");
        if (this.isSelectDistinct()) {
            bf.append(" DISTINCT ");
        }
        if (this.offset < 0 && this.limit < 0) {
            Iterator itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
        }
        this.addSQLQuerySelectField(bf);
        bf.append(this.getSQL(false, false, false, union));
        if (this.offset < 0 && this.limit > 0) {
            bf.append(" FETCH FIRST ");
            bf.append(this.limit);
            bf.append(" ROWS ONLY ");
        }
        return bf.toString();
    }

    private void addSQLQuerySelectField(StringBuilder bf) {
        if (this.fields.isEmpty()) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                String field = (String)it.next();
                if (this.offset >= 0) {
                    field = this.normalizeField(field, false);
                }
                bf.append(field);
            }
        }
    }

    @Override
    public String createSQLDeleteEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append("DELETE ");
        bf.append(this.getSQL(true, false, false, false));
        return bf.toString();
    }

    private String getSQL(boolean delete, boolean update, boolean conditions, boolean union) throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(update, delete, union);
        }
        if (!update && !conditions) {
            bf.append(" FROM ");
            if (this.offset >= 0 && !delete) {
                int base;
                boolean sortTypeAsc;
                String f;
                String t;
                boolean first;
                Iterator it;
                bf.append(" ( SELECT ");
                Iterator itForceIndex = this.forceIndexTableNames.iterator();
                while (itForceIndex.hasNext()) {
                    bf.append(" " + (String)itForceIndex.next() + " ");
                }
                if (this.isSelectDistinct()) {
                    if (this.fields.isEmpty()) {
                        it = this.tableNames.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            t = (String)it.next();
                            bf.append(t + ".*");
                        }
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            String field = (String)it.next();
                            if (this.offset >= 0) {
                                field = this.normalizeField(field, false);
                            }
                            bf.append(field);
                        }
                    }
                } else if (this.fields.isEmpty()) {
                    it = this.tableNames.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        t = (String)it.next();
                        bf.append(t + ".*");
                    }
                } else {
                    it = this.fields.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        f = (String)it.next();
                        bf.append(f);
                    }
                }
                bf.append(" , ROW_NUMBER() OVER ( ORDER BY ");
                if (this.orderBy.isEmpty()) {
                    throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
                }
                if (!this.orderBy.isEmpty()) {
                    it = this.orderBy.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        String condizione = (String)it.next();
                        if (this.alias.containsKey(condizione)) {
                            if (this.isSelectDistinct()) {
                                bf.append(condizione);
                            } else {
                                bf.append((String)this.alias.get(condizione));
                            }
                        } else if (this.alias.containsValue(condizione)) {
                            bf.append(condizione);
                        } else {
                            bf.append(this.normalizeField(condizione));
                        }
                        sortTypeAsc = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(condizione)) {
                            sortTypeAsc = (Boolean)this.orderBySortType.get(condizione);
                        }
                        if (sortTypeAsc) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
                bf.append(" ) AS rowNumber ");
                bf.append(" FROM ");
                if (this.isSelectDistinct()) {
                    bf.append(" ( SELECT DISTINCT ");
                    if (this.fields.isEmpty()) {
                        it = this.tableNames.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            t = (String)it.next();
                            bf.append(t + ".*");
                        }
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            f = (String)it.next();
                            bf.append(f);
                        }
                    }
                    bf.append(" FROM ");
                }
                if (this.tables.isEmpty()) {
                    throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                }
                it = this.tables.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (!this.conditions.isEmpty()) {
                    bf.append(" WHERE ");
                    if (this.notBeforeConditions) {
                        bf.append(" NOT ( ");
                    }
                    for (int i = 0; i < this.conditions.size(); ++i) {
                        if (i > 0) {
                            if (this.andLogicOperator) {
                                bf.append(" AND ");
                            } else {
                                bf.append(" OR ");
                            }
                        }
                        String cond = (String)this.conditions.get(i);
                        bf.append(cond);
                    }
                    if (this.notBeforeConditions) {
                        bf.append(" )");
                    }
                }
                if (!this.getGroupByConditions().isEmpty() && !delete) {
                    bf.append(" GROUP BY ");
                    Iterator<String> it2 = this.getGroupByConditions().iterator();
                    first = true;
                    while (it2.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(it2.next());
                    }
                }
                if (this.isSelectDistinct()) {
                    if (!this.orderBy.isEmpty() && !delete) {
                        bf.append(" ORDER BY ");
                        Iterator it3 = this.orderBy.iterator();
                        first = true;
                        while (it3.hasNext()) {
                            String column = (String)it3.next();
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            bf.append(column);
                            sortTypeAsc = this.sortTypeAsc;
                            if (this.orderBySortType.containsKey(column)) {
                                sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                            }
                            if (sortTypeAsc) {
                                bf.append(" ASC ");
                                continue;
                            }
                            bf.append(" DESC ");
                        }
                    }
                    bf.append(" ) ");
                    bf.append(this.getDefaultAliasFieldKeyword());
                    bf.append("tableSelectRaw");
                    for (int count = 0; count < 3; ++count) {
                        int rnd = SQLQueryObjectCore.getRandom().nextInt(52);
                        base = rnd < 26 ? 65 : 97;
                        bf.append((char)(base + rnd % 26));
                    }
                }
                bf.append(" ) ");
                bf.append(this.getDefaultAliasFieldKeyword());
                bf.append("tabella");
                for (int count = 0; count < 3; ++count) {
                    int rnd = SQLQueryObjectCore.getRandom().nextInt(52);
                    base = rnd < 26 ? 65 : 97;
                    bf.append((char)(base + rnd % 26));
                }
                bf.append(" WHERE ( ");
                if (this.offset >= 0) {
                    bf.append(" rowNumber > ");
                    bf.append(this.offset);
                }
                if (this.limit >= 0) {
                    if (this.offset >= 0) {
                        bf.append(" AND");
                    }
                    bf.append(" rowNumber <=  ");
                    if (this.offset >= 0) {
                        bf.append(this.offset + this.limit);
                    } else {
                        bf.append(this.limit);
                    }
                }
                bf.append(" )");
                if (!union && !this.orderBy.isEmpty()) {
                    bf.append(" ORDER BY ");
                    Iterator it4 = this.orderBy.iterator();
                    boolean first2 = true;
                    while (it4.hasNext()) {
                        if (!first2) {
                            bf.append(",");
                        } else {
                            first2 = false;
                        }
                        String field = (String)it4.next();
                        bf.append(this.normalizeField(field));
                        boolean sortTypeAsc2 = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(field)) {
                            sortTypeAsc2 = (Boolean)this.orderBySortType.get(field);
                        }
                        if (sortTypeAsc2) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
            } else {
                if (this.tables.isEmpty()) {
                    throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                }
                if (delete && this.tables.size() > 2) {
                    throw new SQLQueryObjectException("Non e' possibile effettuare una delete con piu' di una tabella alla volta");
                }
                Iterator it = this.tables.iterator();
                boolean first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (!this.conditions.isEmpty()) {
                    bf.append(" WHERE ");
                    if (this.notBeforeConditions) {
                        bf.append("NOT (");
                    }
                    for (int i = 0; i < this.conditions.size(); ++i) {
                        if (i > 0) {
                            if (this.andLogicOperator) {
                                bf.append(" AND ");
                            } else {
                                bf.append(" OR ");
                            }
                        }
                        bf.append((String)this.conditions.get(i));
                    }
                    if (this.notBeforeConditions) {
                        bf.append(")");
                    }
                }
                if (!this.getGroupByConditions().isEmpty() && !delete) {
                    bf.append(" GROUP BY ");
                    Iterator<String> it5 = this.getGroupByConditions().iterator();
                    first = true;
                    while (it5.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(it5.next());
                    }
                }
                if (!(union || this.orderBy.isEmpty() || delete)) {
                    bf.append(" ORDER BY ");
                    Iterator it6 = this.orderBy.iterator();
                    first = true;
                    while (it6.hasNext()) {
                        String column = (String)it6.next();
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append(column);
                        boolean sortTypeAsc = this.sortTypeAsc;
                        if (this.orderBySortType.containsKey(column)) {
                            sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                        }
                        if (sortTypeAsc) {
                            bf.append(" ASC ");
                            continue;
                        }
                        bf.append(" DESC ");
                    }
                }
                if (this.selectForUpdate) {
                    bf.append(" FOR UPDATE ");
                }
            }
        } else if (!this.conditions.isEmpty()) {
            if (!conditions) {
                bf.append(" WHERE ");
            }
            if (this.notBeforeConditions) {
                bf.append("NOT (");
            }
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    if (this.andLogicOperator) {
                        bf.append(" AND ");
                    } else {
                        bf.append(" OR ");
                    }
                }
                bf.append((String)this.conditions.get(i));
            }
            if (this.notBeforeConditions) {
                bf.append(")");
            }
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnion(boolean unionAll, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(false, sqlQueryObject);
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(false, false, true);
        }
        StringBuilder bf = new StringBuilder();
        if (this.offset >= 0) {
            int i;
            boolean first;
            Iterator it;
            bf.append("SELECT * from ");
            bf.append(" ( SELECT ");
            if (this.fields.isEmpty()) {
                it = this.tableNames.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String t = (String)it.next();
                    bf.append(t + ".*");
                }
            } else {
                it = this.fields.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String f = (String)it.next();
                    bf.append(f);
                }
            }
            bf.append(" , ROW_NUMBER() OVER ( ORDER BY ");
            if (this.orderBy.isEmpty()) {
                throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
            }
            if (!this.orderBy.isEmpty()) {
                it = this.orderBy.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String condizione = (String)it.next();
                    if (this.alias.containsKey(condizione)) {
                        bf.append((String)this.alias.get(condizione));
                    } else {
                        bf.append(condizione);
                    }
                    boolean sortTypeAsc = this.sortTypeAsc;
                    if (this.orderBySortType.containsKey(condizione)) {
                        sortTypeAsc = (Boolean)this.orderBySortType.get(condizione);
                    }
                    if (sortTypeAsc) {
                        bf.append(" ASC ");
                        continue;
                    }
                    bf.append(" DESC ");
                }
            }
            bf.append(" ) AS rowNumber ");
            bf.append(" FROM ( ");
            for (i = 0; i < sqlQueryObject.length; ++i) {
                if (((DB2QueryObject)sqlQueryObject[i]).selectForUpdate) {
                    try {
                        ((DB2QueryObject)sqlQueryObject[i]).checkSelectForUpdate(false, false, true);
                    }
                    catch (Exception e) {
                        throw new SQLQueryObjectException("Parametro SqlQueryObject[" + i + "] non valido: " + e.getMessage());
                    }
                }
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(((DB2QueryObject)sqlQueryObject[i]).createSQLQuery(true));
                bf.append(") ");
            }
            bf.append(" ) as subquery" + this.getSerial() + " ");
            if (!this.conditions.isEmpty()) {
                bf.append(" WHERE ");
                if (this.notBeforeConditions) {
                    bf.append(" NOT ( ");
                }
                for (i = 0; i < this.conditions.size(); ++i) {
                    if (i > 0) {
                        if (this.andLogicOperator) {
                            bf.append(" AND ");
                        } else {
                            bf.append(" OR ");
                        }
                    }
                    String cond = (String)this.conditions.get(i);
                    bf.append(cond);
                }
                if (this.notBeforeConditions) {
                    bf.append(" )");
                }
            }
            if (!this.getGroupByConditions().isEmpty()) {
                bf.append(" GROUP BY ");
                Iterator<String> it2 = this.getGroupByConditions().iterator();
                first = true;
                while (it2.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append(it2.next());
                }
            }
            bf.append(" ) as subquery" + this.getSerial() + " ");
            bf.append(" WHERE ( ");
            if (this.offset >= 0) {
                bf.append(" rowNumber > ");
                bf.append(this.offset);
            }
            if (this.limit >= 0) {
                if (this.offset >= 0) {
                    bf.append(" AND");
                }
                bf.append(" rowNumber <=  ");
                if (this.offset >= 0) {
                    bf.append(this.offset + this.limit);
                } else {
                    bf.append(this.limit);
                }
            }
            bf.append(" )");
        } else {
            boolean first;
            bf.append("SELECT ");
            Iterator itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
            if (this.fields.isEmpty()) {
                bf.append("*");
            } else {
                Iterator it = this.fields.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String f = (String)it.next();
                    bf.append(f);
                }
            }
            bf.append(" FROM ( ");
            for (int i = 0; i < sqlQueryObject.length; ++i) {
                if (((DB2QueryObject)sqlQueryObject[i]).selectForUpdate) {
                    try {
                        ((DB2QueryObject)sqlQueryObject[i]).checkSelectForUpdate(false, false, true);
                    }
                    catch (Exception e) {
                        throw new SQLQueryObjectException("Parametro SqlQueryObject[" + i + "] non valido: " + e.getMessage());
                    }
                }
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(((DB2QueryObject)sqlQueryObject[i]).createSQLQuery(true));
                bf.append(") ");
            }
            bf.append(" ) as subquery" + this.getSerial() + " ");
            if (!this.getGroupByConditions().isEmpty()) {
                bf.append(" GROUP BY ");
                Iterator<String> it = this.getGroupByConditions().iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append(it.next());
                }
            }
            if (!this.orderBy.isEmpty()) {
                bf.append(" ORDER BY ");
                Iterator it = this.orderBy.iterator();
                first = true;
                while (it.hasNext()) {
                    String column = (String)it.next();
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append(column);
                    boolean sortTypeAsc = this.sortTypeAsc;
                    if (this.orderBySortType.containsKey(column)) {
                        sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                    }
                    if (sortTypeAsc) {
                        bf.append(" ASC ");
                        continue;
                    }
                    bf.append(" DESC ");
                }
            }
            if (this.offset < 0 && this.limit > 0) {
                bf.append(" FETCH FIRST ");
                bf.append(this.limit);
                bf.append(" ROWS ONLY ");
            }
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnionCount(boolean unionAll, String aliasCount, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(true, sqlQueryObject);
        if (aliasCount == null) {
            throw new SQLQueryObjectException("Alias per il count non definito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT count(*) " + this.getDefaultAliasFieldKeyword() + " ");
        bf.append(aliasCount);
        bf.append(" FROM ( ");
        bf.append(this.createSQLUnion(unionAll, sqlQueryObject));
        bf.append(" ) as subquery" + this.getSerial() + " ");
        return bf.toString();
    }

    @Override
    public String createSQLUpdateEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append("UPDATE ");
        bf.append(this.updateTable);
        bf.append(" SET ");
        for (int i = 0; i < this.updateFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(" , ");
            }
            bf.append((String)this.updateFieldsName.get(i));
            bf.append(" = ");
            bf.append((String)this.updateFieldsValue.get(i));
        }
        bf.append(this.getSQL(false, true, false, false));
        return bf.toString();
    }

    @Override
    public String createSQLConditionsEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append(this.getSQL(false, false, true, false));
        return bf.toString();
    }
}

