/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sonde.impl;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sonde.ParametriSonda;
import org.openspcoop2.utils.sonde.Sonda;
import org.openspcoop2.utils.sonde.SondaException;

public class SondaInvocazione
extends Sonda {
    private static final String RICHIESTA_OK = "richiestaOk";

    public SondaInvocazione(ParametriSonda param) {
        super(param);
        HashSet<String> reserved = new HashSet<String>();
        reserved.add(RICHIESTA_OK);
        this.getParam().setReserved(reserved);
    }

    @Override
    public Sonda.StatoSonda getStatoSonda() {
        boolean richiestaOK = false;
        if (super.getParam().getDatiCheck().containsKey(RICHIESTA_OK)) {
            try {
                richiestaOK = Boolean.parseBoolean(super.getParam().getDatiCheck().getProperty(RICHIESTA_OK));
            }
            catch (Exception e) {
                super.getParam().getDatiCheck().remove(RICHIESTA_OK);
            }
        }
        Sonda.StatoSonda statoSonda = new Sonda.StatoSonda(this);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.sss");
        if (richiestaOK) {
            statoSonda.setStato(0);
            statoSonda.setDescrizione(null);
        } else {
            if (this.getParam().getDataError() == null) {
                this.getParam().setDataError(new Date());
            }
            statoSonda.setStato(2);
            statoSonda.setDescrizione("Invocazione richiesta dal check " + super.getParam().getNome() + " fallita dal " + format.format(this.getParam().getDataError()));
        }
        return statoSonda;
    }

    public Sonda.StatoSonda aggiornaStatoSonda(boolean richiestaOk, Properties params, Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        super.getParam().putAllCheck(params);
        super.getParam().getDatiCheck().put(RICHIESTA_OK, "" + richiestaOk);
        return this.updateSonda(connection, tipoDatabase);
    }
}

