/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.logger;

import java.io.OutputStream;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openspcoop2.utils.service.logger.LoggingCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpSendMessageToFileSystemInterceptor
extends AbstractPhaseInterceptor {
    static final Logger log = LoggerFactory.getLogger(DumpSendMessageToFileSystemInterceptor.class);

    public DumpSendMessageToFileSystemInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) {
        String msgAsString = message.toString();
        String logMsg = String.format("SEND message %s", msgAsString);
        log.info(logMsg);
        message.put((Object)Message.ENCODING, (Object)"UTF-8");
        OutputStream outputStream = (OutputStream)message.getContent(OutputStream.class);
        if (outputStream != null) {
            CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(outputStream);
            message.setContent(OutputStream.class, (Object)newOut);
            newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback());
        }
    }
}

