/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context;

import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.openspcoop2.utils.logger.beans.context.core.Role;
import org.openspcoop2.utils.service.context.ContextConfig;
import org.openspcoop2.utils.service.context.ContextInInterceptor;
import org.openspcoop2.utils.service.context.ContextOutInterceptor;
import org.openspcoop2.utils.service.context.IContextFactory;
import org.openspcoop2.utils.service.context.ServiceInfoInInterceptor;
import org.openspcoop2.utils.service.context.ServiceInfoOutInterceptor;
import org.openspcoop2.utils.service.context.dump.DumpConfig;
import org.openspcoop2.utils.service.context.dump.DumpFeature;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature)
public class ContextFeature
extends AbstractFeature {
    private ContextInInterceptor in = new ContextInInterceptor();
    private ContextOutInterceptor out = new ContextOutInterceptor();
    private ContextConfig contextConfig;

    public IContextFactory getContextFactory() {
        return this.in.getContextFactory();
    }

    public void setContextFactory(IContextFactory contextFactory) {
        this.in.setContextFactory(contextFactory);
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
        this.in.setContextConfig(contextConfig);
        this.out.setContextConfig(contextConfig);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (this.contextConfig == null) {
            this.contextConfig = new ContextConfig();
            this.in.setContextConfig(this.contextConfig);
            this.out.setContextConfig(this.contextConfig);
        }
        provider.getInInterceptors().add(this.in);
        provider.getInFaultInterceptors().add(this.in);
        if (this.contextConfig.isFillServiceInfo()) {
            ServiceInfoInInterceptor infoIn = new ServiceInfoInInterceptor();
            provider.getInInterceptors().add(infoIn);
            provider.getInFaultInterceptors().add(infoIn);
        }
        provider.getOutInterceptors().add(this.out);
        provider.getOutFaultInterceptors().add(this.out);
        if (this.contextConfig.isFillServiceInfo()) {
            ServiceInfoOutInterceptor infoOut = new ServiceInfoOutInterceptor();
            provider.getOutInterceptors().add(infoOut);
            provider.getOutFaultInterceptors().add(infoOut);
        }
        if (this.contextConfig.isDump()) {
            DumpFeature dumpFeature = new DumpFeature();
            DumpConfig dumpConfig = this.contextConfig.getDumpConfig();
            if (dumpConfig == null) {
                dumpConfig = new DumpConfig();
            }
            dumpConfig.setRole(Role.SERVER);
            dumpFeature.setDumpConfig(dumpConfig);
            dumpFeature.doInitializeProvider(provider, bus);
        }
    }
}

