/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security.test;

import java.security.Provider;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.security.ProviderUtils;

public class ProviderTest {
    public static void main(String[] args) throws UtilsException {
        ProviderTest.test(false);
        ProviderTest.test(true);
    }

    public static void test(boolean useBCFacility) throws UtilsException {
        boolean castle;
        System.out.println("=========================\n");
        BouncyCastleProvider bc = new BouncyCastleProvider();
        List<String> names = ProviderUtils.getProviderNames();
        System.out.println("Providers attuali: " + String.valueOf(names));
        boolean bl = castle = useBCFacility ? ProviderUtils.existsBouncyCastle() : ProviderUtils.exists((Provider)bc);
        if (castle) {
            throw new UtilsException("Provider bouncy castle non atteso");
        }
        if (useBCFacility) {
            ProviderUtils.addBouncyCastle();
        } else {
            ProviderUtils.add((Provider)bc);
        }
        List<String> newNames = ProviderUtils.getProviderNames();
        System.out.println("Providers (dopo add BC): " + String.valueOf(newNames));
        if (newNames.size() != names.size() + 1) {
            throw new UtilsException("Atteso un provider in pi\u00f9");
        }
        if (!bc.getName().equals(newNames.get(newNames.size() - 1))) {
            throw new UtilsException("Atteso provider BC in fondo");
        }
        boolean bl2 = castle = useBCFacility ? ProviderUtils.existsBouncyCastle() : ProviderUtils.exists((Provider)bc);
        if (!castle) {
            throw new UtilsException("Provider bouncy castle atteso");
        }
        if (useBCFacility) {
            ProviderUtils.addBouncyCastleAfterSun(false);
        } else {
            ProviderUtils.addIfNotExists((Provider)bc, 2);
        }
        List<String> newNames2 = ProviderUtils.getProviderNames();
        System.out.println("Providers (dopo add BC if not exists): " + String.valueOf(newNames2));
        if (newNames.size() != newNames2.size()) {
            throw new UtilsException("Attesi identici provider");
        }
        if (!bc.getName().equals(newNames2.get(newNames2.size() - 1))) {
            throw new UtilsException("Atteso provider BC in fondo");
        }
        if (bc.getName().equals(newNames2.get(1))) {
            throw new UtilsException("Non atteso provider BC alla posizione 2");
        }
        if (useBCFacility) {
            ProviderUtils.addBouncyCastleAfterSun(true);
        } else {
            ProviderUtils.addOverrideIfExists((Provider)bc, 2);
        }
        newNames2 = ProviderUtils.getProviderNames();
        System.out.println("Providers (dopo add BC override): " + String.valueOf(newNames2));
        if (newNames.size() != newNames2.size()) {
            throw new UtilsException("Attesi identici provider");
        }
        if (bc.getName().equals(newNames2.get(newNames2.size() - 1))) {
            throw new UtilsException("Non atteso provider BC in fondo");
        }
        if (!bc.getName().equals(newNames2.get(1))) {
            throw new UtilsException("Atteso provider BC alla posizione 2");
        }
        if (useBCFacility) {
            ProviderUtils.addBouncyCastleAfterSun(true);
        } else {
            ProviderUtils.addOverrideIfExists((Provider)bc, 2);
        }
        newNames2 = ProviderUtils.getProviderNames();
        System.out.println("Providers (dopo add BC override): " + String.valueOf(newNames2));
        if (newNames.size() != newNames2.size()) {
            throw new UtilsException("Attesi identici provider");
        }
        if (bc.getName().equals(newNames2.get(newNames2.size() - 1))) {
            throw new UtilsException("Non atteso provider BC in fondo");
        }
        if (!bc.getName().equals(newNames2.get(1))) {
            throw new UtilsException("Atteso provider BC alla posizione 2");
        }
        if (useBCFacility) {
            ProviderUtils.removeBouncyCastle();
        } else {
            ProviderUtils.remove((Provider)bc);
        }
        newNames2 = ProviderUtils.getProviderNames();
        System.out.println("Providers (dopo remove): " + String.valueOf(newNames2));
        if (names.size() != newNames2.size()) {
            throw new UtilsException("Attesi identici provider come all'inizio");
        }
        if (bc.getName().equals(newNames2.get(newNames2.size() - 1))) {
            throw new UtilsException("Non atteso provider BC in fondo");
        }
        if (bc.getName().equals(newNames2.get(1))) {
            throw new UtilsException("Non atteso provider BC alla posizione 2");
        }
        System.out.println("Testsuite completata (useBCFacility:" + useBCFacility + ")");
    }
}

