/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.security.AbstractXmlCipher;
import org.openspcoop2.utils.security.SymmetricKeyWrappedMode;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlDecrypt
extends AbstractXmlCipher {
    public XmlDecrypt(KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey) throws UtilsException {
        super(2, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, false);
    }

    public XmlDecrypt(KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey) throws UtilsException {
        super(2, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, false);
    }

    public XmlDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlDecrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlDecrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(2, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey);
    }

    public XmlDecrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlDecrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(2, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey);
    }

    public XmlDecrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, SecretKey secretKey) throws UtilsException {
        super(2, wrappedSymmetricKeyMode, secretKey);
    }

    public XmlDecrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, wrappedSymmetricKeyMode, secretKey, addBouncyCastleProvider);
    }

    public XmlDecrypt(Certificate certificate, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, certificate, addBouncyCastleProvider);
    }

    public XmlDecrypt(Certificate certificate) throws UtilsException {
        super(2, certificate);
    }

    public XmlDecrypt(PrivateKey key, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key, addBouncyCastleProvider);
    }

    public XmlDecrypt(PrivateKey key) throws UtilsException {
        super(2, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key);
    }

    public XmlDecrypt(PublicKey key, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key, addBouncyCastleProvider);
    }

    public XmlDecrypt(PublicKey key) throws UtilsException {
        super(2, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key);
    }

    public XmlDecrypt(KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, addBouncyCastleProvider);
    }

    public XmlDecrypt(KeyStore keystore) throws UtilsException {
        super(2, keystore);
    }

    public XmlDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, addBouncyCastleProvider);
    }

    public XmlDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore) throws UtilsException {
        super(2, keystore);
    }

    public XmlDecrypt(KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, alias, addBouncyCastleProvider);
    }

    public XmlDecrypt(KeyStore keystore, String alias) throws UtilsException {
        super(2, keystore, alias);
    }

    public XmlDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        super(2, keystore, alias, addBouncyCastleProvider);
    }

    public XmlDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias) throws UtilsException {
        super(2, keystore, alias);
    }

    public Document decrypt(Document document) throws UtilsException {
        return this.decrypt(document, document.getDocumentElement());
    }

    public Document decrypt(Element element) throws UtilsException {
        return this.decrypt(element.getOwnerDocument(), element);
    }

    public Document decrypt(Document document, Element element) throws UtilsException {
        try {
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
            DynamicNamespaceContext dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace(element);
            Element encryptedDataElement = null;
            Object o = xpathEngine.getMatchPattern(element, dnc, "//{http://www.w3.org/2001/04/xmlenc#}EncryptedData", XPathReturnType.NODE);
            if (o == null) {
                throw new Exception("EncryptData not found");
            }
            encryptedDataElement = (Element)o;
            Element encryptedKeyElement = null;
            if (super.isEncryptedKey()) {
                o = xpathEngine.getMatchPattern(encryptedDataElement, dnc, "//{http://www.w3.org/2001/04/xmlenc#}EncryptedKey", XPathReturnType.NODE);
                if (o == null) {
                    throw new Exception("EncryptedKey not found");
                }
                encryptedKeyElement = (Element)o;
            }
            XMLCipher xmlCipherReaderAlgo = super.getXMLCipher();
            EncryptedData encryptedData = xmlCipherReaderAlgo.loadEncryptedData(document, encryptedDataElement);
            EncryptedKey encryptedKey = null;
            if (super.isEncryptedKey()) {
                encryptedKey = xmlCipherReaderAlgo.loadEncryptedKey(document, encryptedKeyElement);
            }
            String encryptAlgorithm = encryptedData.getEncryptionMethod().getAlgorithm();
            String digestAlgorithm = encryptedData.getEncryptionMethod().getDigestAlgorithm();
            String canonicalizationAlgorithm = null;
            if (super.isEncryptedKey()) {
                XMLCipher xmlCipherUnwrap = super.getXMLCipherUnwrappedKey();
                this.secretKeyEncrypt = (SecretKey)xmlCipherUnwrap.decryptKey(encryptedKey, encryptAlgorithm);
            }
            XMLCipher xmlCipher = super.getXMLCipher(encryptAlgorithm, canonicalizationAlgorithm, digestAlgorithm);
            return xmlCipher.doFinal(document, encryptedDataElement);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

