/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public enum OpenSSLEncryptionMode implements Serializable
{
    AES_128_CBC,
    AES_192_CBC,
    AES_256_CBC;

    private static final Map<String, OpenSSLEncryptionMode> localPwdTypeToOpenSSLEncryptionModeMap;

    public static OpenSSLEncryptionMode toMode(String mode) {
        return localPwdTypeToOpenSSLEncryptionModeMap.get(mode);
    }

    static {
        localPwdTypeToOpenSSLEncryptionModeMap = new HashMap<String, OpenSSLEncryptionMode>();
        localPwdTypeToOpenSSLEncryptionModeMap.put("openssl-aes-256-cbc", AES_256_CBC);
        localPwdTypeToOpenSSLEncryptionModeMap.put("openssl-pbkdf2-aes-128-cbc", AES_128_CBC);
        localPwdTypeToOpenSSLEncryptionModeMap.put("openssl-pbkdf2-aes-192-cbc", AES_192_CBC);
        localPwdTypeToOpenSSLEncryptionModeMap.put("openssl-pbkdf2-aes-256-cbc", AES_256_CBC);
    }
}

