/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.problem;

import java.util.List;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.rest.problem.AbstractDeserializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlDeserializer
extends AbstractDeserializer {
    private XMLUtils xmlUtils = XMLUtils.getInstance();

    public XmlDeserializer() {
        this(false);
    }

    public XmlDeserializer(boolean generateTypeBlank) {
        super(generateTypeBlank);
    }

    public boolean isProblemRFC7807(String problemString) {
        Element problemNode = null;
        try {
            problemNode = this.xmlUtils.newElement(problemString.getBytes());
        }
        catch (Exception e) {
            return false;
        }
        return this.isProblemRFC7807(problemNode);
    }

    public boolean isProblemRFC7807(byte[] problemByteArray) {
        Element problemNode = null;
        try {
            problemNode = this.xmlUtils.newElement(problemByteArray);
        }
        catch (Exception e) {
            return false;
        }
        return this.isProblemRFC7807(problemNode);
    }

    public boolean isProblemRFC7807(Node problemNode) {
        return problemNode != null && "problem".equals(problemNode.getLocalName()) && "urn:ietf:rfc:7807".equals(problemNode.getNamespaceURI());
    }

    public ProblemRFC7807 fromString(String problemString) throws UtilsException {
        return this.fromString(problemString, false);
    }

    public ProblemRFC7807 fromString(String problemString, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        Element problemNode = null;
        try {
            problemNode = this.xmlUtils.newElement(problemString.getBytes());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        ProblemRFC7807 p = new ProblemRFC7807();
        p.setRaw(problemString);
        return this._fromNode(p, problemNode, true, throwExceptionIfUnsupportedCustomClaim);
    }

    public ProblemRFC7807 fromByteArray(byte[] problemByteArray) throws UtilsException {
        return this.fromByteArray(problemByteArray, false);
    }

    public ProblemRFC7807 fromByteArray(byte[] problemByteArray, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        Element problemNode = null;
        try {
            problemNode = this.xmlUtils.newElement(problemByteArray);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        ProblemRFC7807 p = new ProblemRFC7807();
        p.setRaw(new String(problemByteArray));
        return this._fromNode(p, problemNode, true, throwExceptionIfUnsupportedCustomClaim);
    }

    public ProblemRFC7807 fromNode(Node problemNode) throws UtilsException {
        return this._fromNode(null, problemNode, true, false);
    }

    public ProblemRFC7807 fromNode(Node problemNode, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        return this._fromNode(null, problemNode, true, throwExceptionIfUnsupportedCustomClaim);
    }

    public ProblemRFC7807 fromNode(Node problemNode, boolean setRaw, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        return this._fromNode(null, problemNode, setRaw, throwExceptionIfUnsupportedCustomClaim);
    }

    private ProblemRFC7807 _fromNode(ProblemRFC7807 problemParam, Node problemNode, boolean setRaw, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        ProblemRFC7807 problem = null;
        problem = problemParam != null ? problemParam : new ProblemRFC7807();
        List<Node> list = this.xmlUtils.getNotEmptyChildNodes(problemNode);
        for (Node node : list) {
            String name = node.getLocalName();
            if (name == null) {
                name = node.getNodeName();
            }
            String value = null;
            try {
                value = node.getTextContent();
            }
            catch (Throwable e) {
                if (e instanceof AbstractMethodError) {
                    value = node.getNodeValue();
                    if (value == null && node.getChildNodes() != null) {
                        value = ((Text)node.getChildNodes().item(0)).getData();
                    }
                }
                throw new UtilsException(e.getMessage(), e);
            }
            super.set(problem, name, value, throwExceptionIfUnsupportedCustomClaim);
        }
        if (setRaw && problem.getRaw() == null) {
            try {
                problem.setRaw(this.xmlUtils.toString(problemNode));
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return problem;
    }
}

