/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.FileRWXConfig;
import org.openspcoop2.utils.resources.FileSystemMkdirConfig;

public class FileSystemUtilities {
    private static final String DIRECTORY_PREFIX_MSG = "Directory [";

    private FileSystemUtilities() {
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        Path p = FileSystemUtilities.createTempPath(prefix, suffix);
        if (p == null) {
            throw new IOException("Creation failed");
        }
        return p.toFile();
    }

    public static Path createTempPath(String prefix, String suffix) throws IOException {
        return Utilities.createTempPath(prefix, suffix);
    }

    public static File createTempFile(File dir, String prefix, String suffix) throws IOException {
        Path p = FileSystemUtilities.createTempPath(dir.toPath(), prefix, suffix);
        if (p == null) {
            throw new IOException("Creation failed");
        }
        return p.toFile();
    }

    public static Path createTempPath(Path dir, String prefix, String suffix) throws IOException {
        return Utilities.createTempPath(dir, prefix, suffix);
    }

    public static void copy(File in, File out) throws IOException {
        FileSystemUtilities.copy(in.getAbsolutePath(), out.getAbsolutePath());
    }

    public static void copy(String in, String out) throws IOException {
        try (FileInputStream fin = new FileInputStream(in);
             FileOutputStream fout = new FileOutputStream(out);){
            FileSystemUtilities.copy(fin, fout);
            fout.flush();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[256];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static void copyDirectory(String srcPath, String dstPath) throws IOException {
        FileSystemUtilities.copyDirectory(new File(srcPath), new File(dstPath));
    }

    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            String[] files;
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            if ((files = srcPath.list()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileSystemUtilities.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
            }
        } else if (srcPath.exists()) {
            try (FileInputStream in = new FileInputStream(srcPath);
                 FileOutputStream out = new FileOutputStream(dstPath);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                out.flush();
            }
        }
    }

    public static String readFile(String f) throws UtilsException, FileNotFoundException {
        return FileSystemUtilities.readFile(new File(f));
    }

    public static String readFile(File f) throws UtilsException, FileNotFoundException {
        return FileSystemUtilities.readFileEngine(f, null, null);
    }

    public static String readFile(String f, String charsetName) throws UtilsException, FileNotFoundException {
        return FileSystemUtilities.readFile(new File(f), charsetName);
    }

    public static String readFile(File f, String charsetName) throws UtilsException, FileNotFoundException {
        return FileSystemUtilities.readFileEngine(f, charsetName, null);
    }

    public static String readFile(String f, Charset charset) throws UtilsException, FileNotFoundException {
        return FileSystemUtilities.readFile(new File(f), charset);
    }

    public static String readFile(File f, Charset charset) throws UtilsException, FileNotFoundException {
        return FileSystemUtilities.readFileEngine(f, null, charset);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readFileEngine(File f, String charsetName, Charset charset) throws UtilsException, FileNotFoundException {
        try (FileInputStream fis = new FileInputStream(f);){
            ByteArrayOutputStream byteInputBuffer;
            block19: {
                block18: {
                    String string;
                    byteInputBuffer = new ByteArrayOutputStream();
                    try {
                        byte[] readB = new byte[8192];
                        int readByte = 0;
                        while ((readByte = fis.read(readB)) != -1) {
                            byteInputBuffer.write(readB, 0, readByte);
                        }
                        byteInputBuffer.flush();
                        if (charsetName == null) break block18;
                        string = byteInputBuffer.toString(charsetName);
                    }
                    catch (Throwable throwable) {
                        try {
                            byteInputBuffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    byteInputBuffer.close();
                    return string;
                }
                if (charset == null) break block19;
                String string = byteInputBuffer.toString(charset);
                byteInputBuffer.close();
                return string;
            }
            String string = byteInputBuffer.toString();
            byteInputBuffer.close();
            return string;
        }
        catch (FileNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static byte[] readBytesFromFile(String f) throws UtilsException, FileNotFoundException {
        return FileSystemUtilities.readBytesFromFile(new File(f));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytesFromFile(File f) throws UtilsException, FileNotFoundException {
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] byArray;
            try (ByteArrayOutputStream byteInputBuffer = new ByteArrayOutputStream();){
                byte[] readB = new byte[8192];
                int readByte = 0;
                while ((readByte = fis.read(readB)) != -1) {
                    byteInputBuffer.write(readB, 0, readByte);
                }
                byteInputBuffer.flush();
                byArray = byteInputBuffer.toByteArray();
            }
            return byArray;
        }
        catch (FileNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void writeFile(String f, byte[] contenuto) throws UtilsException {
        FileSystemUtilities.writeFile(new File(f), contenuto);
    }

    public static void writeFile(File f, byte[] contenuto) throws UtilsException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            fos.write(contenuto);
            fos.flush();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void writeFile(String f, byte[] ... args) throws UtilsException {
        FileSystemUtilities.writeFile(new File(f), args);
    }

    public static void writeFile(File f, byte[] ... args) throws UtilsException {
        if (args != null) {
            try (FileOutputStream fos = new FileOutputStream(f);){
                for (int i = 0; i < args.length; ++i) {
                    fos.write(args[i]);
                }
                fos.flush();
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public static void copyFileAndReplaceAllKeywords(String read, String write, String keyword, String values) throws UtilsException, FileNotFoundException {
        FileSystemUtilities.copyFileAndReplaceAllKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceAllKeywords(File read, File write, String keyword, String values) throws UtilsException, FileNotFoundException {
        String[] k = new String[]{keyword};
        String[] v = new String[]{values};
        FileSystemUtilities.copyFileAndReplaceAllKeywords(read, write, k, v);
    }

    public static void copyFileAndReplaceAllKeywords(String read, String write, String[] keyword, String[] values) throws UtilsException, FileNotFoundException {
        FileSystemUtilities.copyFileAndReplaceAllKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceAllKeywords(File read, File write, String[] keyword, String[] values) throws UtilsException, FileNotFoundException {
        String file = FileSystemUtilities.readFile(read);
        for (int i = 0; i < keyword.length; ++i) {
            int indexOf = file.indexOf(keyword[i]);
            while (indexOf >= 0) {
                file = file.replace(keyword[i], values[i]);
                indexOf = file.indexOf(keyword[i], indexOf + values[i].length());
            }
        }
        FileSystemUtilities.writeFile(write, file.getBytes());
    }

    public static void copyFileAndReplaceKeywords(String read, String write, String keyword, String values) throws UtilsException, FileNotFoundException {
        FileSystemUtilities.copyFileAndReplaceKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceKeywords(File read, File write, String keyword, String values) throws UtilsException, FileNotFoundException {
        String[] k = new String[]{keyword};
        String[] v = new String[]{values};
        FileSystemUtilities.copyFileAndReplaceKeywords(read, write, k, v);
    }

    public static void copyFileAndReplaceKeywords(String read, String write, String[] keyword, String[] values) throws UtilsException, FileNotFoundException {
        FileSystemUtilities.copyFileAndReplaceKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceKeywords(File read, File write, String[] keyword, String[] values) throws UtilsException, FileNotFoundException {
        String file = FileSystemUtilities.readFile(read);
        for (int i = 0; i < keyword.length; ++i) {
            file = file.replace(keyword[i], values[i]);
        }
        FileSystemUtilities.writeFile(write, file.getBytes());
    }

    public static boolean emptyDir(String dir) {
        File d = new File(dir);
        if (!d.exists()) {
            return true;
        }
        return FileSystemUtilities.emptyDir(d);
    }

    public static boolean emptyDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileSystemUtilities.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDirNotEmpty(String dir, int maxChilds) {
        return FileSystemUtilities.deleteDirNotEmpty(new File(dir), maxChilds);
    }

    public static boolean deleteDirNotEmpty(File dir, int maxChilds) {
        return FileSystemUtilities.deleteDirNotEmpty(dir, maxChilds, 0);
    }

    private static boolean deleteDirNotEmpty(File dir, int maxChilds, int level) {
        if (FileSystemUtilities.emptyDir(dir)) {
            FileSystemUtilities.deleteDir(dir);
            return true;
        }
        if (maxChilds == level) {
            return false;
        }
        File[] childs = dir.listFiles();
        if (childs != null && childs.length > 0) {
            return FileSystemUtilities.deleteDirNotEmpty(childs, maxChilds, level);
        }
        return true;
    }

    private static boolean deleteDirNotEmpty(File[] childs, int maxChilds, int level) {
        boolean ok = true;
        for (File file : childs) {
            if (file.isDirectory()) {
                boolean v = FileSystemUtilities.deleteDirNotEmpty(file, maxChilds, level + 1);
                if (v) continue;
                ok = false;
                continue;
            }
            try {
                Files.delete(file.toPath());
            }
            catch (Exception e) {
                ok = false;
            }
        }
        return ok;
    }

    public static boolean deleteDir(String dir) {
        File d = new File(dir);
        if (!d.exists()) {
            return true;
        }
        return FileSystemUtilities.deleteDir(d);
    }

    public static boolean deleteDir(File dir) {
        if (!FileSystemUtilities.emptyDir(dir)) {
            return false;
        }
        try {
            Files.delete(dir.toPath());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void deleteFile(File f) {
        try {
            if (f != null) {
                Files.delete(f.toPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clearFile(File f) {
        block7: {
            try {
                if (f == null) break block7;
                try (FileOutputStream fos = new FileOutputStream(f);){
                    byte[] emptyBytes = new byte[]{};
                    fos.write(emptyBytes);
                    fos.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean moveToDir(String src, String destDir) {
        File file = new File(src);
        File dir = new File(destDir);
        return FileSystemUtilities.moveToDir(file, dir);
    }

    public static boolean moveToDir(File src, File destDir) {
        return src.renameTo(new File(destDir, src.getName()));
    }

    public static boolean moveToFile(String src, String destFile) {
        File file = new File(src);
        File dir = new File(destFile);
        return FileSystemUtilities.moveToDir(file, dir);
    }

    public static boolean moveToFile(File src, File destFile) {
        return src.renameTo(destFile);
    }

    public static void mkdirParentDirectory(File file) throws UtilsException {
        FileSystemUtilities.mkdirParentDirectory(file.getAbsolutePath());
    }

    public static void mkdirParentDirectory(File file, Boolean readable, Boolean readableOwnerOnly, Boolean writable, Boolean writableOwnerOnly, Boolean executable, Boolean executableOwnerOnly) throws UtilsException {
        FileSystemUtilities.mkdirParentDirectory(file.getAbsolutePath(), readable, readableOwnerOnly, writable, writableOwnerOnly, executable, executableOwnerOnly);
    }

    public static void mkdirParentDirectory(String file) throws UtilsException {
        FileSystemUtilities.mkdirParentDirectory(file, null, null, null, null, null, null);
    }

    public static void mkdirParentDirectory(String file, Boolean readable, Boolean readableOwnerOnly, Boolean writable, Boolean writableOwnerOnly, Boolean executable, Boolean executableOwnerOnly) throws UtilsException {
        try {
            File p = new File(file);
            if (p.getParentFile() == null) {
                return;
            }
            if (p.getParentFile().exists()) {
                return;
            }
            FileSystemUtilities.mkdirParentDirectory(p.getParentFile().getAbsolutePath());
            if (!p.getParentFile().mkdir()) {
                throw new UtilsException(DIRECTORY_PREFIX_MSG + p.getParentFile().getAbsolutePath() + "] non esistente e creazione non riuscita");
            }
            FileSystemUtilities.setRWX(p, readable, readableOwnerOnly, writable, writableOwnerOnly, executable, executableOwnerOnly);
        }
        catch (Exception e) {
            throw new UtilsException("mkdirParentDirectory non riuscito: " + e.getMessage(), e);
        }
    }

    private static void setRWX(File p, Boolean readable, Boolean readableOwnerOnly, Boolean writable, Boolean writableOwnerOnly, Boolean executable, Boolean executableOwnerOnly) {
        FileSystemUtilities.setParentR(p, readable, readableOwnerOnly);
        FileSystemUtilities.setParentW(p, writable, writableOwnerOnly);
        FileSystemUtilities.setParentX(p, executable, executableOwnerOnly);
    }

    private static void setParentR(File p, Boolean readable, Boolean readableOwnerOnly) {
        if (readable == null || (readableOwnerOnly != null ? !p.getParentFile().setReadable(readable, readableOwnerOnly) : !p.getParentFile().setReadable(readable))) {
            // empty if block
        }
    }

    private static void setParentW(File p, Boolean writable, Boolean writableOwnerOnly) {
        if (writable == null || (writableOwnerOnly != null ? !p.getParentFile().setWritable(writable, writableOwnerOnly) : !p.getParentFile().setWritable(writable))) {
            // empty if block
        }
    }

    private static void setParentX(File p, Boolean executable, Boolean executableOwnerOnly) {
        if (executable == null || (executableOwnerOnly != null ? !p.getParentFile().setExecutable(executable, executableOwnerOnly) : !p.getParentFile().setExecutable(executable))) {
            // empty if block
        }
    }

    public static void mkdir(String f) throws UtilsException {
        FileSystemUtilities.mkdir(f, new FileSystemMkdirConfig());
    }

    public static void mkdir(String f, Boolean readable, Boolean readableOwnerOnly, Boolean writable, Boolean writableOwnerOnly, Boolean executable, Boolean executableOwnerOnly) throws UtilsException {
        FileSystemUtilities.mkdir(f, new FileSystemMkdirConfig(), new FileRWXConfig(readable, readableOwnerOnly, writable, writableOwnerOnly, executable, executableOwnerOnly));
    }

    public static void mkdir(String f, FileRWXConfig rwxConfig) throws UtilsException {
        FileSystemUtilities.mkdir(f, new FileSystemMkdirConfig(), rwxConfig);
    }

    public static void mkdir(String f, FileSystemMkdirConfig config) throws UtilsException {
        File dir = new File(f);
        FileSystemUtilities.mkdir(dir, config);
    }

    public static void mkdir(String f, FileSystemMkdirConfig config, FileRWXConfig rwxConfig) throws UtilsException {
        File dir = new File(f);
        FileSystemUtilities.mkdir(dir, config, rwxConfig);
    }

    public static void mkdir(File dir) throws UtilsException {
        FileSystemUtilities.mkdir(dir, new FileSystemMkdirConfig());
    }

    public static void mkdir(File dir, Boolean readable, Boolean readableOwnerOnly, Boolean writable, Boolean writableOwnerOnly, Boolean executable, Boolean executableOwnerOnly) throws UtilsException {
        FileSystemUtilities.mkdir(dir, new FileSystemMkdirConfig(), new FileRWXConfig(readable, readableOwnerOnly, writable, writableOwnerOnly, executable, executableOwnerOnly));
    }

    public static void mkdir(File dir, FileRWXConfig rwxConfig) throws UtilsException {
        FileSystemUtilities.mkdir(dir, new FileSystemMkdirConfig(), rwxConfig);
    }

    public static void mkdir(File dir, FileSystemMkdirConfig config) throws UtilsException {
        FileSystemUtilities.mkdir(dir, config, null);
    }

    public static void mkdir(File dir, FileSystemMkdirConfig config, FileRWXConfig rwxConfig) throws UtilsException {
        Boolean readable = null;
        Boolean readableOwnerOnly = null;
        Boolean writable = null;
        Boolean writableOwnerOnly = null;
        Boolean executable = null;
        Boolean executableOwnerOnly = null;
        if (rwxConfig != null) {
            readable = rwxConfig.getReadable();
            readableOwnerOnly = rwxConfig.getReadableOwnerOnly();
            writable = rwxConfig.getWritable();
            writableOwnerOnly = rwxConfig.getWritableOwnerOnly();
            executable = rwxConfig.getExecutable();
            executableOwnerOnly = rwxConfig.getExecutableOwnerOnly();
        }
        if (dir.exists()) {
            FileSystemUtilities.checkDir(dir, config);
        } else {
            File parent;
            if (dir.getParentFile() != null && !(parent = dir.getParentFile()).exists() && config.crateParentIfNotExists) {
                FileSystemUtilities.mkdirParentDirectory(dir, readable, readableOwnerOnly, writable, writableOwnerOnly, executable, executableOwnerOnly);
            }
            if (!dir.mkdir()) {
                throw new UtilsException("Creazione directory [" + dir.getAbsolutePath() + "] non riuscita");
            }
            FileSystemUtilities.setR(dir, readable, readableOwnerOnly);
            FileSystemUtilities.setW(dir, writable, writableOwnerOnly);
            FileSystemUtilities.setX(dir, executable, executableOwnerOnly);
        }
    }

    private static void checkDir(File dir, FileSystemMkdirConfig config) throws UtilsException {
        if (!dir.isDirectory()) {
            throw new UtilsException("File [" + dir.getAbsolutePath() + "] is not directory");
        }
        if (config.isCheckCanRead() && !dir.canRead()) {
            throw new UtilsException(DIRECTORY_PREFIX_MSG + dir.getAbsolutePath() + "] cannot read");
        }
        if (config.isCheckCanWrite() && !dir.canWrite()) {
            throw new UtilsException(DIRECTORY_PREFIX_MSG + dir.getAbsolutePath() + "] cannot write");
        }
        if (config.isCheckCanExecute() && !dir.canExecute()) {
            throw new UtilsException(DIRECTORY_PREFIX_MSG + dir.getAbsolutePath() + "] cannot execute");
        }
    }

    private static void setR(File dir, Boolean readable, Boolean readableOwnerOnly) {
        if (readable == null || (readableOwnerOnly != null ? !dir.setReadable(readable, readableOwnerOnly) : !dir.setReadable(readable))) {
            // empty if block
        }
    }

    private static void setW(File dir, Boolean writable, Boolean writableOwnerOnly) {
        if (writable == null || (writableOwnerOnly != null ? !dir.setWritable(writable, writableOwnerOnly) : !dir.setWritable(writable))) {
            // empty if block
        }
    }

    private static void setX(File dir, Boolean executable, Boolean executableOwnerOnly) {
        if (executable == null || (executableOwnerOnly != null ? !dir.setExecutable(executable, executableOwnerOnly) : !dir.setExecutable(executable))) {
            // empty if block
        }
    }
}

