/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.random.test;

import org.openspcoop2.utils.random.RandomGenerator;
import org.openspcoop2.utils.random.SecureRandomAlgorithm;

public class RandomGeneratorTest {
    public static void main(String[] args) throws Exception {
        SecureRandomAlgorithm[] v;
        RandomGeneratorTest.test(false, null);
        RandomGeneratorTest.test(true, null);
        for (SecureRandomAlgorithm secureRandomAlgorithm : v = SecureRandomAlgorithm.values()) {
            if (SecureRandomAlgorithm.PKCS11.equals((Object)secureRandomAlgorithm) || SecureRandomAlgorithm.WINDOWS_PRNG.equals((Object)secureRandomAlgorithm)) continue;
            RandomGeneratorTest.test(true, secureRandomAlgorithm.getValue());
        }
    }

    public static void test(boolean useSecureRandom, String secureRandomAlgorithm) throws Exception {
        System.out.println("\n---------- (secureRandom:" + useSecureRandom + " algo:" + secureRandomAlgorithm + ")----------------");
        RandomGenerator generator = new RandomGenerator(useSecureRandom, secureRandomAlgorithm);
        String algorithm = generator.getAlgorithm();
        System.out.println("ALGO: " + algorithm);
        byte[] array = generator.nextRandomBytes(16);
        if (array.length != 16) {
            throw new Exception("Lunghezza array " + array.length + " differente da quella attesa (test nextRandomBytes(16))");
        }
        array = generator.nextRandomBytes(8);
        if (array.length != 8) {
            throw new Exception("Lunghezza array " + array.length + " differente da quella attesa (test nextRandomBytes(8))");
        }
        array = new byte[16];
        generator.nextRandomBytes(array);
        if (array.length != 16) {
            throw new Exception("Lunghezza array " + array.length + " differente da quella attesa(test nextRandomBytes(array) con lenght 16)");
        }
        array = new byte[8];
        generator.nextRandomBytes(array);
        if (array.length != 8) {
            throw new Exception("Lunghezza array " + array.length + " differente da quella attesa(test nextRandomBytes(array) con lenght 8)");
        }
        String s = generator.nextRandom(16);
        if (s.length() != 16) {
            throw new Exception("Lunghezza stringa " + s.length() + " differente da quella attesa (test nextRandom(16))");
        }
        s = generator.nextRandom(8);
        if (s.length() != 8) {
            throw new Exception("Lunghezza stringa " + s.length() + " differente da quella attesa (test nextRandom(8))");
        }
        s = generator.nextRandomInt(16);
        if (s.length() != 16) {
            throw new Exception("Lunghezza stringa " + s.length() + " differente da quella attesa (test nextRandomInt(16))");
        }
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            throw new Exception("Stringa " + s + " contiene un carattere che non \u00e8 una cifra '" + c + "' (test nextRandomInt(16))");
        }
        s = generator.nextRandomInt(8);
        if (s.length() != 8) {
            throw new Exception("Lunghezza stringa " + s.length() + " differente da quella attesa (test nextRandomInt(8))");
        }
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            throw new Exception("Stringa " + s + " contiene un carattere che non \u00e8 una cifra '" + c + "' (test nextRandomInt(8))");
        }
        int intNumber = generator.nextInt();
        intNumber = generator.nextInt(1872);
        intNumber = generator.nextInt(23);
        long longNumber = generator.nextLong();
        boolean booleanValue = generator.nextBoolean();
        double dValue = generator.nextDouble();
        dValue = generator.nextGaussian();
        float fValue = generator.nextFloat();
    }
}

