/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;
import org.openspcoop2.utils.CopyStream;

public class PDFSignatureCMSTypedData
implements CMSTypedData {
    private InputStream is;
    private ASN1ObjectIdentifier contentType;

    public PDFSignatureCMSTypedData(InputStream is, ASN1ObjectIdentifier contentType) {
        this.is = is;
        this.contentType = contentType == null ? new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()) : contentType;
    }

    public Object getContent() {
        return this.is;
    }

    public void write(OutputStream out) throws IOException, CMSException {
        try {
            CopyStream.copy(this.is, out);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }
}

